/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.logging.LogUtils;
import java.time.Instant;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.Signer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.bukkit.event.player.PlayerKickEvent;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesConfig;

public class SignedMessageChain {
    private static final Logger a = LogUtils.getLogger();
    @Nullable
    private SignedMessageLink b;
    private Instant c = Instant.EPOCH;

    public SignedMessageChain(UUID sender, UUID sessionId) {
        this.b = SignedMessageLink.a(sender, sessionId);
    }

    public c a(Signer signer) {
        return body -> {
            SignedMessageLink signedMessageLink = this.a();
            return signedMessageLink == null ? null : new MessageSignature(signer.sign(updatable -> PlayerChatMessage.a(updatable, signedMessageLink, body)));
        };
    }

    public b a(ProfilePublicKey playerPublicKey) {
        SignatureValidator signatureValidator = playerPublicKey.a();
        return (signature, body) -> {
            SignedMessageLink signedMessageLink = this.a();
            if (signedMessageLink == null) {
                throw new a((IChatBaseComponent)IChatBaseComponent.c("chat.disabled.chain_broken"), false);
            }
            if (playerPublicKey.b().a()) {
                throw new a(IChatBaseComponent.c("chat.disabled.expiredProfileKey"), false, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            }
            if (body.b().isBefore(this.c) && !LeavesConfig.disableCheckOutOfOrderCommand) {
                throw new a(IChatBaseComponent.c("multiplayer.disconnect.out_of_order_chat"), true, PlayerKickEvent.Cause.OUT_OF_ORDER_CHAT);
            }
            this.c = body.b();
            PlayerChatMessage playerChatMessage = new PlayerChatMessage(signedMessageLink, signature, body, null, FilterMask.c);
            if (!playerChatMessage.a(signatureValidator)) {
                throw new a(IChatBaseComponent.c("multiplayer.disconnect.unsigned_chat"), true, PlayerKickEvent.Cause.UNSIGNED_CHAT);
            }
            if (playerChatMessage.a(Instant.now())) {
                a.warn("Received expired chat: '{}'. Is the client/server system time unsynchronized?", (Object)body.a());
            }
            return playerChatMessage;
        };
    }

    @Nullable
    private SignedMessageLink a() {
        SignedMessageLink signedMessageLink = this.b;
        if (signedMessageLink != null) {
            this.b = signedMessageLink.a();
        }
        return signedMessageLink;
    }

    @FunctionalInterface
    public static interface c {
        public static final c a = body -> null;

        @Nullable
        public MessageSignature pack(SignedMessageBody var1);
    }

    @FunctionalInterface
    public static interface b {
        public static b unsigned(UUID sender, BooleanSupplier secureProfileEnforced) {
            return (signature, body) -> {
                if (secureProfileEnforced.getAsBoolean()) {
                    throw new a((IChatBaseComponent)IChatBaseComponent.c("chat.disabled.missingProfileKey"), false);
                }
                return PlayerChatMessage.a(sender, body.a());
            };
        }

        public PlayerChatMessage unpack(@Nullable MessageSignature var1, SignedMessageBody var2) throws a;
    }

    public static class a
    extends ThrowingComponent {
        private final boolean a;
        public final PlayerKickEvent.Cause kickCause;

        public a(IChatBaseComponent message, boolean shouldDisconnect) {
            this(message, shouldDisconnect, PlayerKickEvent.Cause.UNKNOWN);
        }

        public a(IChatBaseComponent message, boolean shouldDisconnect, PlayerKickEvent.Cause kickCause) {
            super(message);
            this.a = shouldDisconnect;
            this.kickCause = kickCause;
        }

        public boolean a() {
            return this.a;
        }
    }
}

