/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger d = LogUtils.getLogger();
    public static final MapCodec<NbtContents> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::b), (App)Codec.BOOL.optionalFieldOf("interpret", (Object)false).forGetter(NbtContents::c), (App)ComponentSerialization.a.optionalFieldOf("separator").forGetter(NbtContents::d), (App)DataSource.c.forGetter(NbtContents::e)).apply((Applicative)instance, NbtContents::new));
    public static final ComponentContents.a<NbtContents> b = new ComponentContents.a<NbtContents>(a, "nbt");
    private final boolean e;
    private final Optional<IChatBaseComponent> f;
    private final String g;
    private final DataSource h;
    @Nullable
    protected final ArgumentNBTKey.g c;

    public NbtContents(String rawPath, boolean interpret, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        this(rawPath, NbtContents.a(rawPath), interpret, separator, dataSource);
    }

    private NbtContents(String rawPath, @Nullable ArgumentNBTKey.g path, boolean interpret, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        this.g = rawPath;
        this.c = path;
        this.e = interpret;
        this.f = separator;
        this.h = dataSource;
    }

    @Nullable
    private static ArgumentNBTKey.g a(String rawPath) {
        try {
            return new ArgumentNBTKey().a(new StringReader(rawPath));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public String b() {
        return this.g;
    }

    public boolean c() {
        return this.e;
    }

    public Optional<IChatBaseComponent> d() {
        return this.f;
    }

    public DataSource e() {
        return this.h;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NbtContents)) return false;
        NbtContents nbtContents = (NbtContents)object;
        if (!this.h.equals(nbtContents.h)) return false;
        if (!this.f.equals(nbtContents.f)) return false;
        if (this.e != nbtContents.e) return false;
        if (!this.g.equals(nbtContents.g)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int i2 = this.e ? 1 : 0;
        i2 = 31 * i2 + this.f.hashCode();
        i2 = 31 * i2 + this.g.hashCode();
        i2 = 31 * i2 + this.h.hashCode();
        return i2;
    }

    @Override
    public String toString() {
        return "nbt{" + this.h + ", interpreting=" + this.e + ", separator=" + this.f + "}";
    }

    @Override
    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (source == null || this.c == null) {
            return IChatBaseComponent.i();
        }
        Stream<String> stream = this.h.a(source).flatMap(nbt -> {
            try {
                return this.c.a((NBTBase)nbt).stream();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return Stream.empty();
            }
        }).map(NBTBase::t_);
        if (this.e) {
            IChatBaseComponent component = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.a(source, this.f, sender, depth), (Object)ChatComponentUtils.c);
            return stream.flatMap(text -> {
                try {
                    IChatMutableComponent mutableComponent = IChatBaseComponent.ChatSerializer.a(text);
                    return Stream.of(ChatComponentUtils.a(source, mutableComponent, sender, depth));
                }
                catch (Exception exception) {
                    d.warn("Failed to parse component: {}", text, (Object)exception);
                    return Stream.of(new IChatMutableComponent[0]);
                }
            }).reduce((accumulator, current) -> accumulator.b(component).b((IChatBaseComponent)current)).orElseGet(IChatBaseComponent::i);
        }
        return ChatComponentUtils.a(source, this.f, sender, depth).map(text -> stream.map(IChatBaseComponent::b).reduce((accumulator, current) -> accumulator.b((IChatBaseComponent)text).b((IChatBaseComponent)current)).orElseGet(IChatBaseComponent::i)).orElseGet(() -> IChatBaseComponent.b(stream.collect(Collectors.joining(", "))));
    }

    @Override
    @Override
    public ComponentContents.a<?> a() {
        return b;
    }
}

