/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;

public class TranslatableContents
implements ComponentContents {
    public static final Object[] a = new Object[0];
    private static final Codec<Object> d = ExtraCodecs.a(ExtraCodecs.b, TranslatableContents::b);
    private static final Codec<Object> e = Codec.either(d, ComponentSerialization.a).xmap(either -> either.map(object -> object, text -> Objects.requireNonNullElse(text.d(), text)), argument -> {
        Either<Object, Object> either;
        if (argument instanceof IChatBaseComponent) {
            IChatBaseComponent component = (IChatBaseComponent)argument;
            either = Either.right(component);
        } else {
            either = Either.left(argument);
        }
        return either;
    });
    public static final MapCodec<TranslatableContents> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("translate").forGetter(content -> content.h), (App)Codec.STRING.optionalFieldOf("fallback").forGetter(content -> Optional.ofNullable(content.i)), (App)ExtraCodecs.a(e.listOf(), "with").forGetter(content -> TranslatableContents.a(content.j))).apply((Applicative)instance, TranslatableContents::a));
    public static final ComponentContents.a<TranslatableContents> c = new ComponentContents.a<TranslatableContents>(b, "translatable");
    private static final IChatFormatted f = IChatFormatted.e("%");
    private static final IChatFormatted g = IChatFormatted.e("null");
    private final String h;
    @Nullable
    private final String i;
    private final Object[] j;
    @Nullable
    private LocaleLanguage k;
    private List<IChatFormatted> l = ImmutableList.of();
    private static final Pattern m = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public static DataResult<Object> b(@Nullable Object object) {
        return !TranslatableContents.a(object) ? DataResult.error(() -> "This value needs to be parsed as component") : DataResult.success((Object)object);
    }

    public static boolean a(@Nullable Object argument) {
        return argument instanceof Number || argument instanceof Boolean || argument instanceof String;
    }

    private static Optional<List<Object>> a(Object[] args) {
        return args.length == 0 ? Optional.empty() : Optional.of(Arrays.asList(args));
    }

    private static Object[] a(Optional<List<Object>> args) {
        return args.map(list -> list.isEmpty() ? a : list.toArray()).orElse(a);
    }

    private static TranslatableContents a(String key, Optional<String> fallback, Optional<List<Object>> args) {
        return new TranslatableContents(key, fallback.orElse(null), TranslatableContents.a(args));
    }

    public TranslatableContents(String key, @Nullable String fallback, Object[] args) {
        this.h = key;
        this.i = fallback;
        this.j = args;
    }

    @Override
    public ComponentContents.a<?> a() {
        return c;
    }

    private void e() {
        LocaleLanguage language = LocaleLanguage.a();
        if (language != this.k) {
            this.k = language;
            String string = this.i != null ? language.a(this.h, this.i) : language.a(this.h);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.a(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.l = builder.build();
            }
            catch (TranslatableFormatException var4) {
                this.l = ImmutableList.of((Object)IChatFormatted.e(string));
            }
        }
    }

    private void a(String translation, Consumer<IChatFormatted> partsConsumer) {
        Matcher matcher = m.matcher(translation);
        try {
            int i2 = 0;
            int j2 = 0;
            while (matcher.find(j2)) {
                int k2 = matcher.start();
                int l2 = matcher.end();
                if (k2 > j2) {
                    String string = translation.substring(j2, k2);
                    if (string.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    partsConsumer.accept(IChatFormatted.e(string));
                }
                String string2 = matcher.group(2);
                String string3 = translation.substring(k2, l2);
                if ("%".equals(string2) && "%%".equals(string3)) {
                    partsConsumer.accept(f);
                } else {
                    if (!"s".equals(string2)) {
                        throw new TranslatableFormatException(this, "Unsupported format: '" + string3 + "'");
                    }
                    String string4 = matcher.group(1);
                    int m2 = string4 != null ? Integer.parseInt(string4) - 1 : i2++;
                    partsConsumer.accept(this.a(m2));
                }
                j2 = l2;
            }
            if (j2 < translation.length()) {
                String string5 = translation.substring(j2);
                if (string5.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                partsConsumer.accept(IChatFormatted.e(string5));
            }
        }
        catch (IllegalArgumentException var12) {
            throw new TranslatableFormatException(this, (Throwable)var12);
        }
    }

    private IChatFormatted a(int index) {
        if (index >= 0 && index < this.j.length) {
            Object object = this.j[index];
            if (object instanceof IChatBaseComponent) {
                return (IChatBaseComponent)object;
            }
            return object == null ? g : IChatFormatted.e(object.toString());
        }
        throw new TranslatableFormatException(this, index);
    }

    @Override
    public <T> Optional<T> a(IChatFormatted.b<T> visitor, ChatModifier style) {
        this.e();
        for (IChatFormatted formattedText : this.l) {
            Optional<T> optional = formattedText.a(visitor, style);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> a(IChatFormatted.a<T> visitor) {
        try {
            return this.visit(new TranslatableContentConsumer<T>(visitor));
        }
        catch (IllegalArgumentException ignored) {
            return visitor.accept("...");
        }
    }

    private <T> Optional<T> visit(TranslatableContentConsumer<T> visitor) {
        this.e();
        for (IChatFormatted formattedText : this.l) {
            Optional<T> optional = formattedText.a(visitor);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        Object[] objects = new Object[this.j.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            Object object = this.j[i2];
            if (object instanceof IChatBaseComponent) {
                IChatBaseComponent component = (IChatBaseComponent)object;
                objects[i2] = ChatComponentUtils.a(source, component, sender, depth);
                continue;
            }
            objects[i2] = object;
        }
        return IChatMutableComponent.a(new TranslatableContents(this.h, this.i, objects));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)object;
            if (Objects.equals(this.h, translatableContents.h) && Objects.equals(this.i, translatableContents.i) && Arrays.equals(this.j, translatableContents.j)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int i2 = Objects.hashCode(this.h);
        i2 = 31 * i2 + Objects.hashCode(this.i);
        return 31 * i2 + Arrays.hashCode(this.j);
    }

    public String toString() {
        return "translation{key='" + this.h + "'" + (String)(this.i != null ? ", fallback='" + this.i + "'" : "") + ", args=" + Arrays.toString(this.j) + "}";
    }

    public String b() {
        return this.h;
    }

    @Nullable
    public String c() {
        return this.i;
    }

    public Object[] d() {
        return this.j;
    }

    private static final class TranslatableContentConsumer<T>
    implements IChatFormatted.a<T> {
        private static final IllegalArgumentException EX = new IllegalArgumentException("Too long");
        private final IChatFormatted.a<T> visitor;
        private int visited;

        private TranslatableContentConsumer(IChatFormatted.a<T> visitor) {
            this.visitor = visitor;
        }

        @Override
        public Optional<T> accept(String asString) {
            if (this.visited++ > 32) {
                throw EX;
            }
            return this.visitor.accept(asString);
        }
    }
}

