/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class PacketPlayOutUpdateAttributes
implements Packet<PacketListenerPlayOut> {
    private final int a;
    private final List<AttributeSnapshot> b;

    public PacketPlayOutUpdateAttributes(int entityId, Collection<AttributeModifiable> attributes) {
        this.a = entityId;
        this.b = Lists.newArrayList();
        for (AttributeModifiable attributeInstance : attributes) {
            this.b.add(new AttributeSnapshot(attributeInstance.a(), attributeInstance.b(), attributeInstance.c()));
        }
    }

    public PacketPlayOutUpdateAttributes(PacketDataSerializer buf) {
        this.a = buf.n();
        this.b = buf.a(buf2 -> {
            MinecraftKey resourceLocation = buf2.t();
            AttributeBase attribute = BuiltInRegistries.u.a(resourceLocation);
            double d2 = buf2.readDouble();
            List<AttributeModifier> list = buf2.a(modifiers -> new AttributeModifier(modifiers.p(), "Unknown synced attribute modifier", modifiers.readDouble(), AttributeModifier.Operation.a(modifiers.readByte())));
            return new AttributeSnapshot(attribute, d2, list);
        });
    }

    @Override
    @Override
    public void a(PacketDataSerializer buf) {
        buf.c(this.a);
        buf.a(this.b, (buf2, attribute) -> {
            buf2.a(BuiltInRegistries.u.b(attribute.a()));
            buf2.a(attribute.b());
            buf2.a(attribute.c(), (buf3, modifier) -> {
                buf3.a(modifier.a());
                buf3.a(modifier.c());
                buf3.k(modifier.b().a());
            });
        });
    }

    @Override
    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public int a() {
        return this.a;
    }

    public List<AttributeSnapshot> d() {
        return this.b;
    }

    public static class AttributeSnapshot {
        private final AttributeBase a;
        private final double b;
        private final Collection<AttributeModifier> c;

        public AttributeSnapshot(AttributeBase attribute, double baseValue, Collection<AttributeModifier> modifiers) {
            this.a = attribute;
            this.b = baseValue;
            this.c = modifiers;
        }

        public AttributeBase a() {
            return this.a;
        }

        public double b() {
            return this.b;
        }

        public Collection<AttributeModifier> c() {
            return this.c;
        }
    }
}

