/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBufUtil;
import java.lang.reflect.Type;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ChatDeserializer;
import org.apache.commons.lang3.StringUtils;

public class MinecraftKey
implements Comparable<MinecraftKey> {
    public static final Codec<MinecraftKey> a = Codec.STRING.comapFlatMap(MinecraftKey::b, MinecraftKey::toString).stable();
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.id.invalid"));
    public static final char b = ':';
    public static final String c = "minecraft";
    public static final String d = "realms";
    public static final String PAPER_NAMESPACE = "paper";
    private final String f;
    private final String g;

    protected MinecraftKey(String namespace, String path, @Nullable a extraData) {
        String resourceLocation = namespace + ":" + path;
        if (resourceLocation.length() > Short.MAX_VALUE || ByteBufUtil.utf8MaxBytes((CharSequence)resourceLocation) > 65535) {
            throw new ResourceKeyInvalidException("Resource location too long: " + resourceLocation);
        }
        this.f = namespace;
        this.g = path;
    }

    public MinecraftKey(String namespace, String path) {
        this(MinecraftKey.c(namespace, path), MinecraftKey.d(namespace, path), null);
    }

    private MinecraftKey(String[] id) {
        this(id[0], id[1]);
    }

    public MinecraftKey(String id) {
        this(MinecraftKey.b(id, ':'));
    }

    public static MinecraftKey a(String id, char delimiter) {
        return new MinecraftKey(MinecraftKey.b(id, delimiter));
    }

    @Nullable
    public static MinecraftKey a(String id) {
        try {
            return new MinecraftKey(id);
        }
        catch (ResourceKeyInvalidException var2) {
            return null;
        }
    }

    @Nullable
    public static MinecraftKey a(String namespace, String path) {
        try {
            return new MinecraftKey(namespace, path);
        }
        catch (ResourceKeyInvalidException var3) {
            return null;
        }
    }

    protected static String[] b(String id, char delimiter) {
        String[] strings = new String[]{c, id};
        int i2 = id.indexOf(delimiter);
        if (i2 >= 0) {
            strings[1] = id.substring(i2 + 1);
            if (i2 >= 1) {
                strings[0] = id.substring(0, i2);
            }
        }
        return strings;
    }

    public static DataResult<MinecraftKey> b(String id) {
        try {
            return DataResult.success((Object)new MinecraftKey(id));
        }
        catch (ResourceKeyInvalidException var2) {
            return DataResult.error(() -> "Not a valid resource location: " + id + " " + var2.getMessage());
        }
    }

    public String a() {
        return this.g;
    }

    public String b() {
        return this.f;
    }

    public MinecraftKey c(String path) {
        return new MinecraftKey(this.f, MinecraftKey.d(this.f, path), null);
    }

    public MinecraftKey a(UnaryOperator<String> pathFunction) {
        return this.c((String)pathFunction.apply(this.g));
    }

    public MinecraftKey d(String prefix) {
        return this.c(prefix + this.g);
    }

    public MinecraftKey e(String suffix) {
        return this.c(this.g + suffix);
    }

    public String toString() {
        return this.f + ":" + this.g;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof MinecraftKey)) return false;
        MinecraftKey resourceLocation = (MinecraftKey)object;
        if (!this.f.equals(resourceLocation.f)) return false;
        if (!this.g.equals(resourceLocation.g)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.f.hashCode() + this.g.hashCode();
    }

    public int a(MinecraftKey resourceLocation) {
        int i2 = this.g.compareTo(resourceLocation.g);
        if (i2 == 0) {
            i2 = this.f.compareTo(resourceLocation.f);
        }
        return i2;
    }

    public String c() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String d() {
        return this.f + "." + this.g;
    }

    public String e() {
        return this.f.equals(c) ? this.g : this.d();
    }

    public String f(String prefix) {
        return prefix + "." + this.d();
    }

    public String b(String prefix, String suffix) {
        return prefix + "." + this.d() + "." + suffix;
    }

    public static MinecraftKey a(StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && MinecraftKey.a(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(i2, reader.getCursor());
        try {
            return new MinecraftKey(string);
        }
        catch (ResourceKeyInvalidException var4) {
            reader.setCursor(i2);
            throw e.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean a(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 == '_' || c2 == ':' || c2 == '/' || c2 == '.' || c2 == '-';
    }

    public static boolean g(String path) {
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (MinecraftKey.b(path.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean h(String namespace) {
        for (int i2 = 0; i2 < namespace.length(); ++i2) {
            if (MinecraftKey.c(namespace.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static String c(String namespace, String path) {
        if (!MinecraftKey.h(namespace)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9_.-] character in namespace of location: " + StringUtils.normalizeSpace((String)namespace) + ":" + StringUtils.normalizeSpace((String)path));
        }
        return namespace;
    }

    public static boolean b(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '/' || character == '.';
    }

    private static boolean c(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }

    public static boolean i(String id) {
        String[] strings = MinecraftKey.b(id, ':');
        return MinecraftKey.h(StringUtils.isEmpty((CharSequence)strings[0]) ? c : strings[0]) && MinecraftKey.g(strings[1]);
    }

    private static String d(String namespace, String path) {
        if (!MinecraftKey.g(path)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9/._-] character in path of location: " + namespace + ":" + StringUtils.normalizeSpace((String)path));
        }
        return path;
    }

    protected static interface a {
    }

    public static class b
    implements JsonDeserializer<MinecraftKey>,
    JsonSerializer<MinecraftKey> {
        public MinecraftKey a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return new MinecraftKey(ChatDeserializer.a(jsonElement, "location"));
        }

        public JsonElement a(MinecraftKey resourceLocation, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(resourceLocation.toString());
        }
    }
}

