/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import top.leavesmc.leaves.util.BreakBedrockList;

public class ScoreboardServer
extends Scoreboard {
    private final MinecraftServer b;
    private final Set<ScoreboardObjective> c = Sets.newHashSet();
    private final List<Runnable> d = Lists.newArrayList();

    public ScoreboardServer(MinecraftServer server) {
        this.b = server;
    }

    @Override
    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective, ScoreboardScore score) {
        super.a(scoreHolder, objective, score);
        if (this.c.contains(objective)) {
            this.broadcastAll(new PacketPlayOutScoreboardScore(scoreHolder.cy(), objective.b(), score.a(), score.d(), score.c()));
        }
        this.a();
    }

    @Override
    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        super.a(scoreHolder, objective);
        this.a();
    }

    @Override
    public void a(ScoreHolder scoreHolder) {
        super.a(scoreHolder);
        this.broadcastAll(new ClientboundResetScorePacket(scoreHolder.cy(), null));
        this.a();
    }

    @Override
    public void b(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        super.b(scoreHolder, objective);
        if (this.c.contains(objective)) {
            this.broadcastAll(new ClientboundResetScorePacket(scoreHolder.cy(), objective.b()));
        }
        this.a();
    }

    @Override
    public void a(DisplaySlot slot, @Nullable ScoreboardObjective objective) {
        ScoreboardObjective scoreboardobjective1 = this.a(slot);
        super.a(slot, objective);
        if (scoreboardobjective1 != objective && scoreboardobjective1 != null) {
            if (this.h(scoreboardobjective1) > 0) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(slot, objective));
            } else {
                this.g(scoreboardobjective1);
            }
        }
        if (objective != null) {
            if (this.c.contains(objective)) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(slot, objective));
            } else {
                this.e(objective);
            }
        }
        this.a();
    }

    @Override
    public boolean a(String scoreHolderName, ScoreboardTeam team) {
        if (super.a(scoreHolderName, team)) {
            this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, scoreHolderName, PacketPlayOutScoreboardTeam.a.a));
            this.a();
            return true;
        }
        return false;
    }

    public boolean addPlayersToTeam(Collection<String> players, ScoreboardTeam team) {
        boolean anyAdded = false;
        for (String playerName : players) {
            if (!super.a(playerName, team)) continue;
            anyAdded = true;
        }
        if (anyAdded) {
            this.broadcastAll(PacketPlayOutScoreboardTeam.createMultiplePlayerPacket(team, players, PacketPlayOutScoreboardTeam.a.a));
            this.a();
            return true;
        }
        return false;
    }

    @Override
    public void b(String scoreHolderName, ScoreboardTeam team) {
        super.b(scoreHolderName, team);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, scoreHolderName, PacketPlayOutScoreboardTeam.a.b));
        this.a();
    }

    public void removePlayersFromTeam(Collection<String> players, ScoreboardTeam team) {
        for (String playerName : players) {
            super.b(playerName, team);
        }
        this.broadcastAll(PacketPlayOutScoreboardTeam.createMultiplePlayerPacket(team, players, PacketPlayOutScoreboardTeam.a.b));
        this.a();
    }

    @Override
    public void a(ScoreboardObjective objective) {
        super.a(objective);
        BreakBedrockList.onScoreboardAdd(objective);
        this.a();
    }

    @Override
    public void b(ScoreboardObjective objective) {
        super.b(objective);
        if (this.c.contains(objective)) {
            this.broadcastAll(new PacketPlayOutScoreboardObjective(objective, 2));
        }
        this.a();
    }

    @Override
    public void c(ScoreboardObjective objective) {
        super.c(objective);
        BreakBedrockList.onScoreboardRemove(objective);
        if (this.c.contains(objective)) {
            this.g(objective);
        }
        this.a();
    }

    @Override
    public void a(ScoreboardTeam team) {
        super.a(team);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, true));
        this.a();
    }

    @Override
    public void b(ScoreboardTeam team) {
        super.b(team);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, false));
        this.a();
    }

    @Override
    public void c(ScoreboardTeam team) {
        super.c(team);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(team));
        this.a();
    }

    public void a(Runnable listener) {
        this.d.add(listener);
    }

    protected void a() {
        for (Runnable runnable : this.d) {
            runnable.run();
        }
    }

    public List<Packet<?>> d(ScoreboardObjective objective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(objective, 0));
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != objective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displayslot, objective));
        }
        for (PlayerScoreEntry playerscoreentry : this.i(objective)) {
            list.add(new PacketPlayOutScoreboardScore(playerscoreentry.c(), objective.b(), playerscoreentry.d(), playerscoreentry.e(), playerscoreentry.f()));
        }
        return list;
    }

    public void e(ScoreboardObjective objective) {
        List<Packet<?>> list = this.d(objective);
        for (EntityPlayer entityplayer : this.b.ae().t()) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : list) {
                entityplayer.c.b(packet);
            }
        }
        this.c.add(objective);
    }

    public List<Packet<?>> f(ScoreboardObjective objective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(objective, 1));
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != objective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displayslot, objective));
        }
        return list;
    }

    public void g(ScoreboardObjective objective) {
        List<Packet<?>> list = this.f(objective);
        for (EntityPlayer entityplayer : this.b.ae().t()) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : list) {
                entityplayer.c.b(packet);
            }
        }
        this.c.remove(objective);
    }

    public int h(ScoreboardObjective objective) {
        int i2 = 0;
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != objective) continue;
            ++i2;
        }
        return i2;
    }

    public PersistentBase.a<PersistentScoreboard> b() {
        return new PersistentBase.a<PersistentScoreboard>(this::i, this::a, DataFixTypes.n);
    }

    private PersistentScoreboard i() {
        PersistentScoreboard persistentscoreboard = new PersistentScoreboard(this);
        Objects.requireNonNull(persistentscoreboard);
        this.a(persistentscoreboard::c);
        return persistentscoreboard;
    }

    private PersistentScoreboard a(NBTTagCompound nbt) {
        return this.i().b(nbt);
    }

    private void broadcastAll(Packet packet) {
        for (EntityPlayer entityplayer : this.b.ae().l) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            entityplayer.c.b(packet);
        }
    }

    public static enum Action {
        a,
        b;

    }
}

