/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.WorldDataConfiguration;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger a = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> a(c serverConfig, f<D> loadContextSupplier, e<D, R> saveApplierFactory, Executor prepareExecutor, Executor applyExecutor) {
        try {
            Pair<WorldDataConfiguration, IReloadableResourceManager> pair = serverConfig.a.a();
            IReloadableResourceManager closeableResourceManager = (IReloadableResourceManager)pair.getSecond();
            LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = RegistryLayer.a();
            LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess2 = WorldLoader.b(closeableResourceManager, layeredRegistryAccess, RegistryLayer.b, RegistryDataLoader.a);
            IRegistryCustom.Dimension frozen = layeredRegistryAccess2.b(RegistryLayer.c);
            IRegistryCustom.Dimension frozen2 = RegistryDataLoader.a((IResourceManager)closeableResourceManager, frozen, RegistryDataLoader.b);
            WorldDataConfiguration worldDataConfiguration = (WorldDataConfiguration)pair.getFirst();
            b<D> dataLoadOutput = loadContextSupplier.get(new a(closeableResourceManager, worldDataConfiguration, frozen, frozen2));
            LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess3 = layeredRegistryAccess2.a(RegistryLayer.c, dataLoadOutput.b);
            IRegistryCustom.Dimension frozen3 = layeredRegistryAccess3.b(RegistryLayer.d);
            return ((CompletableFuture)DataPackResources.a(closeableResourceManager, frozen3, worldDataConfiguration.b(), serverConfig.b(), serverConfig.c(), prepareExecutor, applyExecutor).whenComplete((dataPackContents, throwable) -> {
                if (throwable != null) {
                    closeableResourceManager.close();
                }
            })).thenApplyAsync(dataPackContents -> {
                dataPackContents.a(frozen3);
                return saveApplierFactory.create(closeableResourceManager, (DataPackResources)dataPackContents, layeredRegistryAccess3, dataLoadOutput.a);
            }, applyExecutor);
        }
        catch (Exception exception) {
            return CompletableFuture.failedFuture(exception);
        }
    }

    private static IRegistryCustom.Dimension a(IResourceManager resourceManager, LayeredRegistryAccess<RegistryLayer> combinedDynamicRegistries, RegistryLayer type, List<RegistryDataLoader.b<?>> entries) {
        IRegistryCustom.Dimension frozen = combinedDynamicRegistries.b(type);
        return RegistryDataLoader.a(resourceManager, frozen, entries);
    }

    public static LayeredRegistryAccess<RegistryLayer> b(IResourceManager resourceManager, LayeredRegistryAccess<RegistryLayer> combinedDynamicRegistries, RegistryLayer type, List<RegistryDataLoader.b<?>> entries) {
        IRegistryCustom.Dimension frozen = WorldLoader.a(resourceManager, combinedDynamicRegistries, type, entries);
        return combinedDynamicRegistries.a(type, frozen);
    }

    public record c(d a, CommandDispatcher.ServerType b, int c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "a", "b", "c"}, this, object);
        }
    }

    public record d(ResourcePackRepository a, WorldDataConfiguration b, boolean c, boolean d) {
        private final ResourcePackRepository a;
        private final WorldDataConfiguration b;
        private final boolean c;
        private final boolean d;

        public Pair<WorldDataConfiguration, IReloadableResourceManager> a() {
            FeatureFlagSet featureFlagSet = this.d ? FeatureFlags.e.a() : this.b.b();
            WorldDataConfiguration worldDataConfiguration = MinecraftServer.a(this.a, this.b.a(), this.c, featureFlagSet);
            if (!this.d) {
                worldDataConfiguration = worldDataConfiguration.a(this.b.b());
            }
            List<IResourcePack> list = this.a.g();
            ResourceManager closeableResourceManager = new ResourceManager(EnumResourcePackType.b, list);
            return Pair.of((Object)worldDataConfiguration, (Object)closeableResourceManager);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this, object);
        }

        public ResourcePackRepository b() {
            return this.a;
        }

        public WorldDataConfiguration c() {
            return this.b;
        }

        public boolean d() {
            return this.c;
        }

        public boolean e() {
            return this.d;
        }
    }

    public record a(IResourceManager a, WorldDataConfiguration b, IRegistryCustom.Dimension c, IRegistryCustom.Dimension d) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this, object);
        }
    }

    @FunctionalInterface
    public static interface f<D> {
        public b<D> get(a var1);
    }

    public record b<D>(D a, IRegistryCustom.Dimension b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this, object);
        }
    }

    @FunctionalInterface
    public static interface e<D, R> {
        public R create(IReloadableResourceManager var1, DataPackResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

