/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;

public class CommandExecute {
    private static final int b = 32768;
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((maxCount, count) -> IChatBaseComponent.b("commands.execute.blocks.toobig", maxCount, count));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(count -> IChatBaseComponent.b("commands.execute.conditional.fail_count", count));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((function, message) -> IChatBaseComponent.b("commands.execute.function.instantiationFailure", function, message));
    private static final SuggestionProvider<CommandListenerWrapper> f = (context, builder) -> {
        LootDataManager lootDataManager = ((CommandListenerWrapper)context.getSource()).l().aJ();
        return ICompletionProvider.a(lootDataManager.a(LootDataType.a), builder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext commandRegistryAccess) {
        LiteralCommandNode<CommandListenerWrapper> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("execute").requires(source -> source.c(2))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("execute").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("run").redirect(dispatcher.getRoot()))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("if"), true, commandRegistryAccess))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("unless"), false, commandRegistryAccess))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity));
            }
            return list;
        })))).then(net.minecraft.commands.CommandDispatcher.a("at").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a((WorldServer)entity.dM()).a(entity.dk()).a(entity.bG()));
            }
            return list;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("store").then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("result"), true))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("positioned").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos")).a(ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity.dk()));
            }
            return list;
        })))).then(net.minecraft.commands.CommandDispatcher.a("over").then(net.minecraft.commands.CommandDispatcher.a("heightmap", HeightmapTypeArgument.a()).redirect(literalCommandNode, context -> {
            Vec3D vec3 = ((CommandListenerWrapper)context.getSource()).d();
            WorldServer serverLevel = ((CommandListenerWrapper)context.getSource()).e();
            double d2 = vec3.a();
            double e2 = vec3.c();
            if (!serverLevel.b(SectionPosition.b(d2), SectionPosition.b(e2))) {
                throw ArgumentPosition.a.create();
            }
            int i2 = serverLevel.a(HeightmapTypeArgument.a((CommandContext<CommandListenerWrapper>)context, "heightmap"), MathHelper.a(d2), MathHelper.a(e2));
            return ((CommandListenerWrapper)context.getSource()).a(new Vec3D(d2, i2, e2));
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotated").then(net.minecraft.commands.CommandDispatcher.a("rot", ArgumentRotation.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentRotation.a((CommandContext<CommandListenerWrapper>)context, "rot").b((CommandListenerWrapper)context.getSource()))))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity.bG()));
            }
            return list;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            ArgumentAnchor.Anchor anchor = ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context, "anchor");
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity, anchor));
            }
            return list;
        }))))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos")))))).then(net.minecraft.commands.CommandDispatcher.a("align").then(net.minecraft.commands.CommandDispatcher.a("axes", ArgumentRotationAxis.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(((CommandListenerWrapper)context.getSource()).d().a(ArgumentRotationAxis.a((CommandContext<CommandListenerWrapper>)context, "axes"))))))).then(net.minecraft.commands.CommandDispatcher.a("anchored").then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context, "anchor")))))).then(net.minecraft.commands.CommandDispatcher.a("in").then(net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "dimension")))))).then(net.minecraft.commands.CommandDispatcher.a("summon").then(net.minecraft.commands.CommandDispatcher.a("entity", ResourceArgument.a(commandRegistryAccess, Registries.u)).suggests(CompletionProviders.d).redirect(literalCommandNode, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ResourceArgument.e((CommandContext<CommandListenerWrapper>)context, "entity")))))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.a("on")))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(LiteralCommandNode<CommandListenerWrapper> node, LiteralArgumentBuilder<CommandListenerWrapper> builder, boolean requestResult) {
        builder.then(net.minecraft.commands.CommandDispatcher.a("score").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).redirect(node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"), requestResult)))));
        builder.then(net.minecraft.commands.CommandDispatcher.a("bossbar").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(CommandBossBar.a).then(net.minecraft.commands.CommandDispatcher.a("value").redirect(node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), true, requestResult)))).then(net.minecraft.commands.CommandDispatcher.a("max").redirect(node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), false, requestResult)))));
        for (CommandData.c dataProvider : CommandData.b) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)builder, builderx -> builderx.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).then(net.minecraft.commands.CommandDispatcher.a("int").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagInt.a((int)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("float").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagFloat.a((float)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("short").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagShort.a((short)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("long").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagLong.a((long)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("double").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagDouble.a((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")), requestResult))))).then(net.minecraft.commands.CommandDispatcher.a("byte").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int result) -> NBTTagByte.a((byte)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))));
        }
        return builder;
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective, boolean requestResult) {
        ScoreboardServer scoreboard = source.l().aH();
        return source.a((successful, returnValue) -> {
            for (ScoreHolder scoreHolder : targets) {
                ScoreAccess scoreAccess = scoreboard.c(scoreHolder, objective);
                int i2 = requestResult ? returnValue : (successful ? 1 : 0);
                scoreAccess.a(i2);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, BossBattleCustom bossBar, boolean storeInValue, boolean requestResult) {
        return source.a((successful, returnValue) -> {
            int i2;
            int n2 = requestResult ? returnValue : (i2 = successful ? 1 : 0);
            if (storeInValue) {
                bossBar.a(i2);
            } else {
                bossBar.b(i2);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, CommandDataAccessor object, ArgumentNBTKey.g path, IntFunction<NBTBase> nbtSetter, boolean requestResult) {
        return source.a((successful, returnValue) -> {
            try {
                NBTTagCompound compoundTag = object.a();
                int i2 = requestResult ? returnValue : (successful ? 1 : 0);
                path.a((NBTBase)compoundTag, (NBTBase)nbtSetter.apply(i2));
                object.a(compoundTag);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }, CommandResultCallback::chain);
    }

    private static boolean a(WorldServer world, BlockPosition pos) {
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        Chunk levelChunk = world.l().a(chunkPos.e, chunkPos.f);
        if (levelChunk != null) {
            return levelChunk.D() == FullChunkStatus.d && world.c(chunkPos.a());
        }
        return false;
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> root, LiteralArgumentBuilder<CommandListenerWrapper> argumentBuilder, boolean positive, CommandBuildContext commandRegistryAccess) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)argumentBuilder.then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("block", ArgumentBlockPredicate.a(commandRegistryAccess)), positive, (CommandContext<CommandListenerWrapper> context) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "block").test(new ShapeDetectorBlock(((CommandListenerWrapper)context.getSource()).e(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), true))))))).then(net.minecraft.commands.CommandDispatcher.a("biome").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("biome", ResourceOrTagArgument.a(commandRegistryAccess, Registries.at)), positive, (CommandContext<CommandListenerWrapper> context) -> ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context, "biome", Registries.at).test(((CommandListenerWrapper)context.getSource()).e().t(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos")))))))).then(net.minecraft.commands.CommandDispatcher.a("loaded").then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()), positive, (CommandContext<CommandListenerWrapper> commandContext) -> CommandExecute.a(((CommandListenerWrapper)commandContext.getSource()).e(), ArgumentPosition.b((CommandContext<CommandListenerWrapper>)commandContext, "pos")))))).then(net.minecraft.commands.CommandDispatcher.a("dimension").then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()), positive, (CommandContext<CommandListenerWrapper> context) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "dimension") == ((CommandListenerWrapper)context.getSource()).e())))).then(net.minecraft.commands.CommandDispatcher.a("score").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targetObjective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int targetScore, int sourceScore) -> targetScore == sourceScore)))))).then(net.minecraft.commands.CommandDispatcher.a("<").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int targetScore, int sourceScore) -> targetScore < sourceScore)))))).then(net.minecraft.commands.CommandDispatcher.a("<=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int targetScore, int sourceScore) -> targetScore <= sourceScore)))))).then(net.minecraft.commands.CommandDispatcher.a(">").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int targetScore, int sourceScore) -> targetScore > sourceScore)))))).then(net.minecraft.commands.CommandDispatcher.a(">=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int targetScore, int sourceScore) -> targetScore >= sourceScore)))))).then(net.minecraft.commands.CommandDispatcher.a("matches").then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.a()), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)context, "range"))))))))).then(net.minecraft.commands.CommandDispatcher.a("blocks").then(net.minecraft.commands.CommandDispatcher.a("start", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a()).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("all"), positive, false))).then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("masked"), positive, true))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).fork(root, context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, positive, !ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "entities").isEmpty()))).executes(CommandExecute.a(positive, (CommandContext<CommandListenerWrapper> context) -> ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "entities").size()))))).then(net.minecraft.commands.CommandDispatcher.a("predicate").then(CommandExecute.a(root, net.minecraft.commands.CommandDispatcher.a("predicate", ArgumentMinecraftKeyRegistered.a()).suggests(f), positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.c((CommandContext<CommandListenerWrapper>)context, "predicate")))))).then(net.minecraft.commands.CommandDispatcher.a("function").then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentTag.a()).suggests(CommandFunction.b).fork(root, (RedirectModifier)new d(positive))));
        for (CommandData.c dataProvider : CommandData.c) {
            argumentBuilder.then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("data"), builder -> builder.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).fork(root, context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, positive, CommandExecute.a(dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")) > 0))).executes(CommandExecute.a(positive, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a(dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")))))));
        }
        return argumentBuilder;
    }

    private static Command<CommandListenerWrapper> a(boolean positive, b condition) {
        if (positive) {
            return context -> {
                int i2 = condition.test((CommandContext<CommandListenerWrapper>)context);
                if (i2 > 0) {
                    ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", i2), false);
                    return i2;
                }
                throw d.create();
            };
        }
        return context -> {
            int i2 = condition.test((CommandContext<CommandListenerWrapper>)context);
            if (i2 == 0) {
                ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw e.create((Object)i2);
        };
    }

    private static int a(CommandDataAccessor object, ArgumentNBTKey.g path) throws CommandSyntaxException {
        return path.b(object.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> context, e predicate) throws CommandSyntaxException {
        ScoreHolder scoreHolder = ArgumentScoreholder.a(context, "target");
        ScoreboardObjective objective = ArgumentScoreboardObjective.a(context, "targetObjective");
        ScoreHolder scoreHolder2 = ArgumentScoreholder.a(context, "source");
        ScoreboardObjective objective2 = ArgumentScoreboardObjective.a(context, "sourceObjective");
        ScoreboardServer scoreboard = ((CommandListenerWrapper)context.getSource()).l().aH();
        ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.d(scoreHolder, objective);
        ReadOnlyScoreInfo readOnlyScoreInfo2 = scoreboard.d(scoreHolder2, objective2);
        if (readOnlyScoreInfo == null || readOnlyScoreInfo2 == null) {
            return false;
        }
        return predicate.test(readOnlyScoreInfo.a(), readOnlyScoreInfo2.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> context, CriterionConditionValue.IntegerRange range) throws CommandSyntaxException {
        ScoreHolder scoreHolder = ArgumentScoreholder.a(context, "target");
        ScoreboardObjective objective = ArgumentScoreboardObjective.a(context, "targetObjective");
        ScoreboardServer scoreboard = ((CommandListenerWrapper)context.getSource()).l().aH();
        ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.d(scoreHolder, objective);
        if (readOnlyScoreInfo == null) {
            return false;
        }
        return range.d(readOnlyScoreInfo.a());
    }

    private static boolean a(CommandListenerWrapper source, LootItemCondition condition) {
        WorldServer serverLevel = source.e();
        LootParams lootParams = new LootParams.a(serverLevel).a(LootContextParameters.f, source.d()).b(LootContextParameters.a, source.f()).a(LootContextParameterSets.d);
        LootTableInfo lootContext = new LootTableInfo.Builder(lootParams).a(Optional.empty());
        lootContext.b(LootTableInfo.a(condition));
        return condition.test(lootContext);
    }

    private static Collection<CommandListenerWrapper> a(CommandContext<CommandListenerWrapper> context, boolean positive, boolean value) {
        if (value == positive) {
            return Collections.singleton((CommandListenerWrapper)context.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> root, ArgumentBuilder<CommandListenerWrapper, ?> builder, boolean positive, c condition) {
        return ((ArgumentBuilder)builder.fork(root, (RedirectModifier<CommandListenerWrapper>)((RedirectModifier)context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, positive, condition.test((CommandContext<CommandListenerWrapper>)context))))).executes(context -> {
            if (positive == condition.test((CommandContext<CommandListenerWrapper>)context)) {
                ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw d.create();
        });
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> root, ArgumentBuilder<CommandListenerWrapper, ?> builder, boolean positive, boolean masked) {
        return ((ArgumentBuilder)builder.fork(root, (RedirectModifier<CommandListenerWrapper>)((RedirectModifier)context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, positive, CommandExecute.c((CommandContext<CommandListenerWrapper>)context, masked).isPresent())))).executes(positive ? context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, masked) : context -> CommandExecute.b((CommandContext<CommandListenerWrapper>)context, masked));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, boolean masked) throws CommandSyntaxException {
        OptionalInt optionalInt = CommandExecute.c(context, masked);
        if (optionalInt.isPresent()) {
            ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", optionalInt.getAsInt()), false);
            return optionalInt.getAsInt();
        }
        throw d.create();
    }

    private static int b(CommandContext<CommandListenerWrapper> context, boolean masked) throws CommandSyntaxException {
        OptionalInt optionalInt = CommandExecute.c(context, masked);
        if (optionalInt.isPresent()) {
            throw e.create((Object)optionalInt.getAsInt());
        }
        ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt c(CommandContext<CommandListenerWrapper> context, boolean masked) throws CommandSyntaxException {
        return CommandExecute.a(((CommandListenerWrapper)context.getSource()).e(), ArgumentPosition.a(context, "start"), ArgumentPosition.a(context, "end"), ArgumentPosition.a(context, "destination"), masked);
    }

    private static OptionalInt a(WorldServer world, BlockPosition start, BlockPosition end, BlockPosition destination, boolean masked) throws CommandSyntaxException {
        StructureBoundingBox boundingBox = StructureBoundingBox.a(start, end);
        StructureBoundingBox boundingBox2 = StructureBoundingBox.a(destination, destination.a(boundingBox.c()));
        BlockPosition blockPos = new BlockPosition(boundingBox2.h() - boundingBox.h(), boundingBox2.i() - boundingBox.i(), boundingBox2.j() - boundingBox.j());
        int i2 = boundingBox.d() * boundingBox.e() * boundingBox.f();
        if (i2 > 32768) {
            throw c.create((Object)32768, (Object)i2);
        }
        int j2 = 0;
        for (int k2 = boundingBox.j(); k2 <= boundingBox.m(); ++k2) {
            for (int l2 = boundingBox.i(); l2 <= boundingBox.l(); ++l2) {
                for (int m2 = boundingBox.h(); m2 <= boundingBox.k(); ++m2) {
                    BlockPosition blockPos2 = new BlockPosition(m2, l2, k2);
                    BlockPosition blockPos3 = blockPos2.a(blockPos);
                    IBlockData blockState = world.a_(blockPos2);
                    if (masked && blockState.a(Blocks.a)) continue;
                    if (blockState != world.a_(blockPos3)) {
                        return OptionalInt.empty();
                    }
                    TileEntity blockEntity = world.c_(blockPos2);
                    TileEntity blockEntity2 = world.c_(blockPos3);
                    if (blockEntity != null) {
                        NBTTagCompound compoundTag2;
                        if (blockEntity2 == null) {
                            return OptionalInt.empty();
                        }
                        if (blockEntity2.v() != blockEntity.v()) {
                            return OptionalInt.empty();
                        }
                        NBTTagCompound compoundTag = blockEntity.q();
                        if (!compoundTag.equals(compoundTag2 = blockEntity2.q())) {
                            return OptionalInt.empty();
                        }
                    }
                    ++j2;
                }
            }
        }
        return OptionalInt.of(j2);
    }

    private static RedirectModifier<CommandListenerWrapper> a(Function<Entity, Optional<Entity>> function) {
        return context -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
            Entity entity2 = commandSourceStack.f();
            if (entity2 == null) {
                return List.of();
            }
            return ((Optional)function.apply(entity2)).filter(entity -> !entity.dH()).map(entity -> List.of(commandSourceStack.a((Entity)entity))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandListenerWrapper> b(Function<Entity, Stream<Entity>> function) {
        return context -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
            Entity entity2 = commandSourceStack.f();
            if (entity2 == null) {
                return List.of();
            }
            return ((Stream)function.apply(entity2)).filter(entity -> !entity.dH()).map(commandSourceStack::a).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(CommandNode<CommandListenerWrapper> node, LiteralArgumentBuilder<CommandListenerWrapper> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(net.minecraft.commands.CommandDispatcher.a("owner").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof OwnableEntity) {
                OwnableEntity ownableEntity = (OwnableEntity)((Object)entity);
                optional = Optional.ofNullable(ownableEntity.R_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("leasher").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                optional = Optional.ofNullable(mob.fT());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("target").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Targeting) {
                Targeting targeting = (Targeting)((Object)entity);
                optional = Optional.ofNullable(targeting.q());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("attacker").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Attackable) {
                Attackable attackable = (Attackable)((Object)entity);
                optional = Optional.ofNullable(attackable.V_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("vehicle").fork(node, CommandExecute.a((Entity entity) -> Optional.ofNullable(entity.cZ()))))).then(net.minecraft.commands.CommandDispatcher.a("controller").fork(node, CommandExecute.a((Entity entity) -> Optional.ofNullable(entity.cN()))))).then(net.minecraft.commands.CommandDispatcher.a("origin").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof TraceableEntity) {
                TraceableEntity traceableEntity = (TraceableEntity)((Object)entity);
                optional = Optional.ofNullable(traceableEntity.w());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("passengers").fork(node, CommandExecute.b((Entity entity) -> entity.cP().stream())));
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, Holder.c<EntityTypes<?>> entityType) throws CommandSyntaxException {
        Entity entity = CommandSummon.a(source, entityType, source.d(), new NBTTagCompound(), true);
        return source.a(entity);
    }

    /*
     * Exception decompiling
     */
    public static <T extends ExecutionCommandSource<T>> void a(T baseSource, List<T> sources, Function<T, T> functionSourceGetter, IntPredicate predicate, ContextChain<T> contextChain, @Nullable NBTTagCompound args, ExecutionControl<T> control, a<T, Collection<net.minecraft.commands.functions.CommandFunction<T>>> functionNamesGetter, ChainModifiers flags) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void a(List list, ExecutionCommandSource executionCommandSource, ExecutionControl newControl) {
        for (InstantiatedFunction instantiatedFunction : list) {
            newControl.a(new CallFunction<ExecutionCommandSource>(instantiatedFunction, newControl.b().d(), true).bind(executionCommandSource));
        }
        newControl.a(FallthroughTask.a());
    }

    private static /* synthetic */ void a(IntPredicate intPredicate, List list, ExecutionCommandSource executionCommandSource, boolean successful, int returnValue) {
        if (intPredicate.test(returnValue)) {
            list.add(executionCommandSource);
        }
    }

    @FunctionalInterface
    static interface c {
        public boolean test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface b {
        public int test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    static class d
    implements CustomModifierExecutor.a<CommandListenerWrapper> {
        private final IntPredicate a;

        d(boolean success) {
            this.a = success ? result -> result != 0 : result -> result == 0;
        }

        @Override
        @Override
        public void a(CommandListenerWrapper baseSource, List<CommandListenerWrapper> sources, ContextChain<CommandListenerWrapper> contextChain, ChainModifiers flags, ExecutionControl<CommandListenerWrapper> control) {
            CommandExecute.a(baseSource, sources, CommandFunction::a, this.a, contextChain, null, control, context -> ArgumentTag.a((CommandContext<CommandListenerWrapper>)context, "name"), flags);
        }
    }

    @FunctionalInterface
    static interface e {
        public boolean test(int var1, int var2);
    }

    @FunctionalInterface
    public static interface a<T, R> {
        public R get(CommandContext<T> var1) throws CommandSyntaxException;
    }
}

