/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;

public class CommandTitle {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("title").requires(source -> source.c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).then(net.minecraft.commands.CommandDispatcher.a("clear").executes(context -> CommandTitle.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"))))).then(net.minecraft.commands.CommandDispatcher.a("reset").executes(context -> CommandTitle.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"))))).then(net.minecraft.commands.CommandDispatcher.a("title").then(net.minecraft.commands.CommandDispatcher.a("title", ArgumentChatComponent.a()).executes(context -> CommandTitle.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "title"), "title", ClientboundSetTitleTextPacket::new))))).then(net.minecraft.commands.CommandDispatcher.a("subtitle").then(net.minecraft.commands.CommandDispatcher.a("title", ArgumentChatComponent.a()).executes(context -> CommandTitle.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "title"), "subtitle", ClientboundSetSubtitleTextPacket::new))))).then(net.minecraft.commands.CommandDispatcher.a("actionbar").then(net.minecraft.commands.CommandDispatcher.a("title", ArgumentChatComponent.a()).executes(context -> CommandTitle.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "title"), "actionbar", ClientboundSetActionBarTextPacket::new))))).then(net.minecraft.commands.CommandDispatcher.a("times").then(net.minecraft.commands.CommandDispatcher.a("fadeIn", ArgumentTime.a()).then(net.minecraft.commands.CommandDispatcher.a("stay", ArgumentTime.a()).then(net.minecraft.commands.CommandDispatcher.a("fadeOut", ArgumentTime.a()).executes(context -> CommandTitle.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"fadeIn"), IntegerArgumentType.getInteger((CommandContext)context, (String)"stay"), IntegerArgumentType.getInteger((CommandContext)context, (String)"fadeOut"))))))))));
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets) {
        ClientboundClearTitlesPacket clientboundClearTitlesPacket = new ClientboundClearTitlesPacket(false);
        for (EntityPlayer serverPlayer : targets) {
            serverPlayer.c.b(clientboundClearTitlesPacket);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.title.cleared.single", ((EntityPlayer)targets.iterator().next()).Q_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.title.cleared.multiple", targets.size()), true);
        }
        return targets.size();
    }

    private static int b(CommandListenerWrapper source, Collection<EntityPlayer> targets) {
        ClientboundClearTitlesPacket clientboundClearTitlesPacket = new ClientboundClearTitlesPacket(true);
        for (EntityPlayer serverPlayer : targets) {
            serverPlayer.c.b(clientboundClearTitlesPacket);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.title.reset.single", ((EntityPlayer)targets.iterator().next()).Q_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.title.reset.multiple", targets.size()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, IChatBaseComponent title, String titleType, Function<IChatBaseComponent, Packet<?>> constructor) throws CommandSyntaxException {
        for (EntityPlayer serverPlayer : targets) {
            serverPlayer.c.b(constructor.apply(ChatComponentUtils.a(source, title, (Entity)serverPlayer, 0)));
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.title.show." + titleType + ".single", ((EntityPlayer)targets.iterator().next()).Q_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.title.show." + titleType + ".multiple", targets.size()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, int fadeIn, int stay, int fadeOut) {
        ClientboundSetTitlesAnimationPacket clientboundSetTitlesAnimationPacket = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        for (EntityPlayer serverPlayer : targets) {
            serverPlayer.c.b(clientboundSetTitlesAnimationPacket);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.title.times.single", ((EntityPlayer)targets.iterator().next()).Q_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.title.times.multiple", targets.size()), true);
        }
        return targets.size();
    }
}

