/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Unit;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class ResetChunksCommand {
    private static final Logger a = LogUtils.getLogger();

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("resetchunks").requires(source -> source.c(2))).executes(context -> ResetChunksCommand.a((CommandListenerWrapper)context.getSource(), 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("range", IntegerArgumentType.integer((int)0, (int)5)).executes(context -> ResetChunksCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"range"), true))).then(net.minecraft.commands.CommandDispatcher.a("skipOldChunks", BoolArgumentType.bool()).executes(context -> ResetChunksCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"range"), BoolArgumentType.getBool((CommandContext)context, (String)"skipOldChunks")))))));
    }

    private static int a(CommandListenerWrapper source, int radius, boolean skipOldChunks) {
        WorldServer serverLevel = source.e();
        ChunkProviderServer serverChunkCache = serverLevel.l();
        serverChunkCache.a.d();
        Vec3D vec3 = source.d();
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(BlockPosition.a(vec3));
        int i2 = chunkPos.f - radius;
        int j2 = chunkPos.f + radius;
        int k2 = chunkPos.e - radius;
        int l2 = chunkPos.e + radius;
        for (int m2 = i2; m2 <= j2; ++m2) {
            for (int n2 = k2; n2 <= l2; ++n2) {
                ChunkCoordIntPair chunkPos2 = new ChunkCoordIntPair(n2, m2);
                Chunk levelChunk = serverChunkCache.a(n2, m2, false);
                if (levelChunk == null || skipOldChunks && levelChunk.s()) continue;
                for (BlockPosition blockPos : BlockPosition.b(chunkPos2.d(), serverLevel.J_(), chunkPos2.e(), chunkPos2.f(), serverLevel.al() - 1, chunkPos2.g())) {
                    serverLevel.a(blockPos, Blocks.a.o(), 16);
                }
            }
        }
        ThreadedMailbox<Runnable> processorMailbox = ThreadedMailbox.a(SystemUtils.f(), "worldgen-resetchunks");
        long o2 = System.currentTimeMillis();
        int p2 = (radius * 2 + 1) * (radius * 2 + 1);
        for (ChunkStatus chunkStatus : ImmutableList.of((Object)ChunkStatus.f, (Object)ChunkStatus.g, (Object)ChunkStatus.h, (Object)ChunkStatus.i, (Object)ChunkStatus.j, (Object)ChunkStatus.k)) {
            long q2 = System.currentTimeMillis();
            CompletionStage<Object> completableFuture = CompletableFuture.supplyAsync(() -> Unit.INSTANCE, processorMailbox::a);
            for (int r2 = chunkPos.f - radius; r2 <= chunkPos.f + radius; ++r2) {
                for (int s2 = chunkPos.e - radius; s2 <= chunkPos.e + radius; ++s2) {
                    ChunkCoordIntPair chunkPos3 = new ChunkCoordIntPair(s2, r2);
                    Chunk levelChunk2 = serverChunkCache.a(s2, r2, false);
                    if (levelChunk2 == null || skipOldChunks && levelChunk2.s()) continue;
                    ArrayList list = Lists.newArrayList();
                    int t2 = Math.max(1, chunkStatus.e());
                    for (int u2 = chunkPos3.f - t2; u2 <= chunkPos3.f + t2; ++u2) {
                        for (int v2 = chunkPos3.e - t2; v2 <= chunkPos3.e + t2; ++v2) {
                            IChunkAccess chunkAccess4;
                            IChunkAccess chunkAccess = serverChunkCache.a(v2, u2, chunkStatus.d(), true);
                            if (chunkAccess instanceof ProtoChunkExtension) {
                                ProtoChunkExtension chunkAccess2 = new ProtoChunkExtension(((ProtoChunkExtension)chunkAccess).C(), true);
                            } else if (chunkAccess instanceof Chunk) {
                                ProtoChunkExtension chunkAccess3 = new ProtoChunkExtension((Chunk)chunkAccess, true);
                            } else {
                                chunkAccess4 = chunkAccess;
                            }
                            list.add(chunkAccess4);
                        }
                    }
                    completableFuture = completableFuture.thenComposeAsync(unit -> chunkStatus.a(processorMailbox::a, serverLevel, serverChunkCache.g(), serverLevel.q(), serverChunkCache.a(), chunk -> {
                        throw new UnsupportedOperationException("Not creating full chunks here");
                    }, list).thenApply(either -> {
                        if (chunkStatus == ChunkStatus.g) {
                            either.left().ifPresent(chunk -> HeightMap.a(chunk, ChunkStatus.b));
                        }
                        return Unit.INSTANCE;
                    }), processorMailbox::a);
                }
            }
            source.l().c(() -> completableFuture.isDone());
            a.debug(chunkStatus + " took " + (System.currentTimeMillis() - q2) + " ms");
        }
        long w2 = System.currentTimeMillis();
        for (int x2 = chunkPos.f - radius; x2 <= chunkPos.f + radius; ++x2) {
            for (int y2 = chunkPos.e - radius; y2 <= chunkPos.e + radius; ++y2) {
                ChunkCoordIntPair chunkPos4 = new ChunkCoordIntPair(y2, x2);
                Chunk levelChunk3 = serverChunkCache.a(y2, x2, false);
                if (levelChunk3 == null || skipOldChunks && levelChunk3.s()) continue;
                for (BlockPosition blockPos2 : BlockPosition.b(chunkPos4.d(), serverLevel.J_(), chunkPos4.e(), chunkPos4.f(), serverLevel.al() - 1, chunkPos4.g())) {
                    serverChunkCache.a(blockPos2);
                }
            }
        }
        a.debug("blockChanged took " + (System.currentTimeMillis() - w2) + " ms");
        long z2 = System.currentTimeMillis() - o2;
        source.a(() -> IChatBaseComponent.b(String.format(Locale.ROOT, "%d chunks have been reset. This took %d ms for %d chunks, or %02f ms per chunk", p2, z2, p2, Float.valueOf((float)z2 / (float)p2))), true);
        return 1;
    }
}

