/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerLocaleChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.util.ReturnPortalManager;

public class EntityPlayer
extends EntityHuman {
    private static final Logger b = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cm = 32;
    private static final int cn = 10;
    private static final int co = 25;
    public PlayerConnection c;
    public final MinecraftServer d;
    public PlayerInteractManager e;
    private final AdvancementDataPlayer cp;
    private final ServerStatisticManager cq;
    private float cr = Float.MIN_VALUE;
    private int cs = Integer.MIN_VALUE;
    private int ct = Integer.MIN_VALUE;
    private int cu = Integer.MIN_VALUE;
    private int cw = Integer.MIN_VALUE;
    private int cx = Integer.MIN_VALUE;
    private float cy = -1.0E8f;
    private int cz = -99999999;
    private boolean cA = true;
    public int cB = -99999999;
    public int cC = 60;
    private EnumChatVisibility cD;
    private boolean cE = true;
    private long cF;
    @Nullable
    private net.minecraft.world.entity.Entity cG;
    public boolean cH;
    public boolean cI;
    private final RecipeBookServer cJ;
    @Nullable
    private Vec3D cK;
    private int cL;
    private boolean cM;
    private int cN = 2;
    public String cO = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3D cP;
    @Nullable
    private Vec3D cQ;
    @Nullable
    private Vec3D cR;
    private SectionPosition cS;
    private ChunkTrackingView cT;
    private ResourceKey<net.minecraft.world.level.World> cU;
    @Nullable
    private BlockPosition cV;
    private boolean cW;
    private float cX;
    private final ITextFilter cY;
    private boolean cZ;
    private boolean da;
    public WardenSpawnTracker db;
    public final ContainerSynchronizer dc;
    private final ICrafting dd;
    @Nullable
    private RemoteChatSession de;
    private int df;
    public boolean f;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public String displayName;
    public Component adventure$displayName;
    public IChatBaseComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean isRealPlayer;
    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> cachedSingleHashSet;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public String clientBrandName = null;
    public PlayerQuitEvent.QuitReason quitReason = null;
    private int instaBreakCountPerTick = 0;
    private int placeBlockCountPerTick = 0;
    private final AtomicReference<RegionizedPlayerChunkLoader.ViewDistances> viewDistances = new AtomicReference<RegionizedPlayerChunkLoader.ViewDistances>(new RegionizedPlayerChunkLoader.ViewDistances(-1, -1, -1));
    public RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    public double lastEntitySpawnRadiusSquared = -1.0;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public RegionizedPlayerChunkLoader.ViewDistances getViewDistances() {
        return this.viewDistances.get();
    }

    private void updateViewDistance(Function<RegionizedPlayerChunkLoader.ViewDistances, RegionizedPlayerChunkLoader.ViewDistances> update) {
        RegionizedPlayerChunkLoader.ViewDistances curr = this.viewDistances.get();
        while (!this.viewDistances.compareAndSet(curr, update.apply(curr))) {
        }
    }

    public void setTickViewDistance(int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("Tick view distance must be a number between 2 and 32, got: " + distance);
        }
        this.updateViewDistance(input -> input.setTickViewDistance(distance));
    }

    public void setLoadViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Load view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setLoadViewDistance(distance));
    }

    public void setSendViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Send view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setSendViewDistance(distance));
    }

    public EntityPlayer(MinecraftServer server, WorldServer world, GameProfile profile, ClientInformation clientOptions) {
        super(world, world.T(), world.U(), profile);
        this.cD = EnumChatVisibility.a;
        this.cF = SystemUtils.b();
        this.cJ = new RecipeBookServer();
        this.cS = SectionPosition.a(0, 0, 0);
        this.cT = ChunkTrackingView.a;
        this.cU = net.minecraft.world.level.World.h;
        this.db = new WardenSpawnTracker(0, 0, 0);
        this.dc = new ContainerSynchronizer(){

            @Override
            public void a(Container handler, NonNullList<ItemStack> stacks, ItemStack cursorStack, int[] properties) {
                EntityPlayer.this.c.b(new PacketPlayOutWindowItems(handler.j, handler.k(), stacks, cursorStack));
                for (int i2 = 0; i2 < properties.length; ++i2) {
                    this.b(handler, i2, properties[i2]);
                }
            }

            @Override
            public void sendOffHandSlotChange() {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(EntityPlayer.this.bR.j, EntityPlayer.this.bR.k(), 45, EntityPlayer.this.bR.b(45).g().p()));
            }

            @Override
            public void a(Container handler, int slot, ItemStack stack) {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(handler.j, handler.k(), slot, stack));
            }

            @Override
            public void a(Container handler, ItemStack stack) {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(-1, handler.k(), -1, stack));
            }

            @Override
            public void a(Container handler, int property, int value) {
                this.b(handler, property, value);
            }

            private void b(Container handler, int property, int value) {
                EntityPlayer.this.c.b(new PacketPlayOutWindowData(handler.j, property, value));
            }
        };
        this.dd = new ICrafting(){

            @Override
            public void a(Container handler, int slotId, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fS()) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.fS(), stack);
                }
            }

            @Override
            public void slotChanged(Container handler, int slotId, ItemStack oldStack, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fS()) {
                    if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                        CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.fS(), stack);
                        return;
                    }
                    PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), slotId, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                    event.callEvent();
                    if (event.shouldTriggerAdvancements()) {
                        CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.fS(), stack);
                    }
                }
            }

            @Override
            public void a(Container handler, int property, int value) {
            }
        };
        this.cY = server.a(this);
        this.e = server.b(this);
        this.d = server;
        this.cq = server.ae().getPlayerStats(this);
        this.cp = server.ae().f(this);
        this.t(1.0f);
        this.updateOptionsNoEvents(clientOptions);
        this.cachedSingleHashSet = new PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>(this);
        this.displayName = this.cy();
        this.adventure$displayName = Component.text((String)this.cy());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eM();
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.T();
        if (worldserver.E_().g() && worldserver.K.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(worldserver));
            int j2 = MathHelper.a(worldserver.D_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    public void e(WorldServer world) {
        BlockPosition blockposition = world.T();
        if (world.E_().g() && world.K.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(world));
            int j2 = MathHelper.a(world.D_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(world, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                this.a(blockposition1, world.U(), 0.0f);
                if (!world.noCollision(this, this.cH(), true)) {
                    continue;
                }
                break;
            }
        } else {
            this.a(blockposition, world.U(), 0.0f);
            while (!world.noCollision(this, this.cH(), true) && this.dt() < (double)(world.al() - 1)) {
                this.a_(this.dr(), this.dt() + 1.0, this.dx());
            }
        }
    }

    private int u(int horizontalSpawnArea) {
        return horizontalSpawnArea <= 16 ? horizontalSpawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String spawnWorld;
        CraftWorld oldWorld;
        super.a(nbt);
        if (nbt.b("warden_spawn_tracker", 10)) {
            DataResult dataresult = WardenSpawnTracker.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("warden_spawn_tracker")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.db = wardenspawntracker;
            });
        }
        if (nbt.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("enteredNetherPosition");
            this.cQ = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.cI = nbt.q("seenCredits");
        if (nbt.b("recipeBook", 10)) {
            this.cJ.a(nbt.p("recipeBook"), this.d.aG());
        }
        this.getBukkitEntity().readExtraData(nbt);
        if (this.fD()) {
            this.fE();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbt.l("SpawnWorld")))) != null) {
            this.cU = oldWorld.getHandle().ae();
        }
        if (nbt.b("SpawnX", 99) && nbt.b("SpawnY", 99) && nbt.b("SpawnZ", 99)) {
            this.cV = new BlockPosition(nbt.h("SpawnX"), nbt.h("SpawnY"), nbt.h("SpawnZ"));
            this.cW = nbt.q("SpawnForced");
            this.cX = nbt.j("SpawnAngle");
            if (nbt.e("SpawnDimension")) {
                DataResult dataresult1 = net.minecraft.world.level.World.g.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("SpawnDimension"));
                Logger logger1 = b;
                Objects.requireNonNull(logger1);
                this.cU = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(net.minecraft.world.level.World.h);
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.db);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("warden_spawn_tracker", (NBTBase)nbtbase));
        this.k(nbt);
        nbt.a("seenCredits", this.cI);
        if (this.cQ != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.cQ.c);
            nbttagcompound1.a("y", this.cQ.d);
            nbttagcompound1.a("z", this.cQ.e);
            nbt.a("enteredNetherPosition", nbttagcompound1);
        }
        net.minecraft.world.entity.Entity entity = this.cW();
        net.minecraft.world.entity.Entity entity1 = this.cZ();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (net.minecraft.world.entity.Entity vehicle = entity1; vehicle != null; vehicle = vehicle.cZ()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.cV() && !entity.dH()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound nbttagcompound3 = new NBTTagCompound();
            entity.e(nbttagcompound3);
            nbttagcompound2.a("Attach", entity1.cw());
            nbttagcompound2.a("Entity", nbttagcompound3);
            nbt.a("RootVehicle", nbttagcompound2);
        }
        nbt.a("recipeBook", this.cJ.b());
        nbt.a("Dimension", this.dM().ae().a().toString());
        if (this.cV != null) {
            nbt.a("SpawnX", this.cV.u());
            nbt.a("SpawnY", this.cV.v());
            nbt.a("SpawnZ", this.cV.w());
            nbt.a("SpawnForced", this.cW);
            nbt.a("SpawnAngle", this.cX);
            dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cU.a());
            logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbt);
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.a(world);
        if (world == null) {
            this.dJ();
            Vec3D position = null;
            if (this.cU != null && (world = this.d.a(this.cU)) != null && this.R() != null) {
                position = EntityHuman.a((WorldServer)world, this.R(), this.S(), false, false).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.b(world.T());
            }
            this.a(world);
            this.p(position.a(), position.b(), position.c());
        }
        this.e.a((WorldServer)world);
    }

    public void a(int points) {
        float f2 = this.gb();
        float f1 = (f2 - 1.0f) / f2;
        this.ch = MathHelper.a((float)points / f2, 0.0f, f1);
        this.cB = -1;
    }

    public void b(int level) {
        this.cf = level;
        this.cB = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cB = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int experienceLevels) {
        super.a(enchantedItem, experienceLevels);
        this.cB = -1;
    }

    public void a(Container screenHandler) {
        screenHandler.a(this.dd);
        screenHandler.a(this.dc);
    }

    public void h() {
        this.a(this.bR);
    }

    @Override
    public void g_() {
        super.g_();
        this.c.b(new ClientboundPlayerCombatEnterPacket());
    }

    @Override
    public void h_() {
        super.h_();
        this.c.b(new ClientboundPlayerCombatEndPacket(this.eK()));
    }

    @Override
    protected void a(IBlockData state) {
        CriterionTriggers.e.a(this, state);
    }

    @Override
    protected ItemCooldown k() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void l() {
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.resetOperationCountPerTick();
        this.e.a();
        this.db.a();
        --this.cC;
        if (this.al > 0) {
            --this.al;
        }
        if (!(this instanceof ServerBot)) {
            if (--this.containerUpdateDelay <= 0) {
                this.bS.d();
                this.containerUpdateDelay = this.dM().paperConfig().tickRates.containerUpdate;
            }
            if (!(this.dM().B || this.bS == this.bR || !this.eY() && this.bS.a(this))) {
                this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
                this.bS = this.bR;
            }
        }
        if ((entity = this.K()) != this) {
            if (entity.bx()) {
                this.a(entity.dr(), entity.dt(), entity.dx(), entity.dC(), entity.dE());
                this.z().l().a(this);
                if (this.fJ()) {
                    this.c((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.c((net.minecraft.world.entity.Entity)this);
            }
        }
        if (!(this instanceof ServerBot)) {
            CriterionTriggers.x.a(this);
        }
        if (this.cK != null) {
            CriterionTriggers.v.a(this, this.cK, this.ah - this.cL);
        }
        this.o();
        this.p();
        this.cp.b(this);
    }

    public void m() {
        try {
            if (this.valid && !this.P_() || !this.de()) {
                super.l();
            }
            for (int i2 = 0; i2 < this.fS().b(); ++i2) {
                Packet<?> packet;
                ItemStack itemstack = this.fS().a(i2);
                if (!itemstack.d().al_() || (packet = ((ItemWorldMapBase)itemstack.d()).a(itemstack, this.dM(), this)) == null) continue;
                this.c.b(packet);
            }
            if (this.ev() != this.cy || this.cz != this.bT.a() || this.bT.e() == 0.0f != this.cA) {
                this.c.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.bT.a(), this.bT.e()));
                this.cy = this.ev();
                this.cz = this.bT.a();
                boolean bl = this.cA = this.bT.e() == 0.0f;
            }
            if (this.ev() + this.fk() != this.cr) {
                this.cr = this.ev() + this.fk();
                this.a(IScoreboardCriteria.f, MathHelper.f(this.cr));
            }
            if (this.bT.a() != this.cs) {
                this.cs = this.bT.a();
                this.a(IScoreboardCriteria.g, MathHelper.f((float)this.cs));
            }
            if (this.ci() != this.ct) {
                this.ct = this.ci();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.ct));
            }
            if (this.eJ() != this.cu) {
                this.cu = this.eJ();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cu));
            }
            if (this.cg != this.cx) {
                this.cx = this.cg;
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cx));
            }
            if (this.maxHealthCache != (double)this.eM()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cf != this.cw) {
                this.cw = this.cf;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cw));
            }
            if (this.cg != this.cB) {
                this.cB = this.cg;
                this.c.b(new PacketPlayOutExperience(this.ch, this.cg, this.cf));
            }
            if (this.ah % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cf;
            }
            if (this.oldLevel != this.cf) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cf);
                this.oldLevel = this.cf;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void n() {
        if (this.ev() > 0.0f && this.cP != null) {
            CriterionTriggers.V.a(this, this.cP);
        }
        this.cP = null;
        super.n();
    }

    public void o() {
        if (this.ab > 0.0f && this.cP == null) {
            this.cP = this.dk();
        }
    }

    public void p() {
        if (this.cZ() != null && this.cZ().bn()) {
            if (this.cR == null) {
                this.cR = this.dk();
            } else {
                CriterionTriggers.W.a(this, this.cR);
            }
        }
        if (!(this.cR == null || this.cZ() != null && this.cZ().bn())) {
            this.cR = null;
        }
    }

    private void a(IScoreboardCriteria criterion, int score) {
        this.dM().getCraftServer().getScoreboardManager().forAllObjectives(criterion, this, scoreaccess -> scoreaccess.a(score));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack item = inv.get(i2);
            if (EnchantmentManager.e(item) || itemsToKeep.isEmpty() || item.b()) {
                inv.set(i2, ItemStack.f);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i2, ItemStack.f);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        TextComponent deathMessage;
        boolean keepInventory;
        boolean flag = this.dM().Z().b(GameRules.n);
        if (this.dH()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.fS().b());
        boolean bl = keepInventory = this.dM().Z().b(GameRules.d) || this.P_();
        if (!keepInventory || this instanceof ServerBot) {
            for (ItemStack item : this.fS().getContents()) {
                if (item.b() || EnchantmentManager.e(item)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false)));
            }
        }
        if (this.ed() && this.dM().Z().b(GameRules.f)) {
            this.a(damageSource, this.aZ > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.eK().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, loot, PaperAdventure.asAdventure(defaultMessage), keepInventory);
        if (event.isCancelled()) {
            if (this.ev() <= 0.0f) {
                this.c((float)event.getReviveHealth());
            }
            return;
        }
        this.a(GameEvent.p);
        if (this.bS != this.bR) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = deathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (deathMessage != null && deathMessage != Component.empty() && flag) {
            IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla((Component)deathMessage);
            this.c.a(new ClientboundPlayerCombatKillPacket(this.aj(), ichatbasecomponent), PacketSendListener.a(() -> {
                boolean flag1 = true;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("death.attack.even_more_magic", this.Q_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.aj(), ichatmutablecomponent1);
            }));
            ScoreboardTeam scoreboardTeam = this.cg();
            if (scoreboardTeam != null && scoreboardTeam.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardTeam.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.d.ae().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardTeam.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.d.ae().b(this, ichatbasecomponent);
                }
            } else {
                this.d.ae().a(ichatbasecomponent, false);
            }
        } else {
            this.c.b(new ClientboundPlayerCombatKillPacket(this.aj(), CommonComponents.a));
        }
        this.gg();
        if (this.dM().Z().b(GameRules.N)) {
            this.gs();
        }
        if (event.shouldDropExperience()) {
            this.ez();
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.fS().o) {
                EntityPlayer.processKeep(event, nonNullList);
            }
            EntityPlayer.processKeep(event, null);
        }
        this.c((net.minecraft.world.entity.Entity)this);
        this.dM().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.c, this, ScoreAccess::b);
        EntityLiving entityliving = this.eL();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ai()));
            entityliving.a((net.minecraft.world.entity.Entity)this, this.bh, damageSource);
            this.f(entityliving);
        }
        this.dM().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aA();
        this.k(0);
        this.a_(false);
        this.eK().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.dM().ae(), this.dm())));
    }

    private void gs() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.dm()).c(32.0, 10.0, 32.0);
        this.dM().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled != this) {
            super.a(entityKilled, score, damageSource);
            this.s(score);
            this.dM().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
            if (entityKilled instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dM().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.d, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.O);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entityKilled, IScoreboardCriteria.l);
            this.a((ScoreHolder)entityKilled, (ScoreHolder)this, IScoreboardCriteria.m);
            CriterionTriggers.c.a(this, entityKilled, damageSource);
        }
    }

    private void a(ScoreHolder targetScoreHolder, ScoreHolder aboutScoreHolder, IScoreboardCriteria[] criterions) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gh().e(aboutScoreHolder.cy());
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < criterions.length) {
            this.dM().getCraftServer().getScoreboardManager().forAllObjectives(criterions[i2], targetScoreHolder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        net.minecraft.world.entity.Entity entity1;
        EntityHuman entityhuman;
        boolean flag;
        if (this.b(source)) {
            return false;
        }
        boolean bl = flag = this.d.l() && this.gt() && source.a(DamageTypeTags.n);
        if (!flag && this.cC > 0 && !source.a(DamageTypeTags.e)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = source.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).w()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(source, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.c.b(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.gt() ? false : super.a(player);
    }

    private boolean gt() {
        return this.dM().pvpMode;
    }

    @Override
    @Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        ShapeDetectorShape shapedetectorshape = super.a(destination);
        WorldServer worldServer = destination = shapedetectorshape == null ? destination : shapedetectorshape.world;
        if (shapedetectorshape != null && this.dM().getTypeKey() == WorldDimension.b && destination != null && destination.getTypeKey() == WorldDimension.d) {
            Vec3D vec3d = shapedetectorshape.a.b(0.0, -1.0, 0.0);
            return new ShapeDetectorShape(vec3d, Vec3D.b, 90.0f, 0.0f, destination, shapedetectorshape.portalEventInfo);
        }
        return shapedetectorshape;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity b(WorldServer destination) {
        return this.changeDimension(destination, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Nullable
    public net.minecraft.world.entity.Entity changeDimension(WorldServer worldserver, PlayerTeleportEvent.TeleportCause cause) {
        if (this.fD()) {
            return this;
        }
        WorldServer worldserver1 = this.z();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        if (resourcekey == WorldDimension.d && worldserver != null && worldserver.getTypeKey() == WorldDimension.b) {
            this.cH = true;
            this.ag();
            this.z().a(this, Entity.RemovalReason.e);
            if (!this.f) {
                if (this.dM().paperConfig().misc.disableEndCredits) {
                    this.cI = true;
                }
                this.f = true;
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, this.cI ? 0.0f : 1.0f));
                this.cI = true;
            }
            return this;
        }
        ShapeDetectorShape shapedetectorshape = this.a(worldserver);
        if (shapedetectorshape != null) {
            worldserver1.af().a("moving");
            worldserver = shapedetectorshape.world;
            if (worldserver != null) {
                if (resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
                    this.cQ = this.dk();
                } else if (worldserver.getTypeKey() == WorldDimension.d && shapedetectorshape.portalEventInfo != null && shapedetectorshape.portalEventInfo.getCanCreatePortal()) {
                    this.a(worldserver, BlockPosition.a(shapedetectorshape.a));
                }
            }
        } else {
            return null;
        }
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(shapedetectorshape.a, (World)worldserver.getWorld(), shapedetectorshape.c, shapedetectorshape.d);
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
            return null;
        }
        exit = tpEvent.getTo();
        worldserver = ((CraftWorld)exit.getWorld()).getHandle();
        worldserver1.af().c();
        worldserver1.af().a("placing");
        this.cH = true;
        this.c.b(new PacketPlayOutRespawn(this.d(worldserver), 3));
        this.c.b(new PacketPlayOutServerDifficulty(worldserver.ak(), this.dM().B_().t()));
        PlayerList playerlist = this.d.ae();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dJ();
        this.c(worldserver);
        this.c.teleport(exit);
        this.c.m();
        worldserver.b(this);
        worldserver1.af().c();
        this.f(worldserver1);
        this.c.b(new PacketPlayOutAbilities(this.fT()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        for (MobEffect mobeffect : this.es()) {
            this.c.b(new PacketPlayOutEntityEffect(this.aj(), mobeffect));
        }
        this.c.b(new PacketPlayOutWorldEvent(1032, BlockPosition.b, 0, false));
        this.cB = -1;
        this.cy = -1.0f;
        this.cz = -1;
        if (LeavesConfig.fakeplayerSupport) {
            ServerBot.getBots().forEach(bot1 -> bot1.sendFakeDataIfNeed(this, true));
        }
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.dM().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (LeavesConfig.netherPortalFix) {
            BlockPosition lastPos;
            ResourceKey<net.minecraft.world.level.World> fromDim = worldserver1.ae();
            ResourceKey<net.minecraft.world.level.World> toDim = this.dM().ae();
            ResourceKey<net.minecraft.world.level.World> OVERWORLD = net.minecraft.world.level.World.h;
            ResourceKey<net.minecraft.world.level.World> THE_NETHER = net.minecraft.world.level.World.i;
            if ((fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD) && (lastPos = ((EntityLiving)this).cb) != null) {
                BlockUtil.Rectangle fromPortal = ReturnPortalManager.findPortalAt(this, fromDim, lastPos);
                BlockPosition toPos = this.dm();
                if (fromPortal != null) {
                    ReturnPortalManager.storeReturnPortal(this, toDim, toPos, fromPortal);
                }
            }
        }
        if (this.fu()) {
            this.ft();
        }
        return this;
    }

    @Override
    protected CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, WorldServer exitWorldServer, Vec3D exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld(), this.dC(), this.dE());
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    private void a(WorldServer world, BlockPosition centerPos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = centerPos.j();
        BlockStateListPopulator blockList = new BlockStateListPopulator(world);
        for (int i2 = -2; i2 <= 2; ++i2) {
            for (int j2 = -2; j2 <= 2; ++j2) {
                for (int k2 = -1; k2 < 3; ++k2) {
                    IBlockData iblockdata = k2 == -1 ? Blocks.co.o() : Blocks.a.o();
                    blockList.a((BlockPosition)blockposition_mutableblockposition.g(centerPos).e(j2, k2, i2), iblockdata, 3);
                }
            }
        }
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)world.getWorld(), (Entity)this.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
        world.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        Optional<BlockUtil.Rectangle> optional = super.getExitPortal(worldserver, blockposition, flag, worldborder, searchRadius, canCreatePortal, createRadius);
        if (LeavesConfig.netherPortalFix) {
            WorldServer toLevel;
            MinecraftServer server;
            ReturnPortalManager.ReturnPortal returnPortal;
            boolean isTeleportBetweenNetherAndOverworld;
            BlockPosition fromPos = this.dm();
            ResourceKey<net.minecraft.world.level.World> fromDim = this.dM().ae();
            ResourceKey<net.minecraft.world.level.World> toDim = this.dM().ae();
            ResourceKey<net.minecraft.world.level.World> OVERWORLD = net.minecraft.world.level.World.h;
            ResourceKey<net.minecraft.world.level.World> THE_NETHER = net.minecraft.world.level.World.i;
            boolean bl = isTeleportBetweenNetherAndOverworld = fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD;
            if (this.av && isTeleportBetweenNetherAndOverworld && (returnPortal = ReturnPortalManager.findReturnPortal(this, fromDim, fromPos)) != null && (server = this.cL()) != null && (toLevel = server.a(toDim)) != null) {
                return Optional.of(returnPortal.rectangle());
            }
        }
        if (optional.isPresent() || !canCreatePortal) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = this.dM().a_(this.ax).d(BlockPortal.b).orElse(EnumDirection.EnumAxis.a);
        Optional<BlockUtil.Rectangle> optional1 = worldserver.p().createPortal(blockposition, enumdirection_enumaxis, this, createRadius);
        if (optional1.isEmpty()) {
            // empty if block
        }
        return optional1;
    }

    public void f(WorldServer origin) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = origin.ae();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.dM().ae();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(origin);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dM());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourcekey;
            maindimensionkey1 = resourcekey1;
        }
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.w.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.cQ != null) {
            CriterionTriggers.D.a(this, this.cQ);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.cQ = null;
        }
    }

    @Override
    public boolean a(EntityPlayer spectator) {
        return spectator.P_() ? this.K() == this : (this.P_() ? false : super.a(spectator));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity item, int count) {
        super.a(item, count);
        this.bS.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fD() && this.bx()) {
            if (!this.dM().E_().j() || !this.dM().E_().l()) {
                return Either.left(EntityHuman.EnumBedResult.a);
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.c);
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.d);
            }
            this.setRespawnPosition(this.dM().ae(), blockposition, this.dC(), false, true, PlayerSetSpawnEvent.Cause.BED);
            if (this.dM().P()) {
                return Either.left(EntityHuman.EnumBedResult.b);
            }
            if (!this.f()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.dM().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.f(this));
                if (!list.isEmpty()) {
                    return Either.left(EntityHuman.EnumBedResult.f);
                }
            }
            return Either.right(Unit.a);
        }
        return Either.left(EntityHuman.EnumBedResult.e);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.dM().a_(blockposition).c(BlockFacingHorizontal.aE);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.r.a(this);
        });
        if (!this.z().d()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dM()).e();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3d = Vec3D.c(pos);
        return Math.abs(this.dr() - vec3d.a()) <= 3.0 && Math.abs(this.dt() - vec3d.b()) <= 2.0 && Math.abs(this.dx() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.c();
        return !this.h(blockposition1) || !this.h(blockposition1.a(direction.g()));
    }

    @Override
    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        if (!this.fD()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fB().orElse(null);
        Block bed = bedPosition != null ? this.dM().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dM().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fD()) {
            this.z().l().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(skipSleepTimer, updateSleepingPlayers);
        if (this.c != null) {
            this.c.teleport(this.dr(), this.dt(), this.dx(), this.dC(), this.dE(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void a(double destX, double destY, double destZ) {
        this.bC();
        this.a_(destX, destY, destZ);
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) || this.O() || !LeavesConfig.mcTechnicalMode && !this.dM().paperConfig().collisions.allowPlayerCrammingDamage && damageSource == this.dN().g();
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    protected void c(BlockPosition pos) {
        if (!this.P_()) {
            super.c(pos);
        }
    }

    public void a(double xDifference, double yDifference, double zDifference, boolean onGround) {
        if (!this.de()) {
            this.b(onGround, new Vec3D(xDifference, yDifference, zDifference));
            BlockPosition blockposition = this.aH();
            super.a(yDifference, onGround, this.dM().a_(blockposition), blockposition);
        }
    }

    @Override
    protected void M_() {
        if (this.dM().s().i()) {
            super.M_();
        }
    }

    @Override
    public void a(TileEntitySign sign, boolean front) {
        this.c.b(new PacketPlayOutBlockChange(this.dM(), sign.aB_()));
        this.c.b(new PacketPlayOutOpenSignEditor(sign.aB_(), front));
    }

    public int nextContainerCounter() {
        this.df = this.df % 100 + 1;
        return this.df;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory factory) {
        if (factory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = factory.createMenu(this.df, this.fS(), this);
        IChatBaseComponent title = null;
        if (container != null) {
            container.setTitle(factory.Q_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, container, cancelled);
            container = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (container == null && !cancelled) {
                if (factory instanceof IInventory) {
                    ((IInventory)((Object)factory)).c(this);
                } else if (factory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)factory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.P_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.bS = container;
        if (!this.eY()) {
            this.c.b(new PacketPlayOutOpenWindow(container.j, container.a(), Objects.requireNonNullElseGet(title, container::getTitle)));
        }
        this.a(container);
        return OptionalInt.of(this.df);
    }

    @Override
    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
        this.c.b(new PacketPlayOutOpenWindowMerchant(syncId, offers, levelProgress, experience, leveled, refreshable));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.df, this.fS(), inventory, horse);
        container.setTitle(horse.Q_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c(this);
            return;
        }
        if (this.bS != this.bR) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        this.c.b(new PacketPlayOutOpenWindowHorse(this.df, inventory.b(), horse.aj()));
        this.bS = container;
        this.a(this.bS);
    }

    @Override
    public void a(ItemStack book, EnumHand hand) {
        if (book.a(Items.tU)) {
            if (ItemWrittenBook.a(book, this.dd(), this)) {
                this.bS.d();
            }
            this.c.b(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.c.b(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::q));
    }

    @Override
    public void r() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.c.b(new PacketPlayOutCloseWindow(this.bS.j));
        this.s();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.c.b(new PacketPlayOutCloseWindow(this.bS.j));
        this.bS = this.bR;
    }

    @Override
    public void s() {
        this.bS.b(this);
        this.bR.a(this.bS);
        this.bS = this.bR;
    }

    public void a(float sidewaysSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        if (this.bO()) {
            if (sidewaysSpeed >= -1.0f && sidewaysSpeed <= 1.0f) {
                this.bk = sidewaysSpeed;
            }
            if (forwardSpeed >= -1.0f && forwardSpeed <= 1.0f) {
                this.bm = forwardSpeed;
            }
            this.bj = jumping;
            if (sneaking != this.bS()) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getBukkitEntity(), sneaking);
                this.d.server.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            this.f(sneaking);
        }
    }

    @Override
    public void a(Vec3D movementInput) {
        double d0 = this.dr();
        double d1 = this.dt();
        double d2 = this.dx();
        super.a(movementInput);
        this.b(this.dr() - d0, this.dt() - d1, this.dx() - d2);
    }

    @Override
    public void t() {
        double d0 = this.dr();
        double d1 = this.dt();
        double d2 = this.dx();
        super.t();
        this.r(this.dr() - d0, this.dt() - d1, this.dx() - d2);
    }

    public void b(double deltaX, double deltaY, double deltaZ) {
        if (!this.bO() && !EntityPlayer.s(deltaX, deltaY, deltaZ)) {
            if (this.bZ()) {
                int i2 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.dM().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((net.minecraft.world.entity.Entity)this).a(TagsFluid.a)) {
                int i3 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                if (i3 > 0) {
                    this.a(StatisticList.w, i3);
                    this.causeFoodExhaustion(this.dM().spigotConfig.swimMultiplier * (float)i3 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.aZ()) {
                int i4 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i4 > 0) {
                    this.a(StatisticList.s, i4);
                    this.causeFoodExhaustion(this.dM().spigotConfig.swimMultiplier * (float)i4 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.e_()) {
                if (deltaY > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(deltaY * 100.0));
                }
            } else if (this.aC()) {
                int i5 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i5 > 0) {
                    if (this.bY()) {
                        this.a(StatisticList.r, i5);
                        this.causeFoodExhaustion(this.dM().spigotConfig.sprintMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.bX()) {
                        this.a(StatisticList.q, i5);
                        this.causeFoodExhaustion(this.dM().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, i5);
                        this.causeFoodExhaustion(this.dM().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fw()) {
                int i6 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                this.a(StatisticList.B, i6);
            } else {
                int i7 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i7 > 25) {
                    this.a(StatisticList.v, i7);
                }
            }
        }
    }

    private void r(double deltaX, double deltaY, double deltaZ) {
        if (this.bO() && !EntityPlayer.s(deltaX, deltaY, deltaZ)) {
            int i2 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
            net.minecraft.world.entity.Entity entity = this.cZ();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof EntityBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    private static boolean s(double deltaX, double deltaY, double deltaZ) {
        return deltaX == 0.0 && deltaY == 0.0 && deltaZ == 0.0;
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cq.b(this, stat, amount);
        this.dM().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, scoreaccess -> scoreaccess.b(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cq.a(this, stat, 0);
        this.dM().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> recipes) {
        return this.cJ.a(recipes, this);
    }

    @Override
    public void a(RecipeHolder<?> recipe, List<ItemStack> ingredients) {
        CriterionTriggers.aa.a(this, recipe.a(), ingredients);
    }

    @Override
    public void a(List<MinecraftKey> recipes) {
        List<RecipeHolder<?>> list1 = recipes.stream().flatMap(minecraftkey -> this.d.aG().a((MinecraftKey)minecraftkey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list1);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> recipes) {
        return this.cJ.b(recipes, this);
    }

    @Override
    public void d(int experience) {
        super.d(experience);
        this.cB = -1;
    }

    public void u() {
        this.cM = true;
        this.bB();
        if (this.bO() && this.cZ() instanceof EntityPlayer) {
            this.ac();
        }
        if (this.fD()) {
            this.a(true, false);
        }
    }

    public boolean v() {
        return this.cM;
    }

    public void w() {
        this.cy = -1.0E8f;
        this.cB = -1;
    }

    @Override
    public void a(IChatBaseComponent message, boolean overlay) {
        this.b(message, overlay);
    }

    @Override
    public void x() {
        if (!this.bv.b() && this.fn()) {
            this.c.b(new PacketPlayOutEntityStatus(this, 9));
            super.x();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.c.b(new PacketPlayOutLookAt(anchorPoint, target.c, target.d, target.e));
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, net.minecraft.world.entity.Entity targetEntity, ArgumentAnchor.Anchor targetAnchor) {
        Vec3D vec3d = targetAnchor.a(targetEntity);
        super.a(anchorPoint, vec3d);
        this.c.b(new PacketPlayOutLookAt(anchorPoint, targetEntity, targetAnchor));
    }

    public void a(EntityPlayer oldPlayer, boolean alive) {
        this.db = oldPlayer.db;
        this.de = oldPlayer.de;
        this.e.a(oldPlayer.e.b(), oldPlayer.e.c());
        this.y();
        if (alive) {
            this.fS().a(oldPlayer.fS());
            this.c(oldPlayer.ev());
            this.bT = oldPlayer.bT;
            this.cf = oldPlayer.cf;
            this.cg = oldPlayer.cg;
            this.ch = oldPlayer.ch;
            this.r(oldPlayer.fN());
            this.ax = oldPlayer.ax;
        } else if (this.dM().Z().b(GameRules.d) || oldPlayer.P_()) {
            this.fS().a(oldPlayer.fS());
            this.cf = oldPlayer.cf;
            this.cg = oldPlayer.cg;
            this.ch = oldPlayer.ch;
            this.r(oldPlayer.fN());
        }
        this.ci = oldPlayer.ci;
        this.bQ = oldPlayer.bQ;
        this.an().b(EntityHuman.bM, oldPlayer.an().b(EntityHuman.bM));
        this.cB = -1;
        this.cy = -1.0f;
        this.cz = -1;
        this.cI = oldPlayer.cI;
        this.cQ = oldPlayer.cQ;
        this.cT = oldPlayer.cT;
        this.i(oldPlayer.gj());
        this.j(oldPlayer.gk());
        ((EntityHuman)this).a(oldPlayer.gr());
    }

    @Override
    protected void a(MobEffect effect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, source);
        this.c.b(new PacketPlayOutEntityEffect(this.aj(), effect));
        if (effect.c() == MobEffects.y) {
            this.cL = this.ah;
            this.cK = this.dk();
        }
        CriterionTriggers.B.a(this, source);
    }

    @Override
    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, reapplyEffect, source);
        this.c.b(new PacketPlayOutEntityEffect(this.aj(), effect));
        CriterionTriggers.B.a(this, source);
    }

    @Override
    protected void a(MobEffect effect) {
        super.a(effect);
        this.c.b(new PacketPlayOutRemoveEntityEffect(this.aj(), effect.c()));
        if (effect.c() == MobEffects.y) {
            this.cK = null;
        }
        CriterionTriggers.B.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void c(double destX, double destY, double destZ) {
        this.c.a(destX, destY, destZ, this.dC(), this.dE(), RelativeMovement.g);
    }

    @Override
    public void d(double offsetX, double offsetY, double offsetZ) {
        this.c.a(this.dr() + offsetX, this.dt() + offsetY, this.dx() + offsetZ, this.dC(), this.dE(), RelativeMovement.f);
    }

    @Override
    public boolean a(WorldServer world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        return this.teleportTo(world, destX, destY, destZ, flags, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
        worldserver.l().a(TicketType.g, chunkcoordintpair, 1, this.aj());
        this.ac();
        if (this.fD()) {
            this.a(true, true);
        }
        if (worldserver == this.dM()) {
            this.c.teleport(d0, d1, d2, f2, f1, set, cause);
        } else {
            this.teleportTo(worldserver, d0, d1, d2, f2, f1, cause);
        }
        this.n(f2);
        return true;
    }

    @Override
    public void e(double x2, double y2, double z2) {
        super.e(x2, y2, z2);
        this.c.m();
    }

    @Override
    public void a(net.minecraft.world.entity.Entity target) {
        this.z().l().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.z().l().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void y() {
        if (this.c != null) {
            this.c.b(new PacketPlayOutAbilities(this.fT()));
            this.J();
        }
    }

    public WorldServer z() {
        return (WorldServer)this.dM();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        PlayerGameModeChangeEvent event = this.e.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.gg();
            this.ac();
        } else {
            this.c((net.minecraft.world.entity.Entity)this);
        }
        this.y();
        this.fl();
        return event;
    }

    @Override
    public boolean P_() {
        return this.e.b() == EnumGamemode.d;
    }

    @Override
    public boolean f() {
        return this.e.b() == EnumGamemode.b;
    }

    @Override
    public void a(IChatBaseComponent message) {
        this.b(message, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.w(overlay)) {
            this.c.a(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.a(() -> {
                if (this.w(false)) {
                    boolean flag1 = true;
                    String s2 = message.a(256);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params) {
        this.sendChatMessage(message, filterMaskEnabled, params, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params, @Nullable IChatBaseComponent unsigned) {
        if (this.gv()) {
            message.sendToPlayer(this, filterMaskEnabled, params, unsigned);
        }
    }

    public String A() {
        SocketAddress socketaddress = this.c.n();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    private Map<ClientOption<?>, ?> getClientOptionMap(String locale, int viewDistance, ClientOption.ChatVisibility chatVisibility, boolean chatColors, PaperSkinParts skinParts, MainHand mainHand, boolean allowsServerListing, boolean textFilteringEnabled) {
        HashMap<ClientOption, Object> map = new HashMap<ClientOption, Object>();
        map.put(ClientOption.LOCALE, locale);
        map.put(ClientOption.VIEW_DISTANCE, viewDistance);
        map.put(ClientOption.CHAT_VISIBILITY, chatVisibility);
        map.put(ClientOption.CHAT_COLORS_ENABLED, chatColors);
        map.put(ClientOption.SKIN_PARTS, skinParts);
        map.put(ClientOption.MAIN_HAND, mainHand);
        map.put(ClientOption.ALLOW_SERVER_LISTINGS, allowsServerListing);
        map.put(ClientOption.TEXT_FILTERING_ENABLED, textFilteringEnabled);
        return map;
    }

    public void a(ClientInformation clientOptions) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), this.getClientOptionMap(clientOptions.b(), clientOptions.c(), ClientOption.ChatVisibility.valueOf((String)clientOptions.d().name()), clientOptions.e(), new PaperSkinParts(clientOptions.f()), clientOptions.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT, clientOptions.i(), clientOptions.h())).callEvent();
        if (this.fm() != clientOptions.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fm() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        if (this.cO == null || !this.cO.equals(clientOptions.b())) {
            event = new org.bukkit.event.player.PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientOptions.b());
            this.d.server.getPluginManager().callEvent((Event)event);
            this.d.server.getPluginManager().callEvent((Event)new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), this.cO, clientOptions.b()));
        }
        this.updateOptionsNoEvents(clientOptions);
    }

    public void updateOptionsNoEvents(ClientInformation clientOptions) {
        this.cO = clientOptions.b();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.cO), Locale.US);
        this.cN = clientOptions.c();
        this.cD = clientOptions.d();
        this.cE = clientOptions.e();
        this.cZ = clientOptions.h();
        this.da = clientOptions.i();
        this.an().b(EntityHuman.bM, (byte)clientOptions.f());
        this.an().b(EntityHuman.bN, (byte)clientOptions.g().a());
    }

    public ClientInformation B() {
        byte b0 = this.an().b(EntityHuman.bM);
        EnumMainHand enummainhand = EnumMainHand.d.apply(this.an().b(EntityHuman.bN).byteValue());
        return new ClientInformation(this.cO, this.cN, this.cD, this.cE, b0, enummainhand, this.cZ, this.da);
    }

    public boolean C() {
        return this.cE;
    }

    public EnumChatVisibility D() {
        return this.cD;
    }

    private boolean w(boolean overlay) {
        return this.cD == EnumChatVisibility.c ? overlay : true;
    }

    private boolean gv() {
        return this.cD == EnumChatVisibility.a;
    }

    public int E() {
        return this.cN;
    }

    public void a(ServerPing metadata) {
        this.c.b(new ClientboundServerDataPacket(metadata.a(), metadata.d().map(ServerPing.a::a), metadata.e()));
    }

    @Override
    protected int F() {
        return this.d.c(this.fR());
    }

    public void G() {
        this.cF = SystemUtils.b();
    }

    public ServerStatisticManager H() {
        return this.cq;
    }

    public RecipeBookServer I() {
        return this.cJ;
    }

    @Override
    protected void J() {
        if (this.P_()) {
            this.eq();
            this.j(true);
        } else {
            super.J();
        }
    }

    public net.minecraft.world.entity.Entity K() {
        return this.cG == null ? this : this.cG;
    }

    public void c(@Nullable net.minecraft.world.entity.Entity entity) {
        net.minecraft.world.entity.Entity entity1 = this.K();
        net.minecraft.world.entity.Entity entity2 = this.cG = entity == null ? this : entity;
        if (entity1 != this.cG) {
            net.minecraft.world.level.World world;
            if (this.cG == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.cG = entity1;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity(), (Entity)entity.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.cG = entity1;
                    return;
                }
            }
            if ((world = this.cG.dM()) instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.teleportTo(worldserver, this.cG.dr(), this.cG.dt(), this.cG.dx(), Set.of(), this.dC(), this.dE(), PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.z().l().a(this);
            }
            this.c.b(new PacketPlayOutCamera(this.cG));
            this.c.m();
        }
    }

    @Override
    protected void L() {
        if (!this.cH) {
            super.L();
        }
    }

    @Override
    public void d(net.minecraft.world.entity.Entity target) {
        if (this.e.b() == EnumGamemode.d) {
            this.c(target);
        } else {
            super.d(target);
        }
    }

    public long M() {
        return this.cF;
    }

    @Nullable
    public IChatBaseComponent N() {
        return this.listName;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gm();
    }

    public boolean O() {
        return this.cH;
    }

    public void P() {
        this.cH = false;
    }

    public AdvancementDataPlayer Q() {
        return this.cp;
    }

    public void a(WorldServer targetWorld, double x2, double y2, double z2, float yaw, float pitch) {
        this.teleportTo(targetWorld, x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.c((net.minecraft.world.entity.Entity)this);
        this.ac();
        this.getBukkitEntity().teleport(new Location((World)worldserver.getWorld(), d0, d1, d2, f2, f1), cause);
    }

    @Nullable
    public BlockPosition R() {
        return this.cV;
    }

    public float S() {
        return this.cX;
    }

    public ResourceKey<net.minecraft.world.level.World> T() {
        return this.cU;
    }

    public boolean U() {
        return this.cW;
    }

    @Deprecated
    public void a(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (pos != null) {
            boolean flag2 = pos.equals(this.cV) && dimension.equals(this.cU);
            spawnLoc = MCUtil.toLocation(this.cL().a(dimension), pos);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag2;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().ae() : dimension;
            pos = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.cV = pos;
            this.cU = dimension;
            this.cX = angle;
            this.cW = forced;
        } else {
            this.cV = null;
            this.cU = net.minecraft.world.level.World.h;
            this.cX = 0.0f;
            this.cW = false;
        }
        return true;
    }

    public SectionPosition V() {
        return this.cS;
    }

    public void a(SectionPosition section) {
        this.cS = section;
    }

    public ChunkTrackingView W() {
        return this.cT;
    }

    public void a(ChunkTrackingView chunkFilter) {
        this.cT = chunkFilter;
    }

    @Override
    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
        this.c.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.d(event), category, this.dr(), this.dt(), this.dx(), volume, pitch, this.ag.g()));
    }

    @Override
    public EntityItem drop(ItemStack stack, boolean throwRandomly, boolean retainOwnership, boolean callDropEvent) {
        EntityItem entityitem = super.drop(stack, throwRandomly, retainOwnership, callDropEvent);
        if (entityitem == null) {
            return null;
        }
        this.dM().b(entityitem);
        ItemStack itemstack1 = entityitem.q();
        if (retainOwnership) {
            if (!itemstack1.b()) {
                this.a(StatisticList.f.b(itemstack1.d()), itemstack1.L());
            }
            this.a(StatisticList.F);
        }
        return entityitem;
    }

    public ITextFilter X() {
        return this.cY;
    }

    public void c(WorldServer world) {
        this.a((net.minecraft.world.level.World)world);
        this.e.a(world);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbt, String key) {
        return nbt != null && nbt.b(key, 99) ? EnumGamemode.a(nbt.h(key)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode backupGameMode) {
        EnumGamemode enumgamemode1 = this.d.bb();
        return enumgamemode1 != null ? enumgamemode1 : (backupGameMode != null ? backupGameMode : this.d.v_());
    }

    public void c(@Nullable NBTTagCompound nbt) {
        if (this.d.bb() != null && this.d.bb() != EntityPlayer.a(nbt, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.d.v_().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.e.a(this.d.bb(), EnumGamemode.e);
            } else {
                this.e.a(EntityPlayer.a(nbt, "playerGameType"), EntityPlayer.a(nbt, "previousPlayerGameType"));
            }
            return;
        }
        this.e.a(this.b(EntityPlayer.a(nbt, "playerGameType")), EntityPlayer.a(nbt, "previousPlayerGameType"));
    }

    private void k(NBTTagCompound nbt) {
        nbt.a("playerGameType", this.e.b().a());
        EnumGamemode enumgamemode = this.e.c();
        if (enumgamemode != null) {
            nbt.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    @Override
    public boolean Y() {
        return this.cZ;
    }

    public boolean b(EntityPlayer player) {
        return player == this ? false : this.cZ || player.cZ;
    }

    @Override
    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return super.a(world, pos) && world.a(this, pos);
    }

    @Override
    protected void a(ItemStack stack) {
        CriterionTriggers.U.a(this, stack);
        super.a(stack);
    }

    public boolean a(boolean entireStack) {
        PlayerInventory playerinventory = this.fS();
        ItemStack itemstack = playerinventory.a(entireStack);
        this.bS.b(playerinventory, playerinventory.l).ifPresent(i2 -> this.bS.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    public boolean Z() {
        return this.da;
    }

    @Override
    public Optional<WardenSpawnTracker> aa() {
        return Optional.of(this.db);
    }

    @Override
    public void a(EntityItem item) {
        super.a(item);
        net.minecraft.world.entity.Entity entity = item.w();
        if (entity != null) {
            CriterionTriggers.Q.a(this, item.q(), entity);
        }
    }

    public void a(RemoteChatSession session) {
        this.de = session;
    }

    @Nullable
    public RemoteChatSession ab() {
        return this.de != null && this.de.b() ? null : this.de;
    }

    @Override
    public void a(double deltaX, double deltaZ) {
        this.cl = (float)(MathHelper.d(deltaZ, deltaX) * 57.2957763671875 - (double)this.dC());
        this.c.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean force) {
        if (!super.a(entity, force)) {
            return false;
        }
        entity.i(this);
        this.c.a(this.dr(), this.dt(), this.dx(), this.dC(), this.dE());
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.es()) {
                this.c.b(new PacketPlayOutEntityEffect(entity.aj(), mobeffect));
            }
        }
        return true;
    }

    @Override
    public void ac() {
        net.minecraft.world.entity.Entity entity = this.cZ();
        super.ac();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.es()) {
                this.c.b(new PacketPlayOutRemoveEntityEffect(entity.aj(), mobeffect.c()));
            }
        }
    }

    public CommonPlayerSpawnInfo d(WorldServer world) {
        return new CommonPlayerSpawnInfo(world.ac(), world.ae(), BiomeManager.a(world.C()), this.e.b(), this.e.c(), world.ah(), world.B(), this.gr(), this.av());
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dM().Y() + this.timeOffset;
        }
        return this.dM().Y() - this.dM().Y() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        } else {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newThunder));
            } else {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dM().B_().k() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cy() + " at " + this.dr() + "," + this.dt() + "," + this.dx() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.c.m();
    }

    @Override
    public boolean eY() {
        return super.eY() || this.c != null && this.c.isDisconnected();
    }

    @Override
    public Scoreboard gh() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.dM().Z().b(GameRules.d);
        if (this.keepLevel) {
            exp = this.ch;
            this.newTotalExp = this.cg;
            this.newLevel = this.cf;
        }
        this.c(this.eM());
        this.ft();
        this.j(this.ch());
        this.h(0);
        this.ab = 0.0f;
        this.bT = new FoodMetaData(this);
        this.cf = this.newLevel;
        this.cg = this.newTotalExp;
        this.ch = 0.0f;
        this.aM = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).bT = true;
        this.bS = this.bR;
        this.aY = null;
        ((EntityLiving)this).bU = null;
        ((EntityLiving)this).bO = new CombatTracker(this);
        this.cB = -1;
        if (this.keepLevel) {
            this.ch = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.o(0.0, 0.0, 0.0);
        ((EntityLiving)this).ch = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    private void resetOperationCountPerTick() {
        this.instaBreakCountPerTick = 0;
        this.placeBlockCountPerTick = 0;
    }

    public int getInstaBreakCountPerTick() {
        return this.instaBreakCountPerTick;
    }

    public int getPlaceBlockCountPerTick() {
        return this.placeBlockCountPerTick;
    }

    public void addInstaBreakCountPerTick() {
        ++this.instaBreakCountPerTick;
    }

    public void addPlaceBlockCountPerTick() {
        ++this.placeBlockCountPerTick;
    }

    public boolean allowOperation() {
        return (this.instaBreakCountPerTick == 0 || this.placeBlockCountPerTick == 0) && this.instaBreakCountPerTick <= 1 && this.placeBlockCountPerTick <= 2;
    }
}

