/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesConfig;

public class EntityTrackerEntry {
    private static final Logger b = LogUtils.getLogger();
    private static final int c = 1;
    private static final double d = 7.62939453125E-6;
    public static final int a = 60;
    private static final int e = 400;
    private final WorldServer f;
    private final Entity g;
    private final int h;
    private final boolean i;
    private final Consumer<Packet<?>> j;
    private final VecDeltaCodec k = new VecDeltaCodec();
    private int l;
    private int m;
    private int n;
    private Vec3D o;
    private int p;
    private int q;
    private List<Entity> r;
    private boolean s;
    private boolean t;
    @Nullable
    private List<DataWatcher.b<?>> u;
    private final Set<ServerPlayerConnection> trackedPlayers;

    public EntityTrackerEntry(WorldServer worldserver, Entity entity, int i2, boolean flag, Consumer<Packet<?>> consumer, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.o = Vec3D.b;
        this.r = ImmutableList.of();
        this.f = worldserver;
        this.j = consumer;
        this.g = entity;
        this.h = i2;
        this.i = flag;
        this.k.e(entity.dl());
        this.l = MathHelper.d(entity.dC() * 256.0f / 360.0f);
        this.m = MathHelper.d(entity.dE() * 256.0f / 360.0f);
        this.n = MathHelper.d(entity.cp() * 256.0f / 360.0f);
        this.t = entity.aC();
        this.u = entity.an().c();
    }

    public void a() {
        List<Entity> list = this.g.cP();
        if (!list.equals(this.r)) {
            this.a(new PacketPlayOutMount(this.g));
            EntityTrackerEntry.a(list, this.r).forEach(entity -> {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    entityplayer.c.a(entityplayer.dr(), entityplayer.dt(), entityplayer.dx(), entityplayer.dC(), entityplayer.dE());
                }
            });
            this.r = list;
        }
        Entity entity2 = this.g;
        if (!this.trackedPlayers.isEmpty() && entity2 instanceof EntityItemFrame) {
            Integer integer;
            WorldMap worldmap;
            EntityItemFrame entityitemframe = (EntityItemFrame)entity2;
            ItemStack itemstack = entityitemframe.G();
            if (this.f.paperConfig().maps.itemFrameCursorUpdateInterval > 0 && this.p % this.f.paperConfig().maps.itemFrameCursorUpdateInterval == 0 && itemstack.d() instanceof ItemWorldMap && (worldmap = ItemWorldMap.a(integer = entityitemframe.cachedMapId, this.f)) != null) {
                Iterator<ServerPlayerConnection> iterator = this.trackedPlayers.iterator();
                while (iterator.hasNext()) {
                    EntityPlayer entityplayer = iterator.next().p();
                    worldmap.a(entityplayer, itemstack);
                    Packet<?> packet = worldmap.a((int)integer, entityplayer);
                    if (packet == null) continue;
                    entityplayer.c.b(packet);
                }
            }
            this.b();
        }
        if (this.p % this.h == 0 || this.g.au || this.g.an().a()) {
            int i2;
            if (this.g.bO()) {
                boolean flag;
                i2 = MathHelper.d(this.g.dC() * 256.0f / 360.0f);
                j = MathHelper.d(this.g.dE() * 256.0f / 360.0f);
                boolean bl = flag = Math.abs(i2 - this.l) >= 1 || Math.abs(j - this.m) >= 1;
                if (flag) {
                    this.j.accept(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.aj(), (byte)i2, (byte)j, this.g.aC()));
                    this.l = i2;
                    this.m = j;
                }
                this.k.e(this.g.dl());
                this.b();
                this.s = true;
            } else {
                Vec3D vec3d1;
                double d0;
                ++this.q;
                i2 = MathHelper.d(this.g.dC() * 256.0f / 360.0f);
                j = MathHelper.d(this.g.dE() * 256.0f / 360.0f);
                Vec3D vec3d = this.g.dl();
                Vec3D base = this.k.b;
                double vec3d_dx = vec3d.c - base.c;
                double vec3d_dy = vec3d.d - base.d;
                double vec3d_dz = vec3d.e - base.e;
                boolean flag1 = vec3d_dx * vec3d_dx + vec3d_dy * vec3d_dy + vec3d_dz * vec3d_dz >= 7.62939453125E-6;
                Packet<PacketListenerPlayOut> packet1 = null;
                boolean flag2 = flag1 || this.p % 60 == 0;
                boolean flag3 = Math.abs(i2 - this.l) >= 1 || Math.abs(j - this.m) >= 1;
                boolean flag4 = false;
                boolean flag5 = false;
                if (!(this.g instanceof EntityHanging) || this.p > 0 || this.g instanceof EntityArrow) {
                    boolean flag6;
                    long k2 = this.k.a(vec3d);
                    long l2 = this.k.b(vec3d);
                    long i1 = this.k.c(vec3d);
                    boolean bl = flag6 = k2 < -32768L || k2 > 32767L || l2 < -32768L || l2 > 32767L || i1 < -32768L || i1 > 32767L;
                    if (!(flag6 || this.q > 400 || this.s || this.t != this.g.aC() || GlobalConfiguration.get().collisions.sendFullPosForHardCollidingEntities && this.g.hardCollides())) {
                        if (!(flag2 && flag3 || this.g instanceof EntityArrow)) {
                            if (flag2) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.g.aj(), (short)k2, (short)l2, (short)i1, this.g.aC());
                                flag4 = true;
                            } else if (flag3) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.aj(), (byte)i2, (byte)j, this.g.aC());
                                flag5 = true;
                            }
                        } else {
                            packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.g.aj(), (short)k2, (short)l2, (short)i1, (byte)i2, (byte)j, this.g.aC());
                            flag4 = true;
                            flag5 = true;
                        }
                    } else {
                        this.t = this.g.aC();
                        this.q = 0;
                        packet1 = new PacketPlayOutEntityTeleport(this.g);
                        flag4 = true;
                        flag5 = true;
                    }
                    if (LeavesConfig.dontSendUselessEntityPackets && this.isUselessPacket(packet1)) {
                        packet1 = null;
                    }
                }
                if ((this.i || this.g.au || this.g instanceof EntityLiving && ((EntityLiving)this.g).fw()) && this.p > 0 && ((d0 = (vec3d1 = this.g.dp()).g(this.o)) > 1.0E-7 || d0 > 0.0 && vec3d1.g() == 0.0)) {
                    this.o = vec3d1;
                    this.j.accept(new PacketPlayOutEntityVelocity(this.g.aj(), this.o));
                }
                if (packet1 != null) {
                    this.j.accept(packet1);
                }
                this.b();
                if (flag4) {
                    this.k.e(vec3d);
                }
                if (flag5) {
                    this.l = i2;
                    this.m = j;
                }
                this.s = false;
            }
            i2 = MathHelper.d(this.g.cp() * 256.0f / 360.0f);
            if (Math.abs(i2 - this.n) >= 1) {
                this.j.accept(new PacketPlayOutEntityHeadRotation(this.g, (byte)i2));
                this.n = i2;
            }
            this.g.au = false;
        }
        ++this.p;
        if (this.g.T) {
            boolean cancelled = false;
            if (this.g instanceof EntityPlayer) {
                Player player = (Player)this.g.getBukkitEntity();
                Vector velocity = player.getVelocity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                this.g.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player.setVelocity(event.getVelocity());
                }
            }
            if (!cancelled) {
                this.a(new PacketPlayOutEntityVelocity(this.g));
            }
            this.g.T = false;
        }
    }

    private static Stream<Entity> a(List<Entity> passengers, List<Entity> lastPassengers) {
        return lastPassengers.stream().filter(entity -> !passengers.contains(entity));
    }

    private boolean isUselessPacket(Packet<?> possibleUselessPacket) {
        if (possibleUselessPacket instanceof PacketPlayOutEntity) {
            PacketPlayOutEntity packet = (PacketPlayOutEntity)possibleUselessPacket;
            if (possibleUselessPacket instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove) {
                return packet.a() == 0 && packet.d() == 0 && packet.e() == 0;
            }
            if (possibleUselessPacket instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook) {
                return packet.a() == 0 && packet.d() == 0 && packet.e() == 0 && packet.f() == 0 && packet.g() == 0;
            }
            if (possibleUselessPacket instanceof PacketPlayOutEntity.PacketPlayOutEntityLook) {
                return packet.f() == 0 && packet.g() == 0;
            }
        }
        return false;
    }

    public void a(EntityPlayer player) {
        this.g.d(player);
        player.c.b(new PacketPlayOutEntityDestroy(this.g.aj()));
    }

    public void b(EntityPlayer player) {
        ArrayList<Packet<PacketListenerPlayOut>> list = new ArrayList<Packet<PacketListenerPlayOut>>();
        Objects.requireNonNull(list);
        this.a(player, list::add);
        player.c.b(new ClientboundBundlePacket((Iterable<Packet<PacketListenerPlayOut>>)list));
        this.g.c(player);
    }

    public void a(EntityPlayer player, Consumer<Packet<PacketListenerPlayOut>> sender) {
        EntityInsentient entityinsentient;
        Entity entity;
        if (this.g.dH()) {
            return;
        }
        Packet<PacketListenerPlayOut> packet = this.g.dj();
        this.n = MathHelper.d(this.g.cp() * 256.0f / 360.0f);
        sender.accept(packet);
        if (this.u != null) {
            sender.accept(new PacketPlayOutEntityMetadata(this.g.aj(), this.u));
        }
        boolean flag = this.i;
        if (this.g instanceof EntityLiving) {
            Collection<AttributeModifiable> collection = ((EntityLiving)this.g).eR().b();
            if (this.g.aj() == player.aj()) {
                ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(collection, false);
            }
            if (!collection.isEmpty()) {
                sender.accept(new PacketPlayOutUpdateAttributes(this.g.aj(), collection));
            }
            if (((EntityLiving)this.g).fw()) {
                flag = true;
            }
        }
        this.o = this.g.dp();
        if (flag && !(this.g instanceof EntityLiving)) {
            sender.accept(new PacketPlayOutEntityVelocity(this.g.aj(), this.o));
        }
        if (this.g instanceof EntityLiving) {
            ArrayList list = Lists.newArrayList();
            for (EnumItemSlot enumitemslot : EnumItemSlot.VALUES) {
                ItemStack itemstack = ((EntityLiving)this.g).c(enumitemslot);
                if (itemstack.b()) continue;
                ItemStack sanitized = EntityLiving.sanitizeItemStack(itemstack.p(), false);
                list.add(Pair.of((Object)enumitemslot, (Object)((EntityLiving)this.g).stripMeta(sanitized, false)));
            }
            if (!list.isEmpty()) {
                sender.accept(new PacketPlayOutEntityEquipment(this.g.aj(), list));
            }
            ((EntityLiving)this.g).detectEquipmentUpdatesPublic();
        }
        if (!this.g.cP().isEmpty()) {
            sender.accept(new PacketPlayOutMount(this.g));
        }
        if (this.g.bO()) {
            sender.accept(new PacketPlayOutMount(this.g.cZ()));
        }
        if ((entity = this.g) instanceof EntityInsentient && (entityinsentient = (EntityInsentient)entity).fS()) {
            sender.accept(new PacketPlayOutAttachEntity(entityinsentient, entityinsentient.fT()));
        }
    }

    private void b() {
        DataWatcher datawatcher = this.g.an();
        List<DataWatcher.b<?>> list = datawatcher.b();
        if (list != null) {
            this.u = datawatcher.c();
            this.a(new PacketPlayOutEntityMetadata(this.g.aj(), list));
        }
        if (this.g instanceof EntityLiving) {
            Set<AttributeModifiable> set = ((EntityLiving)this.g).eR().a();
            if (!set.isEmpty()) {
                if (this.g instanceof EntityPlayer) {
                    ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(set, false);
                }
                this.a(new PacketPlayOutUpdateAttributes(this.g.aj(), set));
            }
            set.clear();
        }
    }

    private void a(Packet<?> packet) {
        this.j.accept(packet);
        if (this.g instanceof EntityPlayer) {
            ((EntityPlayer)this.g).c.b(packet);
        }
    }
}

