/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.destroystokyo.paper.util.maplist.IBlockDataList;
import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import io.papermc.paper.chunk.system.entity.EntityLookup;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import io.papermc.paper.threadedregions.TickRegions;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.WorldUtil;
import io.papermc.paper.util.player.NearbyPlayers;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_20_R3.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_20_R3.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_20_R3.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.command.NoBlockUpdateCommand;
import top.leavesmc.leaves.util.ArrayConstants;

public class WorldServer
extends net.minecraft.world.level.World
implements GeneratorAccessSeed {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider D = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger E = LogUtils.getLogger();
    private static final int F = 300;
    private static final int G = 65536;
    final List<EntityPlayer> H;
    public final ChunkProviderServer I;
    private final MinecraftServer J;
    public final WorldDataServer K;
    final EntityTickList L;
    private final GameEventDispatcher N;
    public boolean e;
    private final SleepStatus O;
    private int P;
    private final PortalTravelAgent Q;
    private final TickListServer<Block> R;
    private final TickListServer<FluidType> S;
    final Set<EntityInsentient> T;
    volatile boolean U;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> V;
    private final List<BlockActionData> W;
    private boolean X;
    private final List<MobSpawner> Y;
    @Nullable
    private EnderDragonBattle Z;
    final Int2ObjectMap<EntityComplexPart> aa;
    private final StructureManager ab;
    private final StructureCheck ac;
    private final boolean ad;
    private final RandomSequences ae;
    public long lastMidTickExecuteFailure;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent;
    private final WireHandler wireHandler = new WireHandler(this);
    public final ChunkTaskScheduler chunkTaskScheduler;
    public final RegionFileIOThread.ChunkDataController chunkDataControllerNew = new RegionFileIOThread.ChunkDataController(RegionFileIOThread.RegionFileType.CHUNK_DATA){

        @Override
        public RegionFileCache getCache() {
            return WorldServer.this.l().a.regionFileCache;
        }

        @Override
        public void writeData(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
            WorldServer.this.l().a.a(new ChunkCoordIntPair(chunkX, chunkZ), compound);
        }

        @Override
        public NBTTagCompound readData(int chunkX, int chunkZ) throws IOException {
            return WorldServer.this.l().a.readSync(new ChunkCoordIntPair(chunkX, chunkZ));
        }
    };
    public final RegionFileIOThread.ChunkDataController poiDataControllerNew = new RegionFileIOThread.ChunkDataController(RegionFileIOThread.RegionFileType.POI_DATA){

        @Override
        public RegionFileCache getCache() {
            return WorldServer.this.l().a.m();
        }

        @Override
        public void writeData(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
            WorldServer.this.l().a.m().a(new ChunkCoordIntPair(chunkX, chunkZ), compound);
        }

        @Override
        public NBTTagCompound readData(int chunkX, int chunkZ) throws IOException {
            return WorldServer.this.l().a.m().a(new ChunkCoordIntPair(chunkX, chunkZ));
        }
    };
    public final RegionFileIOThread.ChunkDataController entityDataControllerNew = new RegionFileIOThread.ChunkDataController(RegionFileIOThread.RegionFileType.ENTITY_DATA){

        @Override
        public RegionFileCache getCache() {
            return WorldServer.this.entityStorage;
        }

        @Override
        public void writeData(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
            WorldServer.this.writeEntityChunk(chunkX, chunkZ, compound);
        }

        @Override
        public NBTTagCompound readData(int chunkX, int chunkZ) throws IOException {
            return WorldServer.this.readEntityChunk(chunkX, chunkZ);
        }
    };
    private final EntityRegionFileStorage entityStorage;
    private final EntityLookup entityLookup;
    private final AtomicLong nonFullSyncLoadIdGenerator = new AtomicLong();
    public final RegionizedPlayerChunkLoader playerChunkLoader = new RegionizedPlayerChunkLoader(this);
    private final AtomicReference<RegionizedPlayerChunkLoader.ViewDistances> viewDistances = new AtomicReference<RegionizedPlayerChunkLoader.ViewDistances>(new RegionizedPlayerChunkLoader.ViewDistances(-1, -1, -1));
    private long lagCompensationTick = MinecraftServer.SERVER_INIT;
    private final BlockPosition.MutableBlockPosition chunkTickMutablePosition = new BlockPosition.MutableBlockPosition();
    private int currentIceAndSnowTick = 0;
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();

    @Override
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.I.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AxisAlignedBB axisalignedbb) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.l();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksAsync(BlockPosition pos, int radiusBlocks, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, priority, onLoad);
    }

    public final void loadChunksAsync(BlockPosition pos, int radiusBlocks, ChunkStatus chunkStatus, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    public final void loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.n, priority, onLoad);
    }

    public final void loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        ArrayList ret = new ArrayList();
        ChunkProviderServer chunkProvider = this.l();
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = chunkProvider.chunkFutureAwaitCounter.getAndIncrement();
        int ticketLevel = 33 + ChunkStatus.a(chunkStatus);
        Consumer<IChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkProvider.addTicketAtLevel(TicketType.FUTURE_AWAIT, chunk.f(), ticketLevel, holderIdentifier);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    onLoad.accept(Collections.unmodifiableList(ret));
                }
                finally {
                    int len = ret.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        ChunkCoordIntPair chunkPos = ((IChunkAccess)ret.get(i2)).f();
                        chunkProvider.addTicketAtLevel(TicketType.h, chunkPos, ticketLevel, chunkPos);
                        chunkProvider.removeTicketAtLevel(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                ChunkSystem.scheduleChunkLoad(this, cx, cz, chunkStatus, true, priority, consumer);
            }
        }
    }

    public final void loadChunksForMoveAsync(AxisAlignedBB axisalignedbb, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    private void writeEntityChunk(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            RegionFileIOThread.scheduleSave(this, chunkX, chunkZ, compound, RegionFileIOThread.RegionFileType.ENTITY_DATA);
            return;
        }
        this.entityStorage.a(new ChunkCoordIntPair(chunkX, chunkZ), compound);
    }

    private NBTTagCompound readEntityChunk(int chunkX, int chunkZ) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            return RegionFileIOThread.loadData(this, chunkX, chunkZ, RegionFileIOThread.RegionFileType.ENTITY_DATA, RegionFileIOThread.getIOBlockingPriorityForCurrentThread());
        }
        return this.entityStorage.a(new ChunkCoordIntPair(chunkX, chunkZ));
    }

    public final EntityLookup getEntityLookup() {
        return this.entityLookup;
    }

    private IChunkAccess getIfAboveStatus(int chunkX, int chunkZ, ChunkStatus status) {
        NewChunkHolder.ChunkCompletion loadedCompletion;
        NewChunkHolder loaded = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (loaded != null && (loadedCompletion = loaded.getLastChunkCompletion()) != null && loadedCompletion.genStatus().b(status)) {
            return loadedCompletion.chunk();
        }
        return null;
    }

    @Override
    public IChunkAccess syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        if (status == null || status.b(ChunkStatus.n)) {
            throw new IllegalArgumentException("Status: " + status);
        }
        IChunkAccess loaded = this.getIfAboveStatus(chunkX, chunkZ, status);
        if (loaded != null) {
            return loaded;
        }
        Long ticketId = this.nonFullSyncLoadIdGenerator.getAndIncrement();
        int ticketLevel = 33 + ChunkStatus.a(status);
        this.chunkTaskScheduler.chunkHolderManager.addTicketAtLevel(TicketType.NON_FULL_SYNC_LOAD, chunkX, chunkZ, ticketLevel, ticketId);
        this.chunkTaskScheduler.chunkHolderManager.processTicketUpdates();
        this.chunkTaskScheduler.beginChunkLoadForNonFullSync(chunkX, chunkZ, status, PrioritisedExecutor.Priority.BLOCKING);
        this.I.g.c(() -> this.getIfAboveStatus(chunkX, chunkZ, status) != null);
        loaded = this.getIfAboveStatus(chunkX, chunkZ, status);
        if (loaded == null) {
            throw new IllegalStateException("Expected chunk to be loaded for status " + status);
        }
        this.chunkTaskScheduler.chunkHolderManager.removeTicketAtLevel(TicketType.NON_FULL_SYNC_LOAD, chunkX, chunkZ, ticketLevel, ticketId);
        return loaded;
    }

    public final int getRegionChunkShift() {
        return TickRegions.getRegionChunkShift();
    }

    public RegionizedPlayerChunkLoader.ViewDistances getViewDistances() {
        return this.viewDistances.get();
    }

    private void updateViewDistance(Function<RegionizedPlayerChunkLoader.ViewDistances, RegionizedPlayerChunkLoader.ViewDistances> update) {
        RegionizedPlayerChunkLoader.ViewDistances curr = this.viewDistances.get();
        while (!this.viewDistances.compareAndSet(curr, update.apply(curr))) {
        }
    }

    public void setTickViewDistance(int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("Tick view distance must be a number between 2 and 32, got: " + distance);
        }
        this.updateViewDistance(input -> input.setTickViewDistance(distance));
    }

    public void setLoadViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Load view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setLoadViewDistance(distance));
    }

    public void setSendViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Send view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setSendViewDistance(distance));
    }

    @Override
    @Nullable
    public EntityHuman b(UUID uuid) {
        EntityPlayer player = this.o().ae().a(uuid);
        return player != null && player.dM() == this ? player : null;
    }

    public long getLagCompensationTick() {
        return this.lagCompensationTick;
    }

    public void updateLagCompensationTick() {
        this.lagCompensationTick = (System.nanoTime() - MinecraftServer.SERVER_INIT) / TimeUnit.MILLISECONDS.toNanos(50L);
    }

    @Override
    public List<EntityHuman> a(PathfinderTargetCondition targetPredicate, EntityLiving entity, AxisAlignedBB box) {
        return this.a(EntityHuman.class, targetPredicate, entity, box);
    }

    @Override
    public EntityHuman a(double x2, double y2, double z2, double maxDistance, @Nullable Predicate<net.minecraft.world.entity.Entity> targetPredicate) {
        if (maxDistance > 0.0) {
            NearbyPlayers players = this.I.a.getNearbyPlayers();
            ReferenceList<EntityPlayer> nearby = players.getPlayersByBlock(CoordinateUtils.getBlockCoordinate(x2), CoordinateUtils.getBlockCoordinate(z2), NearbyPlayers.NearbyMapType.GENERAL);
            if (nearby == null) {
                return null;
            }
            EntityPlayer nearest = null;
            double nearestDist = maxDistance * maxDistance;
            Object[] rawData = nearby.getRawData();
            int len = nearby.size();
            for (int i2 = 0; i2 < len; ++i2) {
                EntityPlayer player = (EntityPlayer)rawData[i2];
                double dist = player.i(x2, y2, z2);
                if (dist >= nearestDist || targetPredicate != null && !targetPredicate.test(player)) continue;
                nearest = player;
                nearestDist = dist;
            }
            return nearest;
        }
        EntityPlayer nearest = null;
        double nearestDist = Double.MAX_VALUE;
        for (EntityPlayer player : this.x()) {
            double dist = player.i(x2, y2, z2);
            if (dist >= nearestDist || targetPredicate != null && !targetPredicate.test(player)) continue;
            nearest = player;
            nearestDist = dist;
        }
        return nearest;
    }

    @Override
    public EntityHuman a(PathfinderTargetCondition targetPredicate, EntityLiving entity) {
        return this.a(targetPredicate, entity, entity.dr(), entity.dt(), entity.dx());
    }

    @Override
    public EntityHuman a(PathfinderTargetCondition targetPredicate, EntityLiving entity, double x2, double y2, double z2) {
        double range = targetPredicate.d;
        if (range > 0.0) {
            NearbyPlayers players = this.I.a.getNearbyPlayers();
            ReferenceList<EntityPlayer> nearby = players.getPlayersByBlock(CoordinateUtils.getBlockCoordinate(x2), CoordinateUtils.getBlockCoordinate(z2), NearbyPlayers.NearbyMapType.GENERAL);
            if (nearby == null) {
                return null;
            }
            EntityPlayer nearest = null;
            double nearestDist = Double.MAX_VALUE;
            Object[] rawData = nearby.getRawData();
            int len = nearby.size();
            for (int i2 = 0; i2 < len; ++i2) {
                EntityPlayer player = (EntityPlayer)rawData[i2];
                double dist = player.i(x2, y2, z2);
                if (dist >= nearestDist || !targetPredicate.a(entity, player)) continue;
                nearest = player;
                nearestDist = dist;
            }
            return nearest;
        }
        return this.a(this.x(), targetPredicate, entity, x2, y2, z2);
    }

    @Override
    @Nullable
    public EntityHuman a(PathfinderTargetCondition targetPredicate, double x2, double y2, double z2) {
        return this.a(targetPredicate, null, x2, y2, z2);
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, WorldLoadListener worldloadlistener, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.aZ(), worlddimension.a(), minecraftserver::aR, false, flag, i2, minecraftserver.bh(), gen, biomeProvider, env, spigotConfig -> minecraftserver.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(convertable_conversionsession.c.f(), iworlddataserver.g(), resourcekey.a(), spigotConfig, minecraftserver.aZ())), executor);
        this.pvpMode = minecraftserver.aa();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.f().toFile());
        this.H = Lists.newArrayList();
        this.L = new EntityTickList();
        this.R = new TickListServer(this::d, this.ag());
        this.S = new TickListServer(this::d, this.ag());
        this.T = new ObjectOpenHashSet();
        this.V = new ObjectLinkedOpenHashSet();
        this.W = new ArrayList<BlockActionData>(64);
        this.aa = new Int2ObjectOpenHashMap();
        this.ad = flag1;
        this.J = minecraftserver;
        this.Y = list;
        this.K = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.b();
        this.K.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.J.aZ().d(Registries.at));
            if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else if (chunkgenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkgenerator;
                chunkgenerator = new ChunkProviderFlat(cpf.g(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.aW();
        DataFixer datafixer = minecraftserver.aA();
        this.entityStorage = new EntityRegionFileStorage(convertable_conversionsession.a(resourcekey).resolve("entities"), flag2);
        StructureTemplateManager structuretemplatemanager = minecraftserver.aX();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        this.I = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, null, () -> minecraftserver.F().u());
        this.I.h().b();
        this.Q = new PortalTravelAgent(this);
        this.S();
        this.V();
        this.D_().a(minecraftserver.au());
        this.f = this.u().a(PersistentRaid.a(this), PersistentRaid.a(this.ad()));
        if (!minecraftserver.Q()) {
            iworlddataserver.a(minecraftserver.v_());
        }
        long l2 = minecraftserver.aY().A().b();
        this.ac = new StructureCheck(this.I.m(), this.I_(), minecraftserver.aX(), this.getTypeKey(), chunkgenerator, this.I.i(), this, chunkgenerator.c(), l2, datafixer);
        this.ab = new StructureManager(this, this.K.A(), this.ac);
        this.Z = this.ae() == net.minecraft.world.level.World.j && this.ad().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.K.A().b(), this.K.E()) : null;
        this.O = new SleepStatus();
        this.N = new GameEventDispatcher(this);
        this.ae = Objects.requireNonNullElseGet(randomsequences, () -> this.u().a(RandomSequences.a(l2), "random_sequences"));
        this.getCraftServer().addWorld(this.getWorld());
        this.chunkTaskScheduler = new ChunkTaskScheduler(this, ChunkTaskScheduler.workerThreads);
        this.entityLookup = new EntityLookup(this, new a());
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.l().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle enderDragonFight) {
        this.Z = enderDragonFight;
    }

    public void a(int clearDuration, int rainDuration, boolean raining, boolean thundering) {
        this.K.a(clearDuration);
        this.K.f(rainDuration);
        this.K.e(rainDuration);
        this.K.setRaining(raining, WeatherChangeEvent.Cause.COMMAND);
        this.K.setThundering(thundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<BiomeBase> a(int biomeX, int biomeY, int biomeZ) {
        return this.l().g().c().getNoiseBiome(biomeX, biomeY, biomeZ, this.l().i().b());
    }

    public StructureManager a() {
        return this.ab;
    }

    public void a(BooleanSupplier shouldKeepTicking) {
        boolean flag1;
        long j2;
        int i2;
        GameProfilerFiller gameprofilerfiller = this.af();
        this.X = true;
        TickRateManager tickratemanager = this.s();
        boolean flag = tickratemanager.i();
        if (flag) {
            gameprofilerfiller.a("world border");
            this.D_().s();
            gameprofilerfiller.b("weather");
            this.at();
        }
        if (this.O.a(i2 = this.Z().c(GameRules.P)) && this.O.a(i2, this.H)) {
            j2 = this.A.f() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.Y());
            if (this.Z().b(GameRules.l)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.Y() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.ar();
            }
            if (this.Z().b(GameRules.v) && this.ab()) {
                this.g();
            }
        }
        this.S();
        if (flag) {
            this.b();
        }
        gameprofilerfiller.b("tickPending");
        if (!this.ah() && flag) {
            j2 = this.X();
            gameprofilerfiller.a("blockTicks");
            this.R.a(j2, this.paperConfig().environment.maxBlockTicks, this::d);
            gameprofilerfiller.b("fluidTicks");
            this.S.a(j2, this.paperConfig().environment.maxFluidTicks, this::a);
            gameprofilerfiller.c();
        }
        gameprofilerfiller.b("raid");
        if (flag) {
            this.f.a();
        }
        gameprofilerfiller.b("chunkSource");
        this.l().a(shouldKeepTicking, true);
        gameprofilerfiller.b("blockEvents");
        if (flag) {
            this.av();
        }
        this.X = false;
        gameprofilerfiller.c();
        boolean bl = flag1 = !this.paperConfig().unsupportedSettings.disableWorldTickingWhenEmpty || !this.H.isEmpty() || !this.w().isEmpty();
        if (flag1) {
            this.h();
        }
        if (flag1 || this.P++ < 300) {
            gameprofilerfiller.a("entities");
            if (this.Z != null && flag) {
                gameprofilerfiller.a("dragonFight");
                this.Z.c();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.L.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.dH() && !tickratemanager.a((net.minecraft.world.entity.Entity)entity)) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.dy();
                    gameprofilerfiller.c();
                    net.minecraft.world.entity.Entity entity1 = entity.cZ();
                    if (entity1 != null) {
                        if (!entity1.dH() && entity1.x((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.ac();
                    }
                    gameprofilerfiller.a("tick");
                    if (LeavesConfig.removeTickGuardLambda) {
                        try {
                            this.a((net.minecraft.world.entity.Entity)entity);
                            MinecraftServer.getServer().executeMidTickTasks();
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof ThreadDeath) {
                                throw throwable;
                            }
                            String msg = String.format("Entity threw exception at %s:%s,%s,%s", entity.dM().getWorld().getName(), entity.dr(), entity.dt(), entity.dx());
                            MinecraftServer.l.error(msg, throwable);
                            this.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, throwable)));
                            entity.am();
                        }
                    } else {
                        this.a(this::a, entity);
                    }
                    gameprofilerfiller.c();
                }
            });
            gameprofilerfiller.c();
            this.R();
        }
        gameprofilerfiller.a("entityManagement");
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long chunkPos) {
        PlayerChunk holder = this.I.a.b(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void b() {
        if (this.ad) {
            long i2 = this.A.e() + 1L;
            this.K.a(i2);
            this.K.u().a(this.J, i2);
            if (this.A.q().b(GameRules.l)) {
                this.b(this.A.f() + 1L);
            }
        }
    }

    public void b(long timeOfDay) {
        this.K.b(timeOfDay);
    }

    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        for (MobSpawner mobspawner : this.Y) {
            mobspawner.a(this, spawnMonsters, spawnAnimals);
        }
    }

    private boolean i(net.minecraft.world.entity.Entity entity) {
        return !this.J.Y() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal) ? true : !this.J.Z() && entity instanceof NPC;
    }

    private void ar() {
        this.O.a();
        this.H.stream().filter(EntityLiving::fD).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    protected void resetIceAndSnowTick() {
        this.currentIceAndSnowTick = this.randomTickRandom.a(16);
    }

    public void a(Chunk chunk, int randomTickSpeed) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.ab();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = this.af();
        gameprofilerfiller.a("thunder");
        BlockPosition.MutableBlockPosition blockposition = this.chunkTickMutablePosition;
        if (!this.paperConfig().environment.disableThunder && flag && this.aa() && this.spigotConfig.thunderChance > 0 && (LeavesConfig.optimizeChunkTicking ? chunk.shouldDoLightning(this.z) : this.z.a(this.spigotConfig.thunderChance) == 0)) {
            blockposition.g(this.b(this.a(j2, 0, k2, 15)));
            if (this.r(blockposition)) {
                EntityLightning entitylightning;
                EntityHorseSkeleton entityhorseskeleton;
                boolean flag1;
                DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
                boolean bl = flag1 = this.Z().b(GameRules.e) && this.z.j() < (double)difficultydamagescaler.b() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.a_(blockposition.d()).a(Blocks.ss);
                if (flag1 && (entityhorseskeleton = EntityTypes.aL.a(this)) != null) {
                    entityhorseskeleton.w(true);
                    entityhorseskeleton.c_(0);
                    entityhorseskeleton.a_(blockposition.u(), blockposition.v(), blockposition.w());
                    this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                }
                if ((entitylightning = EntityTypes.aj.a(this)) != null) {
                    entitylightning.e(Vec3D.c(blockposition));
                    entitylightning.a(flag1);
                    this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
                }
            }
        }
        gameprofilerfiller.b("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow) {
            for (int l2 = 0; l2 < randomTickSpeed; ++l2) {
                if (this.z.a(48) != 0) continue;
                this.getRandomBlockPosition(j2, 0, k2, 15, blockposition);
                this.tickPrecipitation(blockposition, chunk);
            }
        }
        gameprofilerfiller.b("tickBlocks");
        if (randomTickSpeed > 0) {
            ChunkSection[] sections = chunk.d();
            int minSection = WorldUtil.getMinSection(this);
            for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
                ChunkSection section = sections[sectionIndex];
                if (section == null || section.tickingList.size() == 0) continue;
                int yPos = sectionIndex + minSection << 4;
                for (int a2 = 0; a2 < randomTickSpeed; ++a2) {
                    int tickingBlocks = section.tickingList.size();
                    int index = this.randomTickRandom.a(4096);
                    if (index >= tickingBlocks) continue;
                    long raw = section.tickingList.getRaw(index);
                    int location = IBlockDataList.getLocationFromRaw(raw);
                    int randomX = location & 0xF;
                    int randomY = location >>> 8 & 0xFF | yPos;
                    int randomZ = location >>> 4 & 0xF;
                    BlockPosition.MutableBlockPosition blockposition2 = blockposition.d(j2 + randomX, randomY, k2 + randomZ);
                    IBlockData iblockdata = IBlockDataList.getBlockDataFromRaw(raw);
                    iblockdata.b(this, ((BlockPosition)blockposition2).i(), this.randomTickRandom);
                }
            }
        }
        gameprofilerfiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition pos) {
        this.tickPrecipitation(pos.j(), this.m(pos));
    }

    public void tickPrecipitation(BlockPosition.MutableBlockPosition blockposition1, Chunk chunk) {
        int normalY = chunk.a(HeightMap.Type.e, blockposition1.u() & 0xF, blockposition1.w() & 0xF) + 1;
        int downY = normalY - 1;
        blockposition1.q(normalY);
        BiomeBase biomebase = this.t(blockposition1).a();
        blockposition1.q(downY);
        if (biomebase.a(this, blockposition1)) {
            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, (BlockPosition)blockposition1, Blocks.dO.o(), null);
        }
        if (this.ab()) {
            int i2 = this.Z().c(GameRules.T);
            blockposition1.q(normalY);
            if (i2 > 0 && biomebase.b(this, blockposition1)) {
                IBlockData iblockdata = this.a_(blockposition1);
                if (iblockdata.a(Blocks.dN)) {
                    int j2 = iblockdata.c(BlockSnow.c);
                    if (j2 < Math.min(i2, 8)) {
                        IBlockData iblockdata1 = (IBlockData)iblockdata.a(BlockSnow.c, j2 + 1);
                        Block.a(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, (BlockPosition)blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, (BlockPosition)blockposition1, Blocks.dN.o(), null);
                }
            }
            blockposition1.q(downY);
            BiomeBase.Precipitation biomebase_precipitation = biomebase.a(blockposition1);
            if (biomebase_precipitation != BiomeBase.Precipitation.a) {
                IBlockData iblockdata2 = this.a_(blockposition1);
                iblockdata2.b().a(iblockdata2, (net.minecraft.world.level.World)this, (BlockPosition)blockposition1, biomebase_precipitation);
            }
        }
    }

    public Optional<BlockPosition> E(BlockPosition pos) {
        Optional<BlockPosition> optional = this.y().e(holder -> holder.a(PoiTypes.t), blockposition1 -> blockposition1.v() == this.a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, pos, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition b(BlockPosition pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPosition findLightningTargetAround(BlockPosition pos, boolean returnNullWhenNoTarget) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, pos);
        Optional<BlockPosition> optional = this.E(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(blockposition1, new BlockPosition(blockposition1.h(this.al()))).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bx() && this.h(entityliving.dm()) && !entityliving.P_());
        if (!list.isEmpty()) {
            return list.get(this.z.a(list.size())).dm();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (blockposition1.v() == this.J_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean c() {
        return this.X;
    }

    public boolean d() {
        return this.Z().c(GameRules.P) <= 100;
    }

    private void as() {
        if (this.d() && (!this.o().Q() || this.o().p())) {
            int i2 = this.Z().c(GameRules.P);
            IChatMutableComponent ichatmutablecomponent = this.O.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.O.b(), this.O.b(i2));
            for (EntityPlayer entityplayer : this.H) {
                entityplayer.a(ichatmutablecomponent, true);
            }
        }
    }

    public void e() {
        if (!this.H.isEmpty() && this.O.a(this.H)) {
            this.as();
        }
    }

    public ScoreboardServer f() {
        return this.J.aH();
    }

    private void at() {
        int idx;
        boolean flag = this.ab();
        if (this.E_().g()) {
            if (this.Z().b(GameRules.v)) {
                int i2 = this.K.h();
                int j2 = this.K.j();
                int k2 = this.K.l();
                boolean flag1 = this.A.i();
                boolean flag2 = this.A.k();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? d.a(this.z) : D.a(this.z);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? c.a(this.z) : b.a(this.z);
                    }
                }
                this.K.e(j2);
                this.K.f(k2);
                this.K.a(i2);
                this.K.setThundering(flag1, ThunderChangeEvent.Cause.NATURAL);
                this.K.setRaining(flag2, WeatherChangeEvent.Cause.NATURAL);
            }
            this.x = this.y;
            this.y = this.A.i() ? (this.y += 0.01f) : (this.y -= 0.01f);
            this.y = MathHelper.a(this.y, 0.0f, 1.0f);
            this.v = this.w;
            this.w = this.A.k() ? (this.w += 0.01f) : (this.w -= 0.01f);
            this.w = MathHelper.a(this.w, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.H.size(); ++idx) {
            if (this.H.get(idx).dM() != this) continue;
            this.H.get(idx).tickWeather();
        }
        if (flag != this.ab()) {
            for (idx = 0; idx < this.H.size(); ++idx) {
                if (this.H.get(idx).dM() != this) continue;
                this.H.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.H.size(); ++idx) {
            if (this.H.get(idx).dM() != this) continue;
            this.H.get(idx).updateWeather(this.v, this.w, this.x, this.y);
        }
    }

    @VisibleForTesting
    public void g() {
        this.K.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        if (!this.K.k()) {
            this.K.f(0);
        }
        this.K.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        if (!this.K.i()) {
            this.K.e(0);
        }
    }

    public void h() {
        this.P = 0;
    }

    private void a(BlockPosition pos, FluidType fluid) {
        Fluid fluid1 = this.b_(pos);
        if (fluid1.b(fluid)) {
            fluid1.a(this, pos);
        }
        MinecraftServer.getServer().executeMidTickTasks();
    }

    private void d(BlockPosition pos, Block block) {
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.a(block)) {
            iblockdata.a(this, pos, this.z);
        }
        MinecraftServer.getServer().executeMidTickTasks();
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = ArrayConstants.emptyEntityArray;
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            boolean isActive = ActivationRange.checkIfActive(entity);
            entity.bp();
            GameProfilerFiller gameprofilerfiller = this.af();
            ++entity.ah;
            this.af().a(() -> BuiltInRegistries.g.b(entity.ai()).toString());
            gameprofilerfiller.d("tickNonPassenger");
            if (isActive) {
                entity.l();
                entity.postTick();
            } else {
                entity.inactiveTick();
            }
            this.af().c();
            for (net.minecraft.world.entity.Entity entity1 : entity.cP()) {
                this.a(entity, entity1);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    private void a(net.minecraft.world.entity.Entity vehicle, net.minecraft.world.entity.Entity passenger) {
        if (!passenger.dH() && passenger.cZ() == vehicle) {
            if (passenger instanceof EntityHuman || this.L.c(passenger)) {
                boolean isActive = ActivationRange.checkIfActive(passenger);
                passenger.bp();
                ++passenger.ah;
                GameProfilerFiller gameprofilerfiller = this.af();
                gameprofilerfiller.a(() -> BuiltInRegistries.g.b(passenger.ai()).toString());
                gameprofilerfiller.d("tickPassenger");
                if (isActive) {
                    passenger.t();
                    passenger.postTick();
                } else {
                    passenger.g(Vec3D.b);
                    passenger.inactiveTick();
                    vehicle.i(passenger);
                }
                gameprofilerfiller.c();
                for (net.minecraft.world.entity.Entity entity2 : passenger.cP()) {
                    this.a(passenger, entity2);
                }
            }
        } else {
            passenger.ac();
        }
    }

    @Override
    public boolean a(EntityHuman player, BlockPosition pos) {
        return !this.J.a(this, pos, player) && this.D_().a(pos);
    }

    public void saveIncrementally(boolean doFull) {
        ChunkProviderServer chunkproviderserver = this.l();
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        if (doFull) {
            this.saveLevelData(true);
        }
        if (!this.t()) {
            chunkproviderserver.saveIncrementally();
        }
        if (doFull) {
            WorldServer worldserver1 = this;
            this.K.a(worldserver1.D_().t());
            this.K.a(this.J.aL().c());
            this.convertable.a(this.J.aZ(), this.K, this.J.ae().r());
        }
    }

    public void a(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled) {
        this.save(progressListener, flush, savingDisabled, false);
    }

    public void save(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled, boolean close) {
        ChunkProviderServer chunkproviderserver = this.l();
        if (!savingDisabled) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (progressListener != null) {
                progressListener.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.saveLevelData(!close);
            if (progressListener != null) {
                progressListener.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            if (!close) {
                chunkproviderserver.a(flush);
            }
            if (close) {
                chunkproviderserver.close(true);
            }
        } else if (close) {
            chunkproviderserver.close(false);
        }
        WorldServer worldserver1 = this;
        this.K.a(worldserver1.D_().t());
        this.K.a(this.J.aL().c());
        this.convertable.a(this.J.aZ(), this.K, this.J.ae().r());
    }

    private void saveLevelData(boolean async) {
        if (this.Z != null) {
            this.K.a(this.Z.b());
        }
        this.l().k().save(async);
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(filter, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result) {
        this.a(filter, predicate, result, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result, int limit) {
        this.G().a(filter, (U entity) -> {
            if (predicate.test(entity)) {
                result.add((Object)entity);
                if (result.size() >= limit) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> i() {
        return this.a(EntityTypes.D, EntityLiving::bx);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int limit) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.H) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < limit) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer j() {
        List<EntityPlayer> list = this.a(EntityLiving::bx);
        return list.isEmpty() ? null : list.get(this.z.a(list.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.addEntity(entity, reason);
    }

    public void a(EntityPlayer player) {
        this.e(player);
    }

    public void b(EntityPlayer player) {
        this.e(player);
    }

    public void c(EntityPlayer player) {
        this.e(player);
    }

    public void d(EntityPlayer player) {
        this.e(player);
    }

    private void e(EntityPlayer player) {
        net.minecraft.world.entity.Entity entity = this.G().a(player.cw());
        if (entity != null) {
            E.warn("Force-added player with duplicate UUID {}", (Object)player.cw());
            entity.ag();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.entityLookup.addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityItem itemEntity;
        AsyncCatcher.catchOp("entity add");
        entity.generation = false;
        if (entity.valid) {
            MinecraftServer.l.error("Attempted Double World add on {}", (Object)entity, (Object)new Throwable());
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.dH()) {
            return false;
        }
        if (entity instanceof EntityItem && (itemEntity = (EntityItem)entity).q().b()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof EntityItem) {
            this.captureDrops.add((EntityItem)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.entityLookup.addNewEntity(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.cR().map(net.minecraft.world.entity.Entity::cw);
        if (stream.anyMatch(this.entityLookup::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void a(Chunk chunk) {
        for (TileEntity tileentity : chunk.G().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                ((CraftHumanEntity)h2).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.I();
        chunk.b(this);
    }

    public void a(EntityPlayer player, Entity.RemovalReason reason) {
        player.remove(reason, null);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int entityId, BlockPosition pos, int progress) {
        Iterator<EntityPlayer> iterator = this.J.ae().t().iterator();
        EntityHuman entityhuman = null;
        net.minecraft.world.entity.Entity entity = this.a(entityId);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        if (entity != null) {
            float progressFloat = (float)MathHelper.a(progress, 0, 10) / 10.0f;
            CraftBlock bukkitBlock = CraftBlock.at(this, pos);
            new BlockBreakProgressUpdateEvent((org.bukkit.block.Block)bukkitBlock, progressFloat, (Entity)entity.getBukkitEntity()).callEvent();
        }
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.dM() != this || entityplayer.aj() == entityId) continue;
            double d0 = (double)pos.u() - entityplayer.dr();
            double d1 = (double)pos.v() - entityplayer.dt();
            double d2 = (double)pos.w() - entityplayer.dx();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.c.b(new PacketPlayOutBlockBreakAnimation(entityId, pos, progress));
        }
    }

    @Override
    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.J.ae().a(source, x2, y2, z2, sound.a().a(volume), this.ae(), new PacketPlayOutNamedSoundEffect(sound, category, x2, y2, z2, volume, pitch, seed));
    }

    @Override
    public void a(@Nullable EntityHuman source, net.minecraft.world.entity.Entity entity, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.J.ae().a(source, entity.dr(), entity.dt(), entity.dx(), sound.a().a(volume), this.ae(), new PacketPlayOutEntitySound(sound, category, entity, volume, pitch, seed));
    }

    @Override
    public void b(int eventId, BlockPosition pos, int data) {
        if (this.Z().b(GameRules.W)) {
            this.J.ae().a(new PacketPlayOutWorldEvent(eventId, pos, data, true));
        } else {
            this.a((EntityHuman)null, eventId, pos, data);
        }
    }

    @Override
    public void a(@Nullable EntityHuman player, int eventId, BlockPosition pos, int data) {
        this.J.ae().a(player, pos.u(), pos.v(), pos.w(), 64.0, this.ae(), new PacketPlayOutWorldEvent(eventId, pos, data, false));
    }

    public int k() {
        return this.E_().p();
    }

    @Override
    public void a(GameEvent event, Vec3D emitterPos, GameEvent.a emitter) {
        if (this.getChunkIfLoadedImmediately(MathHelper.a(emitterPos.c) >> 4, MathHelper.a(emitterPos.e) >> 4) == null) {
            return;
        }
        this.N.a(event, emitterPos, emitter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState, int flags) {
        VoxelShape voxelshape1;
        VoxelShape voxelshape;
        if (this.U) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.l().a(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && VoxelShapes.c(voxelshape = oldState.k(this, pos), voxelshape1 = newState.k(this, pos), OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.T.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.a(pos, oldState, newState, flags);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.N();
                if (!navigationabstract.b(pos)) continue;
                list.add(navigationabstract);
            }
            try {
                this.U = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.i();
                }
            }
            finally {
                this.U = false;
            }
        }
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock) {
        if (this.captureBlockStates) {
            return;
        }
        this.s.a(pos, sourceBlock, (EnumDirection)null);
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, EnumDirection direction) {
        this.s.a(pos, sourceBlock, direction);
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, BlockPosition sourcePos) {
        this.s.a(pos, sourceBlock, sourcePos);
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        this.s.a(state, pos, sourceBlock, sourcePos, notify);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte status) {
        this.l().a(entity, new PacketPlayOutEntityStatus(entity, status));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.l().a(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    public ChunkProviderServer l() {
        return this.I;
    }

    @Override
    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, World.a explosionSourceType, ParticleParam particle, ParticleParam emitterParticle, SoundEffect soundEvent) {
        Explosion explosion = this.a(entity, damageSource, behavior, x2, y2, z2, power, createFire, explosionSourceType, false, particle, emitterParticle, soundEvent);
        if (explosion.wasCanceled) {
            return explosion;
        }
        if (!explosion.d()) {
            explosion.h();
        }
        for (EntityPlayer entityplayer : this.H) {
            if (!(entityplayer.i(x2, y2, z2) < 4096.0)) continue;
            entityplayer.c.b(new PacketPlayOutExplosion(x2, y2, z2, power, explosion.i(), explosion.e().get(entityplayer), explosion.j(), explosion.k(), explosion.l(), explosion.m()));
        }
        return explosion;
    }

    @Override
    public void a(BlockPosition pos, Block block, int type, int data) {
        this.V.add((Object)new BlockActionData(pos, block, type, data));
    }

    private void av() {
        this.W.clear();
        while (!this.V.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.V.removeFirst();
            if (this.n(blockactiondata.a())) {
                if (!this.a(blockactiondata)) continue;
                this.J.ae().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.ae(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.W.add(blockactiondata);
        }
        this.V.addAll(this.W);
    }

    private boolean a(BlockActionData event) {
        IBlockData iblockdata = this.a_(event.a());
        return iblockdata.a(event.b()) ? iblockdata.a((net.minecraft.world.level.World)this, event.a(), event.c(), event.d()) : false;
    }

    public TickListServer<Block> m() {
        return this.R;
    }

    public TickListServer<FluidType> n() {
        return this.S;
    }

    @Override
    @Nonnull
    public MinecraftServer o() {
        return this.J;
    }

    public PortalTravelAgent p() {
        return this.Q;
    }

    public StructureTemplateManager q() {
        return this.J.aX();
    }

    public <T extends ParticleParam> int a(T particle, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        return this.sendParticles(null, particle, x2, y2, z2, count, deltaX, deltaY, deltaZ, speed, false);
    }

    public <T extends ParticleParam> int sendParticles(EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        return this.sendParticles(this.H, sender, t0, d0, d1, d2, i2, d3, d4, d5, d6, force);
    }

    public <T extends ParticleParam> int sendParticles(List<EntityPlayer> receivers, @Nullable EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (EntityHuman entityHuman : receivers) {
            EntityPlayer entityplayer = (EntityPlayer)entityHuman;
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer viewer, T particle, boolean force, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, force, x2, y2, z2, (float)deltaX, (float)deltaY, (float)deltaZ, (float)speed, count);
        return this.a(viewer, force, x2, y2, z2, packet);
    }

    private boolean a(EntityPlayer player, boolean force, double x2, double y2, double z2, Packet<?> packet) {
        if (player.dM() != this) {
            return false;
        }
        BlockPosition blockposition = player.dm();
        if (blockposition.a(new Vec3D(x2, y2, z2), force ? 512.0 : 32.0)) {
            player.c.b(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(int id) {
        return this.G().a(id);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity b(int id) {
        net.minecraft.world.entity.Entity entity = this.G().a(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.aa.get(id);
    }

    @Nullable
    public net.minecraft.world.entity.Entity a(UUID uuid) {
        return this.G().a(uuid);
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> structureTag, BlockPosition pos, int radius, boolean skipReferencedStructures) {
        if (!this.K.A().c()) {
            return null;
        }
        Optional<HolderSet.Named<Structure>> optional = this.I_().d(Registries.aD).b(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.l().g().a(this, (HolderSet<Structure>)optional.get(), pos, radius, skipReferencedStructures);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> predicate, BlockPosition pos, int radius, int horizontalBlockCheckInterval, int verticalBlockCheckInterval) {
        return this.l().g().c().a(pos, radius, horizontalBlockCheckInterval, verticalBlockCheckInterval, predicate, this.l().i().b(), this);
    }

    @Override
    public CraftingManager r() {
        return this.J.aG();
    }

    @Override
    public TickRateManager s() {
        return this.J.aO();
    }

    @Override
    public boolean t() {
        return this.e;
    }

    public WorldPersistentData u() {
        return this.l().k();
    }

    @Override
    @Nullable
    public WorldMap a(String id) {
        WorldMap data;
        WorldPersistentData storage = this.o().F().u();
        PersistentBase existing = storage.b.get(id);
        if (existing == null && !storage.b.containsKey(id)) {
            PersistentBase.a<WorldMap> factory = WorldMap.a();
            WorldMap map = storage.a(factory.b(), factory.c(), id);
            storage.b.put(id, map);
            if (map != null) {
                map.id = id;
                new MapInitializeEvent((MapView)map.mapView).callEvent();
                return map;
            }
        } else if (existing instanceof WorldMap) {
            WorldMap mapItemSavedData = (WorldMap)existing;
            mapItemSavedData.id = id;
        }
        return existing instanceof WorldMap ? (data = (WorldMap)existing) : null;
    }

    @Override
    public void a(String id, WorldMap state) {
        state.id = id;
        MapInitializeEvent event = new MapInitializeEvent((MapView)state.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.o().F().u().a(id, state);
    }

    @Override
    public int v() {
        return this.o().F().u().a(PersistentIdCounts.a(), "idcounts").b();
    }

    public void addTicketsForSpawn(int radiusInBlocks, BlockPosition spawn) {
        int x2;
        ChunkProviderServer chunkproviderserver = this.l();
        int tickRadius = radiusInBlocks - 16;
        for (x2 = -tickRadius; x2 <= tickRadius; x2 += 16) {
            for (int z2 = -tickRadius; z2 <= tickRadius; z2 += 16) {
                chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, z2)), 2, Unit.a);
            }
        }
        for (x2 = -radiusInBlocks; x2 <= radiusInBlocks; x2 += 16) {
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, radiusInBlocks)), 1, Unit.a);
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, -radiusInBlocks)), 1, Unit.a);
        }
        for (int z3 = -radiusInBlocks + 16; z3 < radiusInBlocks; z3 += 16) {
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(radiusInBlocks, 0, z3)), 1, Unit.a);
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(-radiusInBlocks, 0, z3)), 1, Unit.a);
        }
    }

    public void removeTicketsForSpawn(int radiusInBlocks, BlockPosition spawn) {
        int x2;
        ChunkProviderServer chunkproviderserver = this.l();
        int tickRadius = radiusInBlocks - 16;
        for (x2 = -tickRadius; x2 <= tickRadius; x2 += 16) {
            for (int z2 = -tickRadius; z2 <= tickRadius; z2 += 16) {
                chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, z2)), 2, Unit.a);
            }
        }
        for (x2 = -radiusInBlocks; x2 <= radiusInBlocks; x2 += 16) {
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, radiusInBlocks)), 1, Unit.a);
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, -radiusInBlocks)), 1, Unit.a);
        }
        for (int z3 = -radiusInBlocks + 16; z3 < radiusInBlocks; z3 += 16) {
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(radiusInBlocks, 0, z3)), 1, Unit.a);
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(-radiusInBlocks, 0, z3)), 1, Unit.a);
        }
    }

    public void a(BlockPosition pos, float angle) {
        BlockPosition prevSpawn = this.T();
        Location prevSpawnLoc = this.getWorld().getSpawnLocation();
        this.A.a(pos, angle);
        new SpawnChangeEvent((World)this.getWorld(), prevSpawnLoc).callEvent();
        if (this.keepSpawnInMemory) {
            this.removeTicketsForSpawn(this.paperConfig().spawn.keepSpawnLoadedRange * 16, prevSpawn);
            this.addTicketsForSpawn(this.paperConfig().spawn.keepSpawnLoadedRange * 16, pos);
        }
        this.o().ae().a(new PacketPlayOutSpawnPosition(pos, angle));
    }

    public LongSet w() {
        ForcedChunk forcedchunk = this.u().b(ForcedChunk.a(), "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.b()) : LongSets.EMPTY_SET;
    }

    public boolean a(int x2, int z2, boolean forced) {
        boolean flag1;
        ForcedChunk forcedchunk = this.u().a(ForcedChunk.a(), "chunks");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(x2, z2);
        long k2 = chunkcoordintpair.a();
        if (forced) {
            flag1 = forcedchunk.b().add(k2);
            if (flag1) {
                this.d(x2, z2);
            }
        } else {
            flag1 = forcedchunk.b().remove(k2);
        }
        forcedchunk.a(flag1);
        if (flag1) {
            this.l().a(chunkcoordintpair, forced);
        }
        return flag1;
    }

    public List<EntityPlayer> x() {
        return this.H;
    }

    @Override
    public void a(BlockPosition pos, IBlockData oldBlock, IBlockData newBlock) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(oldBlock);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(newBlock))) {
            BlockPosition blockposition1 = pos.i();
            optional.ifPresent(holder -> this.o().execute(() -> {
                this.y().a(blockposition1);
                PacketDebug.b(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.o().execute(() -> {
                if (optional.isEmpty() && this.y().a(blockposition1, (Holder<VillagePlaceType> poiType) -> true)) {
                    this.y().a(blockposition1);
                }
                this.y().a(blockposition1, (Holder<VillagePlaceType>)holder);
                PacketDebug.a(this, blockposition1);
            }));
        }
    }

    public VillagePlace y() {
        return this.l().l();
    }

    public boolean c(BlockPosition pos) {
        return this.a(pos, 1);
    }

    public boolean a(SectionPosition sectionPos) {
        return this.c(sectionPos.q());
    }

    public boolean a(BlockPosition pos, int maxDistance) {
        return maxDistance > 6 ? false : this.b(SectionPosition.a(pos)) <= maxDistance;
    }

    public int b(SectionPosition pos) {
        return this.y().a(pos);
    }

    public PersistentRaid z() {
        return this.f;
    }

    @Nullable
    public Raid d(BlockPosition pos) {
        return this.f.a(pos, 9216);
    }

    public boolean e(BlockPosition pos) {
        return this.d(pos) != null;
    }

    public void a(ReputationEvent interaction, net.minecraft.world.entity.Entity entity, ReputationHandler observer) {
        observer.a(interaction, entity);
    }

    public void a(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedwriter3;
        PlayerChunkMap playerchunkmap = this.l().a;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.j().b()));
            SpawnerCreature.d spawnercreature_d = this.l().n();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.b().object2IntEntrySet()) {
                    bufferedwriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format(Locale.ROOT, "entities: %s\n", this.entityLookup.getDebugInfo()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.r.size()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.m().a()));
            bufferedwriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.n().a()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.j().c() + "\n");
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.l().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.e());
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedwriter2 != null) {
            bufferedwriter2.close();
        }
        if ((bufferedwriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            bufferedwriter3.close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedwriter4, this.G().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedwriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            IChatBaseComponent ichatbasecomponent = entity.af();
            IChatBaseComponent ichatbasecomponent1 = entity.Q_();
            csvwriter.a(entity.dr(), entity.dt(), entity.dx(), entity.cw(), BuiltInRegistries.g.b(entity.ai()), entity.bx(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.r) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox box) {
        this.V.removeIf(blockactiondata -> box.b(blockactiondata.a()));
    }

    @Override
    public void b(BlockPosition pos, Block block) {
        if (NoBlockUpdateCommand.isNoBlockUpdate()) {
            return;
        }
        if (!this.ah()) {
            if (this.populating) {
                return;
            }
            this.a(pos, block);
        }
    }

    @Override
    public float a(EnumDirection direction, boolean shaded) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> A() {
        return this.G().a();
    }

    public String toString() {
        return "ServerLevel[" + this.K.g() + "]";
    }

    public boolean B() {
        return this.K.B();
    }

    @Override
    public long C() {
        return this.K.A().b();
    }

    @Nullable
    public EnderDragonBattle D() {
        return this.Z;
    }

    @Override
    public WorldServer E() {
        return this;
    }

    @VisibleForTesting
    public String F() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.H.size(), this.entityLookup.getDebugInfo(), WorldServer.a(this.entityLookup.a(), (T entity) -> BuiltInRegistries.g.b(entity.ai()).toString()), this.r.size(), WorldServer.a(this.r, TickingBlockEntity::d), this.m().a(), this.n().a(), this.H());
    }

    private static <T> String a(Iterable<T> items, Function<T, String> classifier) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : items) {
                String s2 = classifier.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void a(WorldServer world) {
        WorldServer.makeObsidianPlatform(world, null);
    }

    public static void makeObsidianPlatform(WorldServer worldserver, net.minecraft.world.entity.Entity entity) {
        BlockPosition blockposition = a;
        int i2 = blockposition.u();
        int j2 = blockposition.v() - 2;
        int k2 = blockposition.w();
        BlockStateListPopulator blockList = new BlockStateListPopulator(worldserver);
        BlockPosition.b(i2 - 2, j2 + 1, k2 - 2, i2 + 2, j2 + 3, k2 + 2).forEach(blockposition1 -> blockList.a((BlockPosition)blockposition1, Blocks.a.o(), 3));
        BlockPosition.b(i2 - 2, j2, k2 - 2, i2 + 2, j2, k2 + 2).forEach(blockposition1 -> blockList.a((BlockPosition)blockposition1, Blocks.co.o(), 3));
        CraftWorld bworld = worldserver.getWorld();
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.END_PLATFORM);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> G() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.entityLookup;
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair forChunk) {
        this.entityLookup.addLegacyChunkEntities(entities.toList(), forChunk);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair forChunk) {
        this.entityLookup.addWorldGenChunkEntities(entities.toList(), forChunk);
    }

    public void b(Chunk chunk) {
        chunk.c(this.B_().e());
    }

    public void a(IChunkAccess chunk) {
        this.J.execute(() -> this.ac.a(chunk.f(), chunk.g()));
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String H() {
        String s2 = this.I.e();
        return "Chunks[S] W: " + s2 + " E: " + this.entityLookup.getDebugInfo();
    }

    public boolean c(long chunkPos) {
        return this.getChunkIfLoadedImmediately(ChunkCoordIntPair.a(chunkPos), ChunkCoordIntPair.b(chunkPos)) != null;
    }

    private boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean f(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean g(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean a(ChunkCoordIntPair pos) {
        NewChunkHolder chunkHolder = this.chunkTaskScheduler.chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Override
    public FeatureFlagSet I() {
        return this.J.aY().M();
    }

    public RandomSource a(MinecraftKey id) {
        return this.ae.a(id);
    }

    public RandomSequences J() {
        return this.ae;
    }

    @Override
    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashreportsystemdetails = super.a(report);
        crashreportsystemdetails.a("Loaded entity count", () -> String.valueOf(this.entityLookup.getAllCopy().length));
        return crashreportsystemdetails;
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    @Override
    @Nullable
    public EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.J.ae().a(uuid);
    }

    private static final class EntityRegionFileStorage
    extends RegionFileCache {
        public EntityRegionFileStorage(Path directory, boolean dsync) {
            super(directory, dsync);
        }

        @Override
        protected void a(ChunkCoordIntPair pos, NBTTagCompound nbt) throws IOException {
            ChunkCoordIntPair nbtPos;
            ChunkCoordIntPair chunkCoordIntPair = nbtPos = nbt == null ? null : EntityStorage.a(nbt);
            if (nbtPos != null && !pos.equals(nbtPos)) {
                throw new IllegalArgumentException("Entity chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + pos.toString() + " but compound says coordinate is " + nbtPos + " for world: " + this);
            }
            super.a(pos, nbt);
        }
    }

    private final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.f().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !WorldServer.this.paperConfig().entities.markers.tick) {
                return;
            }
            WorldServer.this.L.a(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.L.b(entity);
            if (!LeavesConfig.mcTechnicalMode && WorldServer.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                pearl.c = null;
                ((IProjectile)pearl).b = null;
            }
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.add(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                WorldServer.this.T.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.ga()) {
                    WorldServer.this.aa.put(entitycomplexpart.aj(), (Object)entitycomplexpart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.inWorld = true;
            entity.valid = true;
            WorldServer.this.l().b(entity);
            if (entity.getOriginVector() == null) {
                entity.setOrigin(entity.getBukkitEntity().getLocation());
            }
            if (entity.getOriginWorld() == null) {
                entity.setOrigin(entity.getOriginVector().toLocation((World)WorldServer.this.getWorld()));
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.o().H()).map(WorldServer::u).forEach(worldData -> {
                    for (PersistentBase o2 : worldData.b.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)o2;
                        map.o.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.n.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            map.q.remove(entity.ad().getString());
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dI() != Entity.RemovalReason.a)) {
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            WorldServer.this.l().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.remove(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                WorldServer.this.T.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.ga()) {
                    WorldServer.this.aa.remove(entitycomplexpart.aj());
                }
            }
            entity.a(DynamicGameEventListener::b);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.H) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void g(net.minecraft.world.entity.Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

