/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackFile;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.slf4j.Logger;

public class ResourcePackSourceFolder
implements ResourcePackSource {
    static final Logger a = LogUtils.getLogger();
    private final Path b;
    private final EnumResourcePackType c;
    private final PackSource d;
    private final DirectoryValidator e;

    public ResourcePackSourceFolder(Path packsDir, EnumResourcePackType type, PackSource source, DirectoryValidator symlinkFinder) {
        this.b = packsDir;
        this.c = type;
        this.d = source;
        this.e = symlinkFinder;
    }

    private static String a(Path path) {
        return path.getFileName().toString();
    }

    @Override
    @Override
    public void loadPacks(Consumer<ResourcePackLoader> profileAdder) {
        try {
            FileUtils.c(this.b);
            ResourcePackSourceFolder.a(this.b, this.e, false, (path, packFactory) -> {
                String string = ResourcePackSourceFolder.a(path);
                ResourcePackLoader pack = ResourcePackLoader.a("file/" + string, IChatBaseComponent.b(string), false, packFactory, this.c, ResourcePackLoader.Position.a, this.d);
                if (pack != null) {
                    profileAdder.accept(pack);
                }
            });
        }
        catch (IOException iOException) {
            a.warn("Failed to list packs in {}", (Object)this.b, (Object)iOException);
        }
    }

    public static void a(Path path, DirectoryValidator symlinkFinder, boolean alwaysStable, BiConsumer<Path, ResourcePackLoader.c> consumer) throws IOException {
        a folderPackDetector = new a(symlinkFinder, alwaysStable);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                try {
                    ArrayList<ForbiddenSymlinkInfo> list = new ArrayList<ForbiddenSymlinkInfo>();
                    ResourcePackLoader.c resourcesSupplier = (ResourcePackLoader.c)folderPackDetector.a(path2, list);
                    if (!list.isEmpty()) {
                        a.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.a(path2, list));
                        continue;
                    }
                    if (resourcesSupplier != null) {
                        consumer.accept(path2, resourcesSupplier);
                        continue;
                    }
                    a.info("Found non-pack entry '{}', ignoring", (Object)path2);
                }
                catch (IOException iOException) {
                    a.warn("Failed to read properties of '{}', ignoring", (Object)path2, (Object)iOException);
                }
            }
        }
    }

    static class a
    extends PackDetector<ResourcePackLoader.c> {
        private final boolean a;

        protected a(DirectoryValidator symlinkFinder, boolean alwaysStable) {
            super(symlinkFinder);
            this.a = alwaysStable;
        }

        @Nullable
        @Override
        protected ResourcePackLoader.c a(Path path) {
            FileSystem fileSystem = path.getFileSystem();
            if (fileSystem == FileSystems.getDefault() || fileSystem instanceof LinkFileSystem) {
                return new ResourcePackFile.a(path, this.a);
            }
            a.info("Can't open pack archive at {}", (Object)path);
            return null;
        }

        @Override
        protected ResourcePackLoader.c b(Path path) {
            return new PathPackResources.a(path, this.a);
        }

        @Override
        protected /* synthetic */ Object c(Path path) throws IOException {
            return this.b(path);
        }

        @Override
        @Nullable
        protected /* synthetic */ Object d(Path path) throws IOException {
            return this.a(path);
        }
    }
}

