/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class UserCache {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 1000;
    private static final int c = 1;
    private static boolean d;
    private final Map<String, UserCacheEntry> e = Maps.newConcurrentMap();
    private final Map<UUID, UserCacheEntry> f = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> g = Maps.newConcurrentMap();
    private final GameProfileRepository h;
    private final Gson i = new GsonBuilder().create();
    private final File j;
    private final AtomicLong k = new AtomicLong();
    @Nullable
    private Executor l;
    protected final ReentrantLock stateLock = new ReentrantLock();
    protected final ReentrantLock lookupLock = new ReentrantLock();

    public UserCache(GameProfileRepository profileRepository, File cacheFile) {
        this.h = profileRepository;
        this.j = cacheFile;
        Lists.reverse(this.b()).forEach(this::a);
    }

    private void a(UserCacheEntry entry) {
        try {
            this.stateLock.lock();
            GameProfile gameprofile = entry.a();
            entry.a(this.e());
            this.e.put(gameprofile.getName().toLowerCase(Locale.ROOT), entry);
            this.f.put(gameprofile.getId(), entry);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static Optional<GameProfile> a(GameProfileRepository repository, String name) {
        GameProfile gameprofile;
        if (!EntityHuman.c(name)) {
            return UserCache.c(name);
        }
        final AtomicReference atomicreference = new AtomicReference();
        ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameprofile) {
                atomicreference.set(gameprofile);
            }

            public void onProfileLookupFailed(String s1, Exception exception) {
                atomicreference.set(null);
            }
        };
        if (!StringUtils.isBlank((CharSequence)name) && GlobalConfiguration.get().proxies.isProxyOnlineMode()) {
            repository.findProfilesByNames(new String[]{name}, profilelookupcallback);
        }
        return (gameprofile = (GameProfile)atomicreference.get()) != null ? Optional.of(gameprofile) : UserCache.c(name);
    }

    private static Optional<GameProfile> c(String name) {
        return UserCache.d() ? Optional.empty() : Optional.of(UUIDUtil.b(name));
    }

    public static void a(boolean value) {
        d = value;
    }

    private static boolean d() {
        return GlobalConfiguration.get().proxies.isProxyOnlineMode();
    }

    public void a(GameProfile profile) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date date = calendar.getTime();
        UserCacheEntry usercache_usercacheentry = new UserCacheEntry(profile, date);
        this.a(usercache_usercacheentry);
        if (!SpigotConfig.saveUserCacheOnStopOnly) {
            this.save(true);
        }
    }

    private long e() {
        return this.k.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GameProfile getProfileIfCached(String name) {
        try {
            this.stateLock.lock();
            UserCacheEntry entry = this.e.get(name.toLowerCase(Locale.ROOT));
            if (entry == null) {
                GameProfile gameProfile = null;
                return gameProfile;
            }
            entry.a(this.e());
            GameProfile gameProfile = entry.a();
            return gameProfile;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GameProfile> a(String name) {
        String s1 = name.toLowerCase(Locale.ROOT);
        boolean stateLocked = true;
        try {
            Optional<GameProfile> optional;
            this.stateLock.lock();
            UserCacheEntry usercache_usercacheentry = this.e.get(s1);
            boolean flag = false;
            if (usercache_usercacheentry != null && new Date().getTime() >= usercache_usercacheentry.b.getTime()) {
                this.f.remove(usercache_usercacheentry.a().getId());
                this.e.remove(usercache_usercacheentry.a().getName().toLowerCase(Locale.ROOT));
                flag = true;
                usercache_usercacheentry = null;
            }
            if (usercache_usercacheentry != null) {
                usercache_usercacheentry.a(this.e());
                optional = Optional.of(usercache_usercacheentry.a());
                stateLocked = false;
                this.stateLock.unlock();
            } else {
                stateLocked = false;
                this.stateLock.unlock();
                try {
                    this.lookupLock.lock();
                    optional = UserCache.a(this.h, name);
                }
                finally {
                    this.lookupLock.unlock();
                }
                if (optional.isPresent()) {
                    this.a(optional.get());
                    flag = false;
                }
            }
            if (flag && !SpigotConfig.saveUserCacheOnStopOnly) {
                this.save(true);
            }
            Optional<GameProfile> optional2 = optional;
            return optional2;
        }
        finally {
            if (stateLocked) {
                this.stateLock.unlock();
            }
        }
    }

    public CompletableFuture<Optional<GameProfile>> b(String username) {
        if (this.l == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> completablefuture = this.g.get(username);
        if (completablefuture != null) {
            return completablefuture;
        }
        CompletionStage completablefuture1 = CompletableFuture.supplyAsync(() -> this.a(username), SystemUtils.PROFILE_EXECUTOR).whenCompleteAsync((optional, throwable) -> this.g.remove(username), this.l);
        this.g.put(username, (CompletableFuture<Optional<GameProfile>>)completablefuture1);
        return completablefuture1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GameProfile> a(UUID uuid) {
        try {
            this.stateLock.lock();
            UserCacheEntry usercache_usercacheentry = this.f.get(uuid);
            if (usercache_usercacheentry == null) {
                Optional<GameProfile> optional = Optional.empty();
                return optional;
            }
            usercache_usercacheentry.a(this.e());
            Optional<GameProfile> optional = Optional.of(usercache_usercacheentry.a());
            return optional;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void a(Executor executor) {
        this.l = executor;
    }

    public void a() {
        this.l = null;
    }

    private static DateFormat f() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    public List<UserCacheEntry> b() {
        ArrayList arraylist;
        block11: {
            arraylist = Lists.newArrayList();
            try {
                ArrayList arraylist1;
                try (BufferedReader bufferedreader = Files.newReader((File)this.j, (Charset)StandardCharsets.UTF_8);){
                    JsonArray jsonarray = (JsonArray)this.i.fromJson((Reader)bufferedreader, JsonArray.class);
                    if (jsonarray != null) {
                        DateFormat dateformat = UserCache.f();
                        jsonarray.forEach(jsonelement -> {
                            Optional<UserCacheEntry> optional = UserCache.a(jsonelement, dateformat);
                            Objects.requireNonNull(arraylist);
                            optional.ifPresent(arraylist::add);
                        });
                        break block11;
                    }
                    arraylist1 = arraylist;
                }
                return arraylist1;
            }
            catch (FileNotFoundException bufferedreader) {
            }
            catch (JsonSyntaxException | NullPointerException ex) {
                a.warn("Usercache.json is corrupted or has bad formatting. Deleting it to prevent further issues.");
                this.j.delete();
            }
            catch (JsonParseException | IOException ioexception) {
                a.warn("Failed to load profile cache {}", (Object)this.j, (Object)ioexception);
            }
        }
        return arraylist;
    }

    public void save(boolean asyncSave) {
        JsonArray jsonarray = new JsonArray();
        DateFormat dateformat = UserCache.f();
        this.listTopMRUProfiles(SpigotConfig.userCacheCap).forEach(usercache_usercacheentry -> jsonarray.add(UserCache.a(usercache_usercacheentry, dateformat)));
        String s2 = this.i.toJson((JsonElement)jsonarray);
        Runnable save = () -> {
            try (BufferedWriter bufferedwriter = Files.newWriter((File)this.j, (Charset)StandardCharsets.UTF_8);){
                bufferedwriter.write(s2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        if (asyncSave) {
            MCUtil.scheduleAsyncTask(save);
        } else {
            save.run();
        }
    }

    private Stream<UserCacheEntry> a(int limit) {
        return this.listTopMRUProfiles(limit).stream();
    }

    private List<UserCacheEntry> listTopMRUProfiles(int limit) {
        try {
            this.stateLock.lock();
            List<UserCacheEntry> list = this.f.values().stream().sorted(Comparator.comparing(UserCacheEntry::c).reversed()).limit(limit).toList();
            return list;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static JsonElement a(UserCacheEntry entry, DateFormat dateFormat) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", entry.a().getName());
        jsonobject.addProperty("uuid", entry.a().getId().toString());
        jsonobject.addProperty("expiresOn", dateFormat.format(entry.b()));
        return jsonobject;
    }

    private static Optional<UserCacheEntry> a(JsonElement json, DateFormat dateFormat) {
        if (json.isJsonObject()) {
            JsonObject jsonobject = json.getAsJsonObject();
            JsonElement jsonelement1 = jsonobject.get("name");
            JsonElement jsonelement2 = jsonobject.get("uuid");
            JsonElement jsonelement3 = jsonobject.get("expiresOn");
            if (jsonelement1 != null && jsonelement2 != null) {
                String s2 = jsonelement2.getAsString();
                String s1 = jsonelement1.getAsString();
                Date date = null;
                if (jsonelement3 != null) {
                    try {
                        date = dateFormat.parse(jsonelement3.getAsString());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (s1 != null && s2 != null && date != null) {
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(s2);
                    }
                    catch (Throwable throwable) {
                        return Optional.empty();
                    }
                    return Optional.of(new UserCacheEntry(new GameProfile(uuid, s1), date));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static class UserCacheEntry {
        private final GameProfile a;
        final Date b;
        private volatile long c;

        UserCacheEntry(GameProfile profile, Date expirationDate) {
            this.a = profile;
            this.b = expirationDate;
        }

        public GameProfile a() {
            return this.a;
        }

        public Date b() {
            return this.b;
        }

        public void a(long lastAccessed) {
            this.c = lastAccessed;
        }

        public long c() {
            return this.c;
        }
    }
}

