/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatisticManager
extends StatisticManager {
    private static final Logger b = LogUtils.getLogger();
    private final MinecraftServer c;
    private final File d;
    private final Set<Statistic<?>> e = Sets.newHashSet();

    public ServerStatisticManager(MinecraftServer server, File file) {
        this.c = server;
        this.d = file;
        if (file.isFile()) {
            try {
                this.a(server.aA(), FileUtils.readFileToString((File)file));
            }
            catch (IOException ioexception) {
                b.error("Couldn't read statistics file {}", (Object)file, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                b.error("Couldn't parse statistics file {}", (Object)file, (Object)jsonparseexception);
            }
        }
        for (Map.Entry<MinecraftKey, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Statistic<MinecraftKey> wrapper = StatisticList.i.b(Objects.requireNonNull(BuiltInRegistries.m.a(entry.getKey())));
            this.a.put(wrapper, entry.getValue().intValue());
        }
    }

    public void a() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.d, (String)this.b());
        }
        catch (IOException ioexception) {
            b.error("Couldn't save stats", (Throwable)ioexception);
        }
    }

    @Override
    public void a(EntityHuman player, Statistic<?> stat, int value) {
        MinecraftKey resourceLocation;
        Object obj;
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        if (stat.a() == StatisticList.i && (obj = stat.b()) instanceof MinecraftKey && SpigotConfig.forcedStats.get(resourceLocation = (MinecraftKey)obj) != null) {
            return;
        }
        super.a(player, stat, value);
        this.e.add(stat);
    }

    private Set<Statistic<?>> d() {
        HashSet set = Sets.newHashSet(this.e);
        this.e.clear();
        return set;
    }

    public void a(DataFixer dataFixer, String json) {
        block11: {
            try {
                try (JsonReader jsonreader = new JsonReader((Reader)new StringReader(json));){
                    jsonreader.setLenient(false);
                    JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
                    if (!jsonelement.isJsonNull()) {
                        NBTTagCompound nbttagcompound = ServerStatisticManager.a(jsonelement.getAsJsonObject());
                        if (!(nbttagcompound = DataFixTypes.g.a(dataFixer, nbttagcompound, GameProfileSerializer.b(nbttagcompound, 1343))).b("stats", 10)) {
                            break block11;
                        }
                        NBTTagCompound nbttagcompound1 = nbttagcompound.p("stats");
                        Iterator<String> iterator = nbttagcompound1.e().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                break block11;
                            }
                            String s1 = iterator.next();
                            if (!nbttagcompound1.b(s1, 10)) continue;
                            SystemUtils.a(BuiltInRegistries.x.b(new MinecraftKey(s1)), statisticwrapper -> {
                                NBTTagCompound nbttagcompound2 = nbttagcompound1.p(s1);
                                for (String s2 : nbttagcompound2.e()) {
                                    if (nbttagcompound2.b(s2, 99)) {
                                        SystemUtils.a(this.a((StatisticWrapper)statisticwrapper, s2), statistic -> this.a.put(statistic, nbttagcompound2.h(s2)), () -> b.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.d, (Object)s2));
                                        continue;
                                    }
                                    b.warn("Invalid statistic value in {}: Don't know what {} is for key {}", new Object[]{this.d, nbttagcompound2.c(s2), s2});
                                }
                            }, () -> b.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.d, (Object)s1));
                        }
                    }
                    b.error("Unable to parse Stat data from {}", (Object)this.d);
                }
                return;
            }
            catch (JsonParseException | IOException jsonparseexception) {
                b.error("Unable to parse Stat data from {}", (Object)this.d, (Object)jsonparseexception);
            }
        }
    }

    private <T> Optional<Statistic<T>> a(StatisticWrapper<T> type, String id) {
        Optional<MinecraftKey> optional = Optional.ofNullable(MinecraftKey.a(id));
        IRegistry<T> iregistry = type.a();
        return optional.flatMap(iregistry::b).map(type::b);
    }

    private static NBTTagCompound a(JsonObject json) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        for (Map.Entry entry : json.entrySet()) {
            JsonPrimitive jsonprimitive;
            JsonElement jsonelement = (JsonElement)entry.getValue();
            if (jsonelement.isJsonObject()) {
                nbttagcompound.a((String)entry.getKey(), ServerStatisticManager.a(jsonelement.getAsJsonObject()));
                continue;
            }
            if (!jsonelement.isJsonPrimitive() || !(jsonprimitive = jsonelement.getAsJsonPrimitive()).isNumber()) continue;
            nbttagcompound.a((String)entry.getKey(), jsonprimitive.getAsInt());
        }
        return nbttagcompound;
    }

    protected String b() {
        HashMap map = Maps.newHashMap();
        for (Object2IntMap.Entry it_unimi_dsi_fastutil_objects_object2intmap_entry : this.a.object2IntEntrySet()) {
            Statistic statistic = (Statistic)it_unimi_dsi_fastutil_objects_object2intmap_entry.getKey();
            map.computeIfAbsent(statistic.a(), statisticwrapper -> new JsonObject()).addProperty(ServerStatisticManager.b(statistic).toString(), (Number)it_unimi_dsi_fastutil_objects_object2intmap_entry.getIntValue());
        }
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            jsonobject.add(BuiltInRegistries.x.b((StatisticWrapper)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonobject1 = new JsonObject();
        jsonobject1.add("stats", (JsonElement)jsonobject);
        jsonobject1.addProperty("DataVersion", (Number)SharedConstants.b().d().c());
        return jsonobject1.toString();
    }

    private static <T> MinecraftKey b(Statistic<T> stat) {
        return stat.a().a().b(stat.b());
    }

    public void c() {
        this.e.addAll((Collection<Statistic<?>>)this.a.keySet());
    }

    public void a(EntityPlayer player) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (Statistic<?> statistic : this.d()) {
            object2intmap.put(statistic, this.a(statistic));
        }
        player.c.b(new PacketPlayOutStatistic((Object2IntMap<Statistic<?>>)object2intmap));
    }
}

