/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.BaseMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.JavaOps;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ExtraCodecs {
    public static final Codec<JsonElement> a = ExtraCodecs.a(JsonOps.INSTANCE);
    public static final Codec<Object> b = ExtraCodecs.a(JavaOps.a);
    public static final Codec<JsonElement> c = Codec.STRING.flatXmap(json -> {
        try {
            return DataResult.success((Object)JsonParser.parseString((String)json));
        }
        catch (JsonParseException jsonParseException) {
            return DataResult.error(jsonParseException::getMessage);
        }
    }, json -> {
        try {
            return DataResult.success((Object)ChatDeserializer.e(json));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(illegalArgumentException::getMessage);
        }
    });
    public static final Codec<Vector3f> d = Codec.FLOAT.listOf().comapFlatMap(list -> SystemUtils.a(list, 3).map(listx -> new Vector3f(((Float)listx.get(0)).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.get(2)).floatValue())), vec3f -> List.of(Float.valueOf(vec3f.x()), Float.valueOf(vec3f.y()), Float.valueOf(vec3f.z())));
    public static final Codec<Quaternionf> e = Codec.FLOAT.listOf().comapFlatMap(list -> SystemUtils.a(list, 4).map(listx -> new Quaternionf(((Float)listx.get(0)).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.get(2)).floatValue(), ((Float)listx.get(3)).floatValue())), quaternion -> List.of(Float.valueOf(quaternion.x), Float.valueOf(quaternion.y), Float.valueOf(quaternion.z), Float.valueOf(quaternion.w)));
    public static final Codec<AxisAngle4f> f = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("angle").forGetter(axisAngle -> Float.valueOf(axisAngle.angle)), (App)d.fieldOf("axis").forGetter(axisAngle -> new Vector3f(axisAngle.x, axisAngle.y, axisAngle.z))).apply((Applicative)instance, AxisAngle4f::new));
    public static final Codec<Quaternionf> g = ExtraCodecs.e(e, f.xmap(Quaternionf::new, AxisAngle4f::new));
    public static Codec<Matrix4f> h = Codec.FLOAT.listOf().comapFlatMap(list -> SystemUtils.a(list, 16).map(listx -> {
        Matrix4f matrix4f = new Matrix4f();
        for (int i2 = 0; i2 < listx.size(); ++i2) {
            matrix4f.setRowColumn(i2 >> 2, i2 & 3, ((Float)listx.get(i2)).floatValue());
        }
        return matrix4f.determineProperties();
    }), matrix4f -> {
        FloatArrayList floatList = new FloatArrayList(16);
        for (int i2 = 0; i2 < 16; ++i2) {
            floatList.add(matrix4f.getRowColumn(i2 >> 2, i2 & 3));
        }
        return floatList;
    });
    public static final Codec<Integer> i = ExtraCodecs.a(0, Integer.MAX_VALUE, (Integer v2) -> "Value must be non-negative: " + v2);
    public static final Codec<Integer> j = ExtraCodecs.a(1, Integer.MAX_VALUE, (Integer v2) -> "Value must be positive: " + v2);
    public static final Codec<Float> k = ExtraCodecs.a(0.0f, Float.MAX_VALUE, (Float v2) -> "Value must be positive: " + v2);
    public static final Codec<Pattern> l = Codec.STRING.comapFlatMap(pattern -> {
        try {
            return DataResult.success((Object)Pattern.compile(pattern));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return DataResult.error(() -> "Invalid regex pattern '" + pattern + "': " + patternSyntaxException.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> m = ExtraCodecs.a(DateTimeFormatter.ISO_INSTANT).xmap(Instant::from, Function.identity());
    public static final Codec<byte[]> n = Codec.STRING.comapFlatMap(encoded -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)encoded));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, data -> Base64.getEncoder().encodeToString((byte[])data));
    public static final Codec<String> o = Codec.STRING.comapFlatMap(string -> DataResult.success((Object)StringEscapeUtils.unescapeJava((String)string)), StringEscapeUtils::escapeJava);
    public static final Codec<f> p = Codec.STRING.comapFlatMap(tagEntry -> tagEntry.startsWith("#") ? MinecraftKey.b(tagEntry.substring(1)).map(id -> new f((MinecraftKey)id, true)) : MinecraftKey.b(tagEntry).map(id -> new f((MinecraftKey)id, false)), f::c);
    public static final Function<Optional<Long>, OptionalLong> q = optional -> optional.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> r = optionalLong -> optionalLong.isPresent() ? Optional.of(optionalLong.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> s = Codec.LONG_STREAM.xmap(stream -> BitSet.valueOf(stream.toArray()), set -> Arrays.stream(set.toLongArray()));
    private static final Codec<Property> y = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Property::name), (App)Codec.STRING.fieldOf("value").forGetter(Property::value), (App)Codec.STRING.optionalFieldOf("signature").forGetter(property -> Optional.ofNullable(property.signature()))).apply((Applicative)instance, (key, value, signature) -> new Property(key, value, (String)signature.orElse(null))));
    @VisibleForTesting
    public static final Codec<PropertyMap> t = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()), (Codec)y.listOf()).xmap(either -> {
        PropertyMap propertyMap = new PropertyMap();
        either.ifLeft(map -> map.forEach((key, values) -> {
            for (String string : values) {
                propertyMap.put(key, (Object)new Property(key, string));
            }
        })).ifRight(properties -> {
            for (Property property : properties) {
                propertyMap.put((Object)property.name(), (Object)property);
            }
        });
        return propertyMap;
    }, properties -> Either.right(properties.values().stream().toList()));
    private static final MapCodec<GameProfile> z = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.d.fieldOf("id").forGetter(GameProfile::getId), (App)Codec.STRING.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)instance, GameProfile::new));
    public static final Codec<GameProfile> u = RecordCodecBuilder.create(instance -> instance.group((App)z.forGetter(Function.identity()), (App)t.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(GameProfile::getProperties)).apply((Applicative)instance, (profile, properties) -> {
        properties.forEach((key, property) -> profile.getProperties().put(key, property));
        return profile;
    }));
    public static final Codec<String> v = ExtraCodecs.a(Codec.STRING, (T string) -> string.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)string));
    public static final Codec<Integer> w = Codec.STRING.comapFlatMap(string -> {
        int[] is = string.codePoints().toArray();
        if (is.length != 1) {
            return DataResult.error(() -> "Expected one codepoint, got: " + string);
        }
        return DataResult.success((Object)is[0]);
    }, Character::toString);
    public static Codec<String> x = ExtraCodecs.a(Codec.STRING, (T path) -> {
        if (!MinecraftKey.g(path)) {
            return DataResult.error(() -> "Invalid string to use as a resource path element: " + path);
        }
        return DataResult.success((Object)path);
    });

    public static <T> Codec<T> a(DynamicOps<T> ops) {
        return Codec.PASSTHROUGH.xmap(dynamic -> dynamic.convert(ops).getValue(), object -> new Dynamic<Object>(ops, object));
    }

    public static <F, S> Codec<Either<F, S>> a(Codec<F> first, Codec<S> second) {
        return new g<F, S>(first, second);
    }

    public static <P, I> Codec<I> a(Codec<P> codec, String leftFieldName, String rightFieldName, BiFunction<P, P, DataResult<I>> combineFunction, Function<I, P> leftFunction, Function<I, P> rightFunction) {
        Codec codec2 = Codec.list(codec).comapFlatMap(list -> SystemUtils.a(list, 2).flatMap(listx -> {
            Object object = listx.get(0);
            Object object2 = listx.get(1);
            return (DataResult)combineFunction.apply(object, object2);
        }), pair -> ImmutableList.of(leftFunction.apply(pair), rightFunction.apply(pair)));
        Codec codec3 = RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf(leftFieldName).forGetter(Pair::getFirst), (App)codec.fieldOf(rightFieldName).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).comapFlatMap(pair -> (DataResult)combineFunction.apply(pair.getFirst(), pair.getSecond()), pair -> Pair.of(leftFunction.apply(pair), rightFunction.apply(pair)));
        Codec codec4 = ExtraCodecs.e(codec2, codec3);
        return Codec.either(codec, codec4).comapFlatMap(either -> either.map(object -> (DataResult)combineFunction.apply(object, object), DataResult::success), pair -> {
            Object object2;
            Object object = leftFunction.apply(pair);
            if (Objects.equals(object, object2 = rightFunction.apply(pair))) {
                return Either.left(object);
            }
            return Either.right(pair);
        });
    }

    public static <A> Codec.ResultFunction<A> a(final A object) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> dynamicOps, T object2, DataResult<Pair<A, T>> dataResult) {
                MutableObject mutableObject = new MutableObject();
                Optional optional = dataResult.resultOrPartial(arg_0 -> ((MutableObject)mutableObject).setValue(arg_0));
                if (optional.isPresent()) {
                    return dataResult;
                }
                return DataResult.error(() -> "(" + (String)mutableObject.getValue() + " -> using default)", (Object)Pair.of((Object)object, object2));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, A object2, DataResult<T> dataResult) {
                return dataResult;
            }

            @Override
            public String toString() {
                return "OrElsePartial[" + object + "]";
            }
        };
    }

    public static <E> Codec<E> a(ToIntFunction<E> elementToRawId, IntFunction<E> rawIdToElement, int errorRawId) {
        return Codec.INT.flatXmap(rawId -> Optional.ofNullable(rawIdToElement.apply((int)rawId)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + rawId)), element -> {
            int j2 = elementToRawId.applyAsInt(element);
            return j2 == errorRawId ? DataResult.error(() -> "Element with unknown id: " + element) : DataResult.success((Object)j2);
        });
    }

    public static <E> Codec<E> a(Function<E, String> elementToId, Function<String, E> idToElement) {
        return Codec.STRING.flatXmap(id -> Optional.ofNullable(idToElement.apply((String)id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + id)), element -> Optional.ofNullable((String)elementToId.apply(element)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + element)));
    }

    public static <E> Codec<E> b(final Codec<E> uncompressedCodec, final Codec<E> compressedCodec) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E object, DynamicOps<T> dynamicOps, T object2) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.encode(object, dynamicOps, object2);
                }
                return uncompressedCodec.encode(object, dynamicOps, object2);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> dynamicOps, T object) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.decode(dynamicOps, object);
                }
                return uncompressedCodec.decode(dynamicOps, object);
            }

            @Override
            public String toString() {
                return uncompressedCodec + " orCompressed " + compressedCodec;
            }
        };
    }

    public static <E> MapCodec<E> a(final MapCodec<E> uncompressedCodec, final MapCodec<E> compressedCodec) {
        return new MapCodec<E>(){

            public <T> RecordBuilder<T> encode(E object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.encode(object, dynamicOps, recordBuilder);
                }
                return uncompressedCodec.encode(object, dynamicOps, recordBuilder);
            }

            public <T> DataResult<E> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.decode(dynamicOps, mapLike);
                }
                return uncompressedCodec.decode(dynamicOps, mapLike);
            }

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return compressedCodec.keys(dynamicOps);
            }

            public String toString() {
                return uncompressedCodec + " orCompressed " + compressedCodec;
            }
        };
    }

    public static <E> Codec<E> a(Codec<E> originalCodec, final Function<E, Lifecycle> entryLifecycleGetter, final Function<E, Lifecycle> lifecycleGetter) {
        return originalCodec.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> dynamicOps, T object, DataResult<Pair<E, T>> dataResult) {
                return dataResult.result().map(pair -> dataResult.setLifecycle((Lifecycle)entryLifecycleGetter.apply(pair.getFirst()))).orElse(dataResult);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, E object, DataResult<T> dataResult) {
                return dataResult.setLifecycle((Lifecycle)lifecycleGetter.apply(object));
            }

            @Override
            public String toString() {
                return "WithLifecycle[" + entryLifecycleGetter + " " + lifecycleGetter + "]";
            }
        });
    }

    public static <F, S> b<F, S> c(Codec<F> first, Codec<S> second) {
        return new b<F, S>(first, second);
    }

    public static <K, V> e<K, V> d(Codec<K> keyCodec, Codec<V> elementCodec) {
        return new e<K, V>(keyCodec, elementCodec);
    }

    public static <T> Codec<T> a(Codec<T> codec, Function<T, DataResult<T>> validator) {
        if (codec instanceof MapCodec.MapCodecCodec) {
            MapCodec.MapCodecCodec mapCodecCodec = (MapCodec.MapCodecCodec)codec;
            return ExtraCodecs.a(mapCodecCodec.codec(), validator).codec();
        }
        return codec.flatXmap(validator, validator);
    }

    public static <T> MapCodec<T> a(MapCodec<T> codec, Function<T, DataResult<T>> validator) {
        return codec.flatXmap(validator, validator);
    }

    private static Codec<Integer> a(int min, int max, Function<Integer, String> messageFactory) {
        return ExtraCodecs.a(Codec.INT, (T value) -> {
            if (value.compareTo(min) >= 0 && value.compareTo(max) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)messageFactory.apply((Integer)value));
        });
    }

    public static Codec<Integer> a(int min, int max) {
        return ExtraCodecs.a(min, max, (Integer value) -> "Value must be within range [" + min + ";" + max + "]: " + value);
    }

    private static Codec<Float> a(float min, float max, Function<Float, String> messageFactory) {
        return ExtraCodecs.a(Codec.FLOAT, (T value) -> {
            if (value.compareTo(Float.valueOf(min)) > 0 && value.compareTo(Float.valueOf(max)) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)messageFactory.apply((Float)value));
        });
    }

    public static <T> Codec<List<T>> a(Codec<List<T>> originalCodec) {
        return ExtraCodecs.a(originalCodec, (T list) -> list.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)list));
    }

    public static <T> Codec<HolderSet<T>> b(Codec<HolderSet<T>> originalCodec) {
        return ExtraCodecs.a(originalCodec, (T entryList) -> {
            if (entryList.c().right().filter(List::isEmpty).isPresent()) {
                return DataResult.error(() -> "List must have contents");
            }
            return DataResult.success((Object)entryList);
        });
    }

    public static <T> Codec<T> a(String name, Function<Codec<T>, Codec<T>> codecFunction) {
        return new c<T>(name, codecFunction);
    }

    public static <A> Codec<A> a(Supplier<Codec<A>> supplier) {
        return new c(supplier.toString(), codec -> (Codec)supplier.get());
    }

    public static <A> MapCodec<Optional<A>> a(Codec<A> codec, String field) {
        return new d<A>(field, codec);
    }

    public static <A> MapCodec<A> a(Codec<A> codec, String field, A fallback) {
        return ExtraCodecs.a(codec, field).xmap(value -> value.orElse(fallback), value -> Objects.equals(value, fallback) ? Optional.empty() : Optional.of(value));
    }

    public static <E> MapCodec<E> a(Function<DynamicOps<?>, DataResult<E>> retriever) {
        class A
        extends MapCodec<E> {
            final /* synthetic */ Function a;

            A(Function retriever) {
                this.a = retriever;
            }

            public <T> RecordBuilder<T> encode(E object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                return recordBuilder;
            }

            public <T> DataResult<E> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return (DataResult)this.a.apply(dynamicOps);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + this.a + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return Stream.empty();
            }
        }
        return new A(retriever);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> b(Function<E, T> typeGetter) {
        return collection -> {
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                Object object = typeGetter.apply(iterator.next());
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    Object object3 = typeGetter.apply(object2);
                    if (object3 == object) continue;
                    return DataResult.error(() -> "Mixed type list: element " + object2 + " had type " + object3 + ", but list is of type " + object);
                }
            }
            return DataResult.success((Object)collection, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> c(final Codec<A> codec) {
        return Codec.of(codec, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> dynamicOps, T object) {
                try {
                    return codec.decode(dynamicOps, object);
                }
                catch (Exception exception) {
                    return DataResult.error(() -> "Caught exception decoding " + object + ": " + exception.getMessage());
                }
            }
        });
    }

    public static Codec<TemporalAccessor> a(DateTimeFormatter formatter) {
        return Codec.STRING.comapFlatMap(string -> {
            try {
                return DataResult.success((Object)formatter.parse((CharSequence)string));
            }
            catch (Exception exception) {
                return DataResult.error(exception::getMessage);
            }
        }, formatter::format);
    }

    public static MapCodec<OptionalLong> a(MapCodec<Optional<Long>> codec) {
        return codec.xmap(q, r);
    }

    public static Codec<String> b(int minLength, int maxLength) {
        return ExtraCodecs.a(Codec.STRING, (T string) -> {
            int k2 = string.length();
            if (k2 < minLength) {
                return DataResult.error(() -> "String \"" + string + "\" is too short: " + k2 + ", expected range [" + minLength + "-" + maxLength + "]");
            }
            if (k2 > maxLength) {
                return DataResult.error(() -> "String \"" + string + "\" is too long: " + k2 + ", expected range [" + minLength + "-" + maxLength + "]");
            }
            return DataResult.success((Object)string);
        });
    }

    public static <T> Codec<T> e(Codec<T> a2, Codec<? extends T> b2) {
        return Codec.either(a2, b2).xmap(either -> either.map(o2 -> o2, o2 -> o2), Either::left);
    }

    public static <T, U> Codec<T> a(Codec<T> serialized, Codec<U> alternative, Function<U, T> alternativeMapper) {
        return Codec.either(serialized, alternative).xmap(either -> either.map(o2 -> o2, alternativeMapper), Either::left);
    }

    public static <T> Codec<Object2BooleanMap<T>> d(Codec<T> keyCodec) {
        return Codec.unboundedMap(keyCodec, (Codec)Codec.BOOL).xmap(Object2BooleanOpenHashMap::new, Object2ObjectOpenHashMap::new);
    }

    @Deprecated
    public static <K, V> MapCodec<V> a(final String typeKey, final String parametersKey, final Codec<K> typeCodec, final Function<? super V, ? extends K> typeGetter, final Function<? super K, ? extends Codec<? extends V>> parametersCodecGetter) {
        return new MapCodec<V>(){

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return Stream.of(dynamicOps.createString(typeKey), dynamicOps.createString(parametersKey));
            }

            public <T> DataResult<V> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                Object object = mapLike.get(typeKey);
                if (object == null) {
                    return DataResult.error(() -> "Missing \"" + typeKey + "\" in: " + mapLike);
                }
                return typeCodec.decode(dynamicOps, object).flatMap(pair -> {
                    Object object = Objects.requireNonNullElseGet(mapLike.get(parametersKey), () -> ((DynamicOps)dynamicOps).emptyMap());
                    return ((Codec)parametersCodecGetter.apply(pair.getFirst())).decode(dynamicOps, object).map(Pair::getFirst);
                });
            }

            public <T> RecordBuilder<T> encode(V object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                Object object2 = typeGetter.apply(object);
                recordBuilder.add(typeKey, typeCodec.encodeStart(dynamicOps, object2));
                DataResult<T> dataResult = this.a((Codec)parametersCodecGetter.apply(object2), object, dynamicOps);
                if (dataResult.result().isEmpty() || !Objects.equals(dataResult.result().get(), dynamicOps.emptyMap())) {
                    recordBuilder.add(parametersKey, dataResult);
                }
                return recordBuilder;
            }

            private <T, V2 extends V> DataResult<T> a(Codec<V2> codec, V value, DynamicOps<T> ops) {
                return codec.encodeStart(ops, value);
            }
        };
    }

    record g<F, S>(Codec<F> a, Codec<S> b) implements Codec<Either<F, S>>
    {
        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            DataResult dataResult = this.a.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::left));
            DataResult dataResult2 = this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::right));
            Optional optional = dataResult.result();
            Optional optional2 = dataResult2.result();
            if (optional.isPresent() && optional2.isPresent()) {
                return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + optional.get() + " second: " + optional2.get(), (Object)((Pair)optional.get()));
            }
            if (optional.isPresent()) {
                return dataResult;
            }
            if (optional2.isPresent()) {
                return dataResult2;
            }
            return dataResult.apply2((a2, b2) -> b2, dataResult2);
        }

        public <T> DataResult<T> a(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return either.map(left -> this.a.encode(left, dynamicOps, object), right -> this.b.encode(right, dynamicOps, object));
        }

        @Override
        @Override
        public String toString() {
            return "XorCodec[" + this.a + ", " + this.b + "]";
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "first;second", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "first;second", "a", "b"}, this, object);
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Either)object, dynamicOps, object2);
        }
    }

    public static final class b<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> a;
        private final Codec<S> b;

        public b(Codec<F> first, Codec<S> second) {
            this.a = first;
            this.b = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            DataResult dataResult = this.a.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::left));
            if (dataResult.error().isEmpty()) {
                return dataResult;
            }
            DataResult dataResult2 = this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::right));
            if (dataResult2.error().isEmpty()) {
                return dataResult2;
            }
            return dataResult.apply2((pair, pair2) -> pair2, dataResult2);
        }

        public <T> DataResult<T> a(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return either.map(left -> this.a.encode(left, dynamicOps, object), right -> this.b.encode(right, dynamicOps, object));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            b eitherCodec = (b)object;
            return Objects.equals(this.a, eitherCodec.a) && Objects.equals(this.b, eitherCodec.b);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        @Override
        public String toString() {
            return "EitherCodec[" + this.a + ", " + this.b + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Either)object, dynamicOps, object2);
        }
    }

    public static final class e<K, V>
    extends Record
    implements Codec<Map<K, V>>,
    BaseMapCodec<K, V> {
        private final Codec<K> a;
        private final Codec<V> b;

        public e(Codec<K> keyCodec, Codec<V> elementCodec) {
            this.a = keyCodec;
            this.b = elementCodec;
        }

        public <T> DataResult<Map<K, V>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Pair pair : mapLike.entries().toList()) {
                DataResult dataResult2;
                DataResult dataResult = this.keyCodec().parse(dynamicOps, pair.getFirst());
                DataResult dataResult3 = dataResult.apply2stable(Pair::of, dataResult2 = this.elementCodec().parse(dynamicOps, pair.getSecond()));
                if (dataResult3.error().isPresent()) {
                    return DataResult.error(() -> {
                        String string2;
                        DataResult.PartialResult partialResult = (DataResult.PartialResult)dataResult3.error().get();
                        if (dataResult.result().isPresent()) {
                            String string = "Map entry '" + dataResult.result().get() + "' : " + partialResult.message();
                        } else {
                            string2 = partialResult.message();
                        }
                        return string2;
                    });
                }
                if (dataResult3.result().isPresent()) {
                    Pair pair2 = (Pair)dataResult3.result().get();
                    builder.put(pair2.getFirst(), pair2.getSecond());
                    continue;
                }
                return DataResult.error(() -> "Empty or invalid map contents are not allowed");
            }
            ImmutableMap map = builder.build();
            return DataResult.success((Object)map);
        }

        public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            return dynamicOps.getMap(object).setLifecycle(Lifecycle.stable()).flatMap(map -> this.decode(dynamicOps, (Object)map)).map(map -> Pair.of((Object)map, (Object)object));
        }

        public <T> DataResult<T> a(Map<K, V> map, DynamicOps<T> dynamicOps, T object) {
            return this.encode(map, dynamicOps, dynamicOps.mapBuilder()).build(object);
        }

        @Override
        @Override
        public String toString() {
            return "StrictUnboundedMapCodec[" + this.a + " -> " + this.b + "]";
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "keyCodec;elementCodec", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "keyCodec;elementCodec", "a", "b"}, this, object);
        }

        public Codec<K> keyCodec() {
            return this.a;
        }

        public Codec<V> elementCodec() {
            return this.b;
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Map)object, dynamicOps, object2);
        }
    }

    static class c<T>
    implements Codec<T> {
        private final String a;
        private final Supplier<Codec<T>> b;

        c(String name, Function<Codec<T>, Codec<T>> codecFunction) {
            this.a = name;
            this.b = Suppliers.memoize(() -> (Codec)codecFunction.apply(this));
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> dynamicOps, S object) {
            return this.b.get().decode(dynamicOps, object);
        }

        public <S> DataResult<S> encode(T object, DynamicOps<S> dynamicOps, S object2) {
            return this.b.get().encode(object, dynamicOps, object2);
        }

        @Override
        public String toString() {
            return "RecursiveCodec[" + this.a + "]";
        }
    }

    static final class d<A>
    extends MapCodec<Optional<A>> {
        private final String a;
        private final Codec<A> b;

        public d(String field, Codec<A> codec) {
            this.a = field;
            this.b = codec;
        }

        public <T> DataResult<Optional<A>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
            Object object = mapLike.get(this.a);
            if (object == null) {
                return DataResult.success(Optional.empty());
            }
            return this.b.parse(dynamicOps, object).map(Optional::of);
        }

        public <T> RecordBuilder<T> a(Optional<A> optional, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
            if (optional.isPresent()) {
                return recordBuilder.add(this.a, this.b.encodeStart(dynamicOps, optional.get()));
            }
            return recordBuilder;
        }

        public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
            return Stream.of(dynamicOps.createString(this.a));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof d) {
                d strictOptionalFieldCodec = (d)((Object)object);
                return Objects.equals(this.a, strictOptionalFieldCodec.a) && Objects.equals(this.b, strictOptionalFieldCodec.b);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        public String toString() {
            return "StrictOptionalFieldCodec[" + this.a + ": " + this.b + "]";
        }

        public /* synthetic */ RecordBuilder encode(Object object, DynamicOps dynamicOps, RecordBuilder recordBuilder) {
            return this.a((Optional)object, dynamicOps, recordBuilder);
        }
    }

    public record f(MinecraftKey a, boolean b) {
        @Override
        @Override
        public String toString() {
            return this.c();
        }

        private String c() {
            return this.b ? "#" + this.a : this.a.toString();
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "id;tag", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{f.class, "id;tag", "a", "b"}, this, object);
        }
    }
}

