/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class FixProjectileStoredItem
extends DataFix {
    private static final String a = "minecraft:empty";

    public FixProjectileStoredItem(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.x);
        Type type2 = this.getOutputSchema().getType(DataConverterTypes.x);
        return this.fixTypeEverywhereTyped("Fix AbstractArrow item type", type, type2, this.a(this.a("minecraft:trident", FixProjectileStoredItem::c), this.a("minecraft:arrow", FixProjectileStoredItem::a), this.a("minecraft:spectral_arrow", FixProjectileStoredItem::b)));
    }

    @SafeVarargs
    private <T> Function<Typed<?>, Typed<?>> a(Function<Typed<?>, Typed<?>> ... fixAppliers) {
        return typed -> {
            for (Function function : fixAppliers) {
                typed = (Typed)function.apply(typed);
            }
            return typed;
        };
    }

    private Function<Typed<?>, Typed<?>> a(String id, a<?> fixer) {
        Type type = this.getInputSchema().getChoiceType(DataConverterTypes.x, id);
        Type type2 = this.getOutputSchema().getChoiceType(DataConverterTypes.x, id);
        return FixProjectileStoredItem.a(id, fixer, type, type2);
    }

    private static <T> Function<Typed<?>, Typed<?>> a(String id, a<?> fixer, Type<?> inputType, Type<T> outputType) {
        OpticFinder opticFinder = DSL.namedChoice((String)id, inputType);
        a<?> subFixer = fixer;
        return typed2 -> typed2.updateTyped(opticFinder, outputType, typed -> subFixer.fix((Typed<?>)typed, outputType));
    }

    private static <T> Typed<T> a(Typed<?> typed, Type<T> type) {
        return SystemUtils.a(typed, type, data -> data.set("item", FixProjectileStoredItem.a(data, FixProjectileStoredItem.a(data))));
    }

    private static String a(Dynamic<?> arrowData) {
        return arrowData.get("Potion").asString(a).equals(a) ? "minecraft:arrow" : "minecraft:tipped_arrow";
    }

    private static <T> Typed<T> b(Typed<?> typed, Type<T> type) {
        return SystemUtils.a(typed, type, data -> data.set("item", FixProjectileStoredItem.a(data, "minecraft:spectral_arrow")));
    }

    private static Dynamic<?> a(Dynamic<?> projectileData, String id) {
        return projectileData.createMap((Map)ImmutableMap.of((Object)((Object)projectileData.createString("id")), (Object)((Object)projectileData.createString(id)), (Object)((Object)projectileData.createString("Count")), (Object)((Object)projectileData.createInt(1))));
    }

    private static <T> Typed<T> c(Typed<?> typed, Type<T> type) {
        return new Typed(type, typed.getOps(), typed.getValue());
    }

    static interface a<F> {
        public Typed<F> fix(Typed<?> var1, Type<F> var2);
    }
}

