/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class MobEffectIdFix
extends DataFix {
    private static final Int2ObjectMap<String> a = (Int2ObjectMap)SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T idMap) -> {
        idMap.put(1, (Object)"minecraft:speed");
        idMap.put(2, (Object)"minecraft:slowness");
        idMap.put(3, (Object)"minecraft:haste");
        idMap.put(4, (Object)"minecraft:mining_fatigue");
        idMap.put(5, (Object)"minecraft:strength");
        idMap.put(6, (Object)"minecraft:instant_health");
        idMap.put(7, (Object)"minecraft:instant_damage");
        idMap.put(8, (Object)"minecraft:jump_boost");
        idMap.put(9, (Object)"minecraft:nausea");
        idMap.put(10, (Object)"minecraft:regeneration");
        idMap.put(11, (Object)"minecraft:resistance");
        idMap.put(12, (Object)"minecraft:fire_resistance");
        idMap.put(13, (Object)"minecraft:water_breathing");
        idMap.put(14, (Object)"minecraft:invisibility");
        idMap.put(15, (Object)"minecraft:blindness");
        idMap.put(16, (Object)"minecraft:night_vision");
        idMap.put(17, (Object)"minecraft:hunger");
        idMap.put(18, (Object)"minecraft:weakness");
        idMap.put(19, (Object)"minecraft:poison");
        idMap.put(20, (Object)"minecraft:wither");
        idMap.put(21, (Object)"minecraft:health_boost");
        idMap.put(22, (Object)"minecraft:absorption");
        idMap.put(23, (Object)"minecraft:saturation");
        idMap.put(24, (Object)"minecraft:glowing");
        idMap.put(25, (Object)"minecraft:levitation");
        idMap.put(26, (Object)"minecraft:luck");
        idMap.put(27, (Object)"minecraft:unluck");
        idMap.put(28, (Object)"minecraft:slow_falling");
        idMap.put(29, (Object)"minecraft:conduit_power");
        idMap.put(30, (Object)"minecraft:dolphins_grace");
        idMap.put(31, (Object)"minecraft:bad_omen");
        idMap.put(32, (Object)"minecraft:hero_of_the_village");
        idMap.put(33, (Object)"minecraft:darkness");
    });
    private static final Set<String> b = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public MobEffectIdFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    private static <T> Optional<Dynamic<T>> a(Dynamic<T> dynamic, String idKey) {
        return dynamic.get(idKey).asNumber().result().map(oldId -> (String)a.get(oldId.intValue())).map(arg_0 -> dynamic.createString(arg_0));
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic, String key, Optional<Dynamic<T>> value) {
        if (value.isEmpty()) {
            return dynamic;
        }
        return dynamic.set(key, value.get());
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic, String oldKey, String newKey, Optional<Dynamic<T>> value) {
        return MobEffectIdFix.a(dynamic.remove(oldKey), newKey, value);
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic, String oldKey, String newKey) {
        return MobEffectIdFix.a(dynamic.remove(oldKey), newKey, dynamic.get(oldKey).result());
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic, String oldKey, Dynamic<T> dynamic2, String newKey) {
        Optional<Dynamic<T>> optional = MobEffectIdFix.a(dynamic, oldKey);
        return MobEffectIdFix.a(dynamic2, oldKey, newKey, optional);
    }

    private static <T> Dynamic<T> b(Dynamic<T> dynamic, String oldKey, String newKey) {
        return MobEffectIdFix.a(dynamic, oldKey, dynamic, newKey);
    }

    private static <T> Dynamic<T> a(Dynamic<T> effectDynamic) {
        effectDynamic = MobEffectIdFix.b(effectDynamic, "Id", "id");
        effectDynamic = MobEffectIdFix.a(effectDynamic, "Ambient", "ambient");
        effectDynamic = MobEffectIdFix.a(effectDynamic, "Amplifier", "amplifier");
        effectDynamic = MobEffectIdFix.a(effectDynamic, "Duration", "duration");
        effectDynamic = MobEffectIdFix.a(effectDynamic, "ShowParticles", "show_particles");
        effectDynamic = MobEffectIdFix.a(effectDynamic, "ShowIcon", "show_icon");
        effectDynamic = MobEffectIdFix.a(effectDynamic, "FactorCalculationData", "factor_calculation_data");
        Optional<Dynamic<T>> optional = effectDynamic.get("HiddenEffect").result().map(MobEffectIdFix::a);
        return MobEffectIdFix.a(effectDynamic, "HiddenEffect", "hidden_effect", optional);
    }

    private static <T> Dynamic<T> c(Dynamic<T> dynamic, String oldEffectListKey, String newEffectListKey) {
        Optional<Dynamic<T>> optional = dynamic.get(oldEffectListKey).asStreamOpt().result().map(stream -> dynamic.createList(stream.map(MobEffectIdFix::a)));
        return MobEffectIdFix.a(dynamic, oldEffectListKey, newEffectListKey, optional);
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic, Dynamic<T> dynamic2) {
        dynamic2 = MobEffectIdFix.a(dynamic, "EffectId", dynamic2, "id");
        Optional optional = dynamic.get("EffectDuration").result();
        return MobEffectIdFix.a(dynamic2, "EffectDuration", "duration", optional);
    }

    private static <T> Dynamic<T> b(Dynamic<T> dynamic) {
        return MobEffectIdFix.a(dynamic, dynamic);
    }

    private Typed<?> a(Typed<?> typed2, DSL.TypeReference typeReference, String string, Function<Dynamic<?>, Dynamic<?>> function) {
        Type type = this.getInputSchema().getChoiceType(typeReference, string);
        Type type2 = this.getOutputSchema().getChoiceType(typeReference, string);
        return typed2.updateTyped(DSL.namedChoice((String)string, (Type)type), type2, typed -> typed.update(DSL.remainderFinder(), function));
    }

    private TypeRewriteRule a() {
        Type type = this.getInputSchema().getType(DataConverterTypes.s);
        return this.fixTypeEverywhereTyped("BlockEntityMobEffectIdFix", type, typed -> {
            typed = this.a((Typed<?>)typed, DataConverterTypes.s, "minecraft:beacon", dynamic -> {
                dynamic = MobEffectIdFix.b(dynamic, "Primary", "primary_effect");
                return MobEffectIdFix.b(dynamic, "Secondary", "secondary_effect");
            });
            return typed;
        });
    }

    private static <T> Dynamic<T> c(Dynamic<T> dynamic) {
        Dynamic dynamic2 = dynamic.emptyMap();
        Dynamic<T> dynamic3 = MobEffectIdFix.a(dynamic, dynamic2);
        if (!dynamic3.equals((Object)dynamic2)) {
            dynamic = dynamic.set("stew_effects", dynamic.createList(Stream.of(dynamic3)));
        }
        return dynamic.remove("EffectId").remove("EffectDuration");
    }

    private static <T> Dynamic<T> d(Dynamic<T> dynamic) {
        return MobEffectIdFix.c(dynamic, "CustomPotionEffects", "custom_potion_effects");
    }

    private static <T> Dynamic<T> e(Dynamic<T> dynamic) {
        return MobEffectIdFix.c(dynamic, "Effects", "effects");
    }

    private static Dynamic<?> f(Dynamic<?> dynamic) {
        return MobEffectIdFix.c(dynamic, "ActiveEffects", "active_effects");
    }

    private TypeRewriteRule b() {
        Type type = this.getInputSchema().getType(DataConverterTypes.x);
        return this.fixTypeEverywhereTyped("EntityMobEffectIdFix", type, typed -> {
            typed = this.a((Typed<?>)typed, DataConverterTypes.x, "minecraft:mooshroom", MobEffectIdFix::c);
            typed = this.a((Typed<?>)typed, DataConverterTypes.x, "minecraft:arrow", MobEffectIdFix::d);
            typed = this.a((Typed<?>)typed, DataConverterTypes.x, "minecraft:area_effect_cloud", MobEffectIdFix::e);
            typed = typed.update(DSL.remainderFinder(), MobEffectIdFix::f);
            return typed;
        });
    }

    private TypeRewriteRule c() {
        Type type = this.getInputSchema().getType(DataConverterTypes.b);
        return this.fixTypeEverywhereTyped("PlayerMobEffectIdFix", type, typed -> typed.update(DSL.remainderFinder(), MobEffectIdFix::f));
    }

    private static <T> Dynamic<T> g(Dynamic<T> dynamic) {
        Optional<Dynamic<T>> optional = dynamic.get("Effects").asStreamOpt().result().map(stream -> dynamic.createList(stream.map(MobEffectIdFix::b)));
        return MobEffectIdFix.a(dynamic, "Effects", "effects", optional);
    }

    private TypeRewriteRule d() {
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.z.typeName(), DataConverterSchemaNamed.a()));
        Type type = this.getInputSchema().getType(DataConverterTypes.t);
        OpticFinder opticFinder2 = type.findField("tag");
        return this.fixTypeEverywhereTyped("ItemStackMobEffectIdFix", type, typed2 -> {
            Optional optional = typed2.getOptional(opticFinder);
            if (optional.isPresent()) {
                String string = (String)((Pair)optional.get()).getSecond();
                if (string.equals("minecraft:suspicious_stew")) {
                    return typed2.updateTyped(opticFinder2, typed -> typed.update(DSL.remainderFinder(), MobEffectIdFix::g));
                }
                if (b.contains(string)) {
                    return typed2.updateTyped(opticFinder2, typed -> typed.update(DSL.remainderFinder(), dynamic -> MobEffectIdFix.c(dynamic, "CustomPotionEffects", "custom_potion_effects")));
                }
            }
            return typed2;
        });
    }

    protected TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.a(), (TypeRewriteRule[])new TypeRewriteRule[]{this.b(), this.c(), this.d()});
    }
}

