/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.monitoring.jmx;

import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public final class MinecraftServerBeans
implements DynamicMBean {
    private static final Logger a = LogUtils.getLogger();
    private final MinecraftServer b;
    private final MBeanInfo c;
    private final Map<String, a> d = Stream.of(new a("tickTimes", this::b, "Historical tick times (ms)", long[].class), new a("averageTickTime", this::a, "Current average tick time (ms)", Long.TYPE)).collect(Collectors.toMap(entry -> entry.a, Function.identity()));

    private MinecraftServerBeans(MinecraftServer server) {
        this.b = server;
        MBeanAttributeInfo[] mBeanAttributeInfos = (MBeanAttributeInfo[])this.d.values().stream().map(a::a).toArray(MBeanAttributeInfo[]::new);
        this.c = new MBeanInfo(MinecraftServerBeans.class.getSimpleName(), "metrics for dedicated server", mBeanAttributeInfos, null, null, new MBeanNotificationInfo[0]);
    }

    public static void a(MinecraftServer server) {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new MinecraftServerBeans(server), new ObjectName("net.minecraft.server:type=Server"));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException jMException) {
            a.warn("Failed to initialise server as JMX bean", (Throwable)jMException);
        }
    }

    private float a() {
        return this.b.aN();
    }

    private long[] b() {
        return this.b.aQ();
    }

    @Override
    @Nullable
    @Override
    public Object getAttribute(String string) {
        a attributeDescription = this.d.get(string);
        return attributeDescription == null ? null : attributeDescription.b.get();
    }

    @Override
    @Override
    public void setAttribute(Attribute attribute) {
    }

    @Override
    @Override
    public AttributeList getAttributes(String[] strings) {
        List<Attribute> list = Arrays.stream(strings).map(this.d::get).filter(Objects::nonNull).map(entry -> new Attribute(entry.a, entry.b.get())).collect(Collectors.toList());
        return new AttributeList(list);
    }

    @Override
    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        return new AttributeList();
    }

    @Override
    @Nullable
    @Override
    public Object invoke(String string, Object[] objects, String[] strings) {
        return null;
    }

    @Override
    @Override
    public MBeanInfo getMBeanInfo() {
        return this.c;
    }

    static final class a {
        final String a;
        final Supplier<Object> b;
        private final String c;
        private final Class<?> d;

        a(String name, Supplier<Object> getter, String description, Class<?> type) {
            this.a = name;
            this.b = getter;
            this.c = description;
            this.d = type;
        }

        private MBeanAttributeInfo a() {
            return new MBeanAttributeInfo(this.a, this.d.getSimpleName(), this.c, true, false, false);
        }
    }
}

