/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.util.profiling.metrics.MetricCategory;

public class MetricSampler {
    private final String b;
    private final MetricCategory c;
    private final DoubleSupplier d;
    private final ByteBuf e;
    private final ByteBuf f;
    private volatile boolean g;
    @Nullable
    private final Runnable h;
    @Nullable
    final c a;
    private double i;

    protected MetricSampler(String name, MetricCategory type, DoubleSupplier retriever, @Nullable Runnable startAction, @Nullable c deviationChecker) {
        this.b = name;
        this.c = type;
        this.h = startAction;
        this.d = retriever;
        this.a = deviationChecker;
        this.f = ByteBufAllocator.DEFAULT.buffer();
        this.e = ByteBufAllocator.DEFAULT.buffer();
        this.g = true;
    }

    public static MetricSampler a(String name, MetricCategory type, DoubleSupplier retriever) {
        return new MetricSampler(name, type, retriever, null, null);
    }

    public static <T> MetricSampler a(String name, MetricCategory type, T context, ToDoubleFunction<T> retriever) {
        return MetricSampler.a(name, type, retriever, context).a();
    }

    public static <T> a<T> a(String name, MetricCategory type, ToDoubleFunction<T> retriever, T context) {
        return new a<T>(name, type, retriever, context);
    }

    public void a() {
        if (!this.g) {
            throw new IllegalStateException("Not running");
        }
        if (this.h != null) {
            this.h.run();
        }
    }

    public void a(int tick) {
        this.h();
        this.i = this.d.getAsDouble();
        this.f.writeDouble(this.i);
        this.e.writeInt(tick);
    }

    public void b() {
        this.h();
        this.f.release();
        this.e.release();
        this.g = false;
    }

    private void h() {
        if (!this.g) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Sampler for metric %s not started!", this.b));
        }
    }

    DoubleSupplier c() {
        return this.d;
    }

    public String d() {
        return this.b;
    }

    public MetricCategory e() {
        return this.c;
    }

    public b f() {
        Int2DoubleOpenHashMap int2DoubleMap = new Int2DoubleOpenHashMap();
        int i2 = Integer.MIN_VALUE;
        int j2 = Integer.MIN_VALUE;
        while (this.f.isReadable(8)) {
            int k2 = this.e.readInt();
            if (i2 == Integer.MIN_VALUE) {
                i2 = k2;
            }
            int2DoubleMap.put(k2, this.f.readDouble());
            j2 = k2;
        }
        return new b(i2, j2, (Int2DoubleMap)int2DoubleMap);
    }

    public boolean g() {
        return this.a != null && this.a.test(this.i);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MetricSampler metricSampler = (MetricSampler)object;
        return this.b.equals(metricSampler.b) && this.c.equals((Object)metricSampler.c);
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    public static interface c {
        public boolean test(double var1);
    }

    public static class a<T> {
        private final String a;
        private final MetricCategory b;
        private final DoubleSupplier c;
        private final T d;
        @Nullable
        private Runnable e;
        @Nullable
        private c f;

        public a(String name, MetricCategory type, ToDoubleFunction<T> timeFunction, T context) {
            this.a = name;
            this.b = type;
            this.c = () -> timeFunction.applyAsDouble(context);
            this.d = context;
        }

        public a<T> a(Consumer<T> action) {
            this.e = () -> action.accept(this.d);
            return this;
        }

        public a<T> a(c deviationChecker) {
            this.f = deviationChecker;
            return this;
        }

        public MetricSampler a() {
            return new MetricSampler(this.a, this.b, this.c, this.e, this.f);
        }
    }

    public static class b {
        private final Int2DoubleMap a;
        private final int b;
        private final int c;

        public b(int startTick, int endTick, Int2DoubleMap values) {
            this.b = startTick;
            this.c = endTick;
            this.a = values;
        }

        public double a(int tick) {
            return this.a.get(tick);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }
    }

    public static class d
    implements c {
        private final float a;
        private double b = Double.MIN_VALUE;

        public d(float threshold) {
            this.a = threshold;
        }

        @Override
        @Override
        public boolean test(double value) {
            boolean bl2;
            if (this.b == Double.MIN_VALUE || value <= this.b) {
                boolean bl = false;
            } else {
                bl2 = (value - this.b) / this.b >= (double)this.a;
            }
            this.b = value;
            return bl2;
        }
    }
}

