/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class RandomSequences
extends PersistentBase {
    private static final Logger a = LogUtils.getLogger();
    private final long b;
    private int c;
    private boolean d = true;
    private boolean e = true;
    private final Map<MinecraftKey, RandomSequence> f = new Object2ObjectOpenHashMap();

    public static PersistentBase.a<RandomSequences> a(long seed) {
        return new PersistentBase.a<RandomSequences>(() -> new RandomSequences(seed), nbt -> RandomSequences.a(seed, nbt), DataFixTypes.m);
    }

    public RandomSequences(long seed) {
        this.b = seed;
    }

    public RandomSource a(MinecraftKey id) {
        RandomSource randomSource = this.f.computeIfAbsent(id, this::c).a();
        return new a(randomSource);
    }

    private RandomSequence c(MinecraftKey id) {
        return this.b(id, this.c, this.d, this.e);
    }

    private RandomSequence b(MinecraftKey id, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        long l2 = (includeWorldSeed ? this.b : 0L) ^ (long)salt;
        return new RandomSequence(l2, includeSequenceId ? Optional.of(id) : Optional.empty());
    }

    public void a(BiConsumer<MinecraftKey, RandomSequence> consumer) {
        this.f.forEach(consumer);
    }

    public void a(int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        this.c = salt;
        this.d = includeWorldSeed;
        this.e = includeSequenceId;
    }

    @Override
    @Override
    public NBTTagCompound a(NBTTagCompound nbt) {
        nbt.a("salt", this.c);
        nbt.a("include_world_seed", this.d);
        nbt.a("include_sequence_id", this.e);
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.f.forEach((id, sequence) -> compoundTag.a(id.toString(), (NBTBase)RandomSequence.a.encodeStart((DynamicOps)DynamicOpsNBT.a, sequence).result().orElseThrow()));
        nbt.a("sequences", compoundTag);
        return nbt;
    }

    private static boolean a(NBTTagCompound nbt, String key, boolean fallback) {
        if (nbt.b(key, 1)) {
            return nbt.q(key);
        }
        return fallback;
    }

    public static RandomSequences a(long seed, NBTTagCompound nbt) {
        RandomSequences randomSequences = new RandomSequences(seed);
        randomSequences.a(nbt.h("salt"), RandomSequences.a(nbt, "include_world_seed", true), RandomSequences.a(nbt, "include_sequence_id", true));
        NBTTagCompound compoundTag = nbt.p("sequences");
        Set<String> set = compoundTag.e();
        for (String string : set) {
            try {
                RandomSequence randomSequence = (RandomSequence)((Pair)RandomSequence.a.decode((DynamicOps)DynamicOpsNBT.a, (Object)compoundTag.c(string)).result().get()).getFirst();
                randomSequences.f.put(new MinecraftKey(string), randomSequence);
            }
            catch (Exception exception) {
                a.error("Failed to load random sequence {}", (Object)string, (Object)exception);
            }
        }
        return randomSequences;
    }

    public int a() {
        int i2 = this.f.size();
        this.f.clear();
        return i2;
    }

    public void b(MinecraftKey id) {
        this.f.put(id, this.c(id));
    }

    public void a(MinecraftKey id, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        this.f.put(id, this.b(id, salt, includeWorldSeed, includeSequenceId));
    }

    class a
    implements RandomSource {
        private final RandomSource c;

        a(RandomSource random) {
            this.c = random;
        }

        @Override
        @Override
        public RandomSource d() {
            RandomSequences.this.c();
            return this.c.d();
        }

        @Override
        @Override
        public PositionalRandomFactory e() {
            RandomSequences.this.c();
            return this.c.e();
        }

        @Override
        @Override
        public void b(long seed) {
            RandomSequences.this.c();
            this.c.b(seed);
        }

        @Override
        @Override
        public int f() {
            RandomSequences.this.c();
            return this.c.f();
        }

        @Override
        @Override
        public int a(int bound) {
            RandomSequences.this.c();
            return this.c.a(bound);
        }

        @Override
        @Override
        public long g() {
            RandomSequences.this.c();
            return this.c.g();
        }

        @Override
        @Override
        public boolean h() {
            RandomSequences.this.c();
            return this.c.h();
        }

        @Override
        @Override
        public float i() {
            RandomSequences.this.c();
            return this.c.i();
        }

        @Override
        @Override
        public double j() {
            RandomSequences.this.c();
            return this.c.j();
        }

        @Override
        @Override
        public double k() {
            RandomSequences.this.c();
            return this.c.k();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof a) {
                a dirtyMarkingRandomSource = (a)object;
                return this.c.equals(dirtyMarkingRandomSource.c);
            }
            return false;
        }
    }
}

