/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger d = LogUtils.getLogger();
    private static final int e = 5;
    private static final DataWatcherObject<Float> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> i = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float j = 32.0f;
    private static final float k = 0.5f;
    private static final float l = 3.0f;
    public static final float b = 6.0f;
    public static final float c = 0.5f;
    private static final String m = "effects";
    public PotionRegistry n = Potions.b;
    public List<MobEffect> o = Lists.newArrayList();
    private final Map<Entity, Integer> p = Maps.newHashMap();
    private int q = 600;
    public int r = 20;
    public int s = 20;
    private boolean t;
    public int u;
    public float v;
    public float aE;
    @Nullable
    private EntityLiving aF;
    @Nullable
    public UUID aG;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> type, World world) {
        super(type, world);
        this.af = true;
    }

    public EntityAreaEffectCloud(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.c, world);
        this.a_(x2, y2, z2);
    }

    @Override
    protected void c_() {
        this.an().a(g, 0);
        this.an().a(f, Float.valueOf(3.0f));
        this.an().a(h, false);
        this.an().a(i, Particles.v);
    }

    public void a(float radius) {
        if (!this.dM().B) {
            this.an().b(f, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void k_() {
        double d0 = this.dr();
        double d1 = this.dt();
        double d2 = this.dx();
        super.k_();
        this.a_(d0, d1, d2);
    }

    public float h() {
        return this.an().b(f).floatValue();
    }

    public void a(PotionRegistry potion) {
        this.n = potion;
        if (!this.t) {
            this.x();
        }
    }

    public void x() {
        if (this.n == Potions.b && this.o.isEmpty()) {
            this.an().b(g, 0);
        } else {
            this.an().b(g, PotionUtil.a(PotionUtil.a(this.n, this.o)));
        }
    }

    public void a(MobEffect effect) {
        this.o.add(effect);
        if (!this.t) {
            this.x();
        }
    }

    public int i() {
        return this.an().b(g);
    }

    public void a(int rgb) {
        this.t = true;
        this.an().b(g, rgb);
    }

    public ParticleParam j() {
        return this.an().b(i);
    }

    public void a(ParticleParam particle) {
        this.an().b(i, particle);
    }

    protected void a(boolean waiting) {
        this.an().b(h, waiting);
    }

    public boolean k() {
        return this.an().b(h);
    }

    public int m() {
        return this.q;
    }

    public void b(int duration) {
        this.q = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.ah >= this.r + this.q) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void l() {
        block22: {
            ArrayList list;
            float f2;
            block23: {
                boolean flag1;
                boolean flag;
                block21: {
                    float f1;
                    int i2;
                    super.l();
                    flag = this.k();
                    f2 = this.h();
                    if (!this.dM().B) break block21;
                    if (flag && this.ag.h()) {
                        return;
                    }
                    ParticleParam particleparam = this.j();
                    if (flag) {
                        i2 = 2;
                        f1 = 0.2f;
                    } else {
                        i2 = MathHelper.f((float)Math.PI * f2 * f2);
                        f1 = f2;
                    }
                    for (int j2 = 0; j2 < i2; ++j2) {
                        double d5;
                        double d4;
                        double d3;
                        float f22 = this.ag.i() * ((float)Math.PI * 2);
                        float f3 = MathHelper.c(this.ag.i()) * f1;
                        double d0 = this.dr() + (double)(MathHelper.b(f22) * f3);
                        double d1 = this.dt();
                        double d2 = this.dx() + (double)(MathHelper.a(f22) * f3);
                        if (particleparam.b() == Particles.v) {
                            int k2 = flag && this.ag.h() ? 0xFFFFFF : this.i();
                            d3 = (float)(k2 >> 16 & 0xFF) / 255.0f;
                            d4 = (float)(k2 >> 8 & 0xFF) / 255.0f;
                            d5 = (float)(k2 & 0xFF) / 255.0f;
                        } else if (flag) {
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        } else {
                            d3 = (0.5 - this.ag.j()) * 0.15;
                            d4 = 0.01f;
                            d5 = (0.5 - this.ag.j()) * 0.15;
                        }
                        this.dM().b(particleparam, d0, d1, d2, d3, d4, d5);
                    }
                    break block22;
                }
                if (this.ah >= this.r + this.q) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
                boolean bl = flag1 = this.ah < this.r;
                if (flag != flag1) {
                    this.a(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.aE != 0.0f) {
                    if ((f2 += this.aE) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(f2);
                }
                if (this.ah % 5 != 0) break block22;
                this.p.entrySet().removeIf(entry -> this.ah >= (Integer)entry.getValue());
                list = Lists.newArrayList();
                for (MobEffect mobeffect : this.n.a()) {
                    list.add(new MobEffect(mobeffect.c(), mobeffect.a(l2 -> l2 / 4), mobeffect.e(), mobeffect.f(), mobeffect.g()));
                }
                list.addAll(this.o);
                if (!list.isEmpty()) break block23;
                this.p.clear();
                break block22;
            }
            List<EntityLiving> list1 = this.dM().a(EntityLiving.class, this.cH());
            if (list1.isEmpty()) break block22;
            Iterator<EntityLiving> iterator1 = list1.iterator();
            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
            while (iterator1.hasNext()) {
                double d7;
                double d6;
                double d8;
                EntityLiving entityliving = iterator1.next();
                if (this.p.containsKey(entityliving) || !entityliving.fy() || !((d8 = (d6 = entityliving.dr() - this.dr()) * d6 + (d7 = entityliving.dx() - this.dx()) * d7) <= (double)(f2 * f2))) continue;
                entities.add((LivingEntity)entityliving.getBukkitEntity());
            }
            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
            if (!event.isCancelled()) {
                for (LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof CraftLivingEntity)) continue;
                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                    this.p.put(entityliving, this.ah + this.s);
                    for (MobEffect mobeffect1 : list) {
                        if (mobeffect1.c().a()) {
                            mobeffect1.c().a(this, this.s(), entityliving, mobeffect1.e(), 0.5);
                            continue;
                        }
                        entityliving.addEffect(new MobEffect(mobeffect1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                    }
                    if (this.v != 0.0f) {
                        if ((f2 += this.v) < 0.5f) {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            return;
                        }
                        this.a(f2);
                    }
                    if (this.u == 0) continue;
                    this.q += this.u;
                    if (this.q > 0) continue;
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            }
        }
    }

    public float o() {
        return this.v;
    }

    public void b(float radiusOnUse) {
        this.v = radiusOnUse;
    }

    public float p() {
        return this.aE;
    }

    public void c(float radiusGrowth) {
        this.aE = radiusGrowth;
    }

    public int q() {
        return this.u;
    }

    public void c(int durationOnUse) {
        this.u = durationOnUse;
    }

    public int r() {
        return this.r;
    }

    public void d(int waitTime) {
        this.r = waitTime;
    }

    public void a(@Nullable EntityLiving owner) {
        this.aF = owner;
        this.aG = owner == null ? null : owner.cw();
    }

    @Nullable
    public EntityLiving s() {
        Entity entity;
        if (this.aF == null && this.aG != null && this.dM() instanceof WorldServer && (entity = ((WorldServer)this.dM()).a(this.aG)) instanceof EntityLiving) {
            this.aF = (EntityLiving)entity;
        }
        return this.aF;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.ah = nbt.h("Age");
        this.q = nbt.h("Duration");
        this.r = nbt.h("WaitTime");
        this.s = nbt.h("ReapplicationDelay");
        this.u = nbt.h("DurationOnUse");
        this.v = nbt.j("RadiusOnUse");
        this.aE = nbt.j("RadiusPerTick");
        this.a(nbt.j("Radius"));
        if (nbt.b("Owner")) {
            this.aG = nbt.a("Owner");
        }
        if (nbt.b("Particle", 8)) {
            try {
                this.a(ArgumentParticle.a(new StringReader(nbt.l("Particle")), BuiltInRegistries.j.p()));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                d.warn("Couldn't load custom particle {}", (Object)nbt.l("Particle"), (Object)commandsyntaxexception);
            }
        }
        if (nbt.b("Color", 99)) {
            this.a(nbt.h("Color"));
        }
        if (nbt.b("Potion", 8)) {
            this.a(PotionUtil.c(nbt));
        }
        if (nbt.b(m, 9)) {
            NBTTagList nbttaglist = nbt.c(m, 10);
            this.o.clear();
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                MobEffect mobeffect = MobEffect.b(nbttaglist.a(i2));
                if (mobeffect == null) continue;
                this.a(mobeffect);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Age", this.ah);
        nbt.a("Duration", this.q);
        nbt.a("WaitTime", this.r);
        nbt.a("ReapplicationDelay", this.s);
        nbt.a("DurationOnUse", this.u);
        nbt.a("RadiusOnUse", this.v);
        nbt.a("RadiusPerTick", this.aE);
        nbt.a("Radius", this.h());
        nbt.a("Particle", this.j().a());
        if (this.aG != null) {
            nbt.a("Owner", this.aG);
        }
        if (this.t) {
            nbt.a("Color", this.i());
        }
        if (this.n != Potions.b) {
            nbt.a("Potion", BuiltInRegistries.i.b(this.n).toString());
        }
        if (!this.o.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.o) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbt.a(m, nbttaglist);
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (f.equals(data)) {
            this.k_();
        }
        super.a(data);
    }

    public PotionRegistry u() {
        return this.n;
    }

    @Override
    public EnumPistonReaction s_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.h() * 2.0f, 0.5f);
    }
}

