/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.papermc.paper.event.player.PlayerShieldDisableEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import top.leavesmc.leaves.LeavesConfig;

public abstract class EntityInsentient
extends EntityLiving
implements Targeting {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int c = 1;
    private static final int d = 2;
    private static final int e = 4;
    protected static final int f = 1;
    private static final BaseBlockPosition bS = new BaseBlockPosition(1, 0, 1);
    public static final float bA = 0.15f;
    public static final float bB = 0.55f;
    public static final float bC = 0.5f;
    public static final float bD = 0.25f;
    public static final String bE = "Leash";
    public static final float bF = 0.085f;
    public static final int bG = 2;
    public static final int bH = 2;
    private static final double bT = Math.sqrt(2.04f) - (double)0.6f;
    public int bI;
    protected int bJ;
    protected ControllerLook bK;
    protected ControllerMove bL;
    protected ControllerJump bM;
    private final EntityAIBodyControl bU;
    protected NavigationAbstract bN;
    public PathfinderGoalSelector bO;
    @Nullable
    public PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector bP;
    @Nullable
    private EntityLiving bV;
    private final EntitySenses bW;
    private final NonNullList<ItemStack> bX = NonNullList.a(2, ItemStack.f);
    public final float[] bQ = new float[2];
    private final NonNullList<ItemStack> bY = NonNullList.a(4, ItemStack.f);
    public final float[] bR = new float[4];
    private boolean bZ;
    private boolean ca;
    private final Map<PathType, Float> cb = Maps.newEnumMap(PathType.class);
    @Nullable
    public MinecraftKey cc;
    public long cd;
    @Nullable
    private Entity ce;
    private int cf;
    @Nullable
    public NBTTagCompound cg;
    private BlockPosition ch = BlockPosition.b;
    private float ci = -1.0f;
    public boolean aware = true;
    int inactiveTickDisableCounter = 0;
    private BlockPosition cached_eye_blockpos;
    private int cached_position_hashcode;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        this.bO = new PathfinderGoalSelector(world.ag());
        this.bP = new PathfinderGoalSelector(world.ag());
        this.bK = new ControllerLook(this);
        this.bL = new ControllerMove(this);
        this.bM = new ControllerJump(this);
        this.bU = this.H();
        this.bN = this.b(world);
        this.bW = new EntitySenses(this);
        Arrays.fill(this.bR, 0.085f);
        Arrays.fill(this.bQ, 0.085f);
        if (world != null && !world.B) {
            this.B();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.ca = persistenceRequired;
    }

    protected void B() {
    }

    public static AttributeProvider.Builder C() {
        return EntityLiving.dQ().a(GenericAttributes.g, 16.0).a(GenericAttributes.d);
    }

    protected NavigationAbstract b(World world) {
        return new Navigation(this, world);
    }

    protected boolean D() {
        return false;
    }

    public float a(PathType nodeType) {
        EntityInsentient entityinsentient1;
        Entity entity = this.da();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).D() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.cb.get((Object)nodeType);
        return ofloat == null ? nodeType.a() : ofloat.floatValue();
    }

    public void a(PathType nodeType, float penalty) {
        this.cb.put(nodeType, Float.valueOf(penalty));
    }

    public void E() {
    }

    public void G() {
    }

    protected EntityAIBodyControl H() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook I() {
        return this.bK;
    }

    @Override
    public void inactiveTick() {
        boolean isThrottled;
        super.inactiveTick();
        boolean bl = isThrottled = LeavesConfig.throttleInactiveGoalSelectorTick && this.inactiveTickDisableCounter++ % 20 != 0;
        if (this.bO.inactiveTick() && !isThrottled) {
            this.bO.a();
        }
        if (this.bP.inactiveTick()) {
            this.bP.a();
        }
    }

    public ControllerMove K() {
        Entity entity = this.da();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.K();
        }
        return this.bL;
    }

    public ControllerJump M() {
        return this.bM;
    }

    public NavigationAbstract N() {
        Entity entity = this.da();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.N();
        }
        return this.bN;
    }

    @Override
    @Nullable
    public EntityLiving cN() {
        Entity entity = this.cQ();
        if (!this.fU() && entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient1 = (EntityInsentient)entity;
            if (entity.bR()) {
                EntityInsentient entityinsentient = entityinsentient1;
                return entityinsentient;
            }
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses O() {
        return this.bW;
    }

    @Override
    @Nullable
    public EntityLiving q() {
        return this.bV;
    }

    public CraftMob getBukkitMob() {
        return (CraftMob)super.getBukkitEntity();
    }

    public void h(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.q() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.q() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.q().bx() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.dM().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.bV = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.R;
    }

    public boolean a(ItemProjectileWeapon weapon) {
        return false;
    }

    public void P() {
        this.a(GameEvent.m);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(b, (byte)0);
    }

    public int Q() {
        return 80;
    }

    public void R() {
        SoundEffect soundeffect = this.y();
        if (soundeffect != null) {
            this.a(soundeffect, this.eW(), this.eX());
        }
    }

    @Override
    public void as() {
        super.as();
        this.dM().af().a("mobBaseTick");
        if (this.bx() && this.ag.a(1000) < this.bI++) {
            this.u();
            this.R();
        }
        this.dM().af().c();
    }

    @Override
    protected void e(DamageSource source) {
        this.u();
        super.e(source);
    }

    private void u() {
        this.bI = -this.Q();
    }

    @Override
    public int ee() {
        if (this.bJ > 0) {
            int j2;
            int i2 = this.bJ;
            for (j2 = 0; j2 < this.bY.size(); ++j2) {
                if (this.bY.get(j2).b() || !(this.bR[j2] <= 1.0f)) continue;
                i2 += 1 + this.ag.a(3);
            }
            for (j2 = 0; j2 < this.bX.size(); ++j2) {
                if (this.bX.get(j2).b() || !(this.bQ[j2] <= 1.0f)) continue;
                i2 += 1 + this.ag.a(3);
            }
            return i2;
        }
        return this.bJ;
    }

    public void S() {
        if (this.dM().B) {
            for (int i2 = 0; i2 < 20; ++i2) {
                double d0 = this.ag.k() * 0.02;
                double d1 = this.ag.k() * 0.02;
                double d2 = this.ag.k() * 0.02;
                double d3 = 10.0;
                this.dM().a(Particles.Y, this.c(1.0) - d0 * 10.0, this.du() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.dM().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 20) {
            this.S();
        } else {
            super.b(status);
        }
    }

    @Override
    public void l() {
        super.l();
        if (!this.dM().B) {
            this.fR();
            if (this.ah % 5 == 0) {
                this.T();
            }
        }
    }

    protected void T() {
        boolean flag = !(this.cN() instanceof EntityInsentient);
        boolean flag1 = !(this.cZ() instanceof EntityBoat);
        this.bO.a(PathfinderGoal.Type.a, flag);
        this.bO.a(PathfinderGoal.Type.c, flag && flag1);
        this.bO.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected float e(float bodyRotation, float headRotation) {
        this.bU.a();
        return headRotation;
    }

    @Nullable
    protected SoundEffect y() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.y();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound2;
        super.b(nbt);
        nbt.a("CanPickUpLoot", this.fK());
        nbt.a("PersistenceRequired", this.ca);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.bY) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ItemStack itemstack1 : this.bX) {
            nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbt.a("HandItems", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (float f2 : this.bR) {
            nbttaglist2.add(NBTTagFloat.a(f2));
        }
        nbt.a("ArmorDropChances", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (float f1 : this.bQ) {
            nbttaglist3.add(NBTTagFloat.a(f1));
        }
        nbt.a("HandDropChances", nbttaglist3);
        if (this.ce != null && !this.ce.pluginRemoved) {
            nbttagcompound2 = new NBTTagCompound();
            if (this.ce instanceof EntityLiving) {
                UUID uuid = this.ce.cw();
                nbttagcompound2.a("UUID", uuid);
            } else if (this.ce instanceof EntityHanging) {
                BlockPosition blockposition = ((EntityHanging)this.ce).E();
                nbttagcompound2.a("X", blockposition.u());
                nbttagcompound2.a("Y", blockposition.v());
                nbttagcompound2.a("Z", blockposition.w());
            }
            nbt.a(bE, nbttagcompound2);
        } else if (this.cg != null) {
            nbt.a(bE, this.cg.h());
        }
        nbt.a("LeftHanded", this.fV());
        if (this.cc != null) {
            nbt.a("DeathLootTable", this.cc.toString());
            if (this.cd != 0L) {
                nbt.a("DeathLootTableSeed", this.cd);
            }
        }
        if (this.fU()) {
            nbt.a("NoAI", this.fU());
        }
        nbt.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist;
        boolean data;
        super.a(nbt);
        if (nbt.b("CanPickUpLoot", 1)) {
            data = nbt.q("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
                this.s(data);
            }
        }
        data = nbt.q("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
            this.ca = data;
        }
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.bY.size(); ++i2) {
                this.bY.set(i2, ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.bX.size(); ++i2) {
                this.bX.set(i2, ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("ArmorDropChances", 9)) {
            nbttaglist = nbt.c("ArmorDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bR[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b("HandDropChances", 9)) {
            nbttaglist = nbt.c("HandDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bQ[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b(bE, 10)) {
            this.cg = nbt.p(bE);
        }
        this.u(nbt.q("LeftHanded"));
        if (nbt.b("DeathLootTable", 8)) {
            this.cc = MinecraftKey.a(nbt.l("DeathLootTable"));
            this.cd = nbt.i("DeathLootTableSeed");
        }
        this.t(nbt.q("NoAI"));
        if (nbt.e("Bukkit.Aware")) {
            this.aware = nbt.q("Bukkit.Aware");
        }
    }

    @Override
    protected void a(DamageSource damageSource, boolean causedByPlayer) {
        super.a(damageSource, causedByPlayer);
        this.cc = null;
    }

    @Override
    public final MinecraftKey eA() {
        return this.cc == null ? this.U() : this.cc;
    }

    public MinecraftKey U() {
        return super.eA();
    }

    @Override
    public long eB() {
        return this.cd;
    }

    public void A(float forwardSpeed) {
        this.bm = forwardSpeed;
    }

    public void B(float upwardSpeed) {
        this.bl = upwardSpeed;
    }

    public void C(float sidewaysSpeed) {
        this.bk = sidewaysSpeed;
    }

    @Override
    public void w(float movementSpeed) {
        super.w(movementSpeed);
        this.A(movementSpeed);
    }

    @Override
    public void d_() {
        super.d_();
        this.dM().af().a("looting");
        if (!this.dM().B && this.fK() && this.bx() && !this.ba && this.dM().Z().b(GameRules.c)) {
            BaseBlockPosition baseblockposition = this.V();
            List<EntityItem> list = this.dM().a(EntityItem.class, this.cH().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()));
            for (EntityItem entityitem : list) {
                if (entityitem.dH() || entityitem.q().b() || entityitem.z() || !this.k(entityitem.q()) || !entityitem.canMobPickup) continue;
                this.b(entityitem);
            }
        }
        this.dM().af().c();
    }

    protected BaseBlockPosition V() {
        return bS;
    }

    protected void b(EntityItem item) {
        ItemStack itemstack = item.q();
        ItemStack itemstack1 = this.equipItemIfPossible(itemstack.p(), item);
        if (!itemstack1.b()) {
            this.a(item);
            this.a((Entity)item, itemstack1.L());
            itemstack.h(itemstack1.L());
            if (itemstack.b()) {
                item.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack i(ItemStack stack) {
        return this.equipItemIfPossible(stack, null);
    }

    public ItemStack equipItemIfPossible(ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
        ItemStack itemstack1 = this.c(enumitemslot);
        boolean flag = this.b(itemstack, itemstack1);
        if (enumitemslot.f() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.c(enumitemslot);
            flag = itemstack1.b();
        }
        boolean bl = canPickup = flag && this.j(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.f(enumitemslot);
            if (!itemstack1.b() && (double)Math.max(this.ag.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
            }
            if (enumitemslot.f() && itemstack.L() > 1) {
                ItemStack itemstack2 = itemstack.c(1);
                this.b(enumitemslot, itemstack2);
                return itemstack2;
            }
            this.b(enumitemslot, itemstack);
            return itemstack;
        }
        return ItemStack.f;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.e(slot);
        this.ca = true;
    }

    public void e(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                this.bQ[slot.b()] = 2.0f;
                break;
            }
            case b: {
                this.bR[slot.b()] = 2.0f;
            }
        }
    }

    protected boolean b(ItemStack newStack, ItemStack oldStack) {
        if (oldStack.b()) {
            return true;
        }
        if (newStack.d() instanceof ItemSword) {
            if (!(oldStack.d() instanceof ItemSword)) {
                return true;
            }
            ItemSword itemsword = (ItemSword)newStack.d();
            ItemSword itemsword1 = (ItemSword)oldStack.d();
            return itemsword.h() != itemsword1.h() ? itemsword.h() > itemsword1.h() : this.c(newStack, oldStack);
        }
        if (newStack.d() instanceof ItemBow && oldStack.d() instanceof ItemBow) {
            return this.c(newStack, oldStack);
        }
        if (newStack.d() instanceof ItemCrossbow && oldStack.d() instanceof ItemCrossbow) {
            return this.c(newStack, oldStack);
        }
        Item item = newStack.d();
        if (item instanceof ItemArmor) {
            ItemArmor itemarmor = (ItemArmor)item;
            if (EnchantmentManager.d(oldStack)) {
                return false;
            }
            if (!(oldStack.d() instanceof ItemArmor)) {
                return true;
            }
            ItemArmor itemarmor1 = (ItemArmor)oldStack.d();
            return itemarmor.e() != itemarmor1.e() ? itemarmor.e() > itemarmor1.e() : (itemarmor.f() != itemarmor1.f() ? itemarmor.f() > itemarmor1.f() : this.c(newStack, oldStack));
        }
        if (newStack.d() instanceof ItemTool) {
            if (oldStack.d() instanceof ItemBlock) {
                return true;
            }
            Item item1 = oldStack.d();
            if (item1 instanceof ItemTool) {
                ItemTool itemtool = (ItemTool)item1;
                ItemTool itemtool1 = (ItemTool)newStack.d();
                if (itemtool1.d() != itemtool.d()) {
                    return itemtool1.d() > itemtool.d();
                }
                return this.c(newStack, oldStack);
            }
        }
        return false;
    }

    public boolean c(ItemStack newStack, ItemStack oldStack) {
        return newStack.k() >= oldStack.k() && (!newStack.u() || oldStack.u()) ? (newStack.u() && oldStack.u() ? newStack.v().e().stream().anyMatch(s2 -> !s2.equals("Damage")) && !oldStack.v().e().stream().anyMatch(s2 -> !s2.equals("Damage")) : false) : true;
    }

    public boolean j(ItemStack stack) {
        return true;
    }

    public boolean k(ItemStack stack) {
        return this.j(stack);
    }

    public boolean h(double distanceSquared) {
        return true;
    }

    public boolean W() {
        return this.bO();
    }

    protected boolean X() {
        return false;
    }

    @Override
    public void dy() {
        if (this.dM().ak() == EnumDifficulty.a && this.X()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.fL() && !this.W()) {
            EntityHuman entityhuman = this.dM().findNearbyPlayer(this, -1.0, IEntitySelector.PLAYER_AFFECTS_SPAWNING);
            if (entityhuman != null) {
                int i2;
                int j2;
                double d0 = entityhuman.f((Entity)this);
                if (d0 > (double)(j2 = (i2 = this.dM().paperConfig().entities.spawning.despawnRanges.get(this.ai().f()).hard()) * i2) && this.h(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                int k2 = this.dM().paperConfig().entities.spawning.despawnRanges.get(this.ai().f()).soft();
                int l2 = k2 * k2;
                if (this.bb > 600 && this.ag.a(800) == 0 && d0 > (double)l2 && this.h(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                } else if (d0 < (double)l2) {
                    this.bb = 0;
                }
            }
        } else {
            this.bb = 0;
        }
    }

    @Override
    protected final void fi() {
        ++this.bb;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.a()) {
                    this.goalFloat.e();
                }
                this.M().b();
            }
            return;
        }
        this.dM().af().a("sensing");
        this.bW.a();
        this.dM().af().c();
        int i2 = this.dM().o().ai() + this.aj();
        if (i2 % 2 != 0 && this.ah > 1) {
            this.dM().af().a("targetSelector");
            this.bP.a(false);
            this.dM().af().c();
            this.dM().af().a("goalSelector");
            this.bO.a(false);
            this.dM().af().c();
        } else {
            this.dM().af().a("targetSelector");
            this.bP.a();
            this.dM().af().c();
            this.dM().af().a("goalSelector");
            this.bO.a();
            this.dM().af().c();
        }
        this.dM().af().a("navigation");
        this.bN.c();
        this.dM().af().c();
        this.dM().af().a("mob tick");
        this.Z();
        this.dM().af().c();
        this.dM().af().a("controls");
        this.dM().af().a("move");
        this.bL.a();
        this.dM().af().b("look");
        this.bK.a();
        this.dM().af().b("jump");
        this.bM.b();
        this.dM().af().c();
        this.dM().af().c();
        this.Y();
    }

    protected void Y() {
        PacketDebug.a(this.dM(), this, this.bO);
    }

    protected void Z() {
    }

    public int aa() {
        return 40;
    }

    public int ab() {
        return 75;
    }

    public int fH() {
        return 10;
    }

    public void a(Entity targetEntity, float maxYawChange, float maxPitchChange) {
        double d2;
        double d0 = targetEntity.dr() - this.dr();
        double d1 = targetEntity.dx() - this.dx();
        if (targetEntity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)targetEntity;
            d2 = entityliving.dv() - this.dv();
        } else {
            d2 = (targetEntity.cH().b + targetEntity.cH().e) / 2.0 - this.dv();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.s(this.a(this.dE(), f3, maxPitchChange));
        this.r(this.a(this.dC(), f2, maxYawChange));
    }

    private float a(float from, float to, float max) {
        float f3 = MathHelper.g(to - from);
        if (f3 > max) {
            f3 = max;
        }
        if (f3 < -max) {
            f3 = -max;
        }
        return from + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockposition1 = pos.d();
        return spawnReason == EnumMobSpawn.c || world.a_(blockposition1).a((IBlockAccess)world, blockposition1, type);
    }

    public boolean a(GeneratorAccess world, EnumMobSpawn spawnReason) {
        return true;
    }

    public boolean a(IWorldReader world) {
        return !world.d(this.cH()) && world.f(this);
    }

    public int fI() {
        return 4;
    }

    public boolean d(int count) {
        return false;
    }

    @Override
    public int cu() {
        if (this.q() == null) {
            return 3;
        }
        int i2 = (int)(this.ev() - this.eM() * 0.33f);
        if ((i2 -= (3 - this.dM().ak().a()) * 4) < 0) {
            i2 = 0;
        }
        return i2 + 3;
    }

    @Override
    public Iterable<ItemStack> bK() {
        return this.bX;
    }

    @Override
    public Iterable<ItemStack> bL() {
        return this.bY;
    }

    @Override
    public ItemStack c(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bX.get(slot.b());
            }
            case b: {
                return this.bY.get(slot.b());
            }
        }
        return ItemStack.f;
    }

    @Override
    public void a(EnumItemSlot slot, ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        this.e(stack);
        switch (slot.a()) {
            case a: {
                this.onEquipItem(slot, this.bX.set(slot.b(), stack), stack, silent);
                break;
            }
            case b: {
                this.onEquipItem(slot, this.bY.set(slot.b(), stack), stack, silent);
            }
        }
    }

    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return false;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        for (EnumItemSlot enumitemslot : EnumItemSlot.VALUES) {
            boolean flag1;
            if (this.shouldSkipLoot(enumitemslot)) continue;
            ItemStack itemstack = this.c(enumitemslot);
            float f2 = this.f(enumitemslot);
            boolean bl = flag1 = f2 > 1.0f;
            if (itemstack.b() || EnchantmentManager.e(itemstack) || !allowDrops && !flag1 || !(Math.max(this.ag.i() - (float)lootingMultiplier * 0.01f, 0.0f) < f2)) continue;
            if (!flag1 && itemstack.i()) {
                itemstack.b(itemstack.l() - this.ag.a(1 + this.ag.a(Math.max(itemstack.l() - 3, 1))));
            }
            this.b(itemstack);
            if (this.clearEquipmentSlots) {
                this.a(enumitemslot, ItemStack.f);
                continue;
            }
            this.clearedEquipmentSlots.add(enumitemslot);
        }
    }

    protected float f(EnumItemSlot slot) {
        return switch (slot.a()) {
            case EnumItemSlot.Function.a -> this.bQ[slot.b()];
            case EnumItemSlot.Function.b -> this.bR[slot.b()];
            default -> 0.0f;
        };
    }

    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (random.i() < 0.15f * localDifficulty.d()) {
            float f2;
            int i2 = random.a(2);
            float f3 = f2 = this.dM().ak() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (random.i() < 0.095f) {
                ++i2;
            }
            if (random.i() < 0.095f) {
                ++i2;
            }
            if (random.i() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : EnumItemSlot.VALUES) {
                Item item;
                if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
                ItemStack itemstack = this.c(enumitemslot);
                if (!flag && random.i() < f2) break;
                flag = false;
                if (!itemstack.b() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot equipmentSlot, int equipmentLevel) {
        switch (equipmentSlot) {
            case f: {
                if (equipmentLevel == 0) {
                    return Items.pv;
                }
                if (equipmentLevel == 1) {
                    return Items.pL;
                }
                if (equipmentLevel == 2) {
                    return Items.pz;
                }
                if (equipmentLevel == 3) {
                    return Items.pD;
                }
                if (equipmentLevel == 4) {
                    return Items.pH;
                }
            }
            case e: {
                if (equipmentLevel == 0) {
                    return Items.pw;
                }
                if (equipmentLevel == 1) {
                    return Items.pM;
                }
                if (equipmentLevel == 2) {
                    return Items.pA;
                }
                if (equipmentLevel == 3) {
                    return Items.pE;
                }
                if (equipmentLevel == 4) {
                    return Items.pI;
                }
            }
            case d: {
                if (equipmentLevel == 0) {
                    return Items.px;
                }
                if (equipmentLevel == 1) {
                    return Items.pN;
                }
                if (equipmentLevel == 2) {
                    return Items.pB;
                }
                if (equipmentLevel == 3) {
                    return Items.pF;
                }
                if (equipmentLevel == 4) {
                    return Items.pJ;
                }
            }
            case c: {
                if (equipmentLevel == 0) {
                    return Items.py;
                }
                if (equipmentLevel == 1) {
                    return Items.pO;
                }
                if (equipmentLevel == 2) {
                    return Items.pC;
                }
                if (equipmentLevel == 3) {
                    return Items.pG;
                }
                if (equipmentLevel != 4) break;
                return Items.pK;
            }
        }
        return null;
    }

    protected void b(RandomSource random, DifficultyDamageScaler localDifficulty) {
        float f2 = localDifficulty.d();
        this.a(random, f2);
        for (EnumItemSlot enumitemslot : EnumItemSlot.VALUES) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(random, f2, enumitemslot);
        }
    }

    protected void a(RandomSource random, float power) {
        if (!this.eT().b() && random.i() < 0.25f * power) {
            this.a(EnumItemSlot.a, EnchantmentManager.a(random, this.eT(), (int)(5.0f + power * (float)random.a(18)), false));
        }
    }

    protected void a(RandomSource random, float power, EnumItemSlot slot) {
        ItemStack itemstack = this.c(slot);
        if (!itemstack.b() && random.i() < 0.5f * power) {
            this.a(slot, EnchantmentManager.a(random, itemstack, (int)(5.0f + power * (float)random.a(18)), false));
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.F_();
        this.a(GenericAttributes.g).c(new AttributeModifier("Random spawn bonus", randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        if (randomsource.i() < 0.05f) {
            this.u(true);
        } else {
            this.u(false);
        }
        return entityData;
    }

    public void fJ() {
        this.ca = true;
    }

    public void a(EnumItemSlot slot, float chance) {
        switch (slot.a()) {
            case a: {
                this.bQ[slot.b()] = chance;
                break;
            }
            case b: {
                this.bR[slot.b()] = chance;
            }
        }
    }

    public boolean fK() {
        return this.bZ;
    }

    public void s(boolean canPickUpLoot) {
        this.bZ = canPickUpLoot;
    }

    @Override
    public boolean f(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b() && this.fK();
    }

    public boolean fL() {
        return this.ca;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.bx()) {
            return EnumInteractionResult.d;
        }
        if (this.fT() == player) {
            PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, hand, !player.fT().d);
            if (event.isCancelled()) {
                ((EntityPlayer)player).c.b(new PacketPlayOutAttachEntity(this, this.fT()));
                return EnumInteractionResult.d;
            }
            this.a(true, event.isDropLeash());
            this.a(GameEvent.r, (Entity)player);
            return EnumInteractionResult.a(this.dM().B);
        }
        EnumInteractionResult enuminteractionresult = this.c(player, hand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return enuminteractionresult;
        }
        enuminteractionresult = this.b(player, hand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return enuminteractionresult;
        }
        return super.a(player, hand);
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.uD) && this.a(player)) {
            if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player, hand).isCancelled()) {
                ((EntityPlayer)player).c.b(new PacketPlayOutAttachEntity(this, this.fT()));
                player.bS.b();
                return EnumInteractionResult.d;
            }
            this.b((Entity)player, true);
            itemstack.h(1);
            return EnumInteractionResult.a(this.dM().B);
        }
        if (itemstack.a(Items.uE) && (enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.d() instanceof ItemMonsterEgg) {
            if (this.dM() instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.d();
                Optional<EntityInsentient> optional = itemmonsteregg.a(player, this, this.ai(), (WorldServer)this.dM(), this.dk(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(player, (EntityInsentient)entityinsentient));
                return optional.isPresent() ? EnumInteractionResult.a : EnumInteractionResult.d;
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.d;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean fM() {
        return this.a(this.dm());
    }

    public boolean a(BlockPosition pos) {
        return this.ci == -1.0f ? true : this.ch.j(pos) < (double)(this.ci * this.ci);
    }

    public void a(BlockPosition target, int range) {
        this.ch = target;
        this.ci = range;
    }

    public BlockPosition fN() {
        return this.ch;
    }

    public float fO() {
        return this.ci;
    }

    public void fP() {
        this.ci = -1.0f;
    }

    public boolean fQ() {
        return this.ci != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, boolean keepEquipment) {
        return this.convertTo(entityType, keepEquipment, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, boolean flag, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.dH()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.dM());
        if (t0 == null) {
            return null;
        }
        t0.v(this);
        t0.a(this.o_());
        t0.t(this.fU());
        if (this.ae()) {
            t0.b(this.af());
            t0.n(this.cB());
        }
        if (this.fL()) {
            t0.fJ();
        }
        t0.m(this.cr());
        if (flag) {
            t0.s(this.fK());
            for (EnumItemSlot enumitemslot : EnumItemSlot.VALUES) {
                ItemStack itemstack = this.c(enumitemslot);
                if (itemstack.b()) continue;
                t0.a(enumitemslot, itemstack.c());
                t0.a(enumitemslot, this.f(enumitemslot));
            }
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        this.dM().addFreshEntity(t0, spawnReason);
        if (this.bO()) {
            Entity entity = this.cZ();
            this.ac();
            t0.a(entity, true);
        }
        this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        return (T)t0;
    }

    protected void fR() {
        if (this.cg != null) {
            this.ga();
        }
        if (!(this.ce == null || this.bx() && this.ce.bx())) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), !this.bx() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, !this.ce.pluginRemoved);
            this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
            this.a(true, event.isDropLeash());
        }
    }

    public void a(boolean sendPacket, boolean dropItem) {
        if (this.ce != null) {
            this.ce = null;
            this.cg = null;
            if (!this.dM().B && dropItem) {
                this.forceDrops = true;
                this.a((IMaterial)Items.uD);
                this.forceDrops = false;
            }
            if (!this.dM().B && sendPacket && this.dM() instanceof WorldServer) {
                ((WorldServer)this.dM()).l().b(this, new PacketPlayOutAttachEntity(this, null));
            }
        }
    }

    public boolean a(EntityHuman player) {
        return !this.fS() && !(this instanceof IMonster);
    }

    public boolean fS() {
        return this.ce != null;
    }

    @Nullable
    public Entity fT() {
        if (this.ce == null && this.cf != 0 && this.dM().B) {
            this.ce = this.dM().a(this.cf);
        }
        return this.ce;
    }

    public void b(Entity entity, boolean sendPacket) {
        this.ce = entity;
        this.cg = null;
        if (!this.dM().B && sendPacket && this.dM() instanceof WorldServer) {
            ((WorldServer)this.dM()).l().b(this, new PacketPlayOutAttachEntity(this, this.ce));
        }
        if (this.bO()) {
            this.ac();
        }
    }

    public void r(int id) {
        this.cf = id;
        this.a(false, false);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        boolean flag1 = super.a(entity, force);
        if (flag1 && this.fS()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag1;
            }
            this.a(true, event.isDropLeash());
        }
        return flag1;
    }

    private void ga() {
        if (this.cg != null && this.dM() instanceof WorldServer) {
            if (this.cg.b("UUID")) {
                UUID uuid = this.cg.a("UUID");
                Entity entity = ((WorldServer)this.dM()).a(uuid);
                if (entity != null) {
                    this.b(entity, true);
                    return;
                }
            } else if (this.cg.b("X", 99) && this.cg.b("Y", 99) && this.cg.b("Z", 99)) {
                BlockPosition blockposition = GameProfileSerializer.b(this.cg);
                this.b(EntityLeash.b(this.dM(), blockposition), true);
                return;
            }
            if (this.ah > 100) {
                this.forceDrops = true;
                this.a((IMaterial)Items.uD);
                this.forceDrops = false;
                this.cg = null;
            }
        }
    }

    @Override
    public boolean cY() {
        return super.cY() && !this.fU();
    }

    public void t(boolean aiDisabled) {
        byte b0 = this.an.b(b);
        this.an.b(b, aiDisabled ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void u(boolean leftHanded) {
        byte b0 = this.an.b(b);
        this.an.b(b, leftHanded ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void v(boolean attacking) {
        byte b0 = this.an.b(b);
        this.an.b(b, attacking ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean fU() {
        return (this.an.b(b) & 1) != 0;
    }

    public boolean fV() {
        return (this.an.b(b) & 2) != 0;
    }

    public boolean fW() {
        return (this.an.b(b) & 4) != 0;
    }

    public void a(boolean baby) {
    }

    @Override
    public EnumMainHand fm() {
        return this.fV() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean i(EntityLiving entity) {
        return this.fX().c(entity.eF());
    }

    protected AxisAlignedBB fX() {
        AxisAlignedBB axisalignedbb;
        Entity entity = this.cZ();
        if (entity != null) {
            AxisAlignedBB axisalignedbb1 = entity.cH();
            AxisAlignedBB axisalignedbb2 = this.cH();
            axisalignedbb = new AxisAlignedBB(Math.min(axisalignedbb2.a, axisalignedbb1.a), axisalignedbb2.b, Math.min(axisalignedbb2.c, axisalignedbb1.c), Math.max(axisalignedbb2.d, axisalignedbb1.d), axisalignedbb2.e, Math.max(axisalignedbb2.f, axisalignedbb1.f));
        } else {
            axisalignedbb = this.cH();
        }
        return axisalignedbb.c(bT, 0.0, bT);
    }

    @Override
    public boolean C(Entity target) {
        boolean flag;
        int i2;
        float f2 = (float)this.b(GenericAttributes.c);
        float f1 = (float)this.b(GenericAttributes.d);
        if (target instanceof EntityLiving) {
            f2 += EnchantmentManager.a(this.eT(), ((EntityLiving)target).eS());
            f1 += (float)EnchantmentManager.c(this);
        }
        if ((i2 = EnchantmentManager.d(this)) > 0) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), i2 * 4);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                target.setSecondsOnFire(combustEvent.getDuration(), false);
            }
        }
        if (flag = target.a(this.dN().b(this), f2)) {
            if (f1 > 0.0f && target instanceof EntityLiving) {
                ((EntityLiving)target).knockback(f1 * 0.5f, MathHelper.a(this.dC() * ((float)Math.PI / 180)), (double)(-MathHelper.b(this.dC())) * 0.01745329238474369, this, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                this.g(this.dp().d(0.6, 1.0, 0.6));
            }
            if (target instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)target;
                this.a(entityhuman, this.eT(), entityhuman.fn() ? entityhuman.fp() : ItemStack.f);
            }
            this.a((EntityLiving)this, target);
            this.A(target);
        }
        return flag;
    }

    private void a(EntityHuman player, ItemStack mobStack, ItemStack playerStack) {
        if (!mobStack.b() && !playerStack.b() && mobStack.d() instanceof ItemAxe && playerStack.a(Items.vl)) {
            float f2 = 0.25f + (float)EnchantmentManager.g(this) * 0.05f;
            if (this.ag.i() < f2) {
                PlayerShieldDisableEvent shieldDisableEvent = new PlayerShieldDisableEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), 100);
                if (!shieldDisableEvent.callEvent()) {
                    return;
                }
                player.gn().a(Items.vl, shieldDisableEvent.getCooldown());
                this.dM().a((Entity)player, (byte)30);
            }
        }
    }

    public boolean fY() {
        if (this.dM().P() && !this.dM().B) {
            if (!LeavesConfig.optimizeSunBurnTick) {
                boolean flag;
                float f2 = this.bo();
                BlockPosition blockposition = BlockPosition.a(this.dr(), this.dv(), this.dx());
                boolean bl = flag = this.bb() || this.aA || this.aB;
                if (f2 > 0.5f && this.ag.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.dM().h(blockposition)) {
                    return true;
                }
            } else {
                boolean flag;
                float f3;
                int positionHashCode = this.dk().hashCode();
                if (this.cached_position_hashcode != positionHashCode) {
                    this.cached_eye_blockpos = BlockPosition.a(this.dr(), this.dv(), this.dx());
                    this.cached_position_hashcode = positionHashCode;
                }
                if ((f3 = this.getLightLevelDependentMagicValue(this.cached_eye_blockpos)) <= 0.5f) {
                    return false;
                }
                if (this.ag.i() * 30.0f >= (f3 - 0.4f) * 2.0f) {
                    return false;
                }
                boolean bl = flag = this.bb() || this.aA || this.aB;
                if (!flag && this.dM().h(this.cached_eye_blockpos)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        if (this.N().p()) {
            super.c(fluid);
        } else {
            this.g(this.dp().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void fZ() {
        this.c((PathfinderGoal pathfindergoal) -> true);
        this.dO().h();
    }

    public void c(Predicate<PathfinderGoal> predicate) {
        this.bO.a(predicate);
    }

    @Override
    protected void cs() {
        super.cs();
        EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
        this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
        this.a(true, event.isDropLeash());
        this.bM().forEach(itemstack -> {
            if (!itemstack.b()) {
                itemstack.f(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack dz() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.ai());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }
}

