/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.EnchantmentFrostWalker;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R3.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import top.leavesmc.leaves.LeavesConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger b = LogUtils.getLogger();
    private static final String c = "active_effects";
    private static final UUID d = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID e = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final AttributeModifier bA = new AttributeModifier(UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D"), "Sprinting speed boost", 0.3f, AttributeModifier.Operation.c);
    public static final int g = 2;
    public static final int h = 4;
    public static final int i = 98;
    public static final int j = 100;
    public static final int k = 6;
    public static final int l = 100;
    private static final int bB = 40;
    public static final double m = 0.003;
    public static final double n = 0.08;
    public static final int o = 20;
    private static final int bC = 7;
    private static final int bD = 10;
    private static final int bE = 2;
    public static final int p = 4;
    private static final float bF = 0.42f;
    private static final double bG = 128.0;
    protected static final int q = 1;
    protected static final int r = 2;
    protected static final int s = 4;
    protected static final DataWatcherObject<Byte> t = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> bH = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> bI = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bJ = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bK = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bL = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bM = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.o);
    protected static final float u = 1.74f;
    protected static final EntitySize v = EntitySize.c(0.2f, 0.2f);
    public static final float aE = 0.5f;
    private final AttributeMapBase bN;
    public CombatTracker bO = new CombatTracker(this);
    public final Map<MobEffectList, MobEffect> bP = Maps.newHashMap();
    private final NonNullList<ItemStack> bQ;
    private final NonNullList<ItemStack> bR;
    public boolean aF;
    private boolean bS;
    public EnumHand aG;
    public int aH;
    public int aI;
    public int aJ;
    public int aK;
    public int aL;
    public int aM;
    public float aN;
    public float aO;
    protected int aP;
    public final WalkAnimationState aQ;
    public int aR;
    public final float aS;
    public final float aT;
    public float aU;
    public float aV;
    public float aW;
    public float aX;
    @Nullable
    public EntityHuman aY;
    public int aZ;
    protected boolean ba;
    protected int bb;
    protected float bc;
    protected float bd;
    protected float be;
    protected float bf;
    protected float bg;
    protected int bh;
    public float bi;
    public boolean bj;
    public float bk;
    public float bl;
    public float bm;
    protected int bn;
    protected double bo;
    protected double bp;
    protected double bq;
    protected double br;
    protected double bs;
    protected double bt;
    protected int bu;
    public boolean bT;
    @Nullable
    public EntityLiving bU;
    public int bV;
    private EntityLiving bW;
    private int bX;
    private float bY;
    private int bZ;
    private float ca;
    protected ItemStack bv;
    public int bw;
    protected int bx;
    public BlockPosition cb;
    private Optional<BlockPosition> cc;
    @Nullable
    private DamageSource cd;
    private long ce;
    protected int by;
    private float cf;
    private float cg;
    protected BehaviorController<?> bz;
    protected boolean ch;
    public int expToDrop;
    public boolean forceDrops;
    public ArrayList<Entity.DefaultDrop> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EnumItemSlot> clearedEquipmentSlots = new HashSet<EnumItemSlot>();
    private boolean cachedOnClimable = false;
    private BlockPosition lastClimbingPosition = null;
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;
    public int shieldBlockingDelay;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    @Override
    public float getBukkitYaw() {
        return this.cp();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bb;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> type, net.minecraft.world.level.World world) {
        super(type, world);
        this.shieldBlockingDelay = this.dM().paperConfig().misc.shieldBlockingDelay;
        this.bQ = NonNullList.a(2, ItemStack.f);
        this.bR = NonNullList.a(4, ItemStack.f);
        this.bS = false;
        this.aQ = new WalkAnimationState();
        this.aR = 20;
        this.bT = true;
        this.bv = ItemStack.f;
        this.cc = Optional.empty();
        this.bN = new AttributeMapBase(AttributeDefaults.a(type));
        this.craftAttributes = new CraftAttributeMap(this.bN);
        this.an.b(bH, Float.valueOf((float)this.a(GenericAttributes.l).f()));
        this.I = true;
        this.aT = (float)((Math.random() + 1.0) * (double)0.01f);
        this.ar();
        this.aS = (float)Math.random() * 12398.0f;
        this.r((float)(Math.random() * 6.2831854820251465));
        this.aW = this.dC();
        this.t(0.6f);
        DynamicOpsNBT dynamicopsnbt = DynamicOpsNBT.a;
        this.bz = this.a(new Dynamic<NBTBase>(dynamicopsnbt, (NBTBase)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.a("memories"), (Object)((NBTBase)dynamicopsnbt.emptyMap())))));
    }

    public BehaviorController<?> dO() {
        return this.bz;
    }

    protected BehaviorController.b<?> dP() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.dP().a(dynamic);
    }

    @Override
    public void al() {
        this.a(this.dN().w(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> type) {
        return true;
    }

    @Override
    protected void c_() {
        this.an.a(t, (byte)0);
        this.an.a(bI, 0);
        this.an.a(bJ, false);
        this.an.a(bK, 0);
        this.an.a(bL, 0);
        this.an.a(bH, Float.valueOf(1.0f));
        this.an.a(bM, Optional.empty());
    }

    public static AttributeProvider.Builder dQ() {
        return AttributeProvider.a().a(GenericAttributes.l).a(GenericAttributes.i).a(GenericAttributes.m).a(GenericAttributes.a).a(GenericAttributes.b).a(GenericAttributes.k);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        if (!this.aZ()) {
            this.bh();
        }
        if (!this.dM().B && onGround && this.ab > 0.0f) {
            this.dV();
            this.dW();
        }
        if (!this.dM().B && this.ab > 3.0f && onGround && !state.i()) {
            double d1 = this.dr();
            double d2 = this.dt();
            double d3 = this.dx();
            BlockPosition blockposition1 = this.dm();
            if (landedPosition.u() != blockposition1.u() || landedPosition.w() != blockposition1.w()) {
                double d4 = d1 - (double)landedPosition.u() - 0.5;
                double d5 = d3 - (double)landedPosition.w() - 0.5;
                double d6 = Math.max(Math.abs(d4), Math.abs(d5));
                d1 = (double)landedPosition.u() + 0.5 + d4 / d6 * 0.5;
                d3 = (double)landedPosition.w() + 0.5 + d5 / d6 * 0.5;
            }
            float f2 = MathHelper.f(this.ab - 3.0f);
            double d7 = Math.min((double)(0.2f + f2 / 15.0f), 2.5);
            int i2 = (int)(150.0 * d7);
            if (this instanceof EntityPlayer) {
                ((WorldServer)this.dM()).sendParticles((EntityPlayer)this, new ParticleParamBlock(Particles.c, state), this.dr(), this.dt(), this.dx(), i2, 0.0, 0.0, 0.0, 0.15f, false);
            } else {
                ((WorldServer)this.dM()).a(new ParticleParamBlock(Particles.c, state), d1, d2, d3, i2, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.a(heightDifference, onGround, state, landedPosition);
        if (onGround) {
            this.cc = Optional.empty();
        }
    }

    public final boolean dR() {
        return this.ai().a(TagsEntity.m);
    }

    public float a(float tickDelta) {
        return MathHelper.i(tickDelta, this.cg, this.cf);
    }

    @Override
    public void as() {
        this.aN = this.aO;
        if (this.am) {
            this.fB().ifPresent(this::a);
        }
        if (this.dS()) {
            this.dT();
        }
        super.as();
        this.dM().af().a("livingEntityBaseTick");
        if (this.aY() || this.dM().B) {
            this.aA();
        }
        if (this.bx()) {
            BlockPosition blockposition;
            boolean flag = this instanceof EntityHuman;
            if (!this.dM().B) {
                double d1;
                double d0;
                if ((!LeavesConfig.enableSuffocationOptimization || this instanceof EntityWither || this.ah % 10 == 0 && this.couldPossiblyBeHurt(1.0f)) && this.by()) {
                    this.a(this.dN().f(), 1.0f);
                } else if (flag && !this.dM().D_().a(this.cH()) && (d0 = this.dM().D_().a(this) + this.dM().D_().n()) < 0.0 && (d1 = this.dM().D_().o()) > 0.0) {
                    this.a(this.dN().v(), (float)Math.max(1, MathHelper.a(-d0 * d1)));
                }
            }
            if (((Entity)this).a(TagsFluid.a) && !this.dM().a_(BlockPosition.a(this.dr(), this.dv(), this.dx())).a(Blocks.nd)) {
                boolean flag1;
                boolean bl = flag1 = !this.dR() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).fT().a);
                if (flag1) {
                    this.j(this.m(this.ci()));
                    if (this.ci() == -20) {
                        this.j(0);
                        Vec3D vec3d = this.dp();
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d2 = this.ag.j() - this.ag.j();
                            double d3 = this.ag.j() - this.ag.j();
                            double d4 = this.ag.j() - this.ag.j();
                            this.dM().a(Particles.e, this.dr() + d2, this.dt() + d3, this.dx() + d4, vec3d.c, vec3d.d, vec3d.e);
                        }
                        this.a(this.dN().h(), 2.0f);
                    }
                }
                if (!this.dM().B && this.bO() && this.cZ() != null && this.cZ().bQ()) {
                    this.ac();
                }
            } else if (this.ci() < this.ch()) {
                this.j(this.n(this.ci()));
            }
            if (!this.dM().B && !com.google.common.base.Objects.equal((Object)this.cb, (Object)(blockposition = this.dm()))) {
                this.cb = blockposition;
                this.c(blockposition);
            }
        }
        if (this.bx() && (this.bb() || this.aA)) {
            this.aF();
        }
        if (this.aK > 0) {
            --this.aK;
        }
        if (this.al > 0 && !(this instanceof EntityPlayer)) {
            --this.al;
        }
        if (this.ew() && this.dM().h(this)) {
            this.eb();
        }
        if (this.aZ > 0) {
            --this.aZ;
        } else {
            this.aY = null;
        }
        if (this.bW != null && !this.bW.bx()) {
            this.bW = null;
        }
        if (this.bU != null) {
            if (!this.bU.bx()) {
                this.a((EntityLiving)null);
            } else if (this.ah - this.bV > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.en();
        this.bf = this.be;
        this.aV = this.aU;
        this.aX = this.aW;
        this.N = this.dC();
        this.O = this.dE();
        this.dM().af().c();
    }

    public boolean dS() {
        return this.ah % 5 == 0 && this.dp().c != 0.0 && this.dp().e != 0.0 && !this.P_() && EnchantmentManager.k(this) && this.dU();
    }

    protected void dT() {
        Vec3D vec3d = this.dp();
        this.dM().a(Particles.K, this.dr() + (this.ag.j() - 0.5) * (double)this.dg(), this.dt() + 0.1, this.dx() + (this.ag.j() - 0.5) * (double)this.dg(), vec3d.c * -0.2, 0.1, vec3d.e * -0.2);
        float f2 = this.ag.i() * 0.4f + this.ag.i() > 0.9f ? 0.6f : 0.0f;
        this.a(SoundEffects.wT, f2, 0.6f + this.ag.i() * 0.4f);
    }

    protected boolean dU() {
        return this.dM().a_(this.aI()).a(TagsBlock.aM);
    }

    @Override
    protected float aL() {
        return this.dU() && EnchantmentManager.a(Enchantments.l, this) > 0 ? 1.0f : super.aL();
    }

    protected boolean c(IBlockData landingState) {
        return !landingState.i() || this.fw();
    }

    protected void dV() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.m);
        if (attributemodifiable != null && attributemodifiable.a(d) != null) {
            attributemodifiable.b(d);
        }
    }

    protected void dW() {
        int i2;
        if (!this.bj().i() && (i2 = EnchantmentManager.a(Enchantments.l, this)) > 0 && this.dU()) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.m);
            if (attributemodifiable == null) {
                return;
            }
            attributemodifiable.b(new AttributeModifier(d, "Soul speed boost", 0.03f * (1.0f + (float)i2 * 0.35f), AttributeModifier.Operation.a));
            if (this.eg().i() < 0.04f) {
                ItemStack itemstack = this.c(EnumItemSlot.c);
                itemstack.a(1, this, (T entityliving) -> entityliving.d(EnumItemSlot.c));
            }
        }
    }

    protected void dX() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.m);
        if (attributemodifiable != null && attributemodifiable.a(e) != null) {
            attributemodifiable.b(e);
        }
    }

    protected void dY() {
        int i2;
        if ((LeavesConfig.checkFrozenTicksBeforeLandingBlock || !this.bj().i()) && (i2 = this.cj()) > 0) {
            AttributeModifiable attributemodifiable;
            AttributeModifiable attributeModifiable = attributemodifiable = !LeavesConfig.checkFrozenTicksBeforeLandingBlock || !this.bj().i() ? this.a(GenericAttributes.m) : null;
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.ck();
            attributemodifiable.b(new AttributeModifier(e, "Powder snow slow", f2, AttributeModifier.Operation.a));
        }
    }

    protected void c(BlockPosition pos) {
        int i2 = EnchantmentManager.a(Enchantments.j, this);
        if (i2 > 0) {
            EnchantmentFrostWalker.a(this, this.dM(), pos, i2);
        }
        if (this.c(this.bj())) {
            this.dV();
        }
        this.dW();
    }

    public boolean o_() {
        return false;
    }

    public float dZ() {
        return this.o_() ? 0.5f : 1.0f;
    }

    protected boolean ea() {
        return true;
    }

    protected void eb() {
        ++this.aM;
        if (this.aM >= 20 && !this.dM().y_() && !this.dH()) {
            this.dM().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean ec() {
        return !this.o_();
    }

    protected boolean ed() {
        return !this.o_();
    }

    protected int m(int air) {
        int j2 = EnchantmentManager.e(this);
        return j2 > 0 && this.ag.a(j2 + 1) > 0 ? air : air - 1;
    }

    protected int n(int air) {
        return Math.min(air + 4, this.ch());
    }

    public int ee() {
        return 0;
    }

    protected boolean ef() {
        return false;
    }

    public RandomSource eg() {
        return this.ag;
    }

    @Nullable
    public EntityLiving eh() {
        return this.bU;
    }

    @Override
    public EntityLiving V_() {
        return this.eh();
    }

    public int ei() {
        return this.bV;
    }

    public void c(@Nullable EntityHuman attacking) {
        this.aY = attacking;
        this.aZ = this.ah;
    }

    public void a(@Nullable EntityLiving attacker) {
        this.bU = attacker;
        this.bV = this.ah;
    }

    @Nullable
    public EntityLiving ej() {
        return this.bW;
    }

    public int ek() {
        return this.bX;
    }

    public void A(Entity target) {
        this.bW = target instanceof EntityLiving ? (EntityLiving)target : null;
        this.bX = this.ah;
    }

    public int el() {
        return this.bb;
    }

    public void o(int despawnCounter) {
        this.bb = despawnCounter;
    }

    public boolean em() {
        return !this.frictionState.toBooleanOrElse(!this.bS);
    }

    public void p(boolean noDrag) {
        this.bS = noDrag;
    }

    protected boolean a(EnumItemSlot slot) {
        return true;
    }

    public void a(EnumItemSlot slot, ItemStack oldStack, ItemStack newStack) {
        this.onEquipItem(slot, oldStack, newStack, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        boolean flag;
        boolean bl = flag = itemstack1.b() && itemstack.b();
        if (!(flag || ItemStack.c(itemstack, itemstack1) || this.am)) {
            Equipable equipable = Equipable.c_(itemstack1);
            if (!this.dM().y_() && !this.P_()) {
                if (!this.aU() && equipable != null && equipable.g() == enumitemslot && !silent) {
                    this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), equipable.as_(), this.db(), 1.0f, 1.0f);
                }
                if (this.a(enumitemslot)) {
                    this.a(equipable != null ? GameEvent.v : GameEvent.S);
                }
            }
        }
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.bz.a();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", this.ev());
        nbt.a("HurtTime", (short)this.aK);
        nbt.a("HurtByTimestamp", this.bV);
        nbt.a("DeathTime", (short)this.aM);
        nbt.a("AbsorptionAmount", this.fk());
        nbt.a("Attributes", this.eR().c());
        if (!this.bP.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.bP.values()) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbt.a(c, nbttaglist);
        }
        nbt.a("FallFlying", this.fw());
        this.fB().ifPresent(blockposition -> {
            nbt.a("SleepingX", blockposition.u());
            nbt.a("SleepingY", blockposition.v());
            nbt.a("SleepingZ", blockposition.w());
        });
        DataResult<NBTBase> dataresult = this.bz.a(DynamicOpsNBT.a);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("Brain", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        float absorptionAmount = nbt.j("AbsorptionAmount");
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.z(absorptionAmount);
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                b.error("Unknown friction state " + fs + " for " + this);
            }
        }
        if (nbt.b("Attributes", 9) && this.dM() != null && !this.dM().B) {
            this.eR().a(nbt.c("Attributes", 10));
        }
        if (nbt.b(c, 9)) {
            NBTTagList nbttaglist = nbt.c(c, 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(i2);
                MobEffect mobeffect = MobEffect.b(nbttagcompound1);
                if (mobeffect == null) continue;
                this.bP.put(mobeffect.c(), mobeffect);
            }
        }
        if (nbt.e("Bukkit.MaxHealth")) {
            NBTBase nbtbase = nbt.c("Bukkit.MaxHealth");
            if (nbtbase.b() == 5) {
                this.a(GenericAttributes.l).a(((NBTTagFloat)nbtbase).j());
            } else if (nbtbase.b() == 3) {
                this.a(GenericAttributes.l).a(((NBTTagInt)nbtbase).j());
            }
        }
        if (nbt.b("Health", 99)) {
            this.c(nbt.j("Health"));
        }
        this.aK = nbt.g("HurtTime");
        this.aM = nbt.g("DeathTime");
        this.bV = nbt.h("HurtByTimestamp");
        if (nbt.b("Team", 8)) {
            boolean flag;
            String s2 = nbt.l("Team");
            ScoreboardTeam scoreboardteam = this.dM().K().b(s2);
            if (!this.dM().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                scoreboardteam = null;
            }
            boolean bl = flag = scoreboardteam != null && this.dM().K().a(this.cx(), scoreboardteam);
            if (!flag) {
                b.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s2);
            }
        }
        if (nbt.q("FallFlying")) {
            this.b(7, true);
        }
        if (nbt.b("SleepingX", 99) && nbt.b("SleepingY", 99) && nbt.b("SleepingZ", 99)) {
            BlockPosition blockposition = new BlockPosition(nbt.h("SleepingX"), nbt.h("SleepingY"), nbt.h("SleepingZ"));
            if (this.dk().c(blockposition.u(), blockposition.v(), blockposition.w()) < 256.0) {
                this.g(blockposition);
                this.an.b(Entity.as, EntityPose.c);
                if (!this.am) {
                    this.a(blockposition);
                }
            }
        }
        if (nbt.b("Brain", 10)) {
            this.bz = this.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Brain")));
        }
    }

    protected void en() {
        Iterator<MobEffectList> iterator = this.bP.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                MobEffectList mobeffectlist = iterator.next();
                MobEffect mobeffect = this.bP.get(mobeffectlist);
                if (!mobeffect.a(this, () -> this.a(mobeffect, true, (Entity)null))) {
                    EntityPotionEffectEvent event;
                    if (this.dM().B || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.a(mobeffect);
                    continue;
                }
                if (mobeffect.d() % 600 != 0) continue;
                this.a(mobeffect, false, (Entity)null);
            }
        }
        catch (ConcurrentModificationException mobeffectlist) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect e2 : this.effectsToProcess) {
            if (e2.effect != null) {
                this.addEffect(e2.effect, e2.cause);
                continue;
            }
            this.removeEffect(e2.type, e2.cause);
        }
        this.effectsToProcess.clear();
        if (this.bT) {
            if (!this.dM().B) {
                this.J();
                this.u();
            }
            this.bT = false;
        }
        int i2 = this.an.b(bI);
        boolean flag = this.an.b(bJ);
        if (i2 > 0) {
            boolean flag1 = this.ce() ? this.ag.a(15) == 0 : this.ag.h();
            if (flag) {
                flag1 &= this.ag.a(5) == 0;
            }
            if (flag1 && i2 > 0) {
                double d0 = (double)(i2 >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i2 >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i2 >> 0 & 0xFF) / 255.0;
                this.dM().a(flag ? Particles.a : Particles.v, this.d(0.5), this.du(), this.g(0.5), d0, d1, d2);
            }
        }
    }

    protected void J() {
        if (this.bP.isEmpty()) {
            this.eq();
            this.j(false);
        } else {
            Collection<MobEffect> collection = this.bP.values();
            this.an.b(bJ, EntityLiving.c(collection));
            this.an.b(bI, PotionUtil.a(collection));
            this.j(this.a(MobEffects.n));
        }
    }

    private void u() {
        boolean flag = this.cd();
        if (this.i(6) != flag) {
            this.b(6, flag);
        }
    }

    public double B(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.bV()) {
            d0 *= 0.8;
        }
        if (this.ce()) {
            float f2 = this.eV();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.c(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.ai();
            if (entitytypes == EntityTypes.aK && itemstack.a(Items.ue) || entitytypes == EntityTypes.br && itemstack.a(Items.uh) || entitytypes == EntityTypes.ax && itemstack.a(Items.uk) || entitytypes == EntityTypes.ay && itemstack.a(Items.uk) || entitytypes == EntityTypes.v && itemstack.a(Items.ui)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving target) {
        return target instanceof EntityHuman && this.dM().ak() == EnumDifficulty.a ? false : target.eo();
    }

    public boolean a(EntityLiving entity, PathfinderTargetCondition predicate) {
        return predicate.a(this, entity);
    }

    public boolean eo() {
        return !this.cr() && this.ep();
    }

    public boolean ep() {
        return !this.P_() && this.bx();
    }

    public static boolean c(Collection<MobEffect> effects) {
        MobEffect mobeffect;
        Iterator<MobEffect> iterator = effects.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(mobeffect = iterator.next()).g() || mobeffect.f());
        return false;
    }

    protected void eq() {
        this.an.b(bJ, false);
        this.an.b(bI, 0);
    }

    public boolean er() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.dM().B) {
            return false;
        }
        Iterator<MobEffect> iterator = this.bP.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (!event.isCancelled()) {
                this.a(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public Collection<MobEffect> es() {
        return this.bP.values();
    }

    public Map<MobEffectList, MobEffect> et() {
        return this.bP;
    }

    public boolean a(MobEffectList effect) {
        return this.bP.containsKey(effect);
    }

    @Nullable
    public MobEffect b(MobEffectList effect) {
        return this.bP.get(effect);
    }

    public final boolean b(MobEffect effect) {
        return this.b(effect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect effect, @Nullable Entity source) {
        return this.addEffect(effect, source, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, entity, cause, true);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.c(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.bP.get(mobeffect.c());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if (fireEvent) {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override);
            override = event.isOverride();
            if (event.isCancelled()) {
                return false;
            }
        }
        if (mobeffect1 == null) {
            this.bP.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            flag = true;
        } else if (override) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.a(this);
        return flag;
    }

    public boolean c(MobEffect effect) {
        MobEffectList mobeffectlist;
        return this.eS() != EnumMonsterType.b || (mobeffectlist = effect.c()) != MobEffects.j && mobeffectlist != MobEffects.s || !this.dM().paperConfig().entities.mobEffects.undeadImmuneToCertainEffects;
    }

    public void c(MobEffect effect, @Nullable Entity source) {
        if (this.c(effect)) {
            MobEffect mobeffect1 = this.bP.put(effect.c(), effect);
            if (mobeffect1 == null) {
                this.a(effect, source);
            } else {
                this.a(effect, true, source);
            }
        }
    }

    public boolean eu() {
        return this.eS() == EnumMonsterType.b;
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList type) {
        return this.c(type, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffectlist, cause));
            return null;
        }
        MobEffect effect = this.bP.get(mobeffectlist);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bP.remove(mobeffectlist);
    }

    public boolean d(MobEffectList type) {
        return this.removeEffect(type, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.c(mobeffectlist, cause);
        if (mobeffect != null) {
            this.a(mobeffect);
            return true;
        }
        return false;
    }

    protected void a(MobEffect effect, @Nullable Entity source) {
        this.bT = true;
        if (!this.dM().B) {
            effect.c().a(this.eR(), effect.e());
            this.d(effect);
        }
    }

    public void d(MobEffect effect) {
        for (Entity entity : this.cP()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.c.b(new PacketPlayOutEntityEffect(this.aj(), effect));
        }
    }

    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable Entity source) {
        this.bT = true;
        if (reapplyEffect && !this.dM().B) {
            MobEffectList mobeffectlist = effect.c();
            mobeffectlist.a(this.eR());
            mobeffectlist.a(this.eR(), effect.e());
            this.y();
        }
        if (!this.dM().B) {
            this.d(effect);
        }
    }

    protected void a(MobEffect effect) {
        this.bT = true;
        if (!this.dM().B) {
            effect.c().a(this.eR());
            this.y();
            for (Entity entity : this.cP()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.c.b(new PacketPlayOutRemoveEntityEffect(this.aj(), effect.c()));
            }
        }
    }

    private void y() {
        for (AttributeModifiable attributemodifiable : this.eR().a()) {
            this.d(attributemodifiable.a());
        }
    }

    private void d(AttributeBase attribute) {
        if (attribute == GenericAttributes.l) {
            float f2 = this.eM();
            if (this.ev() > f2) {
                this.c(f2);
            }
        } else if (attribute == GenericAttributes.k) {
            float f3 = this.eN();
            if (this.fk() > f3) {
                this.y(f3);
            }
        }
    }

    public void b(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(f2, regainReason, false);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float f1 = this.ev();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason, isFastRegen);
            if (this.valid) {
                this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.c((float)((double)this.ev() + event.getAmount()));
            }
        }
    }

    public float ev() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.an.b(bH).floatValue();
    }

    public void c(float health) {
        if (Float.isNaN(health)) {
            health = this.eM();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.cy() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.an.b(bH, Float.valueOf(MathHelper.a(health, 0.0f, this.eM())));
    }

    public boolean ew() {
        return this.ev() <= 0.0f;
    }

    public boolean couldPossiblyBeHurt(float amount) {
        return !((float)this.al > (float)this.aR / 2.0f) || !(amount <= this.bi);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag2;
        if (this.b(source)) {
            return false;
        }
        if (this.dM().B) {
            return false;
        }
        if (this.dH() || this.ba || this.ev() <= 0.0f) {
            return false;
        }
        if (source.a(DamageTypeTags.j) && this.a(MobEffects.l)) {
            return false;
        }
        if (this.fD() && !this.dM().B) {
            this.fE();
        }
        this.bb = 0;
        float f1 = amount;
        boolean flag = amount > 0.0f && this.f(source);
        float f2 = 0.0f;
        if (source.a(DamageTypeTags.p) && this.ai().a(TagsEntity.l)) {
            amount *= 5.0f;
        }
        this.aQ.a(1.5f);
        boolean flag1 = true;
        if ((float)this.al > (float)this.aR / 2.0f && !source.a(DamageTypeTags.f)) {
            if (amount <= this.bi) {
                return false;
            }
            if (!this.actuallyHurt(source, amount - this.bi)) {
                return false;
            }
            this.bi = amount;
            flag1 = false;
        } else {
            if (!this.actuallyHurt(source, amount)) {
                return false;
            }
            this.bi = amount;
            this.al = this.aR;
            this.aK = this.aL = 10;
        }
        Entity entity1 = source.d();
        if (entity1 != null) {
            EntityWolf entitywolf;
            if (entity1 instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity1;
                if (!source.a(DamageTypeTags.r)) {
                    this.a(entityliving1);
                }
            }
            if (entity1 instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity1;
                this.aZ = 100;
                this.aY = entityhuman;
            } else if (entity1 instanceof EntityWolf && (entitywolf = (EntityWolf)entity1).u()) {
                EntityHuman entityhuman1;
                this.aZ = 100;
                EntityLiving entityliving2 = entitywolf.R_();
                this.aY = entityliving2 instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entityliving2) : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.dM().a((Entity)this, (byte)29);
            } else {
                this.dM().a((Entity)this, source);
            }
            if (!(source.a(DamageTypeTags.s) || flag && !(amount > 0.0f))) {
                this.bq();
            }
            if (entity1 != null && !source.a(DamageTypeTags.A)) {
                double d1;
                boolean far = entity1.f(this) > 40000.0;
                double d0 = far ? Math.random() - Math.random() : entity1.dr() - this.dr();
                double d2 = d1 = far ? Math.random() - Math.random() : entity1.dx() - this.dx();
                while (d0 * d0 + d1 * d1 < 1.0E-4) {
                    d0 = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.knockback(0.4f, d0, d1, entity1, entity1 == null ? EntityKnockbackEvent.KnockbackCause.DAMAGE : EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (this.ew()) {
            if (!this.h(source)) {
                this.silentDeath = !flag1;
                this.a(source);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.e(source);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            this.cd = source;
            this.ce = this.dM().X();
        }
        if (this instanceof EntityPlayer) {
            CriterionTriggers.i.a((EntityPlayer)this, source, f1, amount, flag);
            if (f2 > 0.0f && f2 < 3.4028235E37f) {
                ((EntityPlayer)this).a(StatisticList.K, Math.round(f2 * 10.0f));
            }
        }
        if (entity1 instanceof EntityPlayer) {
            CriterionTriggers.h.a((EntityPlayer)entity1, this, source, f1, amount, flag);
        }
        return flag2;
    }

    protected void d(EntityLiving attacker) {
        attacker.e(this);
    }

    protected void e(EntityLiving target) {
        target.knockback(0.5, target.dr() - this.dr(), target.dx() - this.dx(), this, EntityKnockbackEvent.KnockbackCause.SHIELD_BLOCK);
    }

    private boolean h(DamageSource source) {
        if (source.a(DamageTypeTags.e)) {
            return false;
        }
        ItemStack itemstack = null;
        EnumHand[] aenumhand = EnumHand.values();
        int i2 = aenumhand.length;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.f;
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumHand enumhand = aenumhand[j2];
            itemstack1 = this.b(enumhand);
            if (!itemstack1.a(Items.vm)) continue;
            hand = enumhand;
            itemstack = itemstack1.p();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot, true);
        event.setCancelled(itemstack == null);
        this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.b() && itemstack != null && event.isShrink()) {
                itemstack1.h(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(Items.vm));
                CriterionTriggers.C.a(entityplayer, itemstack);
                this.a(GameEvent.C);
            }
            this.c(1.0f);
            this.removeAllEffects(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.j, 900, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.v, 100, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.l, 800, 0), EntityPotionEffectEvent.Cause.TOTEM);
            this.dM().a((Entity)this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Nullable
    public DamageSource ex() {
        if (this.dM().X() - this.ce > 40L) {
            this.cd = null;
        }
        return this.cd;
    }

    protected void e(DamageSource source) {
        SoundEffect soundeffect = this.d(source);
        if (soundeffect != null) {
            this.a(soundeffect, this.eW(), this.eX());
        }
    }

    public boolean f(DamageSource source) {
        Vec3D vec3d;
        EntityArrow entityarrow;
        Entity entity = source.c();
        boolean flag = false;
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).E() > 0) {
            flag = true;
        }
        if (!source.a(DamageTypeTags.d) && this.fu() && !flag && (vec3d = source.h()) != null) {
            Vec3D vec3d1 = this.b(0.0f, this.cp());
            Vec3D vec3d2 = vec3d.a(this.dk());
            vec3d2 = new Vec3D(vec3d2.c, 0.0, vec3d2.e).d();
            return vec3d2.b(vec3d1) < 0.0;
        }
        return false;
    }

    private void i(ItemStack stack) {
        if (!stack.b()) {
            if (!this.aU()) {
                this.dM().a(this.dr(), this.dt(), this.dx(), SoundEffects.mN, this.db(), 0.8f, 0.8f + this.dM().z.i() * 0.4f, false);
            }
            this.a(stack, 5);
        }
    }

    public void a(DamageSource damageSource) {
        if (!this.dH() && !this.ba) {
            Entity entity = damageSource.d();
            EntityLiving entityliving = this.eL();
            this.ba = true;
            net.minecraft.world.level.World world = this.dM();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EntityDeathEvent deathEvent = this.dropAllDeathLoot(damageSource);
                if (deathEvent == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.f);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.fD()) {
                        this.fE();
                    }
                    if (!this.dM().B && this.ae() && SpigotConfig.logNamedDeaths) {
                        b.info("Named entity {} died: {}", (Object)this, (Object)this.eK().a().getString());
                    }
                    this.eK().c();
                    if (entity != null) {
                        entity.a((WorldServer)this.dM(), this);
                    }
                    this.a(GameEvent.p);
                } else {
                    this.ba = false;
                    this.c((float)deathEvent.getReviveHealth());
                }
                this.f(entityliving);
            }
            if (this.ba) {
                this.dM().a((Entity)this, (byte)3);
                this.b(EntityPose.h);
            }
        }
    }

    protected void f(@Nullable EntityLiving adversary) {
        if (!this.dM().B) {
            boolean flag = false;
            if (this.ba && adversary instanceof EntityWither) {
                if (this.dM().Z().b(GameRules.c)) {
                    BlockPosition blockposition = this.dm();
                    IBlockData iblockdata = Blocks.cd.o();
                    if (this.dM().a_(blockposition).i() && iblockdata.a((IWorldReader)this.dM(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.dM(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.dM(), this.dr(), this.dt(), this.dx(), new ItemStack(Items.dv));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.dM().b(entityitem);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(DamageSource source) {
        Entity entity = source.d();
        int i2 = entity instanceof EntityHuman ? EnchantmentManager.h((EntityLiving)entity) : 0;
        boolean flag = this.aZ > 0;
        this.ey();
        if (this.ed() && this.dM().Z().b(GameRules.f)) {
            this.a(source, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(source, i2, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.drops, () -> {
            EntityLiving entityliving = this.eL();
            if (this.bh >= 0 && entityliving != null) {
                entityliving.a((Entity)this, this.bh, source);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList();
        this.ez();
        return deathEvent;
    }

    protected void ey() {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward() {
        if (this.dM() instanceof WorldServer && !this.eD() && (this.ef() || this.aZ > 0 && this.ec() && this.dM().Z().b(GameRules.f))) {
            int i2 = this.ee();
            return i2;
        }
        return 0;
    }

    protected void ez() {
        if (!(this instanceof EntityEnderDragon)) {
            EntityLiving attacker = this.aY != null ? this.aY : this.bU;
            EntityExperienceOrb.award((WorldServer)this.dM(), this.dk(), this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, attacker, this);
            this.expToDrop = 0;
        }
    }

    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
    }

    public MinecraftKey eA() {
        return this.ai().j();
    }

    public long eB() {
        return 0L;
    }

    protected void a(DamageSource damageSource, boolean causedByPlayer) {
        MinecraftKey minecraftkey = this.eA();
        LootTable loottable = this.dM().o().aJ().getLootTable(minecraftkey);
        LootParams.a lootparams_a = new LootParams.a((WorldServer)this.dM()).a(LootContextParameters.a, this).a(LootContextParameters.f, this.dk()).a(LootContextParameters.c, damageSource).b(LootContextParameters.d, damageSource.d()).b(LootContextParameters.e, damageSource.c());
        if (causedByPlayer && this.aY != null) {
            lootparams_a = lootparams_a.a(LootContextParameters.b, this.aY).a(this.aY.go());
        }
        LootParams lootparams = lootparams_a.a(LootContextParameterSets.g);
        loottable.a(lootparams, this.eB(), this::b);
    }

    public void q(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null, EntityKnockbackEvent.KnockbackCause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, @Nullable Entity attacker, EntityKnockbackEvent.KnockbackCause cause) {
        Vec3D vec3d = this.dp();
        Vec3D vec3d1 = new Vec3D(d1, 0.0, d2).d().a(d0 *= 1.0 - this.b(GenericAttributes.i));
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, cause, d0, vec3d1, vec3d.c / 2.0 - vec3d1.c, this.aC() ? Math.min(0.4, vec3d.d / 2.0 + d0) : vec3d.d, vec3d.e / 2.0 - vec3d1.e);
        if (event.isCancelled()) {
            return;
        }
        Vector currentMovement = this.getBukkitEntity().getVelocity();
        Vector resultingMovement = event.getFinalKnockback();
        Vector deltaMovement = resultingMovement.clone().subtract(currentMovement);
        if (attacker != null) {
            EntityKnockbackByEntityEvent knockbackEvent = new EntityKnockbackByEntityEvent((LivingEntity)this.getBukkitLivingEntity(), (org.bukkit.entity.Entity)attacker.getBukkitEntity(), (float)event.getForce(), deltaMovement);
            if (!knockbackEvent.callEvent()) {
                return;
            }
            resultingMovement = currentMovement.add(knockbackEvent.getAcceleration());
        }
        this.au = true;
        this.o(resultingMovement.getX(), resultingMovement.getY(), resultingMovement.getZ());
    }

    public void a(double deltaX, double deltaZ) {
    }

    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.jC;
    }

    @Nullable
    public SoundEffect n_() {
        return SoundEffects.jx;
    }

    private SoundEffect d(int distance) {
        return distance > 4 ? this.eG().b() : this.eG().a();
    }

    public void eC() {
        this.ch = true;
    }

    public boolean eD() {
        return this.ch;
    }

    public float eE() {
        return 0.0f;
    }

    protected AxisAlignedBB eF() {
        AxisAlignedBB axisalignedbb = this.cH();
        Entity entity = this.cZ();
        if (entity != null) {
            Vec3D vec3d = entity.m(this);
            return axisalignedbb.b(Math.max(vec3d.d, axisalignedbb.b));
        }
        return axisalignedbb;
    }

    public a eG() {
        return new a(SoundEffects.jD, SoundEffects.jv);
    }

    protected SoundEffect c(ItemStack stack) {
        return stack.N();
    }

    public SoundEffect d(ItemStack stack) {
        return stack.O();
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.d(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.n_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.d(fallHeight);
    }

    public SoundEffect getDrinkingSound0(ItemStack itemstack) {
        return this.c(itemstack);
    }

    public SoundEffect getEatingSound0(ItemStack itemstack) {
        return this.d(itemstack);
    }

    public Optional<BlockPosition> eH() {
        return this.cc;
    }

    public boolean onClimableCached() {
        if (!LeavesConfig.cacheClimbCheck) {
            return this.e_();
        }
        if (!this.dm().equals(this.lastClimbingPosition)) {
            this.cachedOnClimable = this.e_();
            this.lastClimbingPosition = this.dm();
        }
        return this.cachedOnClimable;
    }

    public boolean e_() {
        if (this.P_()) {
            return false;
        }
        BlockPosition blockposition = this.dm();
        IBlockData iblockdata = this.dn();
        if (iblockdata.a(TagsBlock.aO)) {
            this.cc = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.cc = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        IBlockData iblockdata1;
        return state.c(BlockTrapdoor.b) != false && (iblockdata1 = this.dM().a_(pos.d())).a(Blocks.cO) && iblockdata1.c(BlockLadder.b) == state.c(BlockFacingHorizontal.aE);
    }

    @Override
    public boolean bx() {
        return !this.dH() && this.ev() > 0.0f;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        int i2 = this.d(fallDistance, damageMultiplier);
        if (i2 > 0) {
            if (!this.a(damageSource, (float)i2)) {
                return true;
            }
            this.a(this.d(i2), 1.0f, 1.0f);
            this.eI();
            return true;
        }
        return flag;
    }

    protected int d(float fallDistance, float damageMultiplier) {
        if (this.ai().a(TagsEntity.o)) {
            return 0;
        }
        MobEffect mobeffect = this.b(MobEffects.h);
        float f2 = mobeffect == null ? 0.0f : (float)(mobeffect.e() + 1);
        return MathHelper.f((fallDistance - 3.0f - f2) * damageMultiplier);
    }

    protected void eI() {
        if (!this.aU()) {
            int i2 = MathHelper.a(this.dr());
            int j2 = MathHelper.a(this.dt() - (double)0.2f);
            int k2 = MathHelper.a(this.dx());
            IBlockData iblockdata = this.dM().a_(new BlockPosition(i2, j2, k2));
            if (!iblockdata.i()) {
                SoundEffectType soundeffecttype = iblockdata.w();
                this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
            }
        }
    }

    @Override
    public void m(float yaw) {
        this.aK = this.aL = 10;
    }

    public int eJ() {
        return MathHelper.a(this.b(GenericAttributes.a));
    }

    protected void b(DamageSource source, float amount) {
    }

    protected void c(DamageSource source, float amount) {
    }

    protected void u(float amount) {
    }

    protected float d(DamageSource source, float amount) {
        if (!source.a(DamageTypeTags.c)) {
            amount = CombatMath.a(amount, this.eJ(), (float)this.b(GenericAttributes.b));
        }
        return amount;
    }

    protected float e(DamageSource source, float amount) {
        if (source.a(DamageTypeTags.g)) {
            return amount;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        if (source.a(DamageTypeTags.i)) {
            return amount;
        }
        int i2 = EnchantmentManager.a(this.bL(), source);
        if (i2 > 0) {
            amount = CombatMath.a(amount, i2);
        }
        return amount;
    }

    protected boolean actuallyHurt(final DamageSource damagesource, float f2) {
        if (!this.b(damagesource)) {
            Entity entity;
            float f3;
            boolean human = this instanceof EntityHuman;
            float originalDamage = f2;
            Function<Double, Double> hardHat = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.c(EnumItemSlot.f).b()) {
                        return -(f2 - f2 * 0.75);
                    }
                    return -0.0;
                }
            };
            float hardHatModifier = ((Double)hardHat.apply((Object)f2)).floatValue();
            Function<Double, Double> blocking = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(EntityLiving.this.f(damagesource) ? f2 : 0.0);
                }
            };
            float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
            Function<Double, Double> armor = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.d(damagesource, f2.floatValue()));
                }
            };
            float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
            Function<Double, Double> resistance = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (!damagesource.a(DamageTypeTags.g) && EntityLiving.this.a(MobEffects.k) && !damagesource.a(DamageTypeTags.h)) {
                        int i2 = (EntityLiving.this.b(MobEffects.k).e() + 1) * 5;
                        int j2 = 25 - i2;
                        float f1 = f2.floatValue() * (float)j2;
                        return -(f2 - (double)(f1 / 25.0f));
                    }
                    return -0.0;
                }
            };
            float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
            Function<Double, Double> magic = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
                }
            };
            float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
            Function<Double, Double> absorption = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.fk(), 0.0), 0.0);
                }
            };
            float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
            EntityDamageEvent event = CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, hardHat, blocking, armor, resistance, magic, absorption);
            if (damagesource.d() instanceof EntityHuman) {
                if (damagesource.d() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damagesource.d();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.B(0.0f)).callEvent()) {
                        player.gm();
                    }
                } else {
                    ((EntityHuman)damagesource.d()).gm();
                }
            }
            if (event.isCancelled()) {
                return false;
            }
            f2 = (float)event.getFinalDamage();
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.c(EnumItemSlot.f).b()) {
                this.c(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.c)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.b(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.dM().a((Entity)this, (byte)29);
                this.u((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity2 = damagesource.c();
                if (entity2 instanceof EntityLiving && entity2.f(this) <= 40000.0) {
                    this.d((EntityLiving)entity2);
                }
            }
            absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.y(Math.max(this.fk() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.L, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.H, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(f2 * 10.0f));
                    }
                }
                this.eK().a(damagesource, f2);
                this.c(this.ev() - f2);
                if (!human) {
                    this.y(this.fk() - f2);
                }
                this.a(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damagesource, originalDamage, f2, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damagesource.d(), this, damagesource, originalDamage, f2, true);
                }
                return false;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker eK() {
        return this.bO;
    }

    @Nullable
    public EntityLiving eL() {
        return this.aY != null ? this.aY : (this.bU != null ? this.bU : null);
    }

    public final float eM() {
        return (float)this.b(GenericAttributes.l);
    }

    public final float eN() {
        return (float)this.b(GenericAttributes.k);
    }

    public final int eO() {
        return this.an.b(bK);
    }

    public final void p(int stuckArrowCount) {
        this.setArrowCount(stuckArrowCount, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.eO(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.an.b(bK, event.getNewAmount());
    }

    public final int eP() {
        return this.an.b(bL);
    }

    public final void q(int stingerCount) {
        this.an.b(bL, stingerCount);
    }

    private int B() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.a(MobEffects.d) ? 6 + (1 + this.b(MobEffects.d).e()) * 2 : 6);
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean fromServerPlayer) {
        if (!this.aF || this.aH >= this.B() / 2 || this.aH < 0) {
            this.aH = -1;
            this.aF = true;
            this.aG = hand;
            if (this.dM() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.dM()).l();
                if (fromServerPlayer) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damageSource) {
        this.aQ.a(1.5f);
        this.al = 20;
        this.aK = this.aL = 10;
        SoundEffect soundeffect = this.d(damageSource);
        if (soundeffect != null) {
            this.a(soundeffect, this.eW(), (this.ag.i() - this.ag.i()) * 0.2f + 1.0f);
        }
        this.a(this.dN().n(), 0.0f);
        this.cd = damageSource;
        this.ce = this.dM().X();
    }

    @Override
    public void b(byte status) {
        switch (status) {
            case 3: {
                SoundEffect soundeffect = this.n_();
                if (soundeffect != null) {
                    this.a(soundeffect, this.eW(), (this.ag.i() - this.ag.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.c(0.0f);
                this.a(this.dN().n());
                break;
            }
            case 29: {
                this.a(SoundEffects.vG, 1.0f, 0.8f + this.dM().z.i() * 0.4f);
                break;
            }
            case 30: {
                this.a(SoundEffects.vH, 0.8f, 0.8f + this.dM().z.i() * 0.4f);
                break;
            }
            case 46: {
                boolean flag = true;
                for (int i2 = 0; i2 < 128; ++i2) {
                    double d0 = (double)i2 / 127.0;
                    float f2 = (this.ag.i() - 0.5f) * 0.2f;
                    float f1 = (this.ag.i() - 0.5f) * 0.2f;
                    float f22 = (this.ag.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.K, this.dr()) + (this.ag.j() - 0.5) * (double)this.dg() * 2.0;
                    double d2 = MathHelper.d(d0, this.L, this.dt()) + this.ag.j() * (double)this.dh();
                    double d3 = MathHelper.d(d0, this.M, this.dx()) + (this.ag.j() - 0.5) * (double)this.dg() * 2.0;
                    this.dM().a(Particles.Z, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                return;
            }
            case 47: {
                this.i(this.c(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.i(this.c(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.i(this.c(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.i(this.c(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.i(this.c(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.i(this.c(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.D();
                break;
            }
            case 60: {
                this.C();
                break;
            }
            default: {
                super.b(status);
            }
        }
    }

    private void C() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.ag.k() * 0.02;
            double d1 = this.ag.k() * 0.02;
            double d2 = this.ag.k() * 0.02;
            this.dM().a(Particles.Y, this.d(1.0), this.du(), this.g(1.0), d0, d1, d2);
        }
    }

    private void D() {
        ItemStack itemstack = this.c(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.c(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void aB() {
        this.a(this.dN().m(), 4.0f);
    }

    protected void eQ() {
        int i2 = this.B();
        if (this.aF) {
            ++this.aH;
            if (this.aH >= i2) {
                this.aH = 0;
                this.aF = false;
            }
        } else {
            this.aH = 0;
        }
        this.aO = (float)this.aH / (float)i2;
    }

    @Nullable
    public AttributeModifiable a(AttributeBase attribute) {
        return this.eR().a(attribute);
    }

    public double a(Holder<AttributeBase> attribute) {
        return this.b(attribute.a());
    }

    public double b(AttributeBase attribute) {
        return this.eR().c(attribute);
    }

    public double b(Holder<AttributeBase> attribute) {
        return this.c(attribute.a());
    }

    public double c(AttributeBase attribute) {
        return this.eR().d(attribute);
    }

    public AttributeMapBase eR() {
        return this.bN;
    }

    public EnumMonsterType eS() {
        return EnumMonsterType.a;
    }

    public ItemStack eT() {
        return this.c(EnumItemSlot.a);
    }

    public ItemStack eU() {
        return this.c(EnumItemSlot.b);
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.eT()) || predicate.test(this.eU());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.c(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.c(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean b(EnumItemSlot slot) {
        return !this.c(slot).b();
    }

    @Override
    public abstract Iterable<ItemStack> bL();

    public abstract ItemStack c(EnumItemSlot var1);

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.a(enumitemslot, itemstack);
    }

    @Override
    public abstract void a(EnumItemSlot var1, ItemStack var2);

    protected void e(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.v();
        if (nbttagcompound != null) {
            stack.d().b(nbttagcompound);
        }
    }

    public float eV() {
        Iterable<ItemStack> iterable = this.bL();
        int i2 = 0;
        int j2 = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.b()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void g(boolean sprinting) {
        super.g(sprinting);
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.m);
        attributemodifiable.b(bA.a());
        if (sprinting) {
            attributemodifiable.b(bA);
        }
    }

    public float eW() {
        return 1.0f;
    }

    public float eX() {
        return this.o_() ? (this.ag.i() - this.ag.i()) * 0.2f + 1.5f : (this.ag.i() - this.ag.i()) * 0.2f + 1.0f;
    }

    protected boolean eY() {
        return this.ew();
    }

    @Override
    public void g(Entity entity) {
        if (!this.fD()) {
            super.g(entity);
        }
    }

    private void a(Entity vehicle) {
        Vec3D vec3d;
        if (this.dH()) {
            vec3d = this.dk();
        } else if (!vehicle.dH() && !this.dM().a_(vehicle.dm()).a(TagsBlock.aI)) {
            vec3d = vehicle.b(this);
        } else {
            double d0 = Math.max(this.dt(), vehicle.dt());
            vec3d = new Vec3D(this.dr(), d0, this.dx());
        }
        this.a(vec3d.c, vec3d.d, vec3d.e);
    }

    @Override
    public boolean cC() {
        return this.cB();
    }

    protected float eZ() {
        return 0.42f * this.aK() + this.fa();
    }

    public float fa() {
        return this.a(MobEffects.h) ? 0.1f * ((float)this.b(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    protected void fb() {
        Vec3D vec3d = this.dp();
        long time = System.nanoTime();
        boolean canCrit = true;
        if (this instanceof EntityHuman) {
            canCrit = false;
            if (time - this.lastJumpTime > 250000000L) {
                this.lastJumpTime = time;
                canCrit = true;
            }
        }
        this.o(vec3d.c, this.eZ(), vec3d.e);
        if (this.bY()) {
            float f2 = this.dC() * ((float)Math.PI / 180);
            if (canCrit) {
                this.g(this.dp().b(-MathHelper.a(f2) * 0.2f, 0.0, MathHelper.b(f2) * 0.2f));
            }
        }
        this.au = true;
    }

    protected void fc() {
        this.g(this.dp().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluid) {
        this.g(this.dp().b(0.0, 0.04f, 0.0));
    }

    protected float fd() {
        return 0.8f;
    }

    public boolean a(Fluid state) {
        return false;
    }

    public void a(Vec3D movementInput) {
        if (this.cX()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = this.dp().d <= 0.0;
            if (flag && this.a(MobEffects.B)) {
                d0 = 0.01;
            }
            Fluid fluid = this.dM().b_(this.dm());
            if (this.aZ() && this.ea() && !this.a(fluid)) {
                double d1 = this.dt();
                float f2 = this.bY() ? 0.9f : this.fd();
                float f1 = 0.02f;
                float f22 = EnchantmentManager.f(this);
                if (f22 > 3.0f) {
                    f22 = 3.0f;
                }
                if (!this.aC()) {
                    f22 *= 0.5f;
                }
                if (f22 > 0.0f) {
                    f2 += (0.54600006f - f2) * f22 / 3.0f;
                    f1 += (this.ff() - f1) * f22 / 3.0f;
                }
                if (this.a(MobEffects.D)) {
                    f2 = 0.96f;
                }
                this.a(f1, movementInput);
                this.a(EnumMoveType.a, this.dp());
                Vec3D vec3d1 = this.dp();
                if (this.P && this.e_()) {
                    vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
                }
                this.g(vec3d1.d(f2, 0.8f, f2));
                Vec3D vec3d2 = this.a(d0, flag, this.dp());
                this.g(vec3d2);
                if (this.P && this.g(vec3d2.c, vec3d2.d + (double)0.6f - this.dt() + d1, vec3d2.e)) {
                    this.o(vec3d2.c, 0.3f, vec3d2.e);
                }
            } else if (this.bn() && this.ea() && !this.a(fluid)) {
                Vec3D vec3d3;
                double d1 = this.dt();
                this.a(0.02f, movementInput);
                this.a(EnumMoveType.a, this.dp());
                if (this.b(TagsFluid.b) <= this.df()) {
                    this.g(this.dp().d(0.5, 0.8f, 0.5));
                    vec3d3 = this.a(d0, flag, this.dp());
                    this.g(vec3d3);
                } else {
                    this.g(this.dp().a(0.5));
                }
                if (!this.aV()) {
                    this.g(this.dp().b(0.0, -d0 / 4.0, 0.0));
                }
                vec3d3 = this.dp();
                if (this.P && this.g(vec3d3.c, vec3d3.d + (double)0.6f - this.dt() + d1, vec3d3.e)) {
                    this.o(vec3d3.c, 0.3f, vec3d3.e);
                }
            } else if (this.fw()) {
                double d7;
                float f3;
                double d6;
                this.cn();
                Vec3D vec3d4 = this.dp();
                Vec3D vec3d5 = this.bF();
                float f4 = this.dE() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.c * vec3d5.c + vec3d5.e * vec3d5.e);
                double d3 = vec3d4.h();
                double d4 = vec3d5.f();
                double d5 = Math.cos(f4);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3d4 = this.dp().b(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3d4.d < 0.0 && d2 > 0.0) {
                    d6 = vec3d4.d * -0.1 * d5;
                    vec3d4 = vec3d4.b(vec3d5.c * d6 / d2, d6, vec3d5.e * d6 / d2);
                }
                if (f4 < 0.0f && d2 > 0.0) {
                    d6 = d3 * (double)(-MathHelper.a(f4)) * 0.04;
                    vec3d4 = vec3d4.b(-vec3d5.c * d6 / d2, d6 * 3.2, -vec3d5.e * d6 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.b((vec3d5.c / d2 * d3 - vec3d4.c) * 0.1, 0.0, (vec3d5.e / d2 * d3 - vec3d4.e) * 0.1);
                }
                this.g(vec3d4.d(0.99f, 0.98f, 0.99f));
                this.a(EnumMoveType.a, this.dp());
                if (this.P && !this.dM().B && (f3 = (float)((d7 = d3 - (d6 = this.dp().h())) * 10.0 - 3.0)) > 0.0f) {
                    this.a(this.d((int)f3), 1.0f, 1.0f);
                    this.a(this.dN().l(), f3);
                }
                if (this.aC() && !this.dM().B && this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
            } else {
                BlockPosition blockposition = this.aI();
                float f4 = this.dM().a_(blockposition).b().i();
                float f5 = this.aC() ? f4 * 0.91f : 0.91f;
                Vec3D vec3d6 = this.a(movementInput, f4);
                double d8 = vec3d6.d;
                if (this.a(MobEffects.y)) {
                    d8 += (0.05 * (double)(this.b(MobEffects.y).e() + 1) - vec3d6.d) * 0.2;
                } else if (this.dM().B && !this.dM().B(blockposition)) {
                    d8 = this.dt() > (double)this.dM().J_() ? -0.1 : 0.0;
                } else if (!this.aV()) {
                    d8 -= d0;
                }
                if (this.em()) {
                    this.o(vec3d6.c, d8, vec3d6.e);
                } else {
                    this.o(vec3d6.c * (double)f5, d8 * (double)0.98f, vec3d6.e * (double)f5);
                }
            }
        }
        this.q(this instanceof EntityBird);
    }

    private void c(EntityHuman controllingPlayer, Vec3D movementInput) {
        Vec3D vec3d1 = this.b(controllingPlayer, movementInput);
        this.a(controllingPlayer, vec3d1);
        if (this.cX()) {
            this.w(this.e(controllingPlayer));
            this.a(vec3d1);
        } else {
            this.q(false);
            this.g(Vec3D.b);
            this.aD();
        }
    }

    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
    }

    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        return movementInput;
    }

    protected float e(EntityHuman controllingPlayer) {
        return this.ff();
    }

    public void q(boolean flutter) {
        float f2 = (float)MathHelper.g(this.dr() - this.K, flutter ? this.dt() - this.L : 0.0, this.dx() - this.M);
        this.v(f2);
    }

    protected void v(float posDelta) {
        float f1 = Math.min(posDelta * 4.0f, 1.0f);
        this.aQ.a(f1, 0.4f);
    }

    public Vec3D a(Vec3D movementInput, float slipperiness) {
        this.a(this.A(slipperiness), movementInput);
        this.g(this.j(this.dp()));
        this.a(EnumMoveType.a, this.dp());
        Vec3D vec3d1 = this.dp();
        if ((this.P || this.bj) && (this.e_() || this.dn().a(Blocks.qP) && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
        }
        return vec3d1;
    }

    public Vec3D a(double gravity, boolean falling, Vec3D motion) {
        if (!this.aV() && !this.bY()) {
            double d1 = falling && Math.abs(motion.d - 0.005) >= 0.003 && Math.abs(motion.d - gravity / 16.0) < 0.003 ? -0.003 : motion.d - gravity / 16.0;
            return new Vec3D(motion.c, d1, motion.e);
        }
        return motion;
    }

    private Vec3D j(Vec3D motion) {
        if (this.e_()) {
            this.n();
            float f2 = 0.15f;
            double d0 = MathHelper.a(motion.c, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(motion.e, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(motion.d, (double)-0.15f);
            if (d2 < 0.0 && !this.dn().a(Blocks.nS) && this.fv() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            motion = new Vec3D(d0, d2, d1);
        }
        return motion;
    }

    private float A(float slipperiness) {
        return this.aC() ? this.ff() * (0.21600002f / (slipperiness * slipperiness * slipperiness)) : this.fe();
    }

    protected float fe() {
        return this.cN() instanceof EntityHuman ? this.ff() * 0.1f : 0.02f;
    }

    public float ff() {
        return this.bY;
    }

    public void w(float movementSpeed) {
        this.bY = movementSpeed;
    }

    public boolean C(Entity target) {
        this.A(target);
        return false;
    }

    @Override
    public void l() {
        super.l();
        this.I();
        this.M();
        if (!this.dM().B) {
            int j2;
            int i2 = this.eO();
            if (i2 > 0) {
                if (this.aI <= 0) {
                    this.aI = 20 * (30 - i2);
                }
                --this.aI;
                if (this.aI <= 0) {
                    this.p(i2 - 1);
                }
            }
            if ((j2 = this.eP()) > 0) {
                if (this.aJ <= 0) {
                    this.aJ = 20 * (30 - j2);
                }
                --this.aJ;
                if (this.aJ <= 0) {
                    this.q(j2 - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.ah % 20 == 0) {
                this.eK().c();
            }
            if (this.fD() && !this.N()) {
                this.fE();
            }
        }
        if (!this.dH()) {
            this.d_();
        }
        double d0 = this.dr() - this.K;
        double d1 = this.dx() - this.M;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.aU;
        float f22 = 0.0f;
        this.bc = this.bd;
        float f3 = 0.0f;
        if (f2 > 0.0025000002f) {
            f3 = 1.0f;
            f22 = (float)Math.sqrt(f2) * 3.0f;
            float f4 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f5 = MathHelper.e(MathHelper.g(this.dC()) - f4);
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.aO > 0.0f) {
            f1 = this.dC();
        }
        if (!this.aC()) {
            f3 = 0.0f;
        }
        this.bd += (f3 - this.bd) * 0.3f;
        this.dM().af().a("headTurn");
        f22 = this.e(f1, f22);
        this.dM().af().c();
        this.dM().af().a("rangeChecks");
        this.N += (float)Math.round((this.dC() - this.N) / 360.0f) * 360.0f;
        this.aV += (float)Math.round((this.aU - this.aV) / 360.0f) * 360.0f;
        this.O += (float)Math.round((this.dE() - this.O) / 360.0f) * 360.0f;
        this.aX += (float)Math.round((this.aW - this.aX) / 360.0f) * 360.0f;
        this.dM().af().c();
        this.be += f22;
        this.bx = this.fw() ? ++this.bx : 0;
        if (this.fD()) {
            this.s(0.0f);
        }
        this.y();
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EnumItemSlot, ItemStack> map = this.G();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> G() {
        EnumMap map = null;
        block4: for (EnumItemSlot enumitemslot : EnumItemSlot.VALUES) {
            ItemStack itemstack;
            switch (enumitemslot.a()) {
                case a: {
                    itemstack = this.f(enumitemslot);
                    break;
                }
                case b: {
                    itemstack = this.e(enumitemslot);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemstack1 = this.c(enumitemslot);
            if (!this.a(itemstack, itemstack1)) continue;
            if (this instanceof EntityPlayer && enumitemslot.a() == EnumItemSlot.Function.b) {
                org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemstack);
                org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemstack1);
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumitemslot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumitemslot, itemstack1);
            if (!itemstack.b()) {
                this.eR().a(itemstack.a(enumitemslot));
            }
            if (itemstack1.b()) continue;
            this.eR().b(itemstack1.a(enumitemslot));
        }
        return map;
    }

    public boolean a(ItemStack stack, ItemStack stack2) {
        return !ItemStack.a(stack2, stack);
    }

    private void a(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ItemStack itemstack = equipmentChanges.get(EnumItemSlot.a);
        ItemStack itemstack1 = equipmentChanges.get(EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.a(itemstack, this.f(EnumItemSlot.b)) && ItemStack.a(itemstack1, this.f(EnumItemSlot.a))) {
            ((WorldServer)this.dM()).l().b(this, new PacketPlayOutEntityStatus(this, 55));
            equipmentChanges.remove(EnumItemSlot.a);
            equipmentChanges.remove(EnumItemSlot.b);
            this.c(EnumItemSlot.a, itemstack.p());
            this.c(EnumItemSlot.b, itemstack1.p());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipmentChanges.size());
        equipmentChanges.forEach((enumitemslot, itemstack) -> {
            ItemStack toSend;
            ItemStack itemstack1 = itemstack.p();
            list.add(Pair.of((Object)enumitemslot, (Object)this.stripMeta(toSend, (toSend = EntityLiving.sanitizeItemStack(itemstack1, true)) == itemstack1)));
            switch (enumitemslot.a()) {
                case a: {
                    this.c((EnumItemSlot)enumitemslot, itemstack1);
                    break;
                }
                case b: {
                    this.b((EnumItemSlot)enumitemslot, itemstack1);
                }
            }
        });
        ((WorldServer)this.dM()).l().b(this, new PacketPlayOutEntityEquipment(this.aj(), list));
    }

    public ItemStack stripMeta(ItemStack itemStack, boolean copyItemStack) {
        ItemStack copy;
        if (itemStack.b() || !itemStack.u() && itemStack.L() < 2) {
            return itemStack;
        }
        ItemStack itemStack2 = copy = copyItemStack ? itemStack.p() : itemStack;
        if (this.dM().paperConfig().anticheat.obfuscation.items.hideDurability && (!copy.a(Items.nS) || copy.k() < copy.l() - 1)) {
            copy.b(0);
        }
        NBTTagCompound tag = copy.v();
        if (this.dM().paperConfig().anticheat.obfuscation.items.hideItemmeta) {
            copy.f(copy.L() > 1 ? 2 : 1);
            if (tag != null) {
                NBTTagList enchantmentsTag;
                NBTBase nBTBase = tag.c("display");
                if (nBTBase instanceof NBTTagCompound) {
                    NBTTagCompound displayTag = (NBTTagCompound)nBTBase;
                    displayTag.r("Lore");
                    displayTag.r("Name");
                }
                if ((nBTBase = tag.c("Enchantments")) instanceof NBTTagList && !(enchantmentsTag = (NBTTagList)nBTBase).isEmpty()) {
                    NBTTagList enchantments = new NBTTagList();
                    NBTTagCompound fakeEnchantment = new NBTTagCompound();
                    if (EnchantmentManager.a(Enchantments.l, itemStack) > 0) {
                        fakeEnchantment.a("id", Enchantment.SOUL_SPEED.getKey().asString());
                        fakeEnchantment.a("lvl", 1);
                    }
                    enchantments.add(fakeEnchantment);
                    tag.a("Enchantments", enchantments);
                }
                tag.r("AttributeModifiers");
                tag.r("Unbreakable");
                tag.r("PublicBukkitValues");
                tag.r("author");
                tag.r("filtered_title");
                tag.r("pages");
                tag.r("filtered_pages");
                tag.r("title");
                tag.r("generation");
                tag.r("map");
                tag.r("map_scale_direction");
                tag.r("map_to_lock");
            }
        }
        if (this.dM().paperConfig().anticheat.obfuscation.items.hideItemmetaWithVisualEffects && tag != null) {
            tag.r("LodestonePos");
            if (tag.e("LodestoneDimension")) {
                tag.a("LodestoneDimension", "paper:paper");
            }
        }
        return copy;
    }

    public static ItemStack sanitizeItemStack(ItemStack itemStack, boolean copyItemStack) {
        NBTTagList oldItems;
        NBTBase nBTBase;
        if (itemStack.b() || !itemStack.u()) {
            return itemStack;
        }
        ItemStack copy = copyItemStack ? itemStack.p() : itemStack;
        NBTTagCompound tag = copy.v();
        if (copy.a(Items.qR) && (nBTBase = tag.c("Items")) instanceof NBTTagList && !(oldItems = (NBTTagList)nBTBase).isEmpty()) {
            BundleMeta bundleMeta = (BundleMeta)copy.asBukkitMirror().getItemMeta();
            int sizeUsed = 0;
            for (org.bukkit.inventory.ItemStack item : bundleMeta.getItems()) {
                int scale = 64 / item.getMaxStackSize();
                sizeUsed += scale * item.getAmount();
            }
            NBTTagList items = new NBTTagList();
            items.add(new ItemStack(Items.qL, sizeUsed).b(new NBTTagCompound()));
            tag.a("Items", items);
        }
        if ((nBTBase = tag.c("BlockEntityTag")) instanceof NBTTagCompound) {
            NBTTagCompound blockEntityTag = (NBTTagCompound)nBTBase;
            blockEntityTag.r("Items");
        }
        return copy;
    }

    private ItemStack e(EnumItemSlot slot) {
        return this.bR.get(slot.b());
    }

    private void b(EnumItemSlot slot, ItemStack armor) {
        this.bR.set(slot.b(), armor);
    }

    private ItemStack f(EnumItemSlot slot) {
        return this.bQ.get(slot.b());
    }

    private void c(EnumItemSlot slot, ItemStack stack) {
        this.bQ.set(slot.b(), stack);
    }

    protected float e(float bodyRotation, float headRotation) {
        boolean flag;
        float f2 = MathHelper.g(bodyRotation - this.aU);
        this.aU += f2 * 0.3f;
        float f3 = MathHelper.g(this.dC() - this.aU);
        float f4 = this.fg();
        if (Math.abs(f3) > f4) {
            this.aU += f3 - (float)MathHelper.j((double)f3) * f4;
        }
        boolean bl = flag = f3 < -90.0f || f3 >= 90.0f;
        if (flag) {
            headRotation *= -1.0f;
        }
        return headRotation;
    }

    protected float fg() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void d_() {
        if (this.bZ > 0) {
            --this.bZ;
        }
        if (this.cX()) {
            this.bn = 0;
            this.f(this.dr(), this.dt(), this.dx());
        }
        if (this.bn > 0) {
            this.a(this.bn, this.bo, this.bp, this.bq, this.br, this.bs);
            --this.bn;
        } else if (!this.cY()) {
            this.g(this.dp().a(0.98));
        }
        if (this.bu > 0) {
            this.a(this.bu, this.bt);
            --this.bu;
        }
        vec3d = this.dp();
        d0 = vec3d.c;
        d1 = vec3d.d;
        d2 = vec3d.e;
        if (Math.abs(vec3d.c) < 0.003) {
            d0 = 0.0;
        }
        if (Math.abs(vec3d.d) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3d.e) < 0.003) {
            d2 = 0.0;
        }
        this.o(d0, d1, d2);
        this.dM().af().a("ai");
        if (this.eY()) {
            this.bj = false;
            this.bk = 0.0f;
            this.bm = 0.0f;
        } else if (this.cY()) {
            this.dM().af().a("newAi");
            this.fi();
            this.dM().af().c();
        }
        this.dM().af().c();
        this.dM().af().a("jump");
        if (this.bj && this.ea()) {
            d3 = this.bn() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.aZ() != false && d3 > 0.0;
            d4 = this.df();
            if (flag && (!this.aC() || d3 > d4)) {
                this.c(TagsFluid.a);
            } else if (this.bn() && (!this.aC() || d3 > d4)) {
                this.c(TagsFluid.b);
            } else if ((this.aC() || flag && d3 <= d4) && this.bZ == 0) {
                if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                    this.fb();
                    this.bZ = 10;
                } else {
                    this.r(false);
                }
            }
        } else {
            this.bZ = 0;
        }
        this.dM().af().c();
        this.dM().af().a("travel");
        this.bk *= 0.98f;
        this.bm *= 0.98f;
        this.H();
        axisalignedbb = this.cH();
        vec3d1 = new Vec3D(this.bk, this.bl, this.bm);
        if (this.a(MobEffects.B) || this.a(MobEffects.y)) {
            this.n();
        }
        if (!((entityliving = this.cN()) instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.bx()) {
            this.c(entityhuman, vec3d1);
        } else lbl-1000:
        // 2 sources

        {
            this.a(vec3d1);
        }
        this.dM().af().c();
        this.dM().af().a("freezing");
        if (!(this.dM().B || this.ew() || this.freezeLocked)) {
            i = this.cj();
            if (this.aA && this.dA()) {
                this.k(Math.min(this.cm(), i + 1));
            } else {
                this.k(Math.max(0, i - 2));
            }
        }
        this.dX();
        this.dY();
        if (!this.dM().B && this.ah % 40 == 0 && this.cl() && this.dA()) {
            this.a(this.dN().t(), 1.0f);
        }
        this.dM().af().c();
        this.dM().af().a("push");
        if (this.by > 0) {
            --this.by;
            this.a(axisalignedbb, this.cH());
        }
        this.M_();
        this.dM().af().c();
        if (((WorldServer)this.dM()).hasEntityMoveEvent && !(this instanceof EntityHuman) && (this.K != this.dr() || this.L != this.dt() || this.M != this.dx() || this.N != this.dC() || this.O != this.dE())) {
            from = new Location((World)this.dM().getWorld(), this.K, this.L, this.M, this.N, this.O);
            to = new Location((World)this.dM().getWorld(), this.dr(), this.dt(), this.dx(), this.dC(), this.dE());
            event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if (!this.dM().B && this.fh() && this.bb()) {
            this.a(this.dN().h(), 1.0f);
        }
    }

    public boolean fh() {
        return false;
    }

    private void H() {
        boolean flag = this.i(7);
        if (flag && !this.aC() && !this.bO() && !this.a(MobEffects.y)) {
            ItemStack itemstack = this.c(EnumItemSlot.e);
            if (itemstack.a(Items.nS) && ItemElytra.d(itemstack)) {
                flag = true;
                int i2 = this.bx + 1;
                if (!this.dM().B && i2 % 10 == 0) {
                    int j2 = i2 / 10;
                    if (j2 % 2 == 0) {
                        itemstack.a(1, this, (T entityliving) -> entityliving.d(EnumItemSlot.e));
                    }
                    this.a(GameEvent.n);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.dM().B && flag != this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, flag).isCancelled()) {
            this.b(7, flag);
        }
    }

    protected void fi() {
    }

    protected void M_() {
        if (this.dM().y_()) {
            this.dM().a(EntityTypeTest.a(EntityHuman.class), this.cH(), IEntitySelector.a(this)).forEach(this::D);
        } else {
            if (!this.bu()) {
                return;
            }
            ScoreboardTeam team = this.cg();
            if (team != null && ((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumTeamPush.b) {
                return;
            }
            int i2 = this.dM().Z().c(GameRules.u);
            if (i2 <= 0 && this.dM().paperConfig().collisions.maxEntityCollisions <= 0) {
                return;
            }
            List<Entity> list = this.dM().a((Entity)this, this.cH(), IEntitySelector.pushable(this, this.dM().paperConfig().collisions.fixClimbingBypassingCrammingRule));
            if (!list.isEmpty()) {
                if (i2 > 0 && list.size() > i2 - 1 && this.ag.a(4) == 0) {
                    int j2 = 0;
                    for (Entity entity : list) {
                        if (entity.bO()) continue;
                        ++j2;
                    }
                    if (j2 > i2 - 1) {
                        this.a(this.dN().g(), 6.0f);
                    }
                }
                Iterator<Entity> iterator1 = list.iterator();
                this.numCollisions = Math.max(0, this.numCollisions - this.dM().paperConfig().collisions.maxEntityCollisions);
                while (iterator1.hasNext() && this.numCollisions < this.dM().paperConfig().collisions.maxEntityCollisions) {
                    Entity entity1 = iterator1.next();
                    ++entity1.numCollisions;
                    ++this.numCollisions;
                    this.D(entity1);
                }
            }
        }
    }

    protected void a(AxisAlignedBB a2, AxisAlignedBB b2) {
        AxisAlignedBB axisalignedbb2 = a2.b(b2);
        List<Entity> list = this.dM().a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityLiving)) continue;
                this.g((EntityLiving)entity);
                this.by = 0;
                this.g(this.dp().a(-0.2));
                break;
            }
        } else if (this.P) {
            this.by = 0;
        }
        if (!this.dM().B && this.by <= 0) {
            this.c(4, false);
        }
    }

    protected void D(Entity entity) {
        entity.g(this);
    }

    protected void g(EntityLiving target) {
    }

    public boolean fj() {
        return (this.an.b(t) & 4) != 0;
    }

    @Override
    public void ac() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity entity = this.cZ();
        super.stopRiding(suppressCancellation);
        if (entity != null && entity != this.cZ() && !this.dM().B && entity.valid) {
            this.a(entity);
        }
    }

    @Override
    public void t() {
        super.t();
        this.bc = this.bd;
        this.bd = 0.0f;
        this.n();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.bo = x2;
        this.bp = y2;
        this.bq = z2;
        this.br = yaw;
        this.bs = pitch;
        this.bn = interpolationSteps;
    }

    @Override
    public double p_() {
        return this.bn > 0 ? this.bo : this.dr();
    }

    @Override
    public double N_() {
        return this.bn > 0 ? this.bp : this.dt();
    }

    @Override
    public double O_() {
        return this.bn > 0 ? this.bq : this.dx();
    }

    @Override
    public float f_() {
        return this.bn > 0 ? (float)this.bs : this.dE();
    }

    @Override
    public float q_() {
        return this.bn > 0 ? (float)this.br : this.dC();
    }

    @Override
    public void a(float yaw, int interpolationSteps) {
        this.bt = yaw;
        this.bu = interpolationSteps;
    }

    public void r(boolean jumping) {
        this.bj = jumping;
    }

    public void a(EntityItem item) {
        EntityHuman entity;
        EntityHuman entityHuman = entity = item.j != null ? this.dM().getGlobalPlayerByUUID(item.j) : null;
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.P.a((EntityPlayer)entity, item.q(), this);
        }
    }

    public void a(Entity item, int count) {
        if (!item.dH() && !this.dM().B && (item instanceof EntityItem || item instanceof EntityArrow || item instanceof EntityExperienceOrb)) {
            ((WorldServer)this.dM()).l().a(this, new PacketPlayOutCollect(item.aj(), this.aj(), count));
        }
    }

    public boolean E(Entity entity) {
        if (entity.dM() != this.dM()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dr(), this.dv(), this.dx());
        Vec3D vec3d1 = new Vec3D(entity.dr(), entity.dv(), entity.dx());
        return vec3d1.g(vec3d) > 16384.0 ? false : this.dM().clipDirect(vec3d, vec3d1, VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float h(float tickDelta) {
        return tickDelta == 1.0f ? this.aW : MathHelper.i(tickDelta, this.aX, this.aW);
    }

    public float x(float tickDelta) {
        float f1 = this.aO - this.aN;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.aN + f1 * tickDelta;
    }

    @Override
    public boolean bt() {
        return !this.dH() && this.collides;
    }

    @Override
    public boolean bu() {
        return this.isCollidable(this.dM().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.bx() && !this.P_() && (ignoreClimbing || !this.e_()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bu() && this.collides != this.collidableExemptions.contains(entity.cw());
    }

    @Override
    public float cp() {
        return this.aW;
    }

    @Override
    public void n(float headYaw) {
        this.aW = headYaw;
    }

    @Override
    public void o(float bodyYaw) {
        this.aU = bodyYaw;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    public static Vec3D i(Vec3D pos) {
        return new Vec3D(pos.c, pos.d, 0.0);
    }

    public float fk() {
        return this.ca;
    }

    public final void y(float absorptionAmount) {
        this.z(!Float.isNaN(absorptionAmount) ? MathHelper.a(absorptionAmount, 0.0f, this.eN()) : 0.0f);
    }

    protected void z(float absorptionAmount) {
        this.ca = absorptionAmount;
    }

    public void g_() {
    }

    public void h_() {
    }

    protected void fl() {
        this.bT = true;
    }

    public abstract EnumMainHand fm();

    public boolean fn() {
        return (this.an.b(t) & 1) > 0;
    }

    public EnumHand fo() {
        return (this.an.b(t) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    public void resyncUsingItem(EntityPlayer serverPlayer) {
        this.an().resendPossiblyDesyncedDataValues(List.of(t), serverPlayer);
    }

    private void I() {
        if (this.fn()) {
            if (ItemStack.b(this.b(this.fo()), this.bv)) {
                this.bv = this.b(this.fo());
                this.a(this.bv);
            } else {
                this.ft();
            }
        }
    }

    protected void a(ItemStack stack) {
        boolean shouldLagCompensate;
        stack.b(this.dM(), this, this.fq());
        if (this.K()) {
            this.b(stack, 5);
        }
        boolean bl = shouldLagCompensate = this.bv.d().u() && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (long)((1 + this.totalEatTimeTicks) * 50 * 1000000);
        if (!(--this.bw != 0 && !shouldLagCompensate || this.dM().B || stack.t())) {
            this.bw = 0;
            this.x();
        }
    }

    private boolean K() {
        int i2 = this.fq();
        FoodInfo foodinfo = this.bv.d().v();
        boolean flag = foodinfo != null && foodinfo.e();
        return (flag |= i2 <= this.bv.r() - 7) && i2 % 4 == 0;
    }

    private void M() {
        this.cg = this.cf;
        this.cf = this.ca() ? Math.min(1.0f, this.cf + 0.09f) : Math.max(0.0f, this.cf - 0.09f);
    }

    protected void c(int mask, boolean value) {
        byte b0 = this.an.b(t);
        int j2 = value ? b0 | mask : b0 & ~mask;
        this.an.b(t, (byte)j2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemstack = this.b(hand);
        if (!itemstack.b() && !this.fn() || forceUpdate) {
            this.bv = itemstack;
            this.bw = this.totalEatTimeTicks = itemstack.r();
            this.eatStartTime = System.nanoTime();
            if (!this.dM().B) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
                this.a(GameEvent.D);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (bM.equals(data)) {
            if (this.dM().B) {
                this.fB().ifPresent(this::a);
            }
        } else if (t.equals(data) && this.dM().B) {
            if (this.fn() && this.bv.b()) {
                this.bv = this.b(this.fo());
                if (!this.bv.b()) {
                    this.bw = this.bv.r();
                }
            } else if (!this.fn() && !this.bv.b()) {
                this.bv = ItemStack.f;
                this.totalEatTimeTicks = 0;
                this.bw = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.aX = this.aW;
        this.aV = this.aU = this.aW;
    }

    protected void b(ItemStack stack, int particleCount) {
        if (!stack.b() && this.fn()) {
            if (stack.s() == EnumAnimation.c) {
                this.a(this.c(stack), 0.5f, this.dM().z.i() * 0.1f + 0.9f);
            }
            if (stack.s() == EnumAnimation.b) {
                this.a(stack, particleCount);
                this.a(this.d(stack), 0.5f + 0.5f * (float)this.ag.a(2), (this.ag.i() - this.ag.i()) * 0.2f + 1.0f);
            }
        }
    }

    private void a(ItemStack stack, int count) {
        for (int j2 = 0; j2 < count; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.ag.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.dE() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dC() * ((float)Math.PI / 180));
            double d0 = (double)(-this.ag.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.ag.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.dE() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dC() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dr(), this.dv(), this.dx());
            this.dM().a(new ParticleParamItem(Particles.Q, stack), vec3d1.c, vec3d1.d, vec3d1.e, vec3d.c, vec3d.d + 0.05, vec3d.e);
        }
    }

    public void x() {
        if (!this.dM().B || this.fn()) {
            EnumHand enumhand = this.fo();
            if (!this.bv.equals(this.b(enumhand))) {
                this.fs();
            } else if (!this.bv.b() && this.fn()) {
                ItemStack itemstack;
                this.startUsingItem(this.fo(), true);
                this.b(this.bv, 16);
                PlayerItemConsumeEvent event = null;
                if (this instanceof EntityPlayer) {
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bv);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.ft();
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                        ((EntityPlayer)this).getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bv.a(this.dM(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.dM(), this);
                } else {
                    itemstack = this.bv.a(this.dM(), this);
                }
                ItemStack defaultReplacement = itemstack;
                if (event != null && event.getReplacement() != null) {
                    itemstack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemstack != this.bv) {
                    this.a(enumhand, itemstack);
                }
                this.ft();
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).getBukkitEntity().updateInventory();
                }
            }
        }
    }

    public ItemStack fp() {
        return this.bv;
    }

    public int fq() {
        return this.bw;
    }

    public int fr() {
        return this.fn() ? this.bv.r() - this.fq() : 0;
    }

    public void fs() {
        if (!this.bv.b()) {
            if (this instanceof EntityPlayer) {
                new PlayerStopUsingItemEvent((Player)this.getBukkitEntity(), this.bv.asBukkitMirror(), this.fr()).callEvent();
            }
            this.bv.a(this.dM(), this, this.fq());
            if (this.bv.t()) {
                this.I();
            }
        }
        this.ft();
    }

    public void ft() {
        if (!this.dM().B) {
            boolean flag = this.fn();
            this.c(1, false);
            if (flag) {
                this.a(GameEvent.C);
            }
        }
        this.bv = ItemStack.f;
        this.totalEatTimeTicks = 0;
        this.bw = 0;
        this.eatStartTime = -1L;
    }

    public boolean fu() {
        if (this.fn() && !this.bv.b()) {
            net.minecraft.world.item.Item item = this.bv.d();
            return item.c(this.bv) != EnumAnimation.d ? false : item.b(this.bv) - this.bw >= this.getShieldBlockingDelay();
        }
        return false;
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dr(), this.dt() + (double)this.cI(), this.dx());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.c + dir.getX(), start.d + dir.getY(), start.e + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.dM().a(raytrace);
    }

    @Nullable
    public MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.j(1.0f);
        Vec3D direction = this.bF();
        Vec3D end = start.b(direction.c * (double)maxDistance, direction.d * (double)maxDistance, direction.e * (double)maxDistance);
        List<Entity> entityList = this.dM().a((Entity)this, this.cH().b(direction.c * (double)maxDistance, direction.d * (double)maxDistance, direction.e * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.f.and(Entity::bt));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.bE();
            AxisAlignedBB aabb = entity.cH().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public int getShieldBlockingDelay() {
        return this.shieldBlockingDelay;
    }

    public void setShieldBlockingDelay(int shieldBlockingDelay) {
        this.shieldBlockingDelay = shieldBlockingDelay;
    }

    public boolean fv() {
        return this.bS();
    }

    public boolean fw() {
        return this.i(7);
    }

    @Override
    public boolean ca() {
        return super.ca() || !this.fw() && this.c(EntityPose.b);
    }

    public int fx() {
        return this.bx;
    }

    public boolean b(double x2, double y2, double z2, boolean particleEffects) {
        return this.randomTeleport(x2, y2, z2, particleEffects, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dr();
        double d4 = this.dt();
        double d5 = this.dx();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        net.minecraft.world.level.World world = this.dM();
        if (world.B(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.J_()) {
                BlockPosition blockposition1 = blockposition.d();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.a_(d0, d6, d2);
                if (world.g(this) && !world.d(this.cH())) {
                    flag1 = true;
                }
                this.a_(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.dM().getWorld(), d3, d4, d5), new Location((World)this.dM().getWorld(), d0, d6, d2));
                        this.dM().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled() || teleport.getTo() == null) return Optional.empty();
                        Location to = teleport.getTo();
                        this.c(to.getX(), to.getY(), to.getZ());
                    } else if (((EntityPlayer)this).c.teleport(d0, d6, d2, this.dC(), this.dE(), Collections.emptySet(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        EntityCreature entitycreature = (EntityCreature)this;
        entitycreature.N().n();
        return Optional.of(true);
    }

    public boolean fy() {
        return !this.ew();
    }

    public boolean fz() {
        return true;
    }

    public void a(BlockPosition songPosition, boolean playing) {
    }

    public boolean f(ItemStack stack) {
        return false;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? v : super.a(pose).a(this.dZ());
    }

    public ImmutableList<EntityPose> fA() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB e(EntityPose pose) {
        EntitySize entitysize = this.a(pose);
        return new AxisAlignedBB(-entitysize.a / 2.0f, 0.0, -entitysize.a / 2.0f, entitysize.a / 2.0f, entitysize.b, entitysize.a / 2.0f);
    }

    protected boolean f(EntityPose pose) {
        AxisAlignedBB axisalignedbb = this.a(pose).a(this.dk());
        return this.dM().b(this, axisalignedbb);
    }

    @Override
    public boolean ct() {
        return super.ct() && !this.fD();
    }

    public Optional<BlockPosition> fB() {
        return this.an.b(bM);
    }

    public void g(BlockPosition pos) {
        this.an.b(bM, Optional.of(pos));
    }

    public void fC() {
        this.an.b(bM, Optional.empty());
    }

    public boolean fD() {
        return this.fB().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData iblockdata;
        if (this.bO()) {
            this.ac();
        }
        if ((iblockdata = this.dM().a_(pos)).b() instanceof BlockBed) {
            this.dM().a(pos, (IBlockData)iblockdata.a(BlockBed.c, true), 3);
        }
        this.b(EntityPose.c);
        this.a(pos);
        this.g(pos);
        this.g(Vec3D.b);
        this.au = true;
    }

    private void a(BlockPosition pos) {
        this.a_((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean N() {
        return this.fB().map(blockposition -> this.dM().a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void fE() {
        Optional<BlockPosition> optional = this.fB();
        net.minecraft.world.level.World world = this.dM();
        Objects.requireNonNull(world);
        optional.filter(world::B).ifPresent(blockposition -> {
            IBlockData iblockdata = this.dM().a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = iblockdata.c(BlockFacingHorizontal.aE);
                this.dM().a((BlockPosition)blockposition, (IBlockData)iblockdata.a(BlockBed.c, false), 3);
                Vec3D vec3d = BlockBed.a(this.ai(), (ICollisionAccess)this.dM(), blockposition, enumdirection, this.dC()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.c();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec3d1.e, vec3d1.c) * 57.2957763671875 - 90.0);
                this.a_(vec3d.c, vec3d.d, vec3d.e);
                this.r(f2);
                this.s(0.0f);
            }
        });
        Vec3D vec3d = this.dk();
        this.b(EntityPose.a);
        this.a_(vec3d.c, vec3d.d, vec3d.e);
        this.fC();
    }

    @Nullable
    public EnumDirection fF() {
        BlockPosition blockposition = this.fB().orElse(null);
        return blockposition != null ? BlockBed.a(this.dM(), blockposition) : null;
    }

    @Override
    public boolean by() {
        return !this.fD() && super.by();
    }

    @Override
    protected final float a(EntityPose pose, EntitySize dimensions) {
        return pose == EntityPose.c ? 0.2f : this.b(pose, dimensions);
    }

    protected float b(EntityPose pose, EntitySize dimensions) {
        return super.a(pose, dimensions);
    }

    public ItemStack g(ItemStack stack) {
        return ItemStack.f;
    }

    public ItemStack a(net.minecraft.world.level.World world, ItemStack stack) {
        if (stack.M()) {
            world.a((EntityHuman)null, this.dr(), this.dt(), this.dx(), this.d(stack), SoundCategory.g, 1.0f, 1.0f + (world.z.i() - world.z.i()) * 0.4f);
            this.a(stack, world, this);
            if (!(this instanceof EntityHuman) || !((EntityHuman)this).fT().d) {
                stack.h(1);
            }
            this.a(GameEvent.m);
        }
        return stack;
    }

    private void a(ItemStack stack, net.minecraft.world.level.World world, EntityLiving targetEntity) {
        net.minecraft.world.item.Item item = stack.d();
        if (item.u()) {
            List<Pair<MobEffect, Float>> list = item.v().f();
            for (Pair<MobEffect, Float> pair : list) {
                if (world.B || pair.getFirst() == null || !(world.z.i() < ((Float)pair.getSecond()).floatValue())) continue;
                targetEntity.addEffect(new MobEffect((MobEffect)pair.getFirst()), EntityPotionEffectEvent.Cause.FOOD);
            }
        }
    }

    public static byte g(EnumItemSlot slot) {
        switch (slot) {
            case a: {
                return 47;
            }
            case b: {
                return 48;
            }
            case f: {
                return 49;
            }
            case e: {
                return 50;
            }
            case c: {
                return 52;
            }
            case d: {
                return 51;
            }
        }
        return 47;
    }

    public void d(EnumItemSlot slot) {
        this.dM().a((Entity)this, EntityLiving.g(slot));
    }

    public void d(EnumHand hand) {
        this.d(hand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b);
    }

    @Override
    public AxisAlignedBB i_() {
        if (this.c(EnumItemSlot.f).a(Items.uj)) {
            float f2 = 0.5f;
            return this.cH().c(0.5, 0.5, 0.5);
        }
        return super.i_();
    }

    public static EnumItemSlot h(ItemStack stack) {
        Equipable equipable = Equipable.c_(stack);
        return equipable != null ? equipable.g() : EnumItemSlot.a;
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, itemstack -> itemstack.b() || EntityInsentient.h(itemstack) == slot) : SlotAccess.a(entity, slot);
    }

    @Nullable
    private static EnumItemSlot r(int slotId) {
        return slotId == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (slotId == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (slotId == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (slotId == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (slotId == 98 ? EnumItemSlot.a : (slotId == 99 ? EnumItemSlot.b : null)))));
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        EnumItemSlot enumitemslot = EntityLiving.r(mappedIndex);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(mappedIndex);
    }

    @Override
    public boolean dA() {
        if (this.P_()) {
            return false;
        }
        boolean flag = !this.c(EnumItemSlot.f).a(TagsItem.az) && !this.c(EnumItemSlot.e).a(TagsItem.az) && !this.c(EnumItemSlot.d).a(TagsItem.az) && !this.c(EnumItemSlot.c).a(TagsItem.az);
        return flag && super.dA();
    }

    @Override
    public boolean cd() {
        return !this.dM().y_() && this.a(MobEffects.x) || super.cd();
    }

    @Override
    public float dD() {
        return this.aU;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        double d0 = packet.f();
        double d1 = packet.g();
        double d2 = packet.h();
        float f2 = packet.m();
        float f1 = packet.l();
        this.f(d0, d1, d2);
        this.aU = packet.n();
        this.aW = packet.n();
        this.aV = this.aU;
        this.aX = this.aW;
        this.e(packet.a());
        this.a_(packet.d());
        this.a(d0, d1, d2, f2, f1);
        this.o(packet.i(), packet.j(), packet.k());
    }

    public boolean fG() {
        return this.eT().d() instanceof ItemAxe;
    }

    @Override
    public float dG() {
        float f2 = super.dG();
        return this.cN() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D m(Entity passenger) {
        return new Vec3D(this.a(passenger, this.a(this.ap()), this.dZ()).rotateY(-this.aU * ((float)Math.PI / 180))).e(this.dk());
    }

    @Override
    public float k(Entity vehicle) {
        return this.l(vehicle) * this.dZ();
    }

    protected void a(int i2, double d0) {
        this.aW = (float)MathHelper.e(1.0 / (double)i2, (double)this.aW, d0);
    }

    private static class ProcessableEffect {
        private MobEffectList type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(MobEffectList type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

