/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.attributes.AttributeBase;

public class AttributeRanged
extends AttributeBase {
    private final double b;
    public double c;

    public AttributeRanged(String translationKey, double fallback, double min, double max) {
        super(translationKey, fallback);
        this.b = min;
        this.c = max;
        if (min > max) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (fallback < min) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (fallback > max) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
    }

    public double d() {
        return this.b;
    }

    public double e() {
        return this.c;
    }

    @Override
    @Override
    public double a(double value) {
        if (Double.isNaN(value)) {
            return this.b;
        }
        return MathHelper.a(value, this.b, this.c);
    }
}

