/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class PrepareRamNearestTarget<E extends EntityCreature>
extends Behavior<E> {
    public static final int c = 160;
    private final ToIntFunction<E> d;
    private final int e;
    private final int f;
    private final float g;
    private final PathfinderTargetCondition h;
    private final int i;
    private final Function<E, SoundEffect> j;
    private Optional<Long> k = Optional.empty();
    private Optional<a> l = Optional.empty();

    public PrepareRamNearestTarget(ToIntFunction<E> cooldownFactory, int minDistance, int maxDistance, float speed, PathfinderTargetCondition targetPredicate, int prepareTime, Function<E, SoundEffect> soundFactory) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.c), MemoryModuleType.U, (Object)((Object)MemoryStatus.b), MemoryModuleType.h, (Object)((Object)MemoryStatus.a), MemoryModuleType.V, (Object)((Object)MemoryStatus.b)), 160);
        this.d = cooldownFactory;
        this.e = minDistance;
        this.f = maxDistance;
        this.g = speed;
        this.h = targetPredicate;
        this.i = prepareTime;
        this.j = soundFactory;
    }

    protected void a(WorldServer worldserver, EntityCreature entitycreature, long i2) {
        BehaviorController<?> behaviorcontroller = entitycreature.dO();
        behaviorcontroller.c(MemoryModuleType.h).flatMap(nearestvisiblelivingentities -> nearestvisiblelivingentities.a(entityliving -> this.h.a(entitycreature, (EntityLiving)entityliving))).ifPresent(entityliving -> {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entitycreature, entityliving, entityliving instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled() || event.getTarget() == null) {
                return;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            this.b(entitycreature, (EntityLiving)entityliving);
        });
    }

    @Override
    protected void b(WorldServer world, E entity, long time) {
        BehaviorController<Vec3D> behaviorcontroller = ((EntityLiving)entity).dO();
        if (!behaviorcontroller.a(MemoryModuleType.V)) {
            world.a((Entity)entity, (byte)59);
            behaviorcontroller.a(MemoryModuleType.U, Integer.valueOf(this.d.applyAsInt(entity)));
        }
    }

    protected boolean c(WorldServer worldserver, EntityCreature entitycreature, long i2) {
        return this.l.isPresent() && this.l.get().c().bx();
    }

    @Override
    protected void d(WorldServer worldserver, E e0, long i2) {
        if (!this.l.isEmpty()) {
            boolean flag;
            ((EntityLiving)e0).dO().a(MemoryModuleType.m, new MemoryTarget(this.l.get().a(), this.g, 0));
            ((EntityLiving)e0).dO().a(MemoryModuleType.n, new BehaviorPositionEntity(this.l.get().c(), true));
            boolean bl = flag = !this.l.get().c().dm().equals(this.l.get().b());
            if (flag) {
                worldserver.a((Entity)e0, (byte)59);
                ((EntityInsentient)e0).N().n();
                this.b((EntityCreature)e0, this.l.get().c);
            } else {
                BlockPosition blockposition = ((Entity)e0).dm();
                if (blockposition.equals(this.l.get().a())) {
                    worldserver.a((Entity)e0, (byte)58);
                    if (this.k.isEmpty()) {
                        this.k = Optional.of(i2);
                    }
                    if (i2 - this.k.get() >= (long)this.i) {
                        ((EntityLiving)e0).dO().a(MemoryModuleType.V, this.a(blockposition, this.l.get().b()));
                        worldserver.a((EntityHuman)null, (Entity)e0, this.j.apply(e0), SoundCategory.g, 1.0f, ((EntityLiving)e0).eX());
                        this.l = Optional.empty();
                    }
                }
            }
        }
    }

    private Vec3D a(BlockPosition start, BlockPosition end) {
        double d0 = 0.5;
        double d1 = 0.5 * (double)MathHelper.j((double)(end.u() - start.u()));
        double d2 = 0.5 * (double)MathHelper.j((double)(end.w() - start.w()));
        return Vec3D.c(end).b(d1, 0.0, d2);
    }

    private Optional<BlockPosition> a(EntityCreature entity, EntityLiving target) {
        BlockPosition blockposition = target.dm();
        if (!this.a(entity, blockposition)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.j();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            blockposition_mutableblockposition.g(blockposition);
            for (int i2 = 0; i2 < this.f; ++i2) {
                if (this.a(entity, (BlockPosition)blockposition_mutableblockposition.c(enumdirection))) {
                    continue;
                }
                blockposition_mutableblockposition.c(enumdirection.g());
                break;
            }
            if (blockposition_mutableblockposition.k(blockposition) < this.e) continue;
            list.add(blockposition_mutableblockposition.i());
        }
        NavigationAbstract navigationabstract = entity.N();
        Stream stream = list.stream();
        BlockPosition blockposition1 = entity.dm();
        Objects.requireNonNull(blockposition1);
        return stream.sorted(Comparator.comparingDouble(blockposition1::j)).filter(blockposition2 -> {
            PathEntity pathentity = navigationabstract.a((BlockPosition)blockposition2, 0);
            return pathentity != null && pathentity.j();
        }).findFirst();
    }

    private boolean a(EntityCreature entity, BlockPosition target) {
        return entity.N().a(target) && entity.a(PathfinderNormal.a((IBlockAccess)entity.dM(), target.j())) == 0.0f;
    }

    private void b(EntityCreature entity, EntityLiving target) {
        this.k = Optional.empty();
        this.l = this.a(entity, target).map(blockposition -> new a((BlockPosition)blockposition, target.dm(), target));
    }

    public static class a {
        private final BlockPosition a;
        private final BlockPosition b;
        final EntityLiving c;

        public a(BlockPosition start, BlockPosition end, EntityLiving entity) {
            this.a = start;
            this.b = end;
            this.c = entity;
        }

        public BlockPosition a() {
            return this.a;
        }

        public BlockPosition b() {
            return this.b;
        }

        public EntityLiving c() {
            return this.c;
        }
    }
}

