/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3D;

public class RandomLookAround
extends Behavior<EntityInsentient> {
    private final IntProvider c;
    private final float d;
    private final float e;
    private final float f;

    public RandomLookAround(IntProvider cooldown, float maxYaw, float minPitch, float maxPitch) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.b), MemoryModuleType.P, (Object)((Object)MemoryStatus.b)));
        if (minPitch > maxPitch) {
            throw new IllegalArgumentException("Minimum pitch is larger than maximum pitch! " + minPitch + " > " + maxPitch);
        }
        this.c = cooldown;
        this.d = maxYaw;
        this.e = minPitch;
        this.f = maxPitch - minPitch;
    }

    @Override
    protected void a(WorldServer serverLevel, EntityInsentient mob, long l2) {
        RandomSource randomSource = mob.eg();
        float f2 = MathHelper.a(randomSource.i() * this.f + this.e, -90.0f, 90.0f);
        float g2 = MathHelper.g(mob.dC() + 2.0f * randomSource.i() * this.d - this.d);
        Vec3D vec3 = Vec3D.a(f2, g2);
        mob.dO().a(MemoryModuleType.n, new BehaviorTarget(mob.br().e(vec3)));
        mob.dO().a(MemoryModuleType.P, Integer.valueOf(this.c.a(randomSource)));
    }

    @Override
    protected /* synthetic */ void d(WorldServer world, EntityLiving entity, long time) {
        this.a(world, (EntityInsentient)entity, time);
    }
}

