/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.util.player.NearbyPlayers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.Vec3D;

public class SensorNearestPlayers
extends Sensor<EntityLiving> {
    @Override
    public Set<MemoryModuleType<?>> a() {
        return ImmutableSet.of(MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l);
    }

    @Override
    protected void a(WorldServer world, EntityLiving entity) {
        NearbyPlayers nearbyPlayers = world.I.a.getNearbyPlayers();
        Vec3D entityPos = entity.dk();
        ReferenceList<EntityPlayer> nearby = nearbyPlayers.getPlayersByChunk(entity.do().e, entity.do().f, NearbyPlayers.NearbyMapType.GENERAL_REALLY_SMALL);
        ArrayList<EntityHuman> players = new ArrayList<EntityHuman>(nearby == null ? 0 : nearby.size());
        if (nearby != null) {
            Object[] rawData = nearby.getRawData();
            int len = nearby.size();
            for (int index = 0; index < len; ++index) {
                EntityPlayer player = (EntityPlayer)rawData[index];
                if (player.P_() || player.i(entityPos.c, entityPos.d, entityPos.e) >= 256.0) continue;
                players.add(player);
            }
        }
        players.sort(Comparator.comparingDouble(entity::f));
        BehaviorController<?> brain = entity.dO();
        brain.a(MemoryModuleType.j, players);
        EntityHuman firstTargetable = null;
        EntityHuman firstAttackable = null;
        for (EntityHuman player : players) {
            if (firstTargetable == null && Sensor.b(entity, player)) {
                firstTargetable = player;
            }
            if (firstAttackable == null && Sensor.c(entity, player)) {
                firstAttackable = player;
            }
            if (firstAttackable == null || firstTargetable == null) continue;
            break;
        }
        brain.a(MemoryModuleType.k, firstTargetable);
        brain.a(MemoryModuleType.l, Optional.ofNullable(firstAttackable));
    }
}

