/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.phys.Vec3D;

public class RandomPositionGenerator {
    private static final int a = 10;

    public static BlockPosition a(RandomSource random, int horizontalRange, int verticalRange) {
        int i2 = random.a(2 * horizontalRange + 1) - horizontalRange;
        int j2 = random.a(2 * verticalRange + 1) - verticalRange;
        int k2 = random.a(2 * horizontalRange + 1) - horizontalRange;
        return new BlockPosition(i2, j2, k2);
    }

    @Nullable
    public static BlockPosition a(RandomSource random, int horizontalRange, int verticalRange, int startHeight, double directionX, double directionZ, double angleRange) {
        double d2 = MathHelper.d(directionZ, directionX) - 1.5707963705062866;
        double e2 = d2 + (double)(2.0f * random.i() - 1.0f) * angleRange;
        double f2 = Math.sqrt(random.j()) * (double)MathHelper.g * (double)horizontalRange;
        double g2 = -f2 * Math.sin(e2);
        double h2 = f2 * Math.cos(e2);
        if (Math.abs(g2) > (double)horizontalRange || Math.abs(h2) > (double)horizontalRange) {
            return null;
        }
        int i2 = random.a(2 * verticalRange + 1) - verticalRange + startHeight;
        return BlockPosition.a(g2, (double)i2, h2);
    }

    @VisibleForTesting
    public static BlockPosition a(BlockPosition pos, int maxY, Predicate<BlockPosition> condition) {
        if (condition.test(pos)) {
            BlockPosition blockPos = pos.c();
            while (blockPos.v() < maxY && condition.test(blockPos)) {
                blockPos = blockPos.c();
            }
            return blockPos;
        }
        return pos;
    }

    @VisibleForTesting
    public static BlockPosition a(BlockPosition pos, int extraAbove, int max, Predicate<BlockPosition> condition) {
        if (extraAbove < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + extraAbove + ", expected >= 0");
        }
        if (condition.test(pos)) {
            BlockPosition blockPos3;
            BlockPosition blockPos = pos.c();
            while (blockPos.v() < max && condition.test(blockPos)) {
                blockPos = blockPos.c();
            }
            BlockPosition blockPos2 = blockPos;
            while (blockPos2.v() < max && blockPos2.v() - blockPos.v() < extraAbove && !condition.test(blockPos3 = blockPos2.c())) {
                blockPos2 = blockPos3;
            }
            return blockPos2;
        }
        return pos;
    }

    @Nullable
    public static Vec3D a(EntityCreature entity, Supplier<BlockPosition> factory) {
        return RandomPositionGenerator.a(factory, entity::h);
    }

    @Nullable
    public static Vec3D a(Supplier<BlockPosition> factory, ToDoubleFunction<BlockPosition> scorer) {
        double d2 = Double.NEGATIVE_INFINITY;
        BlockPosition blockPos = null;
        for (int i2 = 0; i2 < 10; ++i2) {
            double e2;
            BlockPosition blockPos2 = factory.get();
            if (blockPos2 == null || !((e2 = scorer.applyAsDouble(blockPos2)) > d2)) continue;
            d2 = e2;
            blockPos = blockPos2;
        }
        return blockPos != null ? Vec3D.c(blockPos) : null;
    }

    public static BlockPosition a(EntityCreature entity, int horizontalRange, RandomSource random, BlockPosition fuzz) {
        int i2 = fuzz.u();
        int j2 = fuzz.w();
        if (entity.fQ() && horizontalRange > 1) {
            BlockPosition blockPos = entity.fN();
            i2 = entity.dr() > (double)blockPos.u() ? (i2 -= random.a(horizontalRange / 2)) : (i2 += random.a(horizontalRange / 2));
            j2 = entity.dx() > (double)blockPos.w() ? (j2 -= random.a(horizontalRange / 2)) : (j2 += random.a(horizontalRange / 2));
        }
        return BlockPosition.a((double)i2 + entity.dr(), (double)fuzz.v() + entity.dt(), (double)j2 + entity.dx());
    }
}

