/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import top.leavesmc.leaves.LeavesConfig;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float bT = 120.32113f;
    public static final int bU = MathHelper.f(1.4959966f);
    private static final DataWatcherObject<Byte> cd = DataWatcher.a(EntityBee.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> ce = DataWatcher.a(EntityBee.class, DataWatcherRegistry.b);
    private static final int cf = 2;
    private static final int cg = 4;
    private static final int ch = 8;
    private static final int ci = 1200;
    private static final int cj = 2400;
    private static final int ck = 3600;
    private static final int cl = 4;
    private static final int cm = 10;
    private static final int cn = 10;
    private static final int co = 18;
    private static final int cp = 32;
    private static final int cq = 2;
    private static final int cr = 16;
    private static final int cs = 20;
    public static final String bW = "CropsGrownSincePollination";
    public static final String bX = "CannotEnterHiveTicks";
    public static final String bY = "TicksSincePollination";
    public static final String bZ = "HasStung";
    public static final String ca = "HasNectar";
    public static final String cb = "FlowerPos";
    public static final String cc = "HivePos";
    private static final UniformInt ct = TimeRange.a(20, 39);
    @Nullable
    private UUID cu;
    private float cw;
    private float cx;
    private int cy;
    public int cz;
    public int cA;
    public int cB;
    private static final int cC = 200;
    int cD;
    private static final int cE = 200;
    int cF;
    @Nullable
    BlockPosition cG;
    @Nullable
    public BlockPosition cH;
    k cI;
    e cJ;
    private f cK;
    private int cL;
    public TriState rollingOverride = TriState.NOT_SET;

    public EntityBee(EntityTypes<? extends EntityBee> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.cF = MathHelper.a(this.ag, 20, 60);
        class BeeFlyingMoveControl
        extends ControllerMoveFlying {
            public BeeFlyingMoveControl(EntityInsentient entity, int maxPitchChange, boolean noGravity) {
                super(entity, maxPitchChange, noGravity);
            }

            @Override
            public void a() {
                if (this.d.dt() <= (double)EntityBee.this.dM().J_()) {
                    this.d.e(false);
                }
                super.a();
            }
        }
        this.bL = new BeeFlyingMoveControl(this, 20, true);
        this.bK = new j(this);
        this.a(PathType.n, -1.0f);
        this.a(PathType.j, -1.0f);
        this.a(PathType.k, 16.0f);
        this.a(PathType.x, -1.0f);
        this.a(PathType.h, -1.0f);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(cd, (byte)0);
        this.an.a(ce, 0);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).i() ? 10.0f : 0.0f;
    }

    @Override
    protected void B() {
        this.bO.a(0, new b(this, 1.4f, true));
        this.bO.a(1, new d());
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(TagsItem.S), false));
        this.cI = new k();
        this.bO.a(4, this.cI);
        this.bO.a(5, new PathfinderGoalFollowParent(this, 1.25));
        this.bO.a(5, new i());
        this.cJ = new e();
        this.bO.a(5, this.cJ);
        this.cK = new f();
        this.bO.a(6, this.cK);
        this.bO.a(7, new g());
        this.bO.a(8, new l());
        this.bO.a(9, new PathfinderGoalFloat(this));
        this.bP.a(1, new h(this).a(new Class[0]));
        this.bP.a(2, new c(this));
        this.bP.a(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        this.addAdditionalSaveData(nbt, true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        super.b(nbttagcompound);
        if (includeAll && this.gl()) {
            nbttagcompound.a(cc, GameProfileSerializer.a(this.gm()));
        }
        if (includeAll && this.w()) {
            nbttagcompound.a(cb, GameProfileSerializer.a(this.u()));
        }
        nbttagcompound.a(ca, this.go());
        nbttagcompound.a(bZ, this.gp());
        nbttagcompound.a(bY, this.cz);
        nbttagcompound.a(bX, this.cA);
        nbttagcompound.a(bW, this.cB);
        this.c(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.cH = null;
        if (nbt.e(cc)) {
            this.cH = GameProfileSerializer.b(nbt.p(cc));
        }
        this.cG = null;
        if (nbt.e(cb)) {
            this.cG = GameProfileSerializer.b(nbt.p(cb));
        }
        super.a(nbt);
        this.w(nbt.q(ca));
        this.x(nbt.q(bZ));
        this.cz = nbt.h(bY);
        this.cA = nbt.h(bX);
        this.cB = nbt.h(bW);
        this.a(this.dM(), nbt);
    }

    @Override
    public boolean C(Entity target) {
        boolean flag = target.a(this.dN().a(this), (float)((int)this.b(GenericAttributes.c)));
        if (flag) {
            this.a((EntityLiving)this, target);
            if (target instanceof EntityLiving) {
                ((EntityLiving)target).q(((EntityLiving)target).eP() + 1);
                int b0 = 0;
                if (this.dM().ak() == EnumDifficulty.c) {
                    b0 = 10;
                } else if (this.dM().ak() == EnumDifficulty.d) {
                    b0 = 18;
                }
                if (b0 > 0) {
                    ((EntityLiving)target).addEffect(new MobEffect(MobEffects.s, b0 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.x(true);
            this.X_();
            this.a(SoundEffects.bD, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void l() {
        super.l();
        if (this.go() && this.gx() < 10 && this.ag.i() < 0.05f) {
            for (int i2 = 0; i2 < this.ag.a(2) + 1; ++i2) {
                this.a(this.dM(), this.dr() - (double)0.3f, this.dr() + (double)0.3f, this.dx() - (double)0.3f, this.dx() + (double)0.3f, this.e(0.5), Particles.av);
            }
        }
        this.gv();
    }

    private void a(World world, double lastX, double x2, double lastZ, double z2, double y2, ParticleParam effect) {
        world.a(effect, MathHelper.d(world.z.j(), lastX, x2), y2, MathHelper.d(world.z.j(), lastZ, z2), 0.0, 0.0, 0.0);
    }

    void j(BlockPosition pos) {
        Vec3D vec3d1;
        Vec3D vec3d = Vec3D.c(pos);
        int b0 = 0;
        BlockPosition blockposition1 = this.dm();
        int i2 = (int)vec3d.d - blockposition1.v();
        if (i2 > 2) {
            b0 = 4;
        } else if (i2 < -2) {
            b0 = -4;
        }
        int j2 = 6;
        int k2 = 8;
        int l2 = blockposition1.k(pos);
        if (l2 < 15) {
            j2 = l2 / 2;
            k2 = l2 / 2;
        }
        if ((vec3d1 = AirRandomPos.a(this, j2, k2, b0, vec3d, 0.3141592741012573)) != null) {
            this.bN.a(0.5f);
            this.bN.a(vec3d1.c, vec3d1.d, vec3d1.e, 1.0);
        }
    }

    @Nullable
    public BlockPosition u() {
        return this.cG;
    }

    public boolean w() {
        return this.cG != null;
    }

    public void i(BlockPosition flowerPos) {
        this.cG = flowerPos;
    }

    @VisibleForDebug
    public int A() {
        return Math.max(this.cJ.d, this.cK.d);
    }

    @VisibleForDebug
    public List<BlockPosition> ge() {
        return this.cJ.f;
    }

    private boolean gt() {
        return this.cz > 3600;
    }

    boolean gu() {
        if (this.cA <= 0 && !this.cI.l() && !this.gp() && this.q() == null) {
            boolean flag = this.gt() || this.dM().ab() || this.dM().Q() || this.go();
            return flag && !this.gw();
        }
        return false;
    }

    public void t(int cannotEnterHiveTicks) {
        this.cA = cannotEnterHiveTicks;
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.cx, this.cw);
    }

    private void gv() {
        this.cx = this.cw;
        this.cw = this.gB() ? Math.min(1.0f, this.cw + 0.2f) : Math.max(0.0f, this.cw - 0.24f);
    }

    @Override
    protected void Z() {
        boolean flag = this.gp();
        this.cL = this.bc() ? ++this.cL : 0;
        if (this.cL > 20) {
            this.a(this.dN().h(), 1.0f);
        }
        if (flag) {
            ++this.cy;
            if (this.cy % 5 == 0 && this.ag.a(MathHelper.a(1200 - this.cy, 1, 1200)) == 0) {
                this.a(this.dN().n(), this.ev());
            }
        }
        if (!this.go()) {
            ++this.cz;
        }
        if (!this.dM().B) {
            this.a((WorldServer)this.dM(), false);
        }
    }

    public void gk() {
        this.cz = 0;
    }

    private boolean gw() {
        if (this.cH == null) {
            return false;
        }
        if (!this.dM().isLoadedAndInBounds(this.cH)) {
            return false;
        }
        TileEntity tileentity = this.dM().c_(this.cH);
        return tileentity instanceof TileEntityBeehive && ((TileEntityBeehive)tileentity).c();
    }

    @Override
    public int a() {
        return this.an.b(ce);
    }

    @Override
    public void a(int angerTime) {
        this.an.b(ce, angerTime);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cu;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cu = angryAt;
    }

    @Override
    public void c() {
        this.a(ct.a(this.ag));
    }

    private boolean k(BlockPosition pos) {
        if (!this.dM().isLoadedAndInBounds(pos)) {
            return false;
        }
        TileEntity tileentity = this.dM().c_(pos);
        return tileentity instanceof TileEntityBeehive ? !((TileEntityBeehive)tileentity).f() : false;
    }

    @VisibleForDebug
    public boolean gl() {
        return this.cH != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition gm() {
        return this.cH;
    }

    @VisibleForDebug
    public PathfinderGoalSelector gn() {
        return this.bO;
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    int gx() {
        return this.cB;
    }

    private void gy() {
        this.cB = 0;
    }

    void gz() {
        ++this.cB;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dM().B) {
            if (this.cA > 0) {
                --this.cA;
            }
            if (this.cD > 0) {
                --this.cD;
            }
            if (this.cF > 0) {
                --this.cF;
            }
            boolean flag = this.aa_() && !this.gp() && this.q() != null && this.q().f((Entity)this) < 4.0;
            this.y(flag);
            if (this.ah % 20 == 0 && !this.gA()) {
                this.cH = null;
            }
        }
    }

    boolean gA() {
        if (!this.gl()) {
            return false;
        }
        if (this.l(this.cH)) {
            return false;
        }
        if (this.dM().getChunkIfLoadedImmediately(this.cH.u() >> 4, this.cH.w() >> 4) == null) {
            return true;
        }
        TileEntity tileentity = this.dM().c_(this.cH);
        return tileentity != null && tileentity.v() == TileEntityTypes.H;
    }

    public boolean go() {
        return this.u(8);
    }

    public void w(boolean hasNectar) {
        if (hasNectar) {
            this.gk();
        }
        this.d(8, hasNectar);
    }

    public boolean gp() {
        return this.u(4);
    }

    public void x(boolean hasStung) {
        this.d(4, hasStung);
    }

    public boolean gB() {
        return this.u(2);
    }

    public void y(boolean nearTarget) {
        nearTarget = this.rollingOverride.toBooleanOrElse(nearTarget);
        this.d(2, nearTarget);
    }

    boolean l(BlockPosition pos) {
        return !this.b(pos, 32);
    }

    private void d(int bit, boolean value) {
        if (value) {
            this.an.b(cd, (byte)(this.an.b(cd) | bit));
        } else {
            this.an.b(cd, (byte)(this.an.b(cd) & ~bit));
        }
    }

    private boolean u(int location) {
        return (this.an.b(cd) & location) != 0;
    }

    public static AttributeProvider.Builder gq() {
        return EntityInsentient.C().a(GenericAttributes.l, 10.0).a(GenericAttributes.f, 0.6f).a(GenericAttributes.m, 0.3f).a(GenericAttributes.c, 2.0).a(GenericAttributes.g, 48.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world){

            @Override
            public boolean a(BlockPosition pos) {
                return !this.b.a_(pos.d()).i();
            }

            @Override
            public void c() {
                if (!EntityBee.this.cI.l()) {
                    super.c();
                }
            }
        };
        navigationflying.b(false);
        navigationflying.a(false);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.S);
    }

    boolean m(BlockPosition pos) {
        return this.dM().p(pos) && this.dM().a_(pos).a(TagsBlock.U);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    protected SoundEffect y() {
        return null;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.bA;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.bz;
    }

    @Override
    public float eW() {
        return 0.4f;
    }

    @Nullable
    public EntityBee b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.h.a(world);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.o_() ? dimensions.b * 0.5f : dimensions.b * 0.5f;
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    public boolean aT() {
        return this.gr() && this.ah % bU == 0;
    }

    @Override
    public boolean gr() {
        return !this.aC();
    }

    public void gs() {
        this.w(false);
        this.gy();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        boolean result = super.a(source, amount);
        if (result && !this.dM().B) {
            this.cI.m();
        }
        return result;
    }

    @Override
    public EnumMonsterType eS() {
        return EnumMonsterType.c;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        this.g(this.dp().b(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D cJ() {
        return new Vec3D(0.0, 0.5f * this.cI(), this.dg() * 0.2f);
    }

    boolean b(BlockPosition pos, int distance) {
        return pos.a(this.dm(), (double)distance);
    }

    private class j
    extends ControllerLook {
        j(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
            if (!EntityBee.this.aa_()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityBee.this.cI.l();
        }
    }

    private class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        @Override
        public boolean a() {
            return super.a() && EntityBee.this.aa_() && !EntityBee.this.gp();
        }

        @Override
        public boolean b() {
            return super.b() && EntityBee.this.aa_() && !EntityBee.this.gp();
        }
    }

    private class d
    extends a {
        d() {
        }

        @Override
        public boolean h() {
            if (EntityBee.this.gl() && EntityBee.this.gu() && EntityBee.this.cH.a(EntityBee.this.dk(), 2.0)) {
                if (!EntityBee.this.dM().isLoadedAndInBounds(EntityBee.this.cH)) {
                    return false;
                }
                TileEntity tileentity = EntityBee.this.dM().c_(EntityBee.this.cH);
                if (tileentity instanceof TileEntityBeehive) {
                    TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                    if (!tileentitybeehive.f()) {
                        return true;
                    }
                    EntityBee.this.cH = null;
                }
            }
            return false;
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void c() {
            if (!EntityBee.this.dM().isLoadedAndInBounds(EntityBee.this.cH)) {
                return;
            }
            TileEntity tileentity = EntityBee.this.dM().c_(EntityBee.this.cH);
            if (tileentity instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                tileentitybeehive.a(EntityBee.this, EntityBee.this.go());
            }
        }
    }

    private class k
    extends a {
        private static final int c = 400;
        private static final int d = 20;
        private static final int e = 60;
        private final Predicate<IBlockData> f;
        private static final double g = 0.1;
        private static final int h = 25;
        private static final float i = 0.35f;
        private static final float j = 0.6f;
        private static final float k = 0.33333334f;
        private int l;
        private int m;
        private boolean n;
        @Nullable
        private Vec3D o;
        private int p;
        private static final int q = 600;

        k() {
            this.f = iblockdata -> iblockdata.b(BlockProperties.C) && iblockdata.c(BlockProperties.C).booleanValue() ? false : (iblockdata.a(TagsBlock.U) ? (iblockdata.a(Blocks.iD) ? iblockdata.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.a : true) : false);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            if (EntityBee.this.cF > 0) {
                return false;
            }
            if (EntityBee.this.go()) {
                return false;
            }
            if (EntityBee.this.dM().ab()) {
                return false;
            }
            Optional<BlockPosition> optional = this.p();
            if (optional.isPresent()) {
                EntityBee.this.cG = optional.get();
                EntityBee.this.bN.a((double)EntityBee.this.cG.u() + 0.5, (double)EntityBee.this.cG.v() + 0.5, (double)EntityBee.this.cG.w() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.cF = MathHelper.a(EntityBee.this.ag, 20, 60);
            return false;
        }

        @Override
        public boolean i() {
            if (!this.n) {
                return false;
            }
            if (!EntityBee.this.w()) {
                return false;
            }
            if (EntityBee.this.dM().ab()) {
                return false;
            }
            if (this.k()) {
                return EntityBee.this.ag.i() < 0.2f;
            }
            if (EntityBee.this.ah % 20 == 0 && !EntityBee.this.m(EntityBee.this.cG)) {
                EntityBee.this.cG = null;
                return false;
            }
            return true;
        }

        private boolean k() {
            return this.l > 400;
        }

        boolean l() {
            return this.n;
        }

        void m() {
            this.n = false;
        }

        @Override
        public void c() {
            this.l = 0;
            this.p = 0;
            this.m = 0;
            this.n = true;
            EntityBee.this.gk();
        }

        @Override
        public void d() {
            if (this.k()) {
                EntityBee.this.w(true);
            }
            this.n = false;
            EntityBee.this.bN.n();
            EntityBee.this.cF = 200;
        }

        @Override
        public boolean T_() {
            return true;
        }

        @Override
        public void e() {
            ++this.p;
            if (this.p > 600) {
                EntityBee.this.cG = null;
            } else if (EntityBee.this.cG != null) {
                Vec3D vec3d = Vec3D.c(EntityBee.this.cG).b(0.0, 0.6f, 0.0);
                if (vec3d.f(EntityBee.this.dk()) > 1.0) {
                    this.o = vec3d;
                    this.n();
                } else {
                    if (this.o == null) {
                        this.o = vec3d;
                    }
                    boolean flag = EntityBee.this.dk().f(this.o) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.p > 600) {
                        EntityBee.this.cG = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = EntityBee.this.ag.a(25) == 0;
                            if (flag2) {
                                this.o = new Vec3D(vec3d.a() + (double)this.o(), vec3d.b(), vec3d.c() + (double)this.o());
                                EntityBee.this.bN.n();
                            } else {
                                flag1 = false;
                            }
                            EntityBee.this.I().a(vec3d.a(), vec3d.b(), vec3d.c());
                        }
                        if (flag1) {
                            this.n();
                        }
                        ++this.l;
                        if (EntityBee.this.ag.i() < 0.05f && this.l > this.m + 60) {
                            this.m = this.l;
                            EntityBee.this.a(SoundEffects.bE, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void n() {
            EntityBee.this.K().a(this.o.a(), this.o.b(), this.o.c(), 0.35f);
        }

        private float o() {
            return (EntityBee.this.ag.i() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> p() {
            return this.a(this.f, 5.0);
        }

        private Optional<BlockPosition> a(Predicate<IBlockData> predicate, double searchDistance) {
            BlockPosition blockposition = EntityBee.this.dm();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int i2 = 0;
            while ((double)i2 <= searchDistance) {
                int j2 = 0;
                while ((double)j2 < searchDistance) {
                    int k2 = 0;
                    while (k2 <= j2) {
                        int l2;
                        int n2 = l2 = k2 < j2 && k2 > -j2 ? j2 : 0;
                        while (l2 <= j2) {
                            blockposition_mutableblockposition.a(blockposition, k2, i2 - 1, l2);
                            if (blockposition.a(blockposition_mutableblockposition, searchDistance) && predicate.test(EntityBee.this.dM().a_(blockposition_mutableblockposition))) {
                                return Optional.of(blockposition_mutableblockposition);
                            }
                            l2 = l2 > 0 ? -l2 : 1 - l2;
                        }
                        k2 = k2 > 0 ? -k2 : 1 - k2;
                    }
                    ++j2;
                }
                i2 = i2 > 0 ? -i2 : 1 - i2;
            }
            return Optional.empty();
        }
    }

    private class i
    extends a {
        i() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.cD == 0 && !EntityBee.this.gl() && EntityBee.this.gu();
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void c() {
            EntityBee.this.cD = 200;
            List<BlockPosition> list = this.k();
            if (!list.isEmpty()) {
                BlockPosition blockposition;
                Iterator<BlockPosition> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    EntityBee.this.cJ.k();
                    EntityBee.this.cH = list.get(0);
                    return;
                } while (EntityBee.this.cJ.b(blockposition = iterator.next()));
                EntityBee.this.cH = blockposition;
            }
        }

        private List<BlockPosition> k() {
            BlockPosition blockposition = EntityBee.this.dm();
            VillagePlace villageplace = ((WorldServer)EntityBee.this.dM()).y();
            Stream<VillagePlaceRecord> stream = villageplace.c(holder -> holder.a(PoiTypeTags.c), blockposition, 20, VillagePlace.Occupancy.c);
            return stream.map(VillagePlaceRecord::f).filter(EntityBee.this::k).sorted(Comparator.comparingDouble(blockposition1 -> blockposition1.j(blockposition))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int b = 600;
        int d;
        private static final int e = 3;
        final List<BlockPosition> f;
        @Nullable
        private PathEntity g;
        private static final int h = 60;
        private int i;

        e() {
            this.d = LeavesConfig.useVanillaRandom ? EntityBee.this.dM().z.a(10) : EntityBee.this.ag.a(10);
            this.f = Lists.newArrayList();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cH != null && !EntityBee.this.fQ() && EntityBee.this.gu() && !this.d(EntityBee.this.cH) && EntityBee.this.dM().a_(EntityBee.this.cH).a(TagsBlock.aF);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void c() {
            this.d = 0;
            this.i = 0;
            super.c();
        }

        @Override
        public void d() {
            this.d = 0;
            this.i = 0;
            EntityBee.this.bN.n();
            EntityBee.this.bN.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.cH != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    this.l();
                } else if (!EntityBee.this.bN.m()) {
                    if (!EntityBee.this.b(EntityBee.this.cH, 16)) {
                        if (EntityBee.this.l(EntityBee.this.cH)) {
                            this.m();
                        } else {
                            EntityBee.this.j(EntityBee.this.cH);
                        }
                    } else {
                        boolean flag = this.a(EntityBee.this.cH);
                        if (!flag) {
                            this.l();
                        } else if (this.g != null && EntityBee.this.bN.j().a(this.g)) {
                            ++this.i;
                            if (this.i > 60) {
                                this.m();
                                this.i = 0;
                            }
                        } else {
                            this.g = EntityBee.this.bN.j();
                        }
                    }
                }
            }
        }

        private boolean a(BlockPosition pos) {
            EntityBee.this.bN.a(10.0f);
            EntityBee.this.bN.a((double)pos.u(), (double)pos.v(), (double)pos.w(), 1.0);
            return EntityBee.this.bN.j() != null && EntityBee.this.bN.j().j();
        }

        boolean b(BlockPosition pos) {
            return this.f.contains(pos);
        }

        private void c(BlockPosition pos) {
            this.f.add(pos);
            while (this.f.size() > 3) {
                this.f.remove(0);
            }
        }

        void k() {
            this.f.clear();
        }

        private void l() {
            if (EntityBee.this.cH != null) {
                this.c(EntityBee.this.cH);
            }
            this.m();
        }

        private void m() {
            EntityBee.this.cH = null;
            EntityBee.this.cD = 200;
        }

        private boolean d(BlockPosition pos) {
            if (EntityBee.this.b(pos, 2)) {
                return true;
            }
            PathEntity pathentity = EntityBee.this.bN.j();
            return pathentity != null && pathentity.l().equals(pos) && pathentity.j() && pathentity.c();
        }
    }

    public class f
    extends a {
        private static final int c = 600;
        int d;

        f() {
            this.d = EntityBee.this.ag.a(10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cG != null && !EntityBee.this.fQ() && this.k() && EntityBee.this.m(EntityBee.this.cG) && !EntityBee.this.b(EntityBee.this.cG, 2);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void c() {
            this.d = 0;
            super.c();
        }

        @Override
        public void d() {
            this.d = 0;
            EntityBee.this.bN.n();
            EntityBee.this.bN.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.cG != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    EntityBee.this.cG = null;
                } else if (!EntityBee.this.bN.m()) {
                    if (EntityBee.this.l(EntityBee.this.cG)) {
                        EntityBee.this.cG = null;
                    } else {
                        EntityBee.this.j(EntityBee.this.cG);
                    }
                }
            }
        }

        private boolean k() {
            return EntityBee.this.cz > 2400;
        }
    }

    private class g
    extends a {
        static final int b = 30;

        g() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.gx() >= 10 ? false : (EntityBee.this.ag.i() < 0.3f ? false : EntityBee.this.go() && EntityBee.this.gA());
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void e() {
            if (EntityBee.this.ag.a(this.a(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    BlockPosition blockposition = EntityBee.this.dm().c(i2);
                    IBlockData iblockdata = EntityBee.this.dM().a_(blockposition);
                    Block block = iblockdata.b();
                    IBlockData iblockdata1 = null;
                    if (!iblockdata.a(TagsBlock.aH)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops blockcrops = (BlockCrops)block;
                        if (!blockcrops.h(iblockdata)) {
                            iblockdata1 = blockcrops.b(blockcrops.g(iblockdata) + 1);
                        }
                    } else if (block instanceof BlockStem) {
                        int j2 = iblockdata.c(BlockStem.c);
                        if (j2 < 7) {
                            iblockdata1 = (IBlockData)iblockdata.a(BlockStem.c, j2 + 1);
                        }
                    } else if (iblockdata.a(Blocks.oi)) {
                        int j3 = iblockdata.c(BlockSweetBerryBush.c);
                        if (j3 < 3) {
                            iblockdata1 = (IBlockData)iblockdata.a(BlockSweetBerryBush.c, j3 + 1);
                        }
                    } else if (iblockdata.a(Blocks.sv) || iblockdata.a(Blocks.sw)) {
                        ((IBlockFragilePlantElement)((Object)iblockdata.b())).a((WorldServer)EntityBee.this.dM(), EntityBee.this.ag, blockposition, iblockdata);
                    }
                    if (iblockdata1 == null || !CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockposition, iblockdata1)) continue;
                    EntityBee.this.dM().c(2005, blockposition, 0);
                    EntityBee.this.dM().b(blockposition, iblockdata1);
                    EntityBee.this.gz();
                }
            }
        }
    }

    private class l
    extends PathfinderGoal {
        private static final int b = 22;

        l() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityBee.this.bN.l() && EntityBee.this.ag.a(10) == 0;
        }

        @Override
        public boolean b() {
            return EntityBee.this.bN.m();
        }

        @Override
        public void c() {
            Vec3D vec3d = this.h();
            if (vec3d != null) {
                EntityBee.this.bN.a(EntityBee.this.bN.a(BlockPosition.a(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D h() {
            Vec3D vec3d;
            if (EntityBee.this.gA() && !EntityBee.this.b(EntityBee.this.cH, 22)) {
                Vec3D vec3d1 = Vec3D.b(EntityBee.this.cH);
                vec3d = vec3d1.d(EntityBee.this.dk()).d();
            } else {
                vec3d = EntityBee.this.f(0.0f);
            }
            boolean flag = true;
            Vec3D vec3d2 = HoverRandomPos.a(EntityBee.this, 8, 7, vec3d.c, vec3d.e, 1.5707964f, 3, 1);
            return vec3d2 != null ? vec3d2 : AirAndWaterRandomPos.a(EntityBee.this, 8, 4, -2, vec3d.c, vec3d.e, 1.5707963705062866);
        }
    }

    private class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee entitybee) {
            super(entitybee, new Class[0]);
        }

        @Override
        public boolean b() {
            return EntityBee.this.aa_() && super.b();
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityBee && this.e.E(target)) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee bee) {
            super(bee, EntityHuman.class, 10, true, false, bee::a_);
        }

        @Override
        public boolean a() {
            return this.i() && super.a();
        }

        @Override
        public boolean b() {
            boolean flag = this.i();
            if (flag && this.e.q() != null) {
                return super.b();
            }
            this.g = null;
            return false;
        }

        private boolean i() {
            EntityBee entitybee = (EntityBee)this.e;
            return entitybee.aa_() && !entitybee.gp();
        }
    }

    private abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean h();

        public abstract boolean i();

        @Override
        public boolean a() {
            return this.h() && !EntityBee.this.aa_();
        }

        @Override
        public boolean b() {
            return this.i() && !EntityBee.this.aa_();
        }
    }
}

