/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.joml.Vector3f;

public class EntityCat
extends EntityTameableAnimal
implements VariantHolder<CatVariant> {
    public static final double bW = 0.6;
    public static final double bX = 0.8;
    public static final double bY = 1.33;
    private static final RecipeItemStack bZ = RecipeItemStack.a(Items.qW, Items.qX);
    private static final DataWatcherObject<CatVariant> ca = DataWatcher.a(EntityCat.class, DataWatcherRegistry.w);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cd = DataWatcher.a(EntityCat.class, DataWatcherRegistry.b);
    private a<EntityHuman> ce;
    @Nullable
    private PathfinderGoalTempt cf;
    private float cg;
    private float ch;
    private float ci;
    private float cj;
    private float ck;
    private float cl;

    public EntityCat(EntityTypes<? extends EntityCat> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
    }

    public MinecraftKey gk() {
        return this.gl().a();
    }

    @Override
    protected void B() {
        this.cf = new PathfinderGoalTemptChance(this, 0.6, bZ, true);
        this.bO.a(1, new PathfinderGoalFloat(this));
        this.bO.a(1, new PathfinderGoalPanic(this, 1.5));
        this.bO.a(2, new PathfinderGoalSit(this));
        this.bO.a(3, new b(this));
        this.bO.a(4, this.cf);
        this.bO.a(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.bO.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f, false));
        this.bO.a(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.bO.a(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.bO.a(9, new PathfinderGoalOcelotAttack(this));
        this.bO.a(10, new PathfinderGoalBreed(this, 0.8));
        this.bO.a(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.bO.a(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.bP.a(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, (Predicate<EntityLiving>)null));
        this.bP.a(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bU));
    }

    public CatVariant gl() {
        return this.an.b(ca);
    }

    @Override
    public void a(CatVariant variant) {
        this.an.b(ca, variant);
    }

    public void A(boolean sleeping) {
        this.an.b(cb, sleeping);
    }

    public boolean gm() {
        return this.an.b(cb);
    }

    public void B(boolean headDown) {
        this.an.b(cc, headDown);
    }

    public boolean gn() {
        return this.an.b(cc);
    }

    public EnumColor go() {
        return EnumColor.a(this.an.b(cd));
    }

    @Override
    public void a(EnumColor color) {
        this.an.b(cd, color.a());
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(ca, BuiltInRegistries.ak.e(CatVariant.b));
        this.an.a(cb, false);
        this.an.a(cc, false);
        this.an.a(cd, EnumColor.o.a());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("variant", BuiltInRegistries.ak.b(this.gl()).toString());
        nbt.a("CollarColor", (byte)this.go().a());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        CatVariant catvariant = BuiltInRegistries.ak.a(MinecraftKey.a(nbt.l("variant")));
        if (catvariant != null) {
            this.a(catvariant);
        }
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
    }

    @Override
    public void Z() {
        if (this.K().b()) {
            double d0 = this.K().c();
            if (d0 == 0.6) {
                this.b(EntityPose.f);
                this.g(false);
            } else if (d0 == 1.33) {
                this.b(EntityPose.a);
                this.g(true);
            } else {
                this.b(EntityPose.a);
                this.g(false);
            }
        } else {
            this.b(EntityPose.a);
            this.g(false);
        }
    }

    @Override
    @Nullable
    protected SoundEffect y() {
        return this.u() ? (this.gi() ? SoundEffects.dz : (this.ag.a(4) == 0 ? SoundEffects.dA : SoundEffects.ds)) : SoundEffects.dt;
    }

    @Override
    public int Q() {
        return 120;
    }

    public void gp() {
        this.a(SoundEffects.dw, this.eW(), this.eX());
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.dy;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.du;
    }

    public static AttributeProvider.Builder gq() {
        return EntityInsentient.C().a(GenericAttributes.l, 10.0).a(GenericAttributes.m, 0.3f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (this.m(stack)) {
            this.a(SoundEffects.dv, 1.0f, 1.0f);
        }
        super.a(player, hand, stack);
    }

    private float gr() {
        return (float)this.b(GenericAttributes.c);
    }

    @Override
    public boolean C(Entity target) {
        return target.a(this.dN().b(this), this.gr());
    }

    @Override
    public void l() {
        super.l();
        if (this.cf != null && this.cf.i() && !this.u() && this.ah % 100 == 0) {
            this.a(SoundEffects.dx, 1.0f, 1.0f);
        }
        this.gs();
    }

    private void gs() {
        if ((this.gm() || this.gn()) && this.ah % 5 == 0) {
            this.a(SoundEffects.dz, 0.6f + 0.4f * (this.ag.i() - this.ag.i()), 1.0f);
        }
        this.gt();
        this.gu();
    }

    private void gt() {
        this.ch = this.cg;
        this.cj = this.ci;
        if (this.gm()) {
            this.cg = Math.min(1.0f, this.cg + 0.15f);
            this.ci = Math.min(1.0f, this.ci + 0.08f);
        } else {
            this.cg = Math.max(0.0f, this.cg - 0.22f);
            this.ci = Math.max(0.0f, this.ci - 0.13f);
        }
    }

    private void gu() {
        this.cl = this.ck;
        this.ck = this.gn() ? Math.min(1.0f, this.ck + 0.1f) : Math.max(0.0f, this.ck - 0.13f);
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.ch, this.cg);
    }

    public float F(float tickDelta) {
        return MathHelper.i(tickDelta, this.cj, this.ci);
    }

    public float G(float tickDelta) {
        return MathHelper.i(tickDelta, this.cl, this.ck);
    }

    @Nullable
    public EntityCat b(WorldServer world, EntityAgeable entity) {
        EntityCat entitycat = EntityTypes.n.a(world);
        if (entitycat != null && entity instanceof EntityCat) {
            EntityCat entitycat1 = (EntityCat)entity;
            if (this.ag.h()) {
                entitycat.a(this.gl());
            } else {
                entitycat.a(entitycat1.gl());
            }
            if (this.u()) {
                entitycat.b(this.d());
                entitycat.x(true);
                if (this.ag.h()) {
                    entitycat.a(this.go());
                } else {
                    entitycat.a(entitycat1.go());
                }
            }
        }
        return entitycat;
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (!this.u()) {
            return false;
        }
        if (!(other instanceof EntityCat)) {
            return false;
        }
        EntityCat entitycat = (EntityCat)other;
        return entitycat.u() && super.a(other);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        entityData = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        boolean flag = world.ap() > 0.9f;
        TagKey<CatVariant> tagkey = flag ? CatVariantTags.b : CatVariantTags.a;
        BuiltInRegistries.ak.b(tagkey).flatMap(holderset_named -> holderset_named.a(world.F_())).ifPresent(holder -> this.a((CatVariant)holder.a()));
        WorldServer worldserver = world.E();
        if (worldserver.a().getStructureWithPieceAt(this.dm(), StructureTags.n, world).b()) {
            this.a(BuiltInRegistries.ak.e(CatVariant.k));
            this.fJ();
        }
        return entityData;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.d();
        if (this.dM().B) {
            return this.u() && this.j(player) ? EnumInteractionResult.a : (this.m(itemstack) && (this.ev() < this.eM() || !this.u()) ? EnumInteractionResult.a : EnumInteractionResult.d);
        }
        if (this.u()) {
            if (this.j(player)) {
                if (!(item instanceof ItemDye)) {
                    if (item.u() && this.m(itemstack) && this.ev() < this.eM()) {
                        this.a(player, hand, itemstack);
                        this.heal(item.v().a(), EntityRegainHealthEvent.RegainReason.EATING);
                        return EnumInteractionResult.b;
                    }
                    EnumInteractionResult enuminteractionresult2 = super.b(player, hand);
                    if (!enuminteractionresult2.a() || this.o_()) {
                        this.z(!this.ge());
                    }
                    return enuminteractionresult2;
                }
                EnumColor enumcolor = ((ItemDye)item).d();
                if (enumcolor != this.go()) {
                    EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)enumcolor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                    if (!event.callEvent()) {
                        return EnumInteractionResult.e;
                    }
                    enumcolor = EnumColor.a(event.getColor().getWoolData());
                    this.a(enumcolor);
                    if (!player.fT().d) {
                        itemstack.h(1);
                    }
                    this.fJ();
                    return EnumInteractionResult.b;
                }
            }
        } else if (this.m(itemstack)) {
            this.a(player, hand, itemstack);
            if (this.ag.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                this.f(player);
                this.z(true);
                this.dM().a((Entity)this, (byte)7);
            } else {
                this.dM().a((Entity)this, (byte)6);
            }
            this.fJ();
            return EnumInteractionResult.b;
        }
        if ((enuminteractionresult = super.b(player, hand)).a()) {
            this.fJ();
        }
        return enuminteractionresult;
    }

    @Override
    public boolean m(ItemStack stack) {
        return bZ.a(stack);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.5f;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.u() && this.ah > 2400;
    }

    @Override
    protected void w() {
        if (this.ce == null) {
            this.ce = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.bO.a(this.ce);
        if (!this.u()) {
            this.bO.a(4, this.ce);
        }
    }

    @Override
    public boolean bT() {
        return this.bX() || super.bT();
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.1875f * scaleFactor, 0.0f);
    }

    private static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityLiving selectedPlayer;
        private final EntityCat d;

        public PathfinderGoalTemptChance(EntityCat cat, double speed, RecipeItemStack food, boolean canBeScared) {
            super(cat, speed, food, canBeScared);
            this.d = cat;
        }

        @Override
        public void e() {
            super.e();
            if (this.selectedPlayer == null && this.a.eg().a(this.a(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.a.eg().a(this.a(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean h() {
            return this.selectedPlayer != null && this.selectedPlayer.equals(this.player) ? false : super.h();
        }

        @Override
        public boolean a() {
            return super.a() && !this.d.u();
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityCat a;
        @Nullable
        private EntityHuman b;
        @Nullable
        private BlockPosition c;
        private int d;

        public b(EntityCat cat) {
            this.a = cat;
        }

        @Override
        public boolean a() {
            if (!this.a.u()) {
                return false;
            }
            if (this.a.ge()) {
                return false;
            }
            EntityLiving entityliving = this.a.R_();
            if (entityliving instanceof EntityHuman) {
                this.b = (EntityHuman)entityliving;
                if (!entityliving.fD()) {
                    return false;
                }
                if (this.a.f((Entity)this.b) > 100.0) {
                    return false;
                }
                BlockPosition blockposition = this.b.dm();
                IBlockData iblockdata = this.a.dM().a_(blockposition);
                if (iblockdata.a(TagsBlock.R)) {
                    this.c = iblockdata.d(BlockFacingHorizontal.aE).map(enumdirection -> blockposition.a(enumdirection.g())).orElseGet(() -> new BlockPosition(blockposition));
                    return !this.h();
                }
            }
            return false;
        }

        private boolean h() {
            EntityCat entitycat;
            List<EntityCat> list = this.a.dM().a(EntityCat.class, new AxisAlignedBB(this.c).g(2.0));
            Iterator<EntityCat> iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((entitycat = iterator.next()) == this.a || !entitycat.gm() && !entitycat.gn());
            return true;
        }

        @Override
        public boolean b() {
            return this.a.u() && !this.a.ge() && this.b != null && this.b.fD() && this.c != null && !this.h();
        }

        @Override
        public void c() {
            if (this.c != null) {
                this.a.y(false);
                this.a.N().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
            }
        }

        @Override
        public void d() {
            this.a.A(false);
            float f2 = this.a.dM().f(1.0f);
            if (this.b.fW() >= 100 && (double)f2 > 0.77 && (double)f2 < 0.8 && (double)this.a.dM().F_().i() < 0.7) {
                this.i();
            }
            this.d = 0;
            this.a.B(false);
            this.a.N().n();
        }

        private void i() {
            RandomSource randomsource = this.a.eg();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            blockposition_mutableblockposition.g(this.a.fS() ? this.a.fT().dm() : this.a.dm());
            this.a.b(blockposition_mutableblockposition.u() + randomsource.a(11) - 5, blockposition_mutableblockposition.v() + randomsource.a(5) - 2, blockposition_mutableblockposition.w() + randomsource.a(11) - 5, false);
            blockposition_mutableblockposition.g(this.a.dm());
            LootTable loottable = this.a.dM().o().aJ().getLootTable(LootTables.aw);
            LootParams lootparams = new LootParams.a((WorldServer)this.a.dM()).a(LootContextParameters.f, this.a.dk()).a(LootContextParameters.a, this.a).a(LootContextParameterSets.i);
            ObjectArrayList<ItemStack> list = loottable.a(lootparams);
            for (ItemStack itemstack : list) {
                EntityItem entityitem = new EntityItem(this.a.dM(), (double)blockposition_mutableblockposition.u() - (double)MathHelper.a(this.a.aU * ((float)Math.PI / 180)), blockposition_mutableblockposition.v(), (double)blockposition_mutableblockposition.w() + (double)MathHelper.b(this.a.aU * ((float)Math.PI / 180)), itemstack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), (org.bukkit.entity.Item)entityitem.getBukkitEntity());
                entityitem.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.a.dM().b(entityitem);
            }
        }

        @Override
        public void e() {
            if (this.b != null && this.c != null) {
                this.a.y(false);
                this.a.N().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
                if (this.a.f((Entity)this.b) < 2.5) {
                    ++this.d;
                    if (this.d > this.a(16)) {
                        this.a.A(true);
                        this.a.B(false);
                    } else {
                        this.a.a((Entity)this.b, 45.0f, 45.0f);
                        this.a.B(true);
                    }
                } else {
                    this.a.A(false);
                }
            }
        }
    }

    private static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat i;

        public a(EntityCat cat, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super(cat, fleeFromType, distance, slowSpeed, fastSpeed, IEntitySelector.e::test);
            this.i = cat;
        }

        @Override
        public boolean a() {
            return !this.i.u() && super.a();
        }

        @Override
        public boolean b() {
            return !this.i.u() && super.b();
        }
    }
}

