/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityIronGolem.class, DataWatcherRegistry.a);
    private static final int d = 25;
    private int e;
    private int bT;
    private static final UniformInt bU = TimeRange.a(20, 39);
    private int bV;
    @Nullable
    private UUID bW;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
        this.t(1.0f);
    }

    @Override
    protected void B() {
        this.bO.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bO.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.bO.a(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.bO.a(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.bO.a(5, new PathfinderGoalOfferFlower(this));
        this.bO.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalDefendVillage(this));
        this.bP.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, entityliving -> entityliving instanceof IMonster && !(entityliving instanceof EntityCreeper)));
        this.bP.a(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(c, (byte)0);
    }

    public static AttributeProvider.Builder u() {
        return EntityInsentient.C().a(GenericAttributes.l, 100.0).a(GenericAttributes.m, 0.25).a(GenericAttributes.i, 1.0).a(GenericAttributes.c, 15.0);
    }

    @Override
    protected int m(int air) {
        return air;
    }

    @Override
    protected void D(Entity entity) {
        if (entity instanceof IMonster && !(entity instanceof EntityCreeper) && this.eg().a(20) == 0) {
            this.setTarget((EntityLiving)entity, EntityTargetEvent.TargetReason.COLLISION, true);
        }
        super.D(entity);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.e > 0) {
            --this.e;
        }
        if (this.bT > 0) {
            --this.bT;
        }
        if (!this.dM().B) {
            this.a((WorldServer)this.dM(), true);
        }
    }

    @Override
    public boolean bl() {
        return this.dp().i() > 2.500000277905201E-7 && this.ag.a(5) == 0;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return this.gf() && type == EntityTypes.bv ? false : (type == EntityTypes.v ? false : super.a(type));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("PlayerCreated", this.gf());
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.x(nbt.q("PlayerCreated"));
        this.a(this.dM(), nbt);
    }

    @Override
    public void c() {
        this.a(bU.a(this.ag));
    }

    @Override
    public void a(int angerTime) {
        this.bV = angerTime;
    }

    @Override
    public int a() {
        return this.bV;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.bW = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.bW;
    }

    private float gg() {
        return (float)this.b(GenericAttributes.c);
    }

    @Override
    public boolean C(Entity target) {
        this.e = 10;
        this.dM().a((Entity)this, (byte)4);
        float f2 = this.gg();
        float f1 = (int)f2 > 0 ? f2 / 2.0f + (float)this.ag.a((int)f2) : f2;
        boolean flag = target.a(this.dN().b(this), f1);
        if (flag) {
            double d0;
            if (target instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)target;
                d0 = entityliving.b(GenericAttributes.i);
            } else {
                d0 = 0.0;
            }
            double d1 = d0;
            double d2 = Math.max(0.0, 1.0 - d1);
            target.g(target.dp().b(0.0, (double)0.4f * d2, 0.0));
            this.a((EntityLiving)this, target);
        }
        this.a(SoundEffects.mA, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        CrackLevel entityirongolem_cracklevel = this.w();
        boolean flag = super.a(source, amount);
        if (flag && this.w() != entityirongolem_cracklevel) {
            this.a(SoundEffects.mB, 1.0f, 1.0f);
        }
        return flag;
    }

    public CrackLevel w() {
        return CrackLevel.a(this.ev() / this.eM());
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.e = 10;
            this.a(SoundEffects.mA, 1.0f, 1.0f);
        } else if (status == 11) {
            this.bT = 400;
        } else if (status == 34) {
            this.bT = 0;
        } else {
            super.b(status);
        }
    }

    public int A() {
        return this.e;
    }

    public void w(boolean lookingAtVillager) {
        if (lookingAtVillager) {
            this.bT = 400;
            this.dM().a((Entity)this, (byte)11);
        } else {
            this.bT = 0;
            this.dM().a((Entity)this, (byte)34);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.mD;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.mC;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.oB)) {
            return EnumInteractionResult.d;
        }
        float f2 = this.ev();
        this.b(25.0f);
        if (this.ev() == f2) {
            return EnumInteractionResult.d;
        }
        float f1 = 1.0f + (this.ag.i() - this.ag.i()) * 0.2f;
        this.a(SoundEffects.mE, 1.0f, f1);
        if (!player.fT().d) {
            itemstack.h(1);
        }
        return EnumInteractionResult.a(this.dM().B);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.mF, 1.0f, 1.0f);
    }

    public int ge() {
        return this.bT;
    }

    public boolean gf() {
        return (this.an.b(c) & 1) != 0;
    }

    public void x(boolean playerCreated) {
        byte b0 = this.an.b(c);
        if (playerCreated) {
            this.an.b(c, (byte)(b0 | 1));
        } else {
            this.an.b(c, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
    }

    @Override
    public boolean a(IWorldReader world) {
        BlockPosition blockposition = this.dm();
        BlockPosition blockposition1 = blockposition.d();
        IBlockData iblockdata = world.a_(blockposition1);
        if (!iblockdata.a((IBlockAccess)world, blockposition1, (Entity)this) && !this.dM().paperConfig().entities.spawning.ironGolemsCanSpawnInAir) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            IBlockData iblockdata1;
            BlockPosition blockposition2 = blockposition.b(i2);
            if (SpawnerCreature.a(world, blockposition2, iblockdata1 = world.a_(blockposition2), iblockdata1.u(), EntityTypes.ad)) continue;
            return false;
        }
        return SpawnerCreature.a(world, blockposition, world.a_(blockposition), FluidTypes.a.g(), EntityTypes.ad) && world.f(this);
    }

    @Override
    public Vec3D cJ() {
        return new Vec3D(0.0, 0.875f * this.cI(), this.dg() * 0.4f);
    }

    public static enum CrackLevel {
        a(1.0f),
        b(0.75f),
        c(0.5f),
        d(0.25f);

        private static final List<CrackLevel> e;
        private final float f;

        private CrackLevel(float f2) {
            this.f = f2;
        }

        public static CrackLevel a(float healthFraction) {
            CrackLevel entityirongolem_cracklevel;
            Iterator<CrackLevel> iterator = e.iterator();
            do {
                if (!iterator.hasNext()) {
                    return a;
                }
                entityirongolem_cracklevel = iterator.next();
            } while (healthFraction >= entityirongolem_cracklevel.f);
            return entityirongolem_cracklevel;
        }

        static {
            e = (List)Stream.of(CrackLevel.values()).sorted(Comparator.comparingDouble(entityirongolem_cracklevel -> entityirongolem_cracklevel.f)).collect(ImmutableList.toImmutableList());
        }
    }
}

