/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntityMushroomCow
extends EntityCow
implements IShearable,
VariantHolder<Type> {
    private static final DataWatcherObject<String> bT = DataWatcher.a(EntityMushroomCow.class, DataWatcherRegistry.e);
    private static final int bU = 1024;
    private static final String bW = "stew_effects";
    @Nullable
    public List<SuspiciousEffectHolder.a> bX;
    @Nullable
    private UUID bY;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> type, World world) {
        super((EntityTypes<? extends EntityCow>)type, world);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos.d()).a(Blocks.fl) ? 10.0f : world.w(pos);
    }

    public static boolean c(EntityTypes<EntityMushroomCow> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bS) && EntityMushroomCow.a(world, pos);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        UUID uuid = lightning.cw();
        if (!uuid.equals(this.bY)) {
            this.a(this.w() == Type.a ? Type.b : Type.a);
            this.bY = uuid;
            this.a(SoundEffects.nX, 2.0f, 1.0f);
        }
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(bT, Type.a.d);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.pn) && !this.o_()) {
            ItemStack itemstack1;
            boolean flag = false;
            if (this.bX != null) {
                flag = true;
                itemstack1 = new ItemStack(Items.vN);
                ItemSuspiciousStew.a(itemstack1, this.bX);
                this.bX = null;
            } else {
                itemstack1 = new ItemStack(Items.po);
            }
            ItemStack itemstack2 = ItemLiquidUtil.a(itemstack, player, itemstack1, false);
            player.a(hand, itemstack2);
            SoundEffect soundeffect = flag ? SoundEffects.oa : SoundEffects.nZ;
            this.a(soundeffect, 1.0f, 1.0f);
            return EnumInteractionResult.a(this.dM().B);
        }
        if (itemstack.a(Items.rS) && this.a()) {
            List<ItemStack> drops = this.generateDefaultDrops();
            PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
            if (event != null) {
                if (event.isCancelled()) {
                    return EnumInteractionResult.d;
                }
                drops = CraftItemStack.asNMSCopy(event.getDrops());
            }
            this.shear(SoundCategory.h, drops);
            this.a(GameEvent.M, (Entity)player);
            if (!this.dM().B) {
                itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        if (this.w() == Type.b && itemstack.a(TagsItem.O)) {
            if (this.bX != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.dM().a(Particles.ab, this.dr() + this.ag.j() / 2.0, this.e(0.5), this.dx() + this.ag.j() / 2.0, 0.0, this.ag.j() / 5.0, 0.0);
                }
            } else {
                Optional<List<SuspiciousEffectHolder.a>> optional = this.l(itemstack);
                if (optional.isEmpty()) {
                    return EnumInteractionResult.d;
                }
                if (!player.fT().d) {
                    itemstack.h(1);
                }
                for (int j2 = 0; j2 < 4; ++j2) {
                    this.dM().a(Particles.q, this.dr() + this.ag.j() / 2.0, this.e(0.5), this.dx() + this.ag.j() / 2.0, 0.0, this.ag.j() / 5.0, 0.0);
                }
                this.bX = optional.get();
                this.a(SoundEffects.nY, 2.0f, 1.0f);
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        return super.b(player, hand);
    }

    @Override
    public void a(SoundCategory shearedSoundCategory) {
        this.shear(shearedSoundCategory, this.generateDefaultDrops());
    }

    @Override
    public List<ItemStack> generateDefaultDrops() {
        ArrayList<ItemStack> dropEntities = new ArrayList<ItemStack>(5);
        for (int i2 = 0; i2 < 5; ++i2) {
            dropEntities.add(new ItemStack(this.w().a().b()));
        }
        return dropEntities;
    }

    @Override
    public void shear(SoundCategory shearedSoundCategory, List<ItemStack> drops) {
        EntityCow entitycow;
        this.dM().a((EntityHuman)null, this, SoundEffects.ob, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.dM().y_() && (entitycow = EntityTypes.u.a(this.dM())) != null) {
            ((WorldServer)this.dM()).a(Particles.x, this.dr(), this.e(0.5), this.dx(), 1, 0.0, 0.0, 0.0, 0.0);
            entitycow.b(this.dr(), this.dt(), this.dx(), this.dC(), this.dE());
            entitycow.c(this.ev());
            entitycow.aU = this.aU;
            if (this.ae()) {
                entitycow.b(this.af());
                entitycow.n(this.cB());
            }
            if (this.fL()) {
                entitycow.fJ();
            }
            entitycow.m(this.cr());
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, entitycow, EntityTransformEvent.TransformReason.SHEARED).isCancelled()) {
                return;
            }
            this.dM().addFreshEntity(entitycow, CreatureSpawnEvent.SpawnReason.SHEARED);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            for (ItemStack drop : drops) {
                EntityItem entityitem = new EntityItem(this.dM(), this.dr(), this.e(1.0), this.dx(), drop);
                this.spawnAtLocation(entityitem);
            }
        }
    }

    @Override
    public boolean a() {
        return this.bx() && !this.o_();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Type", this.w().c());
        if (this.bX != null) {
            SuspiciousEffectHolder.a.b.encodeStart((DynamicOps)DynamicOpsNBT.a, this.bX).result().ifPresent(nbtbase -> nbt.a(bW, (NBTBase)nbtbase));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Type.a(nbt.l("Type")));
        if (nbt.b(bW, 9)) {
            SuspiciousEffectHolder.a.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(bW)).result().ifPresent(list -> {
                this.bX = list;
            });
        }
    }

    private Optional<List<SuspiciousEffectHolder.a>> l(ItemStack flower) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.a(flower.d());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.b()) : Optional.empty();
    }

    @Override
    public void a(Type variant) {
        this.an.b(bT, variant.d);
    }

    public Type w() {
        return Type.a(this.an.b(bT));
    }

    @Nullable
    public EntityMushroomCow c(WorldServer world, EntityAgeable entity) {
        EntityMushroomCow entitymushroomcow = EntityTypes.ap.a(world);
        if (entitymushroomcow != null) {
            entitymushroomcow.a(this.a((EntityMushroomCow)entity));
        }
        return entitymushroomcow;
    }

    private Type a(EntityMushroomCow mooshroom) {
        Type entitymushroomcow_type1;
        Type entitymushroomcow_type = this.w();
        Type entitymushroomcow_type2 = entitymushroomcow_type == (entitymushroomcow_type1 = mooshroom.w()) && this.ag.a(1024) == 0 ? (entitymushroomcow_type == Type.b ? Type.a : Type.b) : (this.ag.h() ? entitymushroomcow_type : entitymushroomcow_type1);
        return entitymushroomcow_type2;
    }

    public static enum Type implements INamable
    {
        a("red", Blocks.cg.o()),
        b("brown", Blocks.cf.o());

        public static final INamable.a<Type> c;
        final String d;
        final IBlockData e;

        private Type(String s2, IBlockData iblockdata) {
            this.d = s2;
            this.e = iblockdata;
        }

        public IBlockData a() {
            return this.e;
        }

        @Override
        public String c() {
            return this.d;
        }

        static Type a(String name) {
            return c.a(name, a);
        }

        static {
            c = INamable.a(Type::values);
        }
    }
}

