/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte c = 16;
    private static final float d = 1.7f;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
    }

    @Override
    protected void B() {
        this.bO.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.bO.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.bO.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(4, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, entityliving -> entityliving instanceof IMonster));
    }

    public static AttributeProvider.Builder u() {
        return EntityInsentient.C().a(GenericAttributes.l, 4.0).a(GenericAttributes.m, 0.2f);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(b, (byte)16);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Pumpkin", this.w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("Pumpkin")) {
            this.w(nbt.q("Pumpkin"));
        }
    }

    @Override
    public boolean fh() {
        return true;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dM().B) {
            if (this.dM().t(this.dm()).a(BiomeTags.ae)) {
                this.a(this.dN().melting(), 1.0f);
            }
            if (!this.dM().Z().b(GameRules.c)) {
                return;
            }
            IBlockData iblockdata = Blocks.dN.o();
            for (int i2 = 0; i2 < 4; ++i2) {
                int j2 = MathHelper.a(this.dr() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                int k2 = MathHelper.a(this.dt());
                int l2 = MathHelper.a(this.dx() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockposition = new BlockPosition(j2, k2, l2);
                if (!this.dM().a_(blockposition).i() || !iblockdata.a((IWorldReader)this.dM(), blockposition) || !CraftEventFactory.handleBlockFormEvent(this.dM(), blockposition, iblockdata, this)) continue;
                this.dM().a(GameEvent.i, blockposition, GameEvent.a.a(this, iblockdata));
            }
        }
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        EntitySnowball entitysnowball = new EntitySnowball(this.dM(), this);
        double d0 = target.dv() - (double)1.1f;
        double d1 = target.dr() - this.dr();
        double d2 = d0 - entitysnowball.dt();
        double d3 = target.dx() - this.dx();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        entitysnowball.c(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.a(SoundEffects.xJ, 1.0f, 0.4f / (this.eg().i() * 0.4f + 0.8f));
        this.dM().b(entitysnowball);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 1.7f;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.rS) && this.a()) {
            List<ItemStack> drops = this.generateDefaultDrops();
            PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
            if (event != null) {
                if (event.isCancelled()) {
                    return EnumInteractionResult.d;
                }
                drops = CraftItemStack.asNMSCopy(event.getDrops());
            }
            this.shear(SoundCategory.h, drops);
            this.a(GameEvent.M, (Entity)player);
            if (!this.dM().B) {
                itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        return EnumInteractionResult.d;
    }

    @Override
    public void a(SoundCategory shearedSoundCategory) {
        this.shear(shearedSoundCategory, this.generateDefaultDrops());
    }

    @Override
    public List<ItemStack> generateDefaultDrops() {
        return Collections.singletonList(new ItemStack(Items.fk));
    }

    @Override
    public void shear(SoundCategory shearedSoundCategory, List<ItemStack> drops) {
        this.dM().a((EntityHuman)null, this, SoundEffects.xK, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.dM().y_()) {
            this.w(false);
            for (ItemStack drop : drops) {
                this.forceDrops = true;
                this.a(drop, 1.7f);
                this.forceDrops = false;
            }
        }
    }

    @Override
    public boolean a() {
        return this.bx() && this.w();
    }

    public boolean w() {
        return (this.an.b(b) & 0x10) != 0;
    }

    public void w(boolean hasPumpkin) {
        byte b0 = this.an.b(b);
        if (hasPumpkin) {
            this.an.b(b, (byte)(b0 | 0x10));
        } else {
            this.an.b(b, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect y() {
        return SoundEffects.xG;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.xI;
    }

    @Override
    @Nullable
    public SoundEffect n_() {
        return SoundEffects.xH;
    }

    @Override
    public Vec3D cJ() {
        return new Vec3D(0.0, 0.75f * this.cI(), this.dg() * 0.4f);
    }
}

