/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.joml.Vector3f;

public class Frog
extends EntityAnimal
implements VariantHolder<FrogVariant> {
    public static final RecipeItemStack bT = RecipeItemStack.a(Items.qN);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Frog>>> bU = ImmutableList.of(SensorType.c, SensorType.f, SensorType.t, SensorType.r, SensorType.u);
    protected static final ImmutableList<MemoryModuleType<?>> bW = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.r, MemoryModuleType.R, MemoryModuleType.S, MemoryModuleType.o, MemoryModuleType.N, MemoryModuleType.O, (Object[])new MemoryModuleType[]{MemoryModuleType.Q, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.B, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.Y, MemoryModuleType.Z});
    private static final DataWatcherObject<FrogVariant> cc = DataWatcher.a(Frog.class, DataWatcherRegistry.x);
    private static final DataWatcherObject<OptionalInt> cd = DataWatcher.a(Frog.class, DataWatcherRegistry.u);
    private static final int ce = 5;
    public static final String bX = "variant";
    public final AnimationState bY = new AnimationState();
    public final AnimationState bZ = new AnimationState();
    public final AnimationState ca = new AnimationState();
    public final AnimationState cb = new AnimationState();

    public Frog(EntityTypes<? extends EntityAnimal> type, World world) {
        super(type, world);
        this.bK = new a(this);
        this.a(PathType.j, 4.0f);
        this.a(PathType.e, -1.0f);
        this.bL = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.t(1.0f);
    }

    protected BehaviorController.b<Frog> dP() {
        return BehaviorController.a(bW, bU);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return FrogAi.a(this.dP().a(dynamic));
    }

    public BehaviorController<Frog> dO() {
        return super.dO();
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(cc, FrogVariant.a);
        this.an.a(cd, OptionalInt.empty());
    }

    public void u() {
        this.an.b(cd, OptionalInt.empty());
    }

    public Optional<Entity> w() {
        return this.an.b(cd).stream().mapToObj(this.dM()::a).filter(Objects::nonNull).findFirst();
    }

    @Override
    public void a(Entity entity) {
        this.an.b(cd, OptionalInt.of(entity.aj()));
    }

    @Override
    public int fH() {
        return 35;
    }

    @Override
    public int ab() {
        return 5;
    }

    public FrogVariant A() {
        return this.an.b(cc);
    }

    @Override
    public void a(FrogVariant variant) {
        this.an.b(cc, variant);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(bX, BuiltInRegistries.al.b(this.A()).toString());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        FrogVariant frogVariant = BuiltInRegistries.al.a(MinecraftKey.a(nbt.l(bX)));
        if (frogVariant != null) {
            this.a(frogVariant);
        }
    }

    @Override
    protected void Z() {
        this.dM().af().a("frogBrain");
        this.dO().a((WorldServer)this.dM(), this);
        this.dM().af().c();
        this.dM().af().a("frogActivityUpdate");
        FrogAi.a(this);
        this.dM().af().c();
        super.Z();
    }

    @Override
    public void l() {
        if (this.dM().y_()) {
            this.cb.a(this.bc() && !this.aQ.c(), this.ah);
        }
        super.l();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (Entity.as.equals(data)) {
            EntityPose pose = this.ap();
            if (pose == EntityPose.g) {
                this.bY.a(this.ah);
            } else {
                this.bY.a();
            }
            if (pose == EntityPose.i) {
                this.bZ.a(this.ah);
            } else {
                this.bZ.a();
            }
            if (pose == EntityPose.j) {
                this.ca.a(this.ah);
            } else {
                this.ca.a();
            }
        }
        super.a(data);
    }

    @Override
    protected void v(float posDelta) {
        float f2 = this.bY.c() ? 0.0f : Math.min(posDelta * 25.0f, 1.0f);
        this.aQ.a(f2, 0.4f);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        Frog frog = EntityTypes.P.a(world);
        if (frog != null) {
            FrogAi.a(frog, world.F_());
        }
        return frog;
    }

    @Override
    public boolean o_() {
        return false;
    }

    @Override
    public void a(boolean baby) {
    }

    @Override
    public void a(WorldServer world, EntityAnimal other) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, other);
        if (result.isCancelled()) {
            return;
        }
        this.finalizeSpawnChildFromBreeding(world, other, null, result.getExperience());
        this.dO().a(MemoryModuleType.X, Unit.a);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        Holder<BiomeBase> holder = world.t(this.dm());
        if (holder.a(BiomeTags.ai)) {
            this.a(FrogVariant.c);
        } else if (holder.a(BiomeTags.aj)) {
            this.a(FrogVariant.b);
        } else {
            this.a(FrogVariant.a);
        }
        FrogAi.a(this, world.F_());
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static AttributeProvider.Builder ge() {
        return EntityInsentient.C().a(GenericAttributes.m, 1.0).a(GenericAttributes.l, 10.0).a(GenericAttributes.c, 10.0);
    }

    @Override
    @Nullable
    protected SoundEffect y() {
        return SoundEffects.jh;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.jk;
    }

    @Override
    @Nullable
    public SoundEffect n_() {
        return SoundEffects.ji;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.jn, 0.15f, 1.0f);
    }

    @Override
    public boolean cz() {
        return false;
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return super.d(fallDistance, damageMultiplier) - 5;
    }

    @Override
    public void a(Vec3D movementInput) {
        if (this.cX() && this.aZ()) {
            this.a(this.ff(), movementInput);
            this.a(EnumMoveType.a, this.dp());
            this.g(this.dp().a(0.9));
        } else {
            super.a(movementInput);
        }
    }

    public static boolean j(EntityLiving entity) {
        EntitySlime slime;
        if (entity instanceof EntitySlime && (slime = (EntitySlime)entity).gf() != 1) {
            return false;
        }
        return entity.ai().a(TagsEntity.n);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new c(this, world);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.125f * scaleFactor, -0.25f * scaleFactor);
    }

    @Override
    public boolean m(ItemStack stack) {
        return bT.a(stack);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn reason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bY) && Frog.a(world, pos);
    }

    class a
    extends ControllerLook {
        a(EntityInsentient entity) {
            super(entity);
        }

        @Override
        protected boolean c() {
            return Frog.this.w().isEmpty();
        }
    }

    static class c
    extends AmphibiousPathNavigation {
        c(Frog frog, World world) {
            super(frog, world);
        }

        @Override
        public boolean b(PathType nodeType) {
            return nodeType != PathType.k && super.b(nodeType);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new b(true);
            this.o.a(true);
            return new Pathfinder(this.o, range);
        }
    }

    static class b
    extends AmphibiousNodeEvaluator {
        private final BlockPosition.MutableBlockPosition l = new BlockPosition.MutableBlockPosition();

        public b(boolean penalizeDeepWater) {
            super(penalizeDeepWater);
        }

        @Override
        public PathPoint a() {
            return !this.b.aZ() ? super.a() : this.c(new BlockPosition(MathHelper.a(this.b.cH().a), MathHelper.a(this.b.cH().b), MathHelper.a(this.b.cH().c)));
        }

        @Override
        public PathType a(IBlockAccess world, int x2, int y2, int z2) {
            this.l.d(x2, y2 - 1, z2);
            IBlockData blockState = world.a_(this.l);
            return blockState.a(TagsBlock.bK) ? PathType.b : super.a(world, x2, y2, z2);
        }
    }
}

