/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.TadpoleAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class Tadpole
extends EntityFish {
    @VisibleForTesting
    public static int b = Math.abs(-24000);
    public static float c = 0.4f;
    public static float d = 0.3f;
    public int bU;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Tadpole>>> e = ImmutableList.of(SensorType.c, SensorType.d, SensorType.f, SensorType.r);
    protected static final ImmutableList<MemoryModuleType<?>> bT = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.J, MemoryModuleType.O, MemoryModuleType.Q, MemoryModuleType.N, MemoryModuleType.r, MemoryModuleType.Y);
    public boolean ageLocked;

    public Tadpole(EntityTypes<? extends EntityFish> type, World world) {
        super(type, world);
        this.bL = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.bK = new SmoothSwimmingLookControl(this, 10);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationGuardian(this, world);
    }

    protected BehaviorController.b<Tadpole> dP() {
        return BehaviorController.a(bT, e);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return TadpoleAi.a(this.dP().a(dynamic));
    }

    public BehaviorController<Tadpole> dO() {
        return super.dO();
    }

    @Override
    protected SoundEffect gf() {
        return SoundEffects.yx;
    }

    @Override
    protected void Z() {
        this.dM().af().a("tadpoleBrain");
        this.dO().a((WorldServer)this.dM(), this);
        this.dM().af().c();
        this.dM().af().a("tadpoleActivityUpdate");
        TadpoleAi.a(this);
        this.dM().af().c();
        super.Z();
    }

    public static AttributeProvider.Builder gg() {
        return EntityInsentient.C().a(GenericAttributes.m, 1.0).a(GenericAttributes.l, 6.0);
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dM().B && !this.ageLocked) {
            this.s(this.bU + 1);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Age", this.bU);
        nbt.a("AgeLocked", this.ageLocked);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.s(nbt.h("Age"));
        this.ageLocked = nbt.q("AgeLocked");
    }

    @Override
    @Nullable
    protected SoundEffect y() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.yz;
    }

    @Override
    @Nullable
    public SoundEffect n_() {
        return SoundEffects.yw;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.m(itemstack)) {
            this.a(player, itemstack);
            return EnumInteractionResult.a(this.dM().B);
        }
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public boolean w() {
        return true;
    }

    @Override
    public void w(boolean fromBucket) {
    }

    @Override
    public void l(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        NBTTagCompound nbttagcompound = stack.w();
        nbttagcompound.a("Age", this.gh());
        nbttagcompound.a("AgeLocked", this.ageLocked);
    }

    @Override
    public void c(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
        if (nbt.e("Age")) {
            this.s(nbt.h("Age"));
        }
        this.ageLocked = nbt.q("AgeLocked");
    }

    @Override
    public ItemStack b() {
        return new ItemStack(Items.qH);
    }

    @Override
    public SoundEffect A() {
        return SoundEffects.cP;
    }

    private boolean m(ItemStack stack) {
        return Frog.bT.a(stack);
    }

    private void a(EntityHuman player, ItemStack stack) {
        this.b(player, stack);
        this.c(EntityAgeable.d_(this.gj()));
        this.dM().a(Particles.M, this.d(1.0), this.du() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
    }

    private void b(EntityHuman player, ItemStack stack) {
        if (!player.fT().d) {
            stack.h(1);
        }
    }

    private int gh() {
        return this.bU;
    }

    private void c(int seconds) {
        if (this.ageLocked) {
            return;
        }
        this.s(this.bU + seconds * 20);
    }

    private void s(int tadpoleAge) {
        this.bU = tadpoleAge;
        if (this.bU >= b) {
            this.gi();
        }
    }

    private void gi() {
        World world = this.dM();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Frog frog = EntityTypes.P.a(this.dM());
            if (frog != null) {
                frog.b(this.dr(), this.dt(), this.dx(), this.dC(), this.dE());
                frog.a(worldserver, this.dM().d_(frog.dm()), EnumMobSpawn.i, (GroupDataEntity)null, null);
                frog.t(this.fU());
                if (this.ae()) {
                    frog.b(this.af());
                    frog.n(this.cB());
                }
                frog.fJ();
                if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, frog, EntityTransformEvent.TransformReason.METAMORPHOSIS).isCancelled()) {
                    this.s(0);
                    return;
                }
                this.a(SoundEffects.yy, 0.15f, 1.0f);
                worldserver.addFreshEntityWithPassengers(frog, CreatureSpawnEvent.SpawnReason.METAMORPHOSIS);
                this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            }
        }
    }

    public int gj() {
        return Math.max(0, b - this.bU);
    }

    @Override
    public boolean ec() {
        return false;
    }
}

