/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;
import org.joml.Vector3f;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.PcaSyncProtocol;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
OwnableEntity,
IJumpable,
ISaddleable {
    public static final int cf = 400;
    public static final int cg = 499;
    public static final int ch = 500;
    public static final double ci = 0.15;
    private static final float bT = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float bU = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float bW = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float bX = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float bY = EntityHorseAbstract.a((int i2) -> 0);
    private static final float bZ = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float ca = 0.25f;
    private static final float cb = 0.5f;
    private static final Predicate<EntityLiving> cc = entityliving -> entityliving instanceof EntityHorseAbstract && ((EntityHorseAbstract)entityliving).gy();
    private static final PathfinderTargetCondition cd = PathfinderTargetCondition.b().a(16.0).d().a(cc);
    private static final RecipeItemStack ce = RecipeItemStack.a(Items.pt, Items.rx, Blocks.ij.k(), Items.oq, Items.ud, Items.pX, Items.pY);
    private static final DataWatcherObject<Byte> cw = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cx = 2;
    private static final int cy = 4;
    private static final int cz = 8;
    private static final int cA = 16;
    private static final int cB = 32;
    private static final int cC = 64;
    public static final int cj = 0;
    public static final int ck = 1;
    public static final int cl = 2;
    private int cD;
    private int cE;
    private int cF;
    public int cm;
    public int cn;
    protected boolean co;
    public InventorySubcontainer cp;
    protected int cq;
    protected float cr;
    protected boolean cs;
    private float cG;
    private float cH;
    private float cI;
    private float cJ;
    private float cK;
    private float cL;
    protected boolean ct = true;
    protected int cu;
    @Nullable
    private UUID cM;
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.t(1.0f);
        this.gA();
    }

    @Override
    protected void B() {
        this.bO.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bO.a(1, new PathfinderGoalTame(this, 1.2));
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bO.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bO.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bO.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.gk()) {
            this.bO.a(9, new RandomStandGoal(this));
        }
        this.gu();
    }

    protected void gu() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.ud, Items.pX, Items.pY), false));
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(cw, (byte)0);
    }

    protected boolean t(int bitmask) {
        return (this.an.b(cw) & bitmask) != 0;
    }

    protected void d(int bitmask, boolean flag) {
        byte b0 = this.an.b(cw);
        if (flag) {
            this.an.b(cw, (byte)(b0 | bitmask));
        } else {
            this.an.b(cw, (byte)(b0 & ~bitmask));
        }
    }

    public boolean gt() {
        return this.t(2);
    }

    @Override
    @Nullable
    public UUID d() {
        return this.cM;
    }

    public void b(@Nullable UUID ownerUuid) {
        this.cM = ownerUuid;
    }

    public boolean gv() {
        return this.co;
    }

    public void x(boolean tame) {
        this.d(2, tame);
    }

    public void y(boolean inAir) {
        this.co = inAir;
    }

    @Override
    protected void D(float leashLength) {
        if (leashLength > 6.0f && this.gw()) {
            this.A(false);
        }
    }

    public boolean gw() {
        return this.t(16);
    }

    public boolean gx() {
        return this.t(32);
    }

    public boolean gy() {
        return this.t(8);
    }

    public void z(boolean bred) {
        this.d(8, bred);
    }

    @Override
    public boolean g() {
        return this.bx() && !this.o_() && this.gt();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.equipSaddle(sound, null);
    }

    @Override
    public void equipSaddle(@Nullable SoundCategory sound, @Nullable ItemStack stack) {
        this.cp.a(0, stack != null ? stack : new ItemStack(Items.nK));
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.l(stack)) {
            this.cp.a(1, stack.c(1));
            if (!player.fT().d) {
                stack.h(1);
            }
        }
    }

    @Override
    public boolean i() {
        return this.t(4);
    }

    public int gz() {
        return this.cq;
    }

    public void u(int temper) {
        this.cq = temper;
    }

    public int v(int difference) {
        int j2 = MathHelper.a(this.gz() + difference, 0, this.gF());
        this.u(j2);
        return j2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.bP();
    }

    private void u() {
        SoundEffect soundeffect;
        this.ge();
        if (!this.aU() && (soundeffect = this.gl()) != null) {
            this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), soundeffect, this.db(), 1.0f, 1.0f + (this.ag.i() - this.ag.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0f) {
            this.a(SoundEffects.mb, 0.4f, 1.0f);
        }
        if ((i2 = this.d(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        if (this.bP()) {
            for (Entity entity : this.cT()) {
                entity.a(damageSource, (float)i2);
            }
        }
        this.eI();
        return true;
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return MathHelper.f((fallDistance * 0.5f - 3.0f) * damageMultiplier);
    }

    protected int ac_() {
        return 2;
    }

    public void gA() {
        InventorySubcontainer inventorysubcontainer = this.cp;
        this.cp = new InventorySubcontainer(this.ac_(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (inventorysubcontainer != null) {
            inventorysubcontainer.b(this);
            int i2 = Math.min(inventorysubcontainer.b(), this.cp.b());
            for (int j2 = 0; j2 < i2; ++j2) {
                ItemStack itemstack = inventorysubcontainer.a(j2);
                if (itemstack.b()) continue;
                this.cp.a(j2, itemstack.p());
            }
        }
        this.cp.a(this);
        this.gB();
    }

    protected void gB() {
        if (!this.dM().B) {
            this.d(4, !this.cp.a(0).b());
        }
    }

    @Override
    public void a(IInventory sender) {
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.syncEntityToClient(this);
        }
        boolean flag = this.i();
        this.gB();
        if (this.ah > 20 && !flag && this.i()) {
            this.a(this.Z_(), 0.5f, 1.0f);
        }
    }

    public double gC() {
        return this.b(GenericAttributes.h);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (flag && this.ag.a(3) == 0) {
            this.gJ();
        }
        return flag;
    }

    protected boolean gk() {
        return true;
    }

    @Nullable
    protected SoundEffect gl() {
        return null;
    }

    @Nullable
    protected SoundEffect gD() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (!state.k()) {
            IBlockData iblockdata1 = this.dM().a_(pos.c());
            SoundEffectType soundeffecttype = state.w();
            if (iblockdata1.a(Blocks.dN)) {
                soundeffecttype = iblockdata1.w();
            }
            if (this.bP() && this.ct) {
                ++this.cu;
                if (this.cu > 5 && this.cu % 3 == 0) {
                    this.a(soundeffecttype);
                } else if (this.cu <= 5) {
                    this.a(SoundEffects.me, soundeffecttype.a() * 0.15f, soundeffecttype.b());
                }
            } else if (this.b(soundeffecttype)) {
                this.a(SoundEffects.me, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            } else {
                this.a(SoundEffects.md, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            }
        }
    }

    private boolean b(SoundEffectType soundGroup) {
        return soundGroup == SoundEffectType.b || soundGroup == SoundEffectType.aT || soundGroup == SoundEffectType.B || soundGroup == SoundEffectType.aU || soundGroup == SoundEffectType.aS;
    }

    protected void a(SoundEffectType group) {
        this.a(SoundEffects.lY, group.a() * 0.15f, group.b());
    }

    public static AttributeProvider.Builder gE() {
        return EntityInsentient.C().a(GenericAttributes.h).a(GenericAttributes.l, 53.0).a(GenericAttributes.m, 0.225f);
    }

    @Override
    public int fI() {
        return 6;
    }

    public int gF() {
        return this.maxDomestication;
    }

    @Override
    public float eW() {
        return 0.8f;
    }

    @Override
    public int Q() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.dM().B && (!this.bP() || this.x(player)) && this.gt()) {
            player.a(this, this.cp);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (flag & !player.fT().d) {
            stack.h(1);
        }
        return this.dM().B ? EnumInteractionResult.b : (flag ? EnumInteractionResult.a : EnumInteractionResult.d);
    }

    protected boolean a(EntityHuman player, ItemStack item) {
        boolean flag = false;
        float f2 = 0.0f;
        int short0 = 0;
        int b0 = 0;
        if (item.a(Items.pt)) {
            f2 = 2.0f;
            short0 = 20;
            b0 = 3;
        } else if (item.a(Items.rx)) {
            f2 = 1.0f;
            short0 = 30;
            b0 = 3;
        } else if (item.a(Blocks.ij.k())) {
            f2 = 20.0f;
            short0 = 180;
        } else if (item.a(Items.oq)) {
            f2 = 3.0f;
            short0 = 60;
            b0 = 3;
        } else if (item.a(Items.ud)) {
            f2 = 4.0f;
            short0 = 60;
            b0 = 5;
            if (!this.dM().B && this.gt() && this.h() == 0 && !this.gi()) {
                flag = true;
                this.setInLove(player, item.p());
            }
        } else if (item.a(Items.pX) || item.a(Items.pY)) {
            f2 = 10.0f;
            short0 = 240;
            b0 = 10;
            if (!this.dM().B && this.gt() && this.h() == 0 && !this.gi()) {
                flag = true;
                this.setInLove(player, item.p());
            }
        }
        if (this.ev() < this.eM() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.o_() && short0 > 0) {
            this.dM().a(Particles.M, this.d(1.0), this.du() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dM().B) {
                this.b_(short0);
                flag = true;
            }
        }
        if (!(b0 <= 0 || !flag && this.gt() || this.gz() >= this.gF() || this.dM().B)) {
            this.v(b0);
            flag = true;
        }
        if (flag) {
            this.u();
            this.a(GameEvent.m);
        }
        return flag;
    }

    protected void f(EntityHuman player) {
        this.A(false);
        this.B(false);
        if (!this.dM().B) {
            player.r(this.dC());
            player.s(this.dE());
            player.n(this);
        }
    }

    @Override
    public boolean eY() {
        return super.eY() && this.bP() && this.i() || this.gw() || this.gx();
    }

    @Override
    public boolean m(ItemStack stack) {
        return ce.a(stack);
    }

    private void w() {
        this.cm = 1;
    }

    @Override
    protected void ey() {
        super.ey();
        if (this.cp != null) {
            for (int i2 = 0; i2 < this.cp.b(); ++i2) {
                ItemStack itemstack = this.cp.a(i2);
                if (itemstack.b() || EnchantmentManager.e(itemstack)) continue;
                this.b(itemstack);
            }
        }
    }

    @Override
    public void d_() {
        if (this.ag.a(200) == 0) {
            this.w();
        }
        super.d_();
        if (!this.dM().B && this.bx()) {
            if (this.ag.a(900) == 0 && this.aM == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.gH()) {
                if (!this.gw() && !this.bP() && this.ag.a(300) == 0 && this.dM().a_(this.dm().d()).a(Blocks.i)) {
                    this.A(true);
                }
                if (this.gw() && ++this.cD > 50) {
                    this.cD = 0;
                    this.A(false);
                }
            }
            this.gG();
        }
    }

    protected void gG() {
        EntityHorseAbstract entityliving;
        if (this.gy() && this.o_() && !this.gw() && (entityliving = this.dM().a(EntityHorseAbstract.class, cd, this, this.dr(), this.dt(), this.dx(), this.cH().g(16.0))) != null && this.f((Entity)entityliving) > 4.0) {
            this.bN.a((Entity)entityliving, 0);
        }
    }

    public boolean gH() {
        return true;
    }

    @Override
    public void l() {
        super.l();
        if (this.cE > 0 && ++this.cE > 30) {
            this.cE = 0;
            this.d(64, false);
        }
        if (this.cY() && this.cF > 0 && ++this.cF > 20) {
            this.cF = 0;
            this.B(false);
        }
        if (this.cm > 0 && ++this.cm > 8) {
            this.cm = 0;
        }
        if (this.cn > 0) {
            ++this.cn;
            if (this.cn > 300) {
                this.cn = 0;
            }
        }
        this.cH = this.cG;
        if (this.gw()) {
            this.cG += (1.0f - this.cG) * 0.4f + 0.05f;
            if (this.cG > 1.0f) {
                this.cG = 1.0f;
            }
        } else {
            this.cG += (0.0f - this.cG) * 0.4f - 0.05f;
            if (this.cG < 0.0f) {
                this.cG = 0.0f;
            }
        }
        this.cJ = this.cI;
        if (this.gx()) {
            this.cH = this.cG = 0.0f;
            this.cI += (1.0f - this.cI) * 0.4f + 0.05f;
            if (this.cI > 1.0f) {
                this.cI = 1.0f;
            }
        } else {
            this.cs = false;
            this.cI += (0.8f * this.cI * this.cI * this.cI - this.cI) * 0.6f - 0.05f;
            if (this.cI < 0.0f) {
                this.cI = 0.0f;
            }
        }
        this.cL = this.cK;
        if (this.t(64)) {
            this.cK += (1.0f - this.cK) * 0.7f + 0.05f;
            if (this.cK > 1.0f) {
                this.cK = 1.0f;
            }
        } else {
            this.cK += (0.0f - this.cK) * 0.7f - 0.05f;
            if (this.cK < 0.0f) {
                this.cK = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.t(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (!this.bP() && !this.o_()) {
            if (this.gt() && player.fI()) {
                this.b(player);
                return EnumInteractionResult.a(this.dM().B);
            }
            ItemStack itemstack = player.b(hand);
            if (!itemstack.b()) {
                EnumInteractionResult enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand);
                if (enuminteractionresult.a()) {
                    return enuminteractionresult;
                }
                if (this.gN() && this.l(itemstack) && !this.gO()) {
                    this.b(player, itemstack);
                    return EnumInteractionResult.a(this.dM().B);
                }
            }
            this.f(player);
            return EnumInteractionResult.a(this.dM().B);
        }
        return super.b(player, hand);
    }

    private void ge() {
        if (!this.dM().B) {
            this.cE = 1;
            this.d(64, true);
        }
    }

    public void A(boolean eatingGrass) {
        this.d(16, eatingGrass);
    }

    public void setForceStanding(boolean standing) {
        this.d(32, standing);
    }

    public void B(boolean angry) {
        if (angry) {
            this.A(false);
        }
        this.d(32, angry);
    }

    @Nullable
    public SoundEffect gI() {
        return this.y();
    }

    public void gJ() {
        if (this.gk() && this.cY()) {
            this.cF = 1;
            this.B(true);
        }
    }

    public void gK() {
        if (!this.gx()) {
            this.gJ();
            SoundEffect soundeffect = this.gD();
            if (soundeffect != null) {
                this.a(soundeffect, this.eW(), this.eX());
            }
        }
    }

    public boolean h(EntityHuman player) {
        this.b(player.cw());
        this.x(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.y.a((EntityPlayer)player, this);
        }
        this.dM().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        super.a(controllingPlayer, movementInput);
        Vec2F vec2f = this.j(controllingPlayer);
        this.a(vec2f.j, vec2f.i);
        this.aU = this.aW = this.dC();
        this.N = this.aW;
        if (this.cX()) {
            if (movementInput.e <= 0.0) {
                this.cu = 0;
            }
            if (this.aC()) {
                this.y(false);
                if (this.cr > 0.0f && !this.gv()) {
                    this.b(this.cr, movementInput);
                }
                this.cr = 0.0f;
            }
        }
    }

    protected Vec2F j(EntityLiving controllingPassenger) {
        return new Vec2F(controllingPassenger.dE() * 0.5f, controllingPassenger.dC());
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        if (this.aC() && this.cr == 0.0f && this.gx() && !this.cs) {
            return Vec3D.b;
        }
        float f2 = controllingPlayer.bk * 0.5f;
        float f1 = controllingPlayer.bm;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)this.b(GenericAttributes.m);
    }

    protected void b(float strength, Vec3D movementInput) {
        double d0 = this.gC() * (double)strength * (double)this.aK();
        double d1 = d0 + (double)this.fa();
        Vec3D vec3d1 = this.dp();
        this.o(vec3d1.c, d1, vec3d1.e);
        this.y(true);
        this.au = true;
        if (movementInput.e > 0.0) {
            float f1 = MathHelper.a(this.dC() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dC() * ((float)Math.PI / 180));
            this.g(this.dp().b(-0.4f * f1 * strength, 0.0, 0.4f * f2 * strength));
        }
    }

    protected void gL() {
        this.a(SoundEffects.ma, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("EatingHaystack", this.gw());
        nbt.a("Bred", this.gy());
        nbt.a("Temper", this.gz());
        nbt.a("Tame", this.gt());
        if (this.d() != null) {
            nbt.a("Owner", this.d());
        }
        nbt.a("Bukkit.MaxDomestication", this.maxDomestication);
        if (!this.cp.a(0).b()) {
            nbt.a("SaddleItem", this.cp.a(0).b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemstack;
        UUID uuid;
        super.a(nbt);
        this.A(nbt.q("EatingHaystack"));
        this.z(nbt.q("Bred"));
        this.u(nbt.h("Temper"));
        this.x(nbt.q("Tame"));
        if (nbt.b("Owner")) {
            uuid = nbt.a("Owner");
        } else {
            String s2 = nbt.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cL(), s2);
        }
        if (uuid != null) {
            this.b(uuid);
        }
        if (nbt.e("Bukkit.MaxDomestication")) {
            this.maxDomestication = nbt.h("Bukkit.MaxDomestication");
        }
        if (nbt.b("SaddleItem", 10) && (itemstack = ItemStack.a(nbt.p("SaddleItem"))).a(Items.nK)) {
            this.cp.a(0, itemstack);
        }
        this.gB();
    }

    @Override
    public boolean a(EntityAnimal other) {
        return false;
    }

    protected boolean gM() {
        return !this.bP() && !this.bO() && this.gt() && !this.o_() && this.ev() >= this.eM() && this.gi();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    protected void a(EntityAgeable other, EntityHorseAbstract child) {
        this.a(other, child, GenericAttributes.l, (double)bY, (double)bZ);
        this.a(other, child, GenericAttributes.h, (double)bW, (double)bX);
        this.a(other, child, GenericAttributes.m, (double)bT, (double)bU);
    }

    private void a(EntityAgeable other, EntityHorseAbstract child, AttributeBase attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.c(attribute), other.c(attribute), min, max, this.ag);
        child.a(attribute).a(d2);
    }

    static double a(double parentBase, double otherParentBase, double min, double max, RandomSource random) {
        double d7;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        parentBase = MathHelper.a(parentBase, min, max);
        otherParentBase = MathHelper.a(otherParentBase, min, max);
        double d4 = 0.15 * (max - min);
        double d6 = (parentBase + otherParentBase) / 2.0;
        double d5 = Math.abs(parentBase - otherParentBase) + d4 * 2.0;
        double d8 = d6 + d5 * (d7 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d8 > max) {
            double d9 = d8 - max;
            return max - d9;
        }
        if (d8 < min) {
            double d9 = min - d8;
            return min + d9;
        }
        return d8;
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.cH, this.cG);
    }

    public float F(float tickDelta) {
        return MathHelper.i(tickDelta, this.cJ, this.cI);
    }

    public float G(float tickDelta) {
        return MathHelper.i(tickDelta, this.cL, this.cK);
    }

    @Override
    public void b(int strength) {
        if (this.i()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.cs = true;
                this.gJ();
            }
            this.cr = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.i();
    }

    @Override
    public void c(int height) {
        float power = height >= 90 ? 1.0f : 0.4f + 0.4f * (float)height / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.cs = true;
        this.gJ();
        this.gL();
    }

    @Override
    public void b() {
    }

    protected void C(boolean positive) {
        ParticleType particletype = positive ? Particles.O : Particles.ab;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.ag.k() * 0.02;
            double d1 = this.ag.k() * 0.02;
            double d2 = this.ag.k() * 0.02;
            this.dM().a(particletype, this.d(1.0), this.du() + 0.5, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.C(true);
        } else if (status == 6) {
            this.C(false);
        } else {
            super.b(status);
        }
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aU = this.aU;
        }
    }

    protected static float a(IntUnaryOperator randomIntGetter) {
        return 15.0f + (float)randomIntGetter.applyAsInt(8) + (float)randomIntGetter.applyAsInt(9);
    }

    protected static double a(DoubleSupplier randomDoubleGetter) {
        return (double)0.4f + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier randomDoubleGetter) {
        return ((double)0.45f + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.95f;
    }

    public boolean gN() {
        return false;
    }

    public boolean gO() {
        return !this.c(EnumItemSlot.e).b();
    }

    public boolean l(ItemStack item) {
        return false;
    }

    private SlotAccess a(final int slot, final Predicate<ItemStack> predicate) {
        return new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityHorseAbstract.this.cp.a(slot);
            }

            @Override
            public boolean a(ItemStack stack) {
                if (!predicate.test(stack)) {
                    return false;
                }
                EntityHorseAbstract.this.cp.a(slot, stack);
                EntityHorseAbstract.this.gB();
                return true;
            }
        };
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int k2;
        int j2 = mappedIndex - 400;
        if (j2 >= 0 && j2 < 2 && j2 < this.cp.b()) {
            if (j2 == 0) {
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || itemstack.a(Items.nK));
            }
            if (j2 == 1) {
                if (!this.gN()) {
                    return SlotAccess.b;
                }
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || this.l((ItemStack)itemstack));
            }
        }
        return (k2 = mappedIndex - 500 + 2) >= 2 && k2 < this.cp.b() ? SlotAccess.a(this.cp, k2) : super.a_(mappedIndex);
    }

    @Override
    @Nullable
    public EntityLiving cN() {
        Entity entity;
        if (this.i() && (entity = this.cQ()) instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return entityhuman;
        }
        return super.cN();
    }

    @Nullable
    private Vec3D a(Vec3D offset, EntityLiving passenger) {
        double d0 = this.dr() + offset.c;
        double d1 = this.cH().b;
        double d2 = this.dx() + offset.e;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose entitypose : passenger.fA()) {
            blockposition_mutableblockposition.b(d0, d1, d2);
            double d3 = this.cH().e + 0.75;
            do {
                double d4 = this.dM().j(blockposition_mutableblockposition);
                if ((double)blockposition_mutableblockposition.v() + d4 > d3) continue block0;
                if (DismountUtil.a(d4)) {
                    AxisAlignedBB axisalignedbb = passenger.e(entitypose);
                    Vec3D vec3d1 = new Vec3D(d0, (double)blockposition_mutableblockposition.v() + d4, d2);
                    if (DismountUtil.a(this.dM(), passenger, axisalignedbb.c(vec3d1))) {
                        passenger.b(entitypose);
                        return vec3d1;
                    }
                }
                blockposition_mutableblockposition.c(EnumDirection.b);
            } while (!((double)blockposition_mutableblockposition.v() >= d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = EntityHorseAbstract.a(this.dg(), (double)passenger.dg(), this.dC() + (passenger.fm() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D vec3d1 = this.a(vec3d, passenger);
        if (vec3d1 != null) {
            return vec3d1;
        }
        Vec3D vec3d2 = EntityHorseAbstract.a(this.dg(), (double)passenger.dg(), this.dC() + (passenger.fm() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D vec3d3 = this.a(vec3d2, passenger);
        return vec3d3 != null ? vec3d3 : this.dk();
    }

    protected void a(RandomSource random) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(0.2f);
        }
        this.a(world.F_());
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean b(IInventory inventory) {
        return this.cp != inventory;
    }

    public int gP() {
        return this.Q();
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, this.a(dimensions, scaleFactor) + 0.15f * this.cJ * scaleFactor, -0.7f * this.cJ * scaleFactor);
    }

    protected float a(EntitySize dimensions, float scaleFactor) {
        return dimensions.b + (this.o_() ? 0.125f : -0.15625f) * scaleFactor;
    }
}

