/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.joml.Vector3f;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap bT = new PathfinderGoalHorseTrap(this);
    private static final int bU = 18000;
    private boolean bW;
    public int bX;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> type, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, world);
    }

    public static AttributeProvider.Builder u() {
        return EntityHorseSkeleton.gE().a(GenericAttributes.l, 15.0).a(GenericAttributes.m, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn reason, BlockPosition pos, RandomSource random) {
        return !EnumMobSpawn.a(reason) ? EntityAnimal.b(type, world, reason, pos, random) : EnumMobSpawn.b(reason) || EntityHorseSkeleton.a(world, pos);
    }

    @Override
    protected void a(RandomSource random) {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.h);
        Objects.requireNonNull(random);
        attributemodifiable.a(EntityHorseSkeleton.a(random::j));
    }

    @Override
    protected void gu() {
    }

    @Override
    protected SoundEffect y() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.wl : SoundEffects.wh;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.wi;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.wj;
    }

    @Override
    protected SoundEffect aN() {
        if (this.aC()) {
            if (!this.bP()) {
                return SoundEffects.wo;
            }
            ++this.cu;
            if (this.cu > 5 && this.cu % 3 == 0) {
                return SoundEffects.wm;
            }
            if (this.cu <= 5) {
                return SoundEffects.wo;
            }
        }
        return SoundEffects.wk;
    }

    @Override
    protected void e(float volume) {
        if (this.aC()) {
            super.e(0.3f);
        } else {
            super.e(Math.min(0.1f, volume * 25.0f));
        }
    }

    @Override
    protected void gL() {
        if (this.aZ()) {
            this.a(SoundEffects.wn, 0.4f, 1.0f);
        } else {
            super.gL();
        }
    }

    @Override
    public EnumMonsterType eS() {
        return EnumMonsterType.b;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - (this.o_() ? 0.03125f : 0.28125f) * scaleFactor, 0.0f);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.w() && this.bX++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("SkeletonTrap", this.w());
        nbt.a("SkeletonTrapTime", this.bX);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.w(nbt.q("SkeletonTrap"));
        this.bX = nbt.h("SkeletonTrapTime");
    }

    @Override
    protected float fd() {
        return 0.96f;
    }

    public boolean w() {
        return this.bW;
    }

    public void w(boolean trapped) {
        if (trapped != this.bW) {
            this.bW = trapped;
            if (trapped) {
                this.bO.a(1, this.bT);
            } else {
                this.bO.a(this.bT);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aL.a(world);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return !this.gt() ? EnumInteractionResult.d : super.b(player, hand);
    }
}

