/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.joml.Vector3f;

public class Sniffer
extends EntityAnimal {
    private static final int bZ = 1700;
    private static final int ca = 6000;
    private static final int cb = 30;
    private static final int cc = 120;
    private static final int cd = 48000;
    private static final float ce = 0.4f;
    private static final EntitySize cf = EntitySize.b(EntityTypes.aO.k(), EntityTypes.aO.l() - 0.4f);
    private static final DataWatcherObject<State> cg = DataWatcher.a(Sniffer.class, DataWatcherRegistry.z);
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState bT = new AnimationState();
    public final AnimationState bU = new AnimationState();
    public final AnimationState bW = new AnimationState();
    public final AnimationState bX = new AnimationState();
    public final AnimationState bY = new AnimationState();

    public static AttributeProvider.Builder u() {
        return EntityInsentient.C().a(GenericAttributes.m, 0.1f).a(GenericAttributes.l, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> type, World world) {
        super(type, world);
        this.N().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(cg, State.a);
        this.an.a(ch, 0);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.a((EntityPose)pose).b * 0.6f;
    }

    @Override
    public void E() {
        super.E();
        if (this.bN() || this.aZ()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void G() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return this.an.a(cg) && this.gp() == State.f ? cf.a(this.dZ()) : super.a(pose);
    }

    public boolean w() {
        return this.gp() == State.e;
    }

    public boolean A() {
        return this.bz.c(MemoryModuleType.Q).orElse(false);
    }

    public boolean ge() {
        return !this.A() && !this.gb() && !this.aZ() && !this.gi() && this.aC() && !this.bO() && !this.fS();
    }

    public boolean gk() {
        return this.gp() == State.f || this.gp() == State.e;
    }

    private BlockPosition gn() {
        Vec3D vec3d = this.go();
        return BlockPosition.a(vec3d.a(), this.dt() + (double)0.2f, vec3d.c());
    }

    private Vec3D go() {
        return this.dk().e(this.bH().a(2.25));
    }

    public State gp() {
        return this.an.b(cg);
    }

    private Sniffer b(State state) {
        this.an.b(cg, state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (cg.equals(data)) {
            State sniffer_state = this.gp();
            this.gq();
            switch (sniffer_state) {
                case c: {
                    this.bU.b(this.ah);
                    break;
                }
                case d: {
                    this.bW.b(this.ah);
                    break;
                }
                case f: {
                    this.bX.b(this.ah);
                    break;
                }
                case g: {
                    this.bY.b(this.ah);
                    break;
                }
                case b: {
                    this.bT.b(this.ah);
                }
            }
            this.k_();
        }
        super.a(data);
    }

    private void gq() {
        this.bX.a();
        this.bW.a();
        this.bY.a();
        this.bT.a();
        this.bU.a();
    }

    public Sniffer a(State state) {
        switch (state) {
            case c: {
                this.b(State.c).gr();
                break;
            }
            case d: {
                this.a(SoundEffects.xv, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case f: {
                this.b(State.f).gs();
                break;
            }
            case g: {
                this.a(SoundEffects.xy, 1.0f, 1.0f);
                this.b(State.g);
                break;
            }
            case b: {
                this.a(SoundEffects.xz, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case a: {
                this.b(State.a);
                break;
            }
            case e: {
                this.b(State.e);
            }
        }
        return this;
    }

    private Sniffer gr() {
        this.a(SoundEffects.xu, 1.0f, this.o_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer gs() {
        this.an.b(ch, this.ah + 120);
        this.dM().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer w(boolean explored) {
        if (explored) {
            this.j(this.aJ());
        }
        return this;
    }

    public Optional<BlockPosition> gl() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockposition -> this.dM().D_().a((BlockPosition)blockposition)).map(BlockPosition::d).filter(this::i).findFirst();
    }

    public boolean gm() {
        return !this.gb() && !this.A() && !this.o_() && !this.aZ() && this.aC() && !this.bO() && this.i(this.gn().d());
    }

    private boolean i(BlockPosition pos) {
        return this.dM().a_(pos).a(TagsBlock.cj) && this.gu().noneMatch(globalpos -> GlobalPos.a(this.dM().ae(), pos).equals(globalpos)) && Optional.ofNullable(this.N().a(pos, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void gt() {
        if (!this.dM().y_() && this.an.b(ch) == this.ah) {
            WorldServer worldserver = (WorldServer)this.dM();
            LootTable loottable = worldserver.o().aJ().getLootTable(LootTables.aK);
            LootParams lootparams = new LootParams.a(worldserver).a(LootContextParameters.f, this.go()).a(LootContextParameters.a, this).a(LootContextParameterSets.i);
            ObjectArrayList<ItemStack> list = loottable.a(lootparams);
            BlockPosition blockposition = this.gn();
            for (ItemStack itemstack : list) {
                EntityItem entityitem = new EntityItem(worldserver, blockposition.u(), blockposition.v(), blockposition.w(), itemstack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                entityitem.u();
                worldserver.b(entityitem);
            }
            this.a(SoundEffects.xt, 1.0f, 1.0f);
        }
    }

    private Sniffer a(AnimationState diggingAnimationState) {
        boolean flag;
        boolean bl = flag = diggingAnimationState.b() > 1700L && diggingAnimationState.b() < 6000L;
        if (flag) {
            BlockPosition blockposition = this.gn();
            IBlockData iblockdata = this.dM().a_(blockposition.d());
            if (iblockdata.l() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3d = Vec3D.b(blockposition).b(0.0, -0.65f, 0.0);
                    this.dM().a(new ParticleParamBlock(Particles.c, iblockdata), vec3d.c, vec3d.d, vec3d.e, 0.0, 0.0, 0.0);
                }
                if (this.ah % 10 == 0) {
                    this.dM().a(this.dr(), this.dt(), this.dx(), iblockdata.w().f(), this.db(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.ah % 10 == 0) {
            this.dM().a(GameEvent.u, this.gn(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer j(BlockPosition pos) {
        List list = this.gu().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.dM().ae(), pos));
        this.dO().a(MemoryModuleType.aP, list);
        return this;
    }

    public Stream<GlobalPos> gu() {
        return this.dO().c(MemoryModuleType.aP).stream().flatMap(Collection::stream);
    }

    @Override
    protected void fb() {
        double d1;
        super.fb();
        double d0 = this.bL.c();
        if (d0 > 0.0 && (d1 = this.dp().i()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer world, EntityAnimal other) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, other);
        if (result.isCancelled()) {
            return;
        }
        ItemStack itemstack = new ItemStack(Items.kp);
        EntityItem entityitem = new EntityItem(world, this.dk().a(), this.dk().b(), this.dk().c(), itemstack);
        entityitem.u();
        this.finalizeSpawnChildFromBreeding(world, other, null, result.getExperience());
        if (this.spawnAtLocation(entityitem) != null) {
            this.a(SoundEffects.xA, 1.0f, (this.ag.i() - this.ag.i()) * 0.2f + 0.5f);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        this.a(State.a);
        super.a(damageSource);
    }

    @Override
    public void l() {
        switch (this.gp()) {
            case f: {
                this.a(this.bX).gt();
                break;
            }
            case e: {
                this.gv();
            }
        }
        super.l();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        boolean flag = this.m(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && flag) {
            this.dM().a((EntityHuman)null, this, this.d(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.dM().z, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.34375f * scaleFactor, 0.0f);
    }

    @Override
    public float di() {
        return super.di() + 0.3f;
    }

    private void gv() {
        if (this.dM().y_() && this.ah % 20 == 0) {
            this.dM().a(this.dr(), this.dt(), this.dx(), SoundEffects.xw, this.db(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.xo, 0.15f, 1.0f);
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return SoundEffects.xp;
    }

    @Override
    protected SoundEffect y() {
        return Set.of(State.f, State.e).contains((Object)this.gp()) ? null : SoundEffects.xq;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.xr;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.xs;
    }

    @Override
    public int ab() {
        return 50;
    }

    @Override
    public void a(boolean baby) {
        this.c_(baby ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aO.a(world);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (!(other instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)other;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.gp()) && set.contains((Object)sniffer.gp()) && super.a(other);
    }

    @Override
    public AxisAlignedBB i_() {
        return super.i_().g(0.6f);
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.aK);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.dP().a(dynamic));
    }

    public BehaviorController<Sniffer> dO() {
        return super.dO();
    }

    protected BehaviorController.b<Sniffer> dP() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void Z() {
        this.dM().af().a("snifferBrain");
        this.dO().a((WorldServer)this.dM(), this);
        this.dM().af().b("snifferActivityUpdate");
        SnifferAi.a(this);
        this.dM().af().c();
        super.Z();
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    public static enum State {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }
}

