/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import top.leavesmc.leaves.LeavesConfig;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.k);
    public int b;
    public boolean generatedByDragonFight = false;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> type, World world) {
        super(type, world);
        this.I = true;
        this.b = this.ag.a(100000);
    }

    public EntityEnderCrystal(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.C, world);
        this.a_(x2, y2, z2);
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void c_() {
        this.an().a(c, Optional.empty());
        this.an().a(d, true);
    }

    @Override
    public void l() {
        ++this.b;
        if (this.dM() instanceof WorldServer) {
            BlockPosition blockposition = this.dm();
            if (((WorldServer)this.dM()).D() != null && this.dM().a_(blockposition).i() && !CraftEventFactory.callBlockIgniteEvent(this.dM(), blockposition, this).isCancelled()) {
                this.dM().b(blockposition, BlockFireAbstract.a(this.dM(), blockposition));
            }
            if (!LeavesConfig.mcTechnicalMode && this.dM().paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.cr() && (!Objects.equals(((WorldServer)this.dM()).uuid, this.getOriginWorld()) || ((WorldServer)this.dM()).D() == null || ((WorldServer)this.dM()).D().z == null || ((WorldServer)this.dM()).D().z.ordinal() > EnumDragonRespawn.d.ordinal())) {
                this.m(false);
                this.a((BlockPosition)null);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.q() != null) {
            nbt.a("BeamTarget", GameProfileSerializer.a(this.q()));
        }
        nbt.a("ShowBottom", this.s());
        if (this.generatedByDragonFight) {
            nbt.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("BeamTarget", 10)) {
            this.a(GameProfileSerializer.b(nbt.p("BeamTarget")));
        }
        if (nbt.b("ShowBottom", 1)) {
            this.a(nbt.q("ShowBottom"));
        }
        if (nbt.b("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = nbt.q("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean bt() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source.d() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.dH() && !this.dM().B) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                return false;
            }
            if (!source.a(DamageTypeTags.m)) {
                DamageSource damagesource1 = source.d() != null ? this.dN().d(this, source.d()) : null;
                ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, 6.0f, false);
                if (event.isCancelled()) {
                    return false;
                }
                this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.EXPLODE);
                this.dM().a(this, damagesource1, null, this.dr(), this.dt(), this.dx(), event.getRadius(), event.getFire(), World.a.b);
            } else {
                this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            }
            this.a(source);
        }
        return true;
    }

    @Override
    public void al() {
        this.a(this.dN().n());
        super.al();
    }

    private void a(DamageSource source) {
        EnderDragonBattle enderdragonbattle;
        if (this.dM() instanceof WorldServer && (enderdragonbattle = ((WorldServer)this.dM()).D()) != null) {
            enderdragonbattle.a(this, source);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.an().b(c, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition q() {
        return this.an().b(c).orElse(null);
    }

    public void a(boolean showBottom) {
        this.an().b(d, showBottom);
    }

    public boolean s() {
        return this.an().b(d);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.q() != null;
    }

    @Override
    public ItemStack dz() {
        return new ItemStack(Items.uY);
    }
}

