/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntityItemFrame
extends EntityHanging {
    private static final Logger f = LogUtils.getLogger();
    public static final DataWatcherObject<ItemStack> g = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> h = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int e = 8;
    public float i = 1.0f;
    public boolean j;
    public Integer cachedMapId;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World world) {
        super((EntityTypes<? extends EntityHanging>)type, world);
    }

    public EntityItemFrame(World world, BlockPosition pos, EnumDirection facing) {
        this(EntityTypes.ag, world, pos, facing);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World world, BlockPosition pos, EnumDirection facing) {
        super(type, world, pos);
        this.a(facing);
    }

    @Override
    protected float a(EntityPose pose, EntitySize dimensions) {
        return 0.0f;
    }

    @Override
    protected void c_() {
        this.an().a(g, ItemStack.f);
        this.an().a(h, 0);
    }

    @Override
    public void a(EnumDirection facing) {
        Validate.notNull((Object)facing);
        this.d = facing;
        if (facing.o().d()) {
            this.s(0.0f);
            this.r(this.d.e() * 90);
        } else {
            this.s(-90 * facing.f().a());
            this.r(0.0f);
        }
        this.O = this.dE();
        this.N = this.dC();
        this.z();
    }

    @Override
    protected void z() {
        if (this.d != null) {
            this.a(EntityItemFrame.calculateBoundingBox(this, this.c, this.d, this.B(), this.C()));
        }
    }

    public static AxisAlignedBB calculateBoundingBox(@javax.annotation.Nullable Entity entity, BlockPosition blockPosition, EnumDirection direction, int width, int height) {
        double d0 = 0.46875;
        double d1 = (double)blockPosition.u() + 0.5 - (double)direction.j() * 0.46875;
        double d2 = (double)blockPosition.v() + 0.5 - (double)direction.k() * 0.46875;
        double d3 = (double)blockPosition.w() + 0.5 - (double)direction.l() * 0.46875;
        if (entity != null) {
            entity.p(d1, d2, d3);
        }
        double d4 = width;
        double d5 = height;
        double d6 = width;
        EnumDirection.EnumAxis enumdirection_enumaxis = direction.o();
        switch (enumdirection_enumaxis) {
            case a: {
                d4 = 1.0;
                break;
            }
            case b: {
                d5 = 1.0;
                break;
            }
            case c: {
                d6 = 1.0;
            }
        }
        return new AxisAlignedBB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6);
    }

    @Override
    public boolean A() {
        if (this.j) {
            return true;
        }
        if (!this.dM().g(this)) {
            return false;
        }
        IBlockData iblockdata = this.dM().a_(this.c.a(this.d.g()));
        return !iblockdata.e() && (!this.d.o().d() || !BlockDiodeAbstract.h(iblockdata)) ? false : this.dM().a((Entity)this, this.cH(), EntityHanging.b).isEmpty();
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (!this.j) {
            super.a(movementType, movement);
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        if (!this.j) {
            super.push(deltaX, deltaY, deltaZ, pushingEntity);
        }
    }

    @Override
    public void al() {
        this.c(this.G());
        super.al();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.j) {
            return !source.a(DamageTypeTags.e) && !source.g() ? false : super.a(source, amount);
        }
        if (this.b(source)) {
            return false;
        }
        if (!source.a(DamageTypeTags.m) && !this.G().b()) {
            if (!this.dM().B) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false) || this.dH()) {
                    return true;
                }
                Entity entity = source.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.G().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.REMOVE);
                    if (!event.callEvent()) {
                        return true;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()), false);
                }
                this.b(source.d(), false);
                this.a(GameEvent.c, source.d());
                this.a(this.q(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.a(source, amount);
    }

    public SoundEffect q() {
        return SoundEffects.mL;
    }

    @Override
    public int B() {
        return 12;
    }

    @Override
    public int C() {
        return 12;
    }

    @Override
    public boolean a(double distance) {
        double d1 = 16.0;
        return distance < (d1 *= 64.0 * EntityItemFrame.cA()) * d1;
    }

    @Override
    public void a(@javax.annotation.Nullable Entity entity) {
        this.a(this.s(), 1.0f, 1.0f);
        this.b(entity, true);
        this.a(GameEvent.c, entity);
    }

    public SoundEffect s() {
        return SoundEffects.mJ;
    }

    @Override
    public void D() {
        this.a(this.u(), 1.0f, 1.0f);
    }

    public SoundEffect u() {
        return SoundEffects.mK;
    }

    private void b(@javax.annotation.Nullable Entity entity, boolean alwaysDrop) {
        if (!this.j) {
            ItemStack itemstack = this.G();
            this.a(ItemStack.f);
            if (!this.dM().Z().b(GameRules.i)) {
                if (entity == null) {
                    this.c(itemstack);
                }
            } else {
                if (entity instanceof EntityHuman) {
                    EntityHuman entityhuman = (EntityHuman)entity;
                    if (entityhuman.fT().d) {
                        this.c(itemstack);
                        return;
                    }
                }
                if (alwaysDrop) {
                    this.b(this.y());
                }
                if (!itemstack.b()) {
                    itemstack = itemstack.p();
                    this.c(itemstack);
                    if (this.ag.i() < this.i) {
                        this.b(itemstack);
                    }
                }
            }
        }
    }

    @Override
    @javax.annotation.Nullable
    public EntityItem b(ItemStack stack) {
        return this.a(stack, this.cE().equals(EnumDirection.a) ? -0.6f : 0.0f);
    }

    private void c(ItemStack itemstack) {
        this.getFramedMapIdFromItem(itemstack).ifPresent(i2 -> {
            WorldMap worldmap = ItemWorldMap.a(i2, this.dM());
            if (worldmap != null) {
                worldmap.a(this.c, this.aj());
                worldmap.a(true);
            }
        });
        itemstack.a((Entity)null);
    }

    public ItemStack G() {
        return this.an().b(g);
    }

    public OptionalInt H() {
        ItemStack itemstack = this.G();
        return this.getFramedMapIdFromItem(itemstack);
    }

    public OptionalInt getFramedMapIdFromItem(ItemStack itemstack) {
        Integer integer;
        if (itemstack.a(Items.rR) && (integer = ItemWorldMap.d(itemstack)) != null) {
            return OptionalInt.of(integer);
        }
        return OptionalInt.empty();
    }

    public boolean I() {
        return this.H().isPresent();
    }

    public void a(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack value, boolean update) {
        this.setItem(value, update, true);
    }

    public void setItem(ItemStack itemstack, boolean flag, boolean playSound) {
        if (!itemstack.b()) {
            itemstack = itemstack.c(1);
        }
        this.d(itemstack);
        this.an().b(g, itemstack);
        if (!itemstack.b() && flag && playSound) {
            this.a(this.w(), 1.0f, 1.0f);
        }
        if (flag && this.c != null) {
            this.dM().c(this.c, Blocks.a);
        }
    }

    public SoundEffect w() {
        return SoundEffects.mI;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        return mappedIndex == 0 ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityItemFrame.this.G();
            }

            @Override
            public boolean a(ItemStack stack) {
                EntityItemFrame.this.a(stack);
                return true;
            }
        } : super.a_(mappedIndex);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (data.equals(g)) {
            this.d(this.G());
        }
    }

    private void d(ItemStack stack) {
        this.cachedMapId = ItemWorldMap.d(stack);
        if (!stack.b() && stack.G() != this) {
            stack.a(this);
        }
        this.z();
    }

    public int J() {
        return this.an().b(h);
    }

    public void b(int value) {
        this.a(value, true);
    }

    private void a(int value, boolean updateComparators) {
        this.an().b(h, value % 8);
        if (updateComparators && this.c != null) {
            this.dM().c(this.c, Blocks.a);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (!this.G().b()) {
            nbt.a("Item", this.G().b(new NBTTagCompound()));
            nbt.a("ItemRotation", (byte)this.J());
            nbt.a("ItemDropChance", this.i);
        }
        nbt.a("Facing", (byte)this.d.d());
        nbt.a("Invisible", this.ce());
        nbt.a("Fixed", this.j);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagCompound nbttagcompound1 = nbt.p("Item");
        if (nbttagcompound1 != null && !nbttagcompound1.g()) {
            ItemStack itemstack1;
            ItemStack itemstack = ItemStack.a(nbttagcompound1);
            if (itemstack.b()) {
                f.warn("Unable to load item from: {}", (Object)nbttagcompound1);
            }
            if (!(itemstack1 = this.G()).b() && !ItemStack.a(itemstack, itemstack1)) {
                this.c(itemstack1);
            }
            this.a(itemstack, false);
            this.a(nbt.f("ItemRotation"), false);
            if (nbt.b("ItemDropChance", 99)) {
                this.i = nbt.j("ItemDropChance");
            }
        }
        this.a(EnumDirection.a(nbt.f("Facing")));
        this.j(nbt.q("Invisible"));
        this.j = nbt.q("Fixed");
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        boolean flag1;
        ItemStack itemstack = player.b(hand);
        boolean flag = !this.G().b();
        boolean bl = flag1 = !itemstack.b();
        if (this.j) {
            return EnumInteractionResult.d;
        }
        if (!this.dM().B) {
            if (!flag) {
                if (flag1 && !this.dH()) {
                    WorldMap worldmap;
                    if (itemstack.a(Items.rR) && (worldmap = ItemWorldMap.b(itemstack, this.dM())) != null && worldmap.b(256)) {
                        return EnumInteractionResult.e;
                    }
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), itemstack.asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.PLACE);
                    if (!event.callEvent()) {
                        return EnumInteractionResult.e;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()));
                    this.a(GameEvent.c, (Entity)player);
                    if (!player.fT().d) {
                        itemstack.h(1);
                    }
                }
            } else {
                PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.G().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE);
                if (!event.callEvent()) {
                    return EnumInteractionResult.e;
                }
                this.setItem(ItemStack.fromBukkitCopy(event.getItemStack()), false, false);
                this.a(this.x(), 1.0f, 1.0f);
                this.b(this.J() + 1);
                this.a(GameEvent.c, (Entity)player);
            }
            return EnumInteractionResult.b;
        }
        return !flag && !flag1 ? EnumInteractionResult.d : EnumInteractionResult.a;
    }

    public SoundEffect x() {
        return SoundEffects.mM;
    }

    public int K() {
        return this.G().b() ? 0 : this.J() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> dj() {
        return new PacketPlayOutSpawnEntity(this, this.d.d(), this.E());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.o()));
    }

    @Override
    public ItemStack dz() {
        ItemStack itemstack = this.G();
        return itemstack.b() ? this.y() : itemstack.p();
    }

    protected ItemStack y() {
        return new ItemStack(Items.tV);
    }

    @Override
    public float dD() {
        EnumDirection enumdirection = this.cE();
        int i2 = enumdirection.o().b() ? 90 * enumdirection.f().a() : 0;
        return MathHelper.b(180 + enumdirection.e() * 90 + this.J() * 45 + i2);
    }
}

