/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster
implements PowerableMob {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private int e;
    public int bT;
    public int bU = 30;
    public int bV = 3;
    private int bW;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void B() {
        this.bO.a(1, new PathfinderGoalFloat(this));
        this.bO.a(2, new PathfinderGoalSwell(this));
        this.bO.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bO.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bO.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bO.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(6, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bP.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder u() {
        return EntityMonster.gk().a(GenericAttributes.m, 0.25);
    }

    @Override
    public int cu() {
        return this.q() == null ? 3 : 3 + (int)(this.ev() - 1.0f);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        this.bT += (int)(fallDistance * 1.5f);
        if (this.bT > this.bU - 5) {
            this.bT = this.bU - 5;
        }
        return flag;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(b, -1);
        this.an.a(c, false);
        this.an.a(d, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.an.b(c).booleanValue()) {
            nbt.a("powered", true);
        }
        nbt.a("Fuse", (short)this.bU);
        nbt.a("ExplosionRadius", (byte)this.bV);
        nbt.a("ignited", this.A());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.an.b(c, nbt.q("powered"));
        if (nbt.b("Fuse", 99)) {
            this.bU = nbt.g("Fuse");
        }
        if (nbt.b("ExplosionRadius", 99)) {
            this.bV = nbt.f("ExplosionRadius");
        }
        if (nbt.q("ignited")) {
            this.an.b(d, true);
        }
    }

    @Override
    public void l() {
        if (this.bx()) {
            int i2;
            this.e = this.bT;
            if (this.A()) {
                this.b(1);
            }
            if ((i2 = this.w()) > 0 && this.bT == 0) {
                this.a(SoundEffects.fH, 1.0f, 0.5f);
                this.a(GameEvent.I);
            }
            this.bT += i2;
            if (this.bT < 0) {
                this.bT = 0;
            }
            if (this.bT >= this.bU) {
                this.bT = this.bU;
                this.gh();
            }
        }
        super.l();
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (!(target instanceof Goat)) {
            super.h(target);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.fG;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.fF;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        EntityCreeper entitycreeper;
        super.a(source, lootingMultiplier, allowDrops);
        Entity entity = source.d();
        if (entity != this && entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gf()) {
            entitycreeper.gg();
            this.a((IMaterial)Items.ui);
        }
    }

    @Override
    public boolean C(Entity target) {
        return true;
    }

    @Override
    public boolean a() {
        return this.an.b(c);
    }

    public float E(float timeDelta) {
        return MathHelper.i(timeDelta, this.e, this.bT) / (float)(this.bU - 2);
    }

    public int w() {
        return this.an.b(b);
    }

    public void b(int fuseSpeed) {
        this.an.b(b, fuseSpeed);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        super.a(world, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.an.b(c, true);
    }

    public void setPowered(boolean powered) {
        this.an.b(c, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(TagsItem.aF)) {
            SoundEffect soundeffect = itemstack.a(Items.tS) ? SoundEffects.ig : SoundEffects.iv;
            this.dM().a(player, this.dr(), this.dt(), this.dx(), soundeffect, this.db(), 1.0f, this.ag.i() * 0.4f + 0.8f);
            if (!this.dM().B) {
                this.ge();
                if (itemstack.d().n() == 0) {
                    itemstack.h(1);
                } else {
                    itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
                }
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        return super.b(player, hand);
    }

    public void gh() {
        if (!this.dM().B) {
            float f2 = this.a() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.bV * f2, false);
            if (!event.isCancelled()) {
                this.ba = true;
                this.dM().a((Entity)this, this.dr(), this.dt(), this.dx(), event.getRadius(), event.getFire(), World.a.c);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
                this.gi();
            } else {
                this.bT = 0;
                this.an.b(d, false);
            }
        }
    }

    private void gi() {
        Collection<MobEffect> collection = this.es();
        if (!collection.isEmpty() && !this.dM().paperConfig().entities.behavior.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dM(), this.dr(), this.dt(), this.dx());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.b(-0.5f);
            entityareaeffectcloud.d(10);
            entityareaeffectcloud.b(entityareaeffectcloud.m() / 2);
            entityareaeffectcloud.c(-entityareaeffectcloud.h() / (float)entityareaeffectcloud.m());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.dM().addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean A() {
        return this.an.b(d);
    }

    public void ge() {
        this.setIgnited(true);
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.A() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.an.b(d, event.isIgnited());
        }
    }

    public boolean gf() {
        return this.a() && this.bW < 1;
    }

    public void gg() {
        ++this.bW;
    }
}

