/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EndermanAttackPlayerEvent;
import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.joml.Vector3f;
import top.leavesmc.leaves.LeavesConfig;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final UUID c = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier d = new AttributeModifier(c, "Attacking speed boost", 0.15f, AttributeModifier.Operation.a);
    private static final int e = 400;
    private static final int bT = 600;
    private static final DataWatcherObject<Optional<IBlockData>> bU = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int bX = Integer.MIN_VALUE;
    private int bY;
    private static final UniformInt bZ = TimeRange.a(20, 39);
    private int ca;
    @Nullable
    private UUID cb;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.t(1.0f);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void B() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(1, new a(this));
        this.bO.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bO.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.bO.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.bO.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.bP.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a_));
        this.bP.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.bP.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder u() {
        return EntityMonster.gk().a(GenericAttributes.l, 40.0).a(GenericAttributes.m, 0.3f).a(GenericAttributes.c, 7.0).a(GenericAttributes.g, 64.0);
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    private boolean tryEscape(EndermanEscapeEvent.Reason reason) {
        return new EndermanEscapeEvent((Enderman)((CraftEnderman)this.getBukkitEntity()), reason).callEvent();
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (!super.setTarget(entityliving, reason, fireEvent)) {
            return false;
        }
        entityliving = this.q();
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.m);
        if (entityliving == null) {
            this.bY = 0;
            this.an.b(bV, false);
            this.an.b(bW, false);
            attributemodifiable.b(d.a());
        } else {
            this.bY = this.ah;
            this.an.b(bV, true);
            if (!attributemodifiable.a(d)) {
                attributemodifiable.b(d);
            }
        }
        return true;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(bU, Optional.empty());
        this.an.a(bV, false);
        this.an.a(bW, false);
    }

    @Override
    public void c() {
        this.a(bZ.a(this.ag));
    }

    @Override
    public void a(int angerTime) {
        this.ca = angerTime;
    }

    @Override
    public int a() {
        return this.ca;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cb = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cb;
    }

    public void w() {
        if (this.ah >= this.bX + 400) {
            this.bX = this.ah;
            if (!this.aU()) {
                this.dM().a(this.dr(), this.dv(), this.dx(), SoundEffects.hJ, this.db(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bV.equals(data) && this.gg() && this.dM().B) {
            this.w();
        }
        super.a(data);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        IBlockData iblockdata = this.ge();
        if (iblockdata != null) {
            nbt.a("carriedBlockState", GameProfileSerializer.a(iblockdata));
        }
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        IBlockData iblockdata = null;
        if (nbt.b("carriedBlockState", 10) && (iblockdata = GameProfileSerializer.a(this.dM().a(Registries.f), nbt.p("carriedBlockState"))).i()) {
            iblockdata = null;
        }
        this.d(iblockdata);
        this.a(this.dM(), nbt);
    }

    private boolean g(EntityHuman player) {
        boolean shouldAttack = this.isLookingAtMe_check(player);
        EndermanAttackPlayerEvent event = new EndermanAttackPlayerEvent((Enderman)this.getBukkitEntity(), (Player)player.getBukkitEntity());
        event.setCancelled(!shouldAttack);
        return event.callEvent();
    }

    private boolean isLookingAtMe_check(EntityHuman player) {
        ItemStack itemstack = player.fS().j.get(3);
        if (itemstack.a(Blocks.ee.k())) {
            return false;
        }
        Vec3D vec3d = player.f(1.0f).d();
        Vec3D vec3d1 = new Vec3D(this.dr() - player.dr(), this.dv() - player.dv(), this.dx() - player.dx());
        double d0 = vec3d1.f();
        double d1 = vec3d.b(vec3d1 = vec3d1.d());
        return d1 > 1.0 - 0.025 / d0 ? player.E(this) : false;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 2.55f;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.09375f * scaleFactor, 0.0f);
    }

    @Override
    public void d_() {
        if (this.dM().B) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.dM().a(Particles.Z, this.d(0.5), this.du() - 0.25, this.g(0.5), (this.ag.j() - 0.5) * 2.0, -this.ag.j(), (this.ag.j() - 0.5) * 2.0);
            }
        }
        this.bj = false;
        if (!this.dM().B) {
            this.a((WorldServer)this.dM(), true);
        }
        super.d_();
    }

    @Override
    public boolean fh() {
        return true;
    }

    @Override
    protected void Z() {
        float f2;
        if (this.dM().P() && this.ah >= this.bY + 600 && (f2 = this.bo()) > 0.5f && this.dM().h(this.dm()) && this.ag.i() * 30.0f < (f2 - 0.4f) * 2.0f && this.tryEscape(EndermanEscapeEvent.Reason.RUNAWAY)) {
            this.h((EntityLiving)null);
            this.A();
        }
        super.Z();
    }

    public boolean A() {
        if (!this.dM().y_() && this.bx()) {
            double d0 = this.dr() + (this.ag.j() - 0.5) * 64.0;
            double d1 = this.dt() + (double)(this.ag.a(64) - 32);
            double d2 = this.dx() + (this.ag.j() - 0.5) * 64.0;
            return this.r(d0, d1, d2);
        }
        return false;
    }

    public boolean a(Entity entity) {
        Vec3D vec3d = new Vec3D(this.dr() - entity.dr(), this.e(0.5) - entity.dv(), this.dx() - entity.dx());
        vec3d = vec3d.d();
        double d0 = 16.0;
        double d1 = this.dr() + (this.ag.j() - 0.5) * 8.0 - vec3d.c * 16.0;
        double d2 = this.dt() + (double)(this.ag.a(16) - 8) - vec3d.d * 16.0;
        double d3 = this.dx() + (this.ag.j() - 0.5) * 8.0 - vec3d.e * 16.0;
        return this.r(d1, d2, d3);
    }

    private boolean r(double x2, double y2, double z2) {
        IBlockData iblockdata;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(x2, y2, z2);
        if (LeavesConfig.reduceChuckLoadAndLookup) {
            Chunk chunk = this.dM().getChunkIfLoaded(blockposition_mutableblockposition);
            if (chunk == null) {
                return false;
            }
            while (blockposition_mutableblockposition.v() > this.dM().J_() && !chunk.a_(blockposition_mutableblockposition).d()) {
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
            iblockdata = chunk.a_(blockposition_mutableblockposition);
        } else {
            while (blockposition_mutableblockposition.v() > this.dM().J_() && !this.dM().a_(blockposition_mutableblockposition).d()) {
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
            iblockdata = this.dM().a_(blockposition_mutableblockposition);
        }
        boolean flag = iblockdata.d();
        boolean flag1 = iblockdata.u().a(TagsFluid.a);
        if (flag && !flag1) {
            Vec3D vec3d = this.dk();
            boolean flag2 = this.b(x2, y2, z2, true);
            if (flag2) {
                this.dM().a(GameEvent.R, vec3d, GameEvent.a.a(this));
                if (!this.aU()) {
                    this.dM().a((EntityHuman)null, this.K, this.L, this.M, SoundEffects.hK, this.db(), 1.0f, 1.0f);
                    this.a(SoundEffects.hK, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    protected SoundEffect y() {
        return this.gf() ? SoundEffects.hI : SoundEffects.hF;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.hH;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.hG;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        IBlockData iblockdata = this.ge();
        if (iblockdata != null) {
            ItemStack itemstack = new ItemStack(Items.pf);
            itemstack.a(Enchantments.v, 1);
            LootParams.a lootparams_a = new LootParams.a((WorldServer)this.dM()).a(LootContextParameters.f, this.dk()).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, this);
            List<ItemStack> list = iblockdata.a(lootparams_a);
            for (ItemStack itemstack1 : list) {
                this.b(itemstack1);
            }
        }
    }

    public void d(@Nullable IBlockData state) {
        this.an.b(bU, Optional.ofNullable(state));
    }

    @Nullable
    public IBlockData ge() {
        return this.an.b(bU).orElse(null);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag1;
        if (this.b(source)) {
            return false;
        }
        boolean flag = source.c() instanceof EntityPotion;
        if (!source.a(DamageTypeTags.k) && !flag) {
            boolean flag12 = super.a(source, amount);
            if (!this.dM().y_() && !(source.d() instanceof EntityLiving) && this.ag.a(10) != 0) {
                this.A();
            }
            return flag12;
        }
        boolean bl = flag1 = flag && this.a(source, (EntityPotion)source.c(), amount);
        if (this.tryEscape(EndermanEscapeEvent.Reason.INDIRECT)) {
            for (int i2 = 0; i2 < 64; ++i2) {
                if (!this.A()) continue;
                return true;
            }
        }
        return flag1;
    }

    private boolean a(DamageSource source, EntityPotion potion, float amount) {
        ItemStack itemstack = potion.q();
        PotionRegistry potionregistry = PotionUtil.d(itemstack);
        List<MobEffect> list = PotionUtil.a(itemstack);
        boolean flag = potionregistry == Potions.c && list.isEmpty();
        return flag ? super.a(source, amount) : false;
    }

    public boolean gf() {
        return this.an.b(bV);
    }

    public boolean gg() {
        return this.an.b(bW);
    }

    public void gh() {
        this.an.b(bW, true);
    }

    public void setCreepy(boolean creepy) {
        this.an.b(bV, creepy);
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.an.b(bW, hasBeenStaredAt);
    }

    @Override
    public boolean W() {
        return super.W() || !LeavesConfig.despawnEndermanWithBlock && this.ge() != null;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman enderman) {
            this.a = enderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            this.b = this.a.q();
            if (!(this.b instanceof EntityHuman)) {
                return false;
            }
            double d0 = this.b.f((Entity)this.a);
            return d0 > 256.0 ? false : this.a.g((EntityHuman)this.b);
        }

        @Override
        public void c() {
            this.a.N().n();
        }

        @Override
        public void e() {
            this.a.I().a(this.b.dr(), this.b.dv(), this.b.dx());
        }
    }

    private static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean a() {
            return this.a.ge() == null ? false : (!this.a.dM().Z().b(GameRules.c) ? false : this.a.eg().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0);
        }

        @Override
        public void e() {
            int k2;
            int j2;
            int i2;
            BlockPosition blockposition;
            RandomSource randomsource = this.a.eg();
            World world = this.a.dM();
            IBlockData iblockdata = world.getBlockStateIfLoaded(blockposition = new BlockPosition(i2 = MathHelper.a(this.a.dr() - 1.0 + randomsource.j() * 2.0), j2 = MathHelper.a(this.a.dt() + randomsource.j() * 2.0), k2 = MathHelper.a(this.a.dx() - 1.0 + randomsource.j() * 2.0)));
            if (iblockdata == null) {
                return;
            }
            BlockPosition blockposition1 = blockposition.d();
            IBlockData iblockdata1 = world.a_(blockposition1);
            IBlockData iblockdata2 = this.a.ge();
            if (iblockdata2 != null && this.a(world, blockposition, iblockdata2 = Block.b(iblockdata2, this.a.dM(), blockposition), iblockdata, iblockdata1, blockposition1) && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata2)) {
                world.a(blockposition, iblockdata2, 3);
                world.a(GameEvent.i, blockposition, GameEvent.a.a(this.a, iblockdata2));
                this.a.d((IBlockData)null);
            }
        }

        private boolean a(World world, BlockPosition posAbove, IBlockData carriedState, IBlockData stateAbove, IBlockData state, BlockPosition pos) {
            return stateAbove.i() && !state.i() && !state.a(Blocks.F) && state.r(world, pos) && carriedState.a((IWorldReader)world, posAbove) && world.a_(this.a, AxisAlignedBB.a(Vec3D.a(posAbove))).isEmpty();
        }
    }

    private static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean a() {
            return this.a.ge() != null ? false : (!this.a.dM().Z().b(GameRules.c) ? false : this.a.eg().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0);
        }

        @Override
        public void e() {
            int k2;
            int j2;
            int i2;
            BlockPosition blockposition;
            RandomSource randomsource = this.a.eg();
            World world = this.a.dM();
            IBlockData iblockdata = world.getBlockStateIfLoaded(blockposition = new BlockPosition(i2 = MathHelper.a(this.a.dr() - 2.0 + randomsource.j() * 4.0), j2 = MathHelper.a(this.a.dt() + randomsource.j() * 3.0), k2 = MathHelper.a(this.a.dx() - 2.0 + randomsource.j() * 4.0)));
            if (iblockdata == null) {
                return;
            }
            Vec3D vec3d = new Vec3D((double)this.a.dq() + 0.5, (double)j2 + 0.5, (double)this.a.dw() + 0.5);
            Vec3D vec3d1 = new Vec3D((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5);
            MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = movingobjectpositionblock.a().equals(blockposition);
            if (iblockdata.a(TagsBlock.ak) && flag && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata.u().g())) {
                world.a(blockposition, false);
                world.a(GameEvent.f, blockposition, GameEvent.a.a(this.a, iblockdata));
                this.a.d(iblockdata.b().o());
            }
        }
    }

    private static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final Predicate<EntityLiving> o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman enderman, @Nullable Predicate<EntityLiving> targetPredicate) {
            super(enderman, EntityHuman.class, 10, false, false, targetPredicate);
            this.i = enderman;
            this.o = entityliving -> (enderman.g((EntityHuman)entityliving) || enderman.a_((EntityLiving)entityliving)) && !enderman.z((Entity)entityliving);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean a() {
            this.j = this.i.dM().a(this.m, this.i);
            return this.j != null;
        }

        @Override
        public void c() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gh();
        }

        @Override
        public void d() {
            this.j = null;
            super.d();
        }

        @Override
        public boolean b() {
            if (this.j != null) {
                if (!this.o.test(this.j)) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.z(this.c)) {
                    return false;
                }
                if (this.n.a(this.i, this.c)) {
                    return true;
                }
            }
            return super.b();
        }

        @Override
        public void e() {
            if (this.i.q() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.c();
                }
            } else {
                if (this.c != null && !this.i.bO()) {
                    if (this.i.g((EntityHuman)this.c)) {
                        if (this.c.f((Entity)this.i) < 16.0 && this.i.tryEscape(EndermanEscapeEvent.Reason.STARE)) {
                            this.i.A();
                        }
                        this.l = 0;
                    } else if (this.c.f((Entity)this.i) > 256.0 && this.l++ >= this.a(30) && this.i.a((Entity)this.c)) {
                        this.l = 0;
                    }
                }
                super.e();
            }
        }
    }
}

