/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCrossbowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityPillager
extends EntityIllagerAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityPillager.class, DataWatcherRegistry.k);
    private static final int e = 5;
    private static final int bT = 300;
    private static final float bU = 1.6f;
    public final InventorySubcontainer bV = new InventorySubcontainer(5);

    public EntityPillager(EntityTypes<? extends EntityPillager> type, World world) {
        super((EntityTypes<? extends EntityIllagerAbstract>)type, world);
    }

    @Override
    protected void B() {
        super.B();
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(2, new EntityRaider.a(this, this, 10.0f));
        this.bO.a(3, new PathfinderGoalCrossbowAttack<EntityPillager>(this, 1.0, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bO.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 15.0f, 1.0f));
        this.bO.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 15.0f));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    public static AttributeProvider.Builder w() {
        return EntityMonster.gk().a(GenericAttributes.m, 0.35f).a(GenericAttributes.l, 24.0).a(GenericAttributes.c, 5.0).a(GenericAttributes.g, 32.0);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(b, false);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.vM;
    }

    public boolean ge() {
        return this.an.b(b);
    }

    @Override
    public void b(boolean charging) {
        this.an.b(b, charging);
    }

    @Override
    public void a() {
        this.bb = 0;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.a_(nbt);
    }

    @Override
    public EntityIllagerAbstract.a u() {
        return this.ge() ? EntityIllagerAbstract.a.f : (this.b(Items.vM) ? EntityIllagerAbstract.a.e : (this.fW() ? EntityIllagerAbstract.a.b : EntityIllagerAbstract.a.h));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.c(nbt);
        this.s(true);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    public int fI() {
        return 1;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.F_();
        this.a(randomsource, difficulty);
        this.b(randomsource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.vM));
    }

    @Override
    protected void a(RandomSource random, float power) {
        ItemStack itemstack;
        super.a(random, power);
        if (random.a(300) == 0 && (itemstack = this.eT()).a(Items.vM)) {
            Map<Enchantment, Integer> map = EnchantmentManager.a(itemstack);
            map.putIfAbsent(Enchantments.K, 1);
            EnchantmentManager.a(map, itemstack);
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public boolean s(Entity other) {
        return super.s(other) ? true : (other instanceof EntityLiving && ((EntityLiving)other).eS() == EnumMonsterType.d ? this.cg() == null && other.cg() == null : false);
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.sY;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.ta;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.tb;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b(this, 1.6f);
    }

    @Override
    public void a(EntityLiving target, ItemStack crossbow, IProjectile projectile, float multiShotSpray) {
        this.a(this, target, projectile, multiShotSpray, 1.6f);
    }

    @Override
    public InventorySubcontainer A() {
        return this.bV;
    }

    @Override
    protected void b(EntityItem item) {
        ItemStack itemstack = item.q();
        if (itemstack.d() instanceof ItemBanner) {
            super.b(item);
        } else if (this.l(itemstack)) {
            this.a(item);
            ItemStack itemstack1 = this.bV.a(itemstack);
            if (itemstack1.b()) {
                item.discard(EntityRemoveEvent.Cause.PICKUP);
            } else {
                itemstack.f(itemstack1.L());
            }
        }
    }

    private boolean l(ItemStack stack) {
        return this.gt() && stack.a(Items.uI);
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int j2 = mappedIndex - 300;
        return j2 >= 0 && j2 < this.bV.b() ? SlotAccess.a(this.bV, j2) : super.a_(mappedIndex);
    }

    @Override
    public void a(int wave, boolean unused) {
        boolean flag1;
        Raid raid = this.gs();
        boolean bl = flag1 = this.ag.i() <= raid.w();
        if (flag1) {
            ItemStack itemstack = new ItemStack(Items.vM);
            HashMap map = Maps.newHashMap();
            if (wave > raid.a(EnumDifficulty.c)) {
                map.put(Enchantments.J, 2);
            } else if (wave > raid.a(EnumDifficulty.b)) {
                map.put(Enchantments.J, 1);
            }
            map.put(Enchantments.I, 1);
            EnchantmentManager.a(map, itemstack);
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public SoundEffect af_() {
        return SoundEffects.sZ;
    }
}

