/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.joml.Vector3f;

public class EntityStrider
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final UUID bT = UUID.fromString("9e362924-01de-4ddd-a2b2-d0f7a405a174");
    private static final AttributeModifier bU = new AttributeModifier(bT, "Strider suffocating modifier", -0.34f, AttributeModifier.Operation.b);
    private static final float bW = 0.35f;
    private static final float bX = 0.55f;
    private static final RecipeItemStack bY = RecipeItemStack.a(Items.dC);
    private static final RecipeItemStack bZ = RecipeItemStack.a(Items.dC, Items.nR);
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage cd;
    @Nullable
    private PathfinderGoalTempt ce;

    public EntityStrider(EntityTypes<? extends EntityStrider> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.cd = new SaddleStorage(this.an, ca, cc);
        this.I = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.j();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (world.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return world.a_(blockposition_mutableblockposition).i();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (ca.equals(data) && this.dM().B) {
            this.cd.a();
        }
        super.a(data);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(ca, 0);
        this.an.a(cb, false);
        this.an.a(cc, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.cd.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.cd.b(nbt);
    }

    @Override
    public boolean i() {
        return this.cd.d();
    }

    @Override
    public boolean g() {
        return this.bx() && !this.o_();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.cd.a(true);
        if (sound != null) {
            this.dM().a((EntityHuman)null, this, SoundEffects.xh, sound, 0.5f, 1.0f);
        }
    }

    @Override
    protected void B() {
        this.bO.a(1, new PathfinderGoalPanic(this, 1.65));
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0));
        this.ce = new PathfinderGoalTempt(this, 1.4, bZ, false);
        this.bO.a(3, this.ce);
        this.bO.a(4, new a(this, 1.0));
        this.bO.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.bO.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.bO.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void w(boolean cold) {
        this.an.b(cb, cold);
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.m);
        if (attributemodifiable != null) {
            attributemodifiable.b(bT);
            if (cold) {
                attributemodifiable.b(bU);
            }
        }
    }

    public boolean u() {
        return this.an.b(cb);
    }

    @Override
    public boolean a(Fluid state) {
        return state.a(TagsFluid.b);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        float f1 = Math.min(0.25f, this.aQ.a());
        float f2 = this.aQ.b();
        float f3 = 0.12f * MathHelper.b(f2 * 1.5f) * 2.0f * f1;
        return new Vector3f(0.0f, dimensions.b + f3 * scaleFactor, 0.0f);
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    @Nullable
    public EntityLiving cN() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.i() && (entity = this.cQ()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.nR)) {
            return entityhuman;
        }
        return super.cN();
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.dg(), (double)passenger.dg(), passenger.dC()), EntityStrider.a(this.dg(), (double)passenger.dg(), passenger.dC() - 22.5f), EntityStrider.a(this.dg(), (double)passenger.dg(), passenger.dC() + 22.5f), EntityStrider.a(this.dg(), (double)passenger.dg(), passenger.dC() - 45.0f), EntityStrider.a(this.dg(), (double)passenger.dg(), passenger.dC() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.cH().e;
        double d1 = this.cH().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        Vec3D[] avec3d1 = avec3d;
        int i2 = avec3d.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = avec3d1[j2];
            blockposition_mutableblockposition.b(this.dr() + vec3d.c, d0, this.dx() + vec3d.e);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.i());
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.dM().b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.dM().j(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : passenger.fA()) {
                AxisAlignedBB axisalignedbb = passenger.e(entitypose);
                if (!DismountUtil.a(this.dM(), passenger, axisalignedbb.c(vec3d1))) continue;
                passenger.b(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dr(), this.cH().e, this.dx());
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        this.a(controllingPlayer.dC(), controllingPlayer.dE() * 0.5f);
        this.aU = this.aW = this.dC();
        this.N = this.aW;
        this.cd.b();
        super.a(controllingPlayer, movementInput);
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)(this.b(GenericAttributes.m) * (double)(this.u() ? 0.35f : 0.55f) * (double)this.cd.c());
    }

    @Override
    protected float aM() {
        return this.Z + 0.6f;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.bn() ? SoundEffects.xf : SoundEffects.xe, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.cd.a(this.eg());
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        this.aQ();
        if (this.bn()) {
            this.n();
        } else {
            super.a(heightDifference, onGround, state, landedPosition);
        }
    }

    @Override
    public void l() {
        if (this.A() && this.ag.a(140) == 0) {
            this.a(SoundEffects.xa, 1.0f, this.eX());
        } else if (this.gb() && this.ag.a(60) == 0) {
            this.a(SoundEffects.xb, 1.0f, this.eX());
        }
        if (!this.fU()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.dM().a_(this.dm());
            IBlockData iblockdata1 = this.bj();
            boolean flag = iblockdata.a(TagsBlock.aT) || iblockdata1.a(TagsBlock.aT) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.cZ();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).u();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.u() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.w(suffocating);
            }
        }
        super.l();
        this.ge();
        this.aQ();
    }

    private boolean A() {
        return this.ce != null && this.ce.i();
    }

    @Override
    protected boolean D() {
        return true;
    }

    private void ge() {
        if (this.bn()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.d, this.dm(), true) && !this.dM().b_(this.dm().c()).a(TagsFluid.b)) {
                this.c(true);
            } else {
                this.g(this.dp().a(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder w() {
        return EntityInsentient.C().a(GenericAttributes.m, 0.175f).a(GenericAttributes.g, 16.0);
    }

    @Override
    protected SoundEffect y() {
        return !this.gb() && !this.A() ? SoundEffects.wZ : null;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.xd;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.xc;
    }

    @Override
    protected boolean r(Entity passenger) {
        return !this.bP() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fh() {
        return true;
    }

    @Override
    public boolean bN() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).u().a(TagsFluid.b) ? 10.0f : (this.bn() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Nullable
    public EntityStrider b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aW.a(world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return bY.a(stack);
    }

    @Override
    protected void ey() {
        super.ey();
        if (this.i()) {
            this.a((IMaterial)Items.nK);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.m(player.b(hand));
        if (!flag && this.i() && !this.bP() && !player.fI()) {
            if (!this.dM().B) {
                player.n(this);
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.nK) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.d;
        }
        if (flag && !this.aU()) {
            this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), SoundEffects.xg, this.db(), 1.0f, 1.0f + (this.ag.i() - this.ag.i()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D cJ() {
        return new Vec3D(0.0, 0.6f * this.cI(), this.dg() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (this.o_()) {
            return super.a(world, difficulty, spawnReason, entityData, entityNbt);
        }
        RandomSource randomsource = world.F_();
        if (randomsource.a(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.bu.a(world.E());
            if (entityinsentient != null) {
                entityData = this.a(world, difficulty, entityinsentient, new EntityZombie.GroupDataZombie(EntityZombie.a(randomsource), false));
                entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.nR));
                this.a((SoundCategory)null);
            }
        } else if (randomsource.a(10) == 0) {
            EntityAgeable entityageable = EntityTypes.aW.a(world.E());
            if (entityageable != null) {
                entityageable.c_(-24000);
                entityData = this.a(world, difficulty, entityageable, (GroupDataEntity)null);
            }
        } else {
            entityData = new EntityAgeable.a(0.5f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntityInsentient rider, @Nullable GroupDataEntity entityData) {
        rider.b(this.dr(), this.dt(), this.dx(), this.dC(), 0.0f);
        rider.a(world, difficulty, EnumMobSpawn.g, entityData, null);
        rider.a((Entity)this, true);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider strider, double speed) {
            super(strider, speed, 8, 2);
            this.g = strider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean b() {
            return !this.g.bn() && this.a(this.g.dM(), this.e);
        }

        @Override
        public boolean a() {
            return !this.g.bn() && super.a();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.H) && world.a_(pos.c()).a((IBlockAccess)world, pos, PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entity, World world) {
            super(entity, world);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new PathfinderNormal();
            this.o.a(true);
            return new Pathfinder(this.o, range);
        }

        @Override
        protected boolean a(PathType pathType) {
            return pathType != PathType.i && pathType != PathType.o && pathType != PathType.n ? super.a(pathType) : true;
        }

        @Override
        public boolean a(BlockPosition pos) {
            return this.b.a_(pos).a(Blocks.H) || super.a(pos);
        }
    }
}

