/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;
import org.joml.Vector3f;

public class EntityVex
extends EntityMonster
implements TraceableEntity {
    public static final float b = 45.836624f;
    public static final int c = MathHelper.f(3.9269907f);
    protected static final DataWatcherObject<Byte> d = DataWatcher.a(EntityVex.class, DataWatcherRegistry.a);
    private static final int e = 1;
    @Nullable
    EntityInsentient bT;
    @Nullable
    private BlockPosition bU;
    public boolean bV;
    public int bW;

    public EntityVex(EntityTypes<? extends EntityVex> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.bL = new c(this);
        this.bJ = 3;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b - 0.28125f;
    }

    @Override
    public boolean aT() {
        return this.ah % c == 0;
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        super.a(movementType, movement);
        this.aQ();
    }

    @Override
    public void l() {
        this.af = true;
        super.l();
        this.af = false;
        this.e(true);
        if (this.bV && --this.bW <= 0) {
            this.bW = 20;
            this.a(this.dN().i(), 1.0f);
        }
    }

    @Override
    protected void B() {
        super.B();
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(4, new a());
        this.bO.a(8, new d());
        this.bO.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bO.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bP.a(2, new b(this));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder u() {
        return EntityMonster.gk().a(GenericAttributes.l, 14.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(d, (byte)0);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("BoundX")) {
            this.bU = new BlockPosition(nbt.h("BoundX"), nbt.h("BoundY"), nbt.h("BoundZ"));
        }
        if (nbt.e("LifeTicks")) {
            this.b(nbt.h("LifeTicks"));
        }
    }

    @Override
    public void w(Entity original) {
        super.w(original);
        if (original instanceof EntityVex) {
            EntityVex entityvex = (EntityVex)original;
            this.bT = entityvex.A();
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.bU != null) {
            nbt.a("BoundX", this.bU.u());
            nbt.a("BoundY", this.bU.v());
            nbt.a("BoundZ", this.bU.w());
        }
        if (this.bV) {
            nbt.a("LifeTicks", this.bW);
        }
    }

    @Nullable
    public EntityInsentient A() {
        return this.bT;
    }

    @Nullable
    public BlockPosition ge() {
        return this.bU;
    }

    public void i(@Nullable BlockPosition bounds) {
        this.bU = bounds;
    }

    private boolean c(int mask) {
        byte b0 = this.an.b(d);
        return (b0 & mask) != 0;
    }

    private void a(int mask, boolean value) {
        byte b0 = this.an.b(d);
        int j2 = value ? b0 | mask : b0 & ~mask;
        this.an.b(d, (byte)(j2 & 0xFF));
    }

    public boolean gf() {
        return this.c(1);
    }

    public void w(boolean charging) {
        this.a(1, charging);
    }

    public void a(EntityInsentient owner) {
        this.bT = owner;
    }

    public void b(int lifeTicks) {
        this.bV = true;
        this.bW = lifeTicks;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.zD;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.zF;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.zG;
    }

    @Override
    public float bo() {
        return 1.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.F_();
        this.a(randomsource, difficulty);
        this.b(randomsource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.oX));
        this.a(EnumItemSlot.a, 0.0f);
    }

    @Override
    protected float l(Entity vehicle) {
        return 0.04f;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.0625f * scaleFactor, 0.0f);
    }

    private class c
    extends ControllerMove {
        public c(EntityVex entityvex) {
            super(entityvex);
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b) {
                Vec3D vec3d = new Vec3D(this.e - EntityVex.this.dr(), this.f - EntityVex.this.dt(), this.g - EntityVex.this.dx());
                double d0 = vec3d.f();
                if (d0 < EntityVex.this.cH().a()) {
                    this.k = ControllerMove.Operation.a;
                    EntityVex.this.g(EntityVex.this.dp().a(0.5));
                } else {
                    EntityVex.this.g(EntityVex.this.dp().e(vec3d.a(this.h * 0.05 / d0)));
                    if (EntityVex.this.q() == null) {
                        Vec3D vec3d1 = EntityVex.this.dp();
                        EntityVex.this.r(-((float)MathHelper.d(vec3d1.c, vec3d1.e)) * 57.295776f);
                        EntityVex.this.aU = EntityVex.this.dC();
                    } else {
                        double d1 = EntityVex.this.q().dr() - EntityVex.this.dr();
                        double d2 = EntityVex.this.q().dx() - EntityVex.this.dx();
                        EntityVex.this.r(-((float)MathHelper.d(d1, d2)) * 57.295776f);
                        EntityVex.this.aU = EntityVex.this.dC();
                    }
                }
            }
        }
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = EntityVex.this.q();
            return entityliving != null && entityliving.bx() && !EntityVex.this.K().b() && EntityVex.this.ag.a(a.b(7)) == 0 ? EntityVex.this.f((Entity)entityliving) > 4.0 : false;
        }

        @Override
        public boolean b() {
            return EntityVex.this.K().b() && EntityVex.this.gf() && EntityVex.this.q() != null && EntityVex.this.q().bx();
        }

        @Override
        public void c() {
            EntityLiving entityliving = EntityVex.this.q();
            if (entityliving != null) {
                Vec3D vec3d = entityliving.br();
                EntityVex.this.bL.a(vec3d.c, vec3d.d, vec3d.e, 1.0);
            }
            EntityVex.this.w(true);
            EntityVex.this.a(SoundEffects.zE, 1.0f, 1.0f);
        }

        @Override
        public void d() {
            EntityVex.this.w(false);
        }

        @Override
        public boolean T_() {
            return true;
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityVex.this.q();
            if (entityliving != null) {
                if (EntityVex.this.cH().c(entityliving.cH())) {
                    EntityVex.this.C(entityliving);
                    EntityVex.this.w(false);
                } else {
                    double d0 = EntityVex.this.f((Entity)entityliving);
                    if (d0 < 9.0) {
                        Vec3D vec3d = entityliving.br();
                        EntityVex.this.bL.a(vec3d.c, vec3d.d, vec3d.e, 1.0);
                    }
                }
            }
        }
    }

    private class d
    extends PathfinderGoal {
        public d() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return !EntityVex.this.K().b() && EntityVex.this.ag.a(net.minecraft.world.entity.monster.EntityVex$d.b(7)) == 0;
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public void e() {
            BlockPosition blockposition = EntityVex.this.ge();
            if (blockposition == null) {
                blockposition = EntityVex.this.dm();
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockposition1 = blockposition.b(EntityVex.this.ag.a(15) - 7, EntityVex.this.ag.a(11) - 5, EntityVex.this.ag.a(15) - 7);
                IBlockData blockState = EntityVex.this.dM().getBlockStateIfLoaded(blockposition1);
                if (blockState == null || !blockState.i()) continue;
                EntityVex.this.bL.a((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.5, (double)blockposition1.w() + 0.5, 0.25);
                if (EntityVex.this.q() != null) break;
                EntityVex.this.I().a((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.5, (double)blockposition1.w() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    private class b
    extends PathfinderGoalTarget {
        private final PathfinderTargetCondition b;

        public b(EntityCreature entitycreature) {
            super(entitycreature, false);
            this.b = PathfinderTargetCondition.b().d().e();
        }

        @Override
        public boolean a() {
            return EntityVex.this.bT != null && EntityVex.this.bT.q() != null && this.a(EntityVex.this.bT.q(), this.b);
        }

        @Override
        public void c() {
            EntityVex.this.setTarget(EntityVex.this.bT.q(), EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET, true);
            super.c();
        }
    }
}

