/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.joml.Vector3f;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final float bX = 0.2f;
    private static final int bY = 40;
    private static final float bZ = 0.3f;
    private static final int ca = 1;
    private static final float cb = 0.6f;
    private static final int cc = 6;
    private static final float cd = 0.5f;
    private static final int ce = 300;
    private int cf;
    public int cg;
    public boolean ch;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> bT = ImmutableList.of(SensorType.c, SensorType.d, SensorType.n, SensorType.m);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bU = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.ap, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.ar, MemoryModuleType.as, MemoryModuleType.ao, MemoryModuleType.J, MemoryModuleType.av, MemoryModuleType.aw, MemoryModuleType.Y});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bJ = 5;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.fS();
    }

    public static AttributeProvider.Builder u() {
        return EntityMonster.gk().a(GenericAttributes.l, 40.0).a(GenericAttributes.m, 0.3f).a(GenericAttributes.i, 0.6f).a(GenericAttributes.d, 1.0).a(GenericAttributes.c, 6.0);
    }

    @Override
    public boolean C(Entity target) {
        if (!(target instanceof EntityLiving)) {
            return false;
        }
        this.cf = 10;
        this.dM().a((Entity)this, (byte)4);
        this.a(SoundEffects.lC, 1.0f, this.eX());
        HoglinAI.a(this, (EntityLiving)target);
        return IOglin.a(this, (EntityLiving)target);
    }

    @Override
    protected void e(EntityLiving target) {
        if (this.w()) {
            IOglin.b(this, target);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean bl = super.a(source, amount);
        if (this.dM().B) {
            return false;
        }
        if (bl && source.d() instanceof EntityLiving) {
            HoglinAI.b(this, (EntityLiving)source.d());
        }
        return bl;
    }

    protected BehaviorController.b<EntityHoglin> dP() {
        return BehaviorController.a(bU, bT);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.dP().a(dynamic));
    }

    public BehaviorController<EntityHoglin> dO() {
        return super.dO();
    }

    @Override
    protected void Z() {
        this.dM().af().a("hoglinBrain");
        this.dO().a((WorldServer)this.dM(), this);
        this.dM().af().c();
        HoglinAI.a(this);
        if (this.A()) {
            ++this.cg;
            if (this.cg > 300) {
                this.b(SoundEffects.lD);
                this.c((WorldServer)this.dM());
            }
        } else {
            this.cg = 0;
        }
    }

    @Override
    public void d_() {
        if (this.cf > 0) {
            --this.cf;
        }
        super.d_();
    }

    @Override
    protected void m() {
        if (this.o_()) {
            this.bJ = 3;
            this.a(GenericAttributes.c).a(0.5);
        } else {
            this.bJ = 5;
            this.a(GenericAttributes.c).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return !world.a_(pos.d()).a(Blocks.kK);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (world.F_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.fL();
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        if (HoglinAI.a(this, pos)) {
            return -1.0f;
        }
        return world.a_(pos.d()).a(Blocks.ow) ? 10.0f : 0.0f;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.09375f * scaleFactor, 0.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            this.fJ();
        }
        return interactionResult;
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.cf = 10;
            this.a(SoundEffects.lC, 1.0f, this.eX());
        } else {
            super.b(status);
        }
    }

    @Override
    public int ge() {
        return this.cf;
    }

    @Override
    public boolean ec() {
        return true;
    }

    @Override
    public int ee() {
        return this.bJ;
    }

    private void c(WorldServer word) {
        EntityZoglin zoglin = this.a(EntityTypes.bq, true);
        if (zoglin != null) {
            zoglin.b(new MobEffect(MobEffects.i, 200, 0));
        } else {
            this.cg = 0;
        }
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(Items.dB);
    }

    public boolean w() {
        return !this.o_();
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(bW, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.gl()) {
            nbt.a("IsImmuneToZombification", true);
        }
        nbt.a("TimeInOverworld", this.cg);
        if (this.ch) {
            nbt.a("CannotBeHunted", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.w(nbt.q("IsImmuneToZombification"));
        this.cg = nbt.h("TimeInOverworld");
        this.x(nbt.q("CannotBeHunted"));
    }

    public void w(boolean immuneToZombification) {
        this.an().b(bW, immuneToZombification);
    }

    public boolean gl() {
        return this.an().b(bW);
    }

    public boolean A() {
        return !this.dM().E_().b() && !this.gl() && !this.fU();
    }

    private void x(boolean cannotBeHunted) {
        this.ch = cannotBeHunted;
    }

    public boolean gk() {
        return this.w() && !this.ch;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        EntityHoglin hoglin = EntityTypes.X.a(world);
        if (hoglin != null) {
            hoglin.fJ();
        }
        return hoglin;
    }

    @Override
    public boolean gf() {
        return !HoglinAI.c(this) && super.gf();
    }

    @Override
    public SoundCategory db() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect y() {
        return this.dM().B ? null : (SoundEffect)HoglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.lF;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.lE;
    }

    @Override
    protected SoundEffect aN() {
        return SoundEffects.mk;
    }

    @Override
    protected SoundEffect aO() {
        return SoundEffects.mj;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.lH, 0.15f, 1.0f);
    }

    protected void b(SoundEffect sound) {
        this.a(sound, this.eW(), this.eX());
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }
}

