/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final Logger bV = LogUtils.getLogger();
    private static final int bW = 40;
    private static final int bX = 200;
    private static final int bY = 500;
    private static final float bZ = 0.3f;
    private static final float ca = 1.0f;
    private static final float cb = 1.5f;
    private static final int cc = 30;
    private static final DataWatcherObject<Integer> cd = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int ce = 200;
    private static final int cf = 260;
    private static final int cg = 20;
    private static final int ch = 120;
    private static final int ci = 20;
    private static final int cj = 35;
    private static final int ck = 10;
    private static final int cl = 20;
    private static final int cm = 100;
    private static final int cn = 20;
    private static final int co = 30;
    private static final float cp = 4.5f;
    private static final float cq = 0.7f;
    private static final int cr = 30;
    private int cs;
    private int ct;
    private int cu;
    private int cw;
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState bT = new AnimationState();
    public AnimationState bU = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cx = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d cy = new a();
    private VibrationSystem.a cz = new VibrationSystem.a();
    AngerManagement cA = new AngerManagement(this::a, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> type, World world) {
        super(type, world);
        this.bJ = 5;
        this.N().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> dj() {
        return new PacketPlayOutSpawnEntity(this, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (packet.o() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader world) {
        return super.a(world) && world.a((Entity)this, this.ai().n().a(this.dk()));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return this.gi() && !damageSource.a(DamageTypeTags.e) ? true : super.b(damageSource);
    }

    boolean gi() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean fG() {
        return true;
    }

    @Override
    protected float aM() {
        return this.Z + 0.55f;
    }

    public static AttributeProvider.Builder u() {
        return EntityMonster.gk().a(GenericAttributes.l, 500.0).a(GenericAttributes.m, 0.3f).a(GenericAttributes.i, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0);
    }

    @Override
    public boolean aX() {
        return true;
    }

    @Override
    public float eW() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect y() {
        return !this.c(EntityPose.l) && !this.gi() ? this.A().b() : null;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.AD;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Az;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.AN, 10.0f, 1.0f);
    }

    @Override
    public boolean C(Entity target) {
        this.dM().a((Entity)this, (byte)4);
        this.a(SoundEffects.Ay, 10.0f, this.eX());
        SonicBoom.a((EntityLiving)this, 40);
        return super.C(target);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(cd, 0);
    }

    public int w() {
        return this.an.b(cd);
    }

    private void gl() {
        this.an.b(cd, this.go());
    }

    @Override
    public void l() {
        World world = this.dM();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.cz, this.cy);
            if (this.fL() || this.W()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.l();
        if (this.dM().y_()) {
            if (this.ah % this.gm() == 0) {
                this.cu = 10;
                if (!this.aU()) {
                    this.dM().a(this.dr(), this.dt(), this.dx(), SoundEffects.AC, this.db(), 5.0f, this.eX(), false);
                }
            }
            this.ct = this.cs;
            if (this.cs > 0) {
                --this.cs;
            }
            this.cw = this.cu;
            if (this.cu > 0) {
                --this.cu;
            }
            switch (this.ap()) {
                case n: {
                    this.a(this.d);
                    break;
                }
                case o: {
                    this.a(this.e);
                }
            }
        }
    }

    @Override
    protected void Z() {
        WorldServer worldserver = (WorldServer)this.dM();
        worldserver.af().a("wardenBrain");
        this.dO().a(worldserver, this);
        this.dM().af().c();
        super.Z();
        if ((this.ah + this.aj()) % 120 == 0) {
            Warden.a(worldserver, this.dk(), this, 20);
        }
        if (this.ah % 20 == 0) {
            this.cA.a(worldserver, this::a);
            this.gl();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.b.a();
            this.bT.a(this.ah);
        } else if (status == 61) {
            this.cs = 10;
        } else if (status == 62) {
            this.bU.a(this.ah);
        } else {
            super.b(status);
        }
    }

    private int gm() {
        float f2 = (float)this.w() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.ct, this.cs) / 10.0f;
    }

    public float F(float tickDelta) {
        return MathHelper.i(tickDelta, this.cw, this.cu) / 10.0f;
    }

    private void a(AnimationState animationState) {
        if ((float)animationState.b() < 4500.0f) {
            RandomSource randomsource = this.eg();
            IBlockData iblockdata = this.bk();
            if (iblockdata.l() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dr() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.dt();
                    double d2 = this.dx() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.dM().a(new ParticleParamBlock(Particles.c, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (Entity.as.equals(data)) {
            switch (this.ap()) {
                case n: {
                    this.d.a(this.ah);
                    break;
                }
                case o: {
                    this.e.a(this.ah);
                    break;
                }
                case l: {
                    this.b.a(this.ah);
                    break;
                }
                case m: {
                    this.c.a(this.ah);
                }
            }
        }
        super.a(data);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gi();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> dO() {
        return super.dO();
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> callback) {
        World world = this.dM();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            callback.accept(this.cx, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean a(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.dM() == entity.dM() && IEntitySelector.e.test(entity) && !this.s(entity) && entityliving.ai() != EntityTypes.d && entityliving.ai() != EntityTypes.bj && !entityliving.cr() && !entityliving.ew() && this.dM().D_().a(entityliving.cH())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer world, Vec3D pos, @Nullable Entity entity, int range) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(world, entity, pos, range, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = AngerManagement.a(this::a).encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cA);
        Logger logger = bV;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("anger", (NBTBase)nbtbase));
        dataresult = VibrationSystem.a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cz);
        logger = bV;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("listener", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        Logger logger;
        DataResult dataresult;
        super.a(nbt);
        if (nbt.e("anger")) {
            dataresult = AngerManagement.a(this::a).parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("anger")));
            logger = bV;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(angermanagement -> {
                this.cA = angermanagement;
            });
            this.gl();
        }
        if (nbt.b("listener", 10)) {
            dataresult = VibrationSystem.a.a.parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p("listener")));
            logger = bV;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(vibrationsystem_a -> {
                this.cz = vibrationsystem_a;
            });
        }
    }

    private void gn() {
        if (!this.c(EntityPose.l)) {
            this.a(this.A().c(), 10.0f, this.eX());
        }
    }

    public AngerLevel A() {
        return AngerLevel.a(this.go());
    }

    private int go() {
        return this.cA.b(this.q());
    }

    public void b(Entity entity) {
        this.cA.a(entity);
    }

    public void c(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int amount, boolean listening) {
        if (!this.fU() && this.a(entity)) {
            int activeAnger = this.cA.b(entity);
            WardenAngerChangeEvent event = new WardenAngerChangeEvent((org.bukkit.entity.Warden)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), activeAnger, Math.min(150, activeAnger + amount));
            this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            amount = event.getNewAnger() - activeAnger;
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.dO().c(MemoryModuleType.o).orElse(null) instanceof EntityHuman);
            int j2 = this.cA.a(entity, amount);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.dO().b(MemoryModuleType.o);
            }
            if (listening) {
                this.gn();
            }
        }
    }

    public Optional<EntityLiving> ge() {
        return this.A().d() ? this.cA.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving q() {
        return this.dO().c(MemoryModuleType.o).orElse(null);
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.dO().a(MemoryModuleType.aD, Unit.a, 1200L);
        if (spawnReason == EnumMobSpawn.k) {
            this.b(EntityPose.n);
            this.dO().a(MemoryModuleType.aB, Unit.a, WardenAi.a);
            this.a(SoundEffects.Av, 5.0f, 1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (!(this.dM().B || this.fU() || this.gi())) {
            Entity entity = source.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bz.c(MemoryModuleType.o).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (!source.b() || this.a((Entity)entityliving, 5.0)) {
                    this.j(entityliving);
                }
            }
        }
        return flag;
    }

    public void j(EntityLiving target) {
        this.dO().b(MemoryModuleType.ax);
        this.dO().a(MemoryModuleType.o, target);
        this.dO().b(MemoryModuleType.E);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        EntitySize entitysize = super.a(pose);
        return this.gi() ? EntitySize.c(entitysize.a, 1.0f) : entitysize;
    }

    @Override
    public boolean bu() {
        return !this.gi() && super.bu();
    }

    @Override
    protected void D(Entity entity) {
        if (!this.fU() && !this.dO().a(MemoryModuleType.aG)) {
            this.dO().a(MemoryModuleType.aG, Unit.a, 20L);
            this.c(entity);
            WardenAi.a(this, entity.dm());
        }
        super.D(entity);
    }

    @VisibleForTesting
    public AngerManagement gf() {
        return this.cA;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, world){

            @Override
            protected Pathfinder a(int range) {
                this.o = new PathfinderNormal();
                this.o.a(true);
                return new Pathfinder(this.o, range){

                    @Override
                    protected float a(PathPoint a2, PathPoint b2) {
                        return a2.b(b2);
                    }
                };
            }
        };
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.25f * scaleFactor, 0.0f);
    }

    @Override
    public VibrationSystem.a gg() {
        return this.cz;
    }

    @Override
    public VibrationSystem.d gh() {
        return this.cy;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cI());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer world, BlockPosition pos, GameEvent event, GameEvent.a emitter) {
            if (!(Warden.this.fU() || Warden.this.ew() || Warden.this.dO().a(MemoryModuleType.aH) || Warden.this.gi() || !world.D_().a(pos))) {
                EntityLiving entityliving;
                Entity entity = emitter.a();
                if (entity instanceof EntityLiving && !Warden.this.a((Entity)(entityliving = (EntityLiving)entity))) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer world, BlockPosition pos, GameEvent event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
            if (!Warden.this.ew()) {
                Warden.this.bz.a(MemoryModuleType.aH, Unit.a, 40L);
                world.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.AO, 5.0f, Warden.this.eX());
                BlockPosition blockposition1 = pos;
                if (entity != null) {
                    if (Warden.this.a(entity, 30.0)) {
                        if (Warden.this.dO().a(MemoryModuleType.az)) {
                            if (Warden.this.a(entity)) {
                                blockposition1 = entity.dm();
                            }
                            Warden.this.c(entity);
                        } else {
                            Warden.this.a(entity, 10, true);
                        }
                    }
                    Warden.this.dO().a(MemoryModuleType.az, Unit.a, 100L);
                } else {
                    Warden.this.c(sourceEntity);
                }
                if (!Warden.this.A().d()) {
                    Optional<EntityLiving> optional = Warden.this.cA.a();
                    if (entity != null || optional.isEmpty() || optional.get() == sourceEntity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

