/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import top.leavesmc.leaves.LeavesConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger bZ = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> ca = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.t);
    public static final int bV = 12;
    public static final Map<Item, Integer> bW = ImmutableMap.of((Object)Items.pu, (Object)4, (Object)Items.tZ, (Object)1, (Object)Items.tY, (Object)1, (Object)Items.vd, (Object)1);
    private static final int cb = 2;
    private static final Set<Item> cc = ImmutableSet.of((Object)Items.pu, (Object)Items.tZ, (Object)Items.tY, (Object)Items.pt, (Object)Items.ps, (Object)Items.vd, (Object[])new Item[]{Items.ve, Items.vb, Items.vc});
    private static final int cd = 10;
    private static final int ce = 1200;
    private static final int cf = 24000;
    private static final int cg = 25;
    private static final int ch = 10;
    private static final int ci = 5;
    private static final long cj = 24000L;
    @VisibleForTesting
    public static final float bX = 0.5f;
    private int ck;
    private boolean cl;
    @Nullable
    private EntityHuman cm;
    private boolean cn;
    private int co;
    private final Reputation cp = new Reputation();
    private long cq;
    private long cr;
    private int cs;
    private long ct;
    public int cu;
    private long cw;
    private boolean cx;
    private static final ImmutableList<MemoryModuleType<?>> cy = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.K, MemoryModuleType.aO, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.n, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.t, MemoryModuleType.v, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.A, MemoryModuleType.f, MemoryModuleType.C, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.G, MemoryModuleType.H, MemoryModuleType.I, MemoryModuleType.F});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cz = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> bY = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gp().b().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world) {
        this(entityType, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world, VillagerType type) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entityType, world);
        ((Navigation)this.N()).b(true);
        this.N().a(true);
        this.s(true);
        this.a(this.gp().a(type).a(VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> dO() {
        return super.dO();
    }

    protected BehaviorController.b<EntityVillager> dP() {
        return BehaviorController.a(cy, cz);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dP().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void c(WorldServer world) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dO();
        behaviorcontroller.b(world, this);
        this.bz = behaviorcontroller.i();
        this.a(this.dO());
    }

    @Override
    private void a(BehaviorController<EntityVillager> brain) {
        VillagerProfession villagerprofession = this.gp().b();
        if (this.o_()) {
            brain.a(Schedule.e);
            brain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            brain.a(Schedule.f);
            brain.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        brain.a(Activity.a, Behaviors.a(villagerprofession, 0.5f));
        brain.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        brain.a(Activity.e, Behaviors.c(villagerprofession, 0.5f));
        brain.a(Activity.b, Behaviors.e(villagerprofession, 0.5f));
        brain.a(Activity.g, Behaviors.f(villagerprofession, 0.5f));
        brain.a(Activity.i, Behaviors.g(villagerprofession, 0.5f));
        brain.a(Activity.h, Behaviors.h(villagerprofession, 0.5f));
        brain.a(Activity.j, Behaviors.i(villagerprofession, 0.5f));
        brain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        brain.b(Activity.b);
        brain.a(Activity.b);
        brain.a(this.dM().Y(), this.dM().X());
    }

    @Override
    protected void m() {
        super.m();
        if (this.dM() instanceof WorldServer) {
            this.c((WorldServer)this.dM());
        }
    }

    public static AttributeProvider.Builder gn() {
        return EntityInsentient.C().a(GenericAttributes.m, 0.5).a(GenericAttributes.g, 48.0);
    }

    public boolean go() {
        return this.cx;
    }

    @Override
    public void inactiveTick() {
        if (this.u() > 0) {
            this.s(this.u() - 1);
        }
        if (this.cY()) {
            if (this.dM().spigotConfig.tickInactiveVillagers) {
                this.Z();
            } else {
                this.customServerAiStep(true);
            }
        }
        this.gN();
        super.inactiveTick();
    }

    @Override
    @Deprecated
    protected void Z() {
        this.customServerAiStep(false);
    }

    protected void customServerAiStep(boolean inactive) {
        Raid raid;
        this.dM().af().a("villagerBrain");
        if (!inactive) {
            this.dO().a((WorldServer)this.dM(), this);
        }
        this.dM().af().c();
        if (this.cx) {
            this.cx = false;
        }
        if (!this.gf() && this.ck > 0) {
            --this.ck;
            if (this.ck <= 0) {
                if (this.cl) {
                    this.gL();
                    this.cl = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cm != null && this.dM() instanceof WorldServer) {
            ((WorldServer)this.dM()).a(ReputationEvent.e, (Entity)this.cm, this);
            this.dM().a((Entity)this, (byte)14);
            this.cm = null;
        }
        if (!inactive && !this.fU() && this.ag.a(100) == 0 && (raid = ((WorldServer)this.dM()).d(this.dm())) != null && raid.v() && !raid.a()) {
            this.dM().a((Entity)this, (byte)42);
        }
        if (this.gp().b() == VillagerProfession.b && this.gf()) {
            this.gk();
        }
        if (inactive) {
            return;
        }
        super.Z();
    }

    @Override
    public void l() {
        super.l();
        if (this.u() > 0) {
            this.s(this.u() - 1);
        }
        this.gN();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.tE) && this.bx() && !this.gf() && !this.fD()) {
            if (this.o_()) {
                this.gA();
                return EnumInteractionResult.a(this.dM().B);
            }
            boolean flag = this.gg().isEmpty();
            if (hand == EnumHand.a) {
                if (flag && !this.dM().B) {
                    this.gA();
                }
                player.a(StatisticList.S);
            }
            if (flag) {
                return EnumInteractionResult.a(this.dM().B);
            }
            if (!this.dM().B && !this.bU.isEmpty()) {
                this.h(player);
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        return super.b(player, hand);
    }

    public void gA() {
        this.s(40);
        if (!this.dM().y_()) {
            this.a(SoundEffects.zL, this.eW(), this.eX());
        }
    }

    private void h(EntityHuman customer) {
        this.voidTrade = false;
        this.i(customer);
        this.f(customer);
        this.a(customer, this.Q_(), this.gp().c());
    }

    @Override
    public void f(@Nullable EntityHuman customer) {
        boolean flag = this.ge() != null && customer == null;
        super.f(customer);
        if (flag) {
            this.gk();
        }
    }

    @Override
    protected void gk() {
        super.gk();
        this.gB();
    }

    private void gB() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gg()) {
            merchantrecipe.l();
        }
    }

    @Override
    public boolean gq() {
        return true;
    }

    @Override
    public boolean gm() {
        return this.dM().B;
    }

    public void gr() {
        this.gG();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gg()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.h();
        }
        this.gC();
        this.ct = this.dM().X();
        ++this.cu;
    }

    private void gC() {
        MerchantRecipeList merchantrecipelist = this.gg();
        EntityHuman entityhuman = this.ge();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.bS.j, merchantrecipelist, this.gp().c(), this.w(), this.gh(), this.gq());
        }
    }

    private boolean gD() {
        net.minecraft.world.item.trading.MerchantRecipe merchantrecipe;
        Iterator iterator = this.gg().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(merchantrecipe = (net.minecraft.world.item.trading.MerchantRecipe)iterator.next()).r());
        return true;
    }

    private boolean gE() {
        return this.cu == 0 || this.cu < 2 && this.dM().X() > this.ct + 2400L;
    }

    public boolean gs() {
        long i2 = this.ct + 12000L;
        long j2 = this.dM().X();
        boolean flag = j2 > i2;
        long k2 = this.dM().Y();
        if (this.cw > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cw / 24000L;
            flag |= i1 > l2;
        }
        this.cw = k2;
        if (flag) {
            this.ct = j2;
            this.gO();
        }
        return this.gE() && this.gD();
    }

    private void gF() {
        int i2 = 2 - this.cu;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gg()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.h();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.gG();
        }
        this.gC();
    }

    private void gG() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gg()) {
            merchantrecipe.e();
        }
    }

    private void i(EntityHuman player) {
        int i2 = this.g(player);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gg()) {
                if (merchantrecipe.ignoreDiscounts) continue;
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.n()));
            }
        }
        if (player.a(MobEffects.F)) {
            MobEffect mobeffect = player.b(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.gg()) {
                if (merchantrecipe1.ignoreDiscounts) continue;
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().L());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(ca, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gp());
        Logger logger = bZ;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        nbt.a("FoodLevel", (byte)this.co);
        nbt.a("Gossips", this.cp.a(DynamicOpsNBT.a));
        nbt.a("Xp", this.cs);
        nbt.a("LastRestock", this.ct);
        nbt.a("LastGossipDecay", this.cr);
        nbt.a("RestocksToday", this.cu);
        if (this.cx) {
            nbt.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = bZ;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.b("Offers", 10)) {
            this.bU = new MerchantRecipeList(nbt.p("Offers"));
        }
        if (nbt.b("FoodLevel", 1)) {
            this.co = nbt.f("FoodLevel");
        }
        NBTTagList nbttaglist = nbt.c("Gossips", 10);
        this.cp.a(new Dynamic<NBTTagList>(DynamicOpsNBT.a, nbttaglist));
        if (nbt.b("Xp", 3)) {
            this.cs = nbt.h("Xp");
        }
        this.ct = nbt.i("LastRestock");
        this.cr = nbt.i("LastGossipDecay");
        this.s(true);
        if (this.dM() instanceof WorldServer) {
            this.c((WorldServer)this.dM());
        }
        this.cu = nbt.h("RestocksToday");
        if (nbt.e("AssignProfessionWhenSpawned")) {
            this.cx = nbt.q("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect y() {
        return this.fD() ? null : (this.gf() ? SoundEffects.zM : SoundEffects.zH);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.zK;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.zJ;
    }

    public void gt() {
        SoundEffect soundeffect = this.gp().b().f();
        if (soundeffect != null) {
            this.a(soundeffect, this.eW(), this.eX());
        }
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.gp();
        if (villagerdata1.b() != villagerData.b()) {
            this.bU = null;
        }
        this.an.b(ca, villagerData);
    }

    @Override
    public VillagerData gp() {
        return this.an.b(ca);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.ag.a(4);
        if (!this.voidTrade) {
            this.cs += offer.o();
            this.cm = this.ge();
        }
        if (this.gK()) {
            this.ck = 40;
            this.cl = true;
            i2 += 5;
        }
        if (offer.s()) {
            this.dM().b(new EntityExperienceOrb(this.dM(), this.dr(), this.dt() + 0.5, this.dx(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.ge(), this));
        }
    }

    public void x(boolean flag) {
        this.cn = flag;
    }

    public boolean gu() {
        return this.cn;
    }

    @Override
    public void a(@Nullable EntityLiving attacker) {
        if (attacker != null && this.dM() instanceof WorldServer) {
            ((WorldServer)this.dM()).a(ReputationEvent.c, (Entity)attacker, this);
            if (this.bx() && attacker instanceof EntityHuman) {
                this.dM().a((Entity)this, (byte)13);
            }
        }
        super.a(attacker);
    }

    @Override
    public void a(DamageSource damageSource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            bZ.info("Villager {} died, message: '{}'", (Object)this, (Object)damageSource.a(this).getString());
        }
        if ((entity = damageSource.d()) != null) {
            this.a(entity);
        }
        this.gH();
        super.a(damageSource);
    }

    public void gH() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    @Override
    private void a(Entity killer) {
        World world = this.dM();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bz.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, killer, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    @Override
    public void a(MemoryModuleType<GlobalPos> pos) {
        if (this.dM() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.dM()).o();
            this.bz.c(pos).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.y();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = bY.get(pos);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean Y_() {
        return this.co + this.gM() >= 12 && !this.fD() && this.h() == 0;
    }

    private boolean gI() {
        return this.co < 12;
    }

    private void gJ() {
        if (this.gI() && this.gM() != 0) {
            for (int i2 = 0; i2 < this.A().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.A().a(i2);
                if (itemstack.b() || (integer = bW.get(itemstack.d())) == null) continue;
                for (int k2 = j2 = itemstack.L(); k2 > 0; --k2) {
                    this.co += integer.intValue();
                    this.A().a(i2, 1);
                    if (this.gI()) continue;
                    return;
                }
            }
        }
    }

    public int g(EntityHuman player) {
        return this.cp.a(player.cw(), (ReputationType reputationtype) -> true);
    }

    private void v(int amount) {
        this.co -= amount;
    }

    public void gv() {
        this.gJ();
        this.v(12);
    }

    public void b(MerchantRecipeList offers) {
        this.bU = offers;
    }

    private boolean gK() {
        int i2 = this.gp().c();
        return VillagerData.d(i2) && this.cs >= VillagerData.c(i2);
    }

    public void gL() {
        this.a(this.gp().a(this.gp().c() + 1));
        this.gl();
    }

    @Override
    protected IChatBaseComponent co() {
        String s2 = this.ai().g();
        return IChatBaseComponent.c(s2 + "." + BuiltInRegistries.z.b(this.gp().b()).a());
    }

    @Override
    public void b(byte status) {
        if (status == 12) {
            this.a(Particles.O);
        } else if (status == 13) {
            this.a(Particles.b);
        } else if (status == 14) {
            this.a(Particles.M);
        } else if (status == 42) {
            this.a(Particles.aj);
        } else {
            super.b(status);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (spawnReason == EnumMobSpawn.e) {
            this.a(this.gp().a(VillagerProfession.b));
        }
        if (spawnReason == EnumMobSpawn.n || spawnReason == EnumMobSpawn.m || EnumMobSpawn.a(spawnReason) || spawnReason == EnumMobSpawn.o) {
            this.a(this.gp().a(VillagerType.a(world.t(this.dm()))));
        }
        if (spawnReason == EnumMobSpawn.d) {
            this.cx = true;
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Nullable
    public EntityVillager b(WorldServer world, EntityAgeable entity) {
        double d0 = this.ag.j();
        VillagerType villagertype = d0 < 0.5 ? VillagerType.a(world.t(this.dm())) : (d0 < 0.75 ? this.gp().a() : ((EntityVillager)entity).gp().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bg, world, villagertype);
        entityvillager.a(world, world.d_(entityvillager.dm()), EnumMobSpawn.e, (GroupDataEntity)null, null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.ak() != EnumDifficulty.a) {
            EntityWitch entitywitch = EntityTypes.bl.a(world);
            if (entitywitch != null) {
                if (CraftEventFactory.callEntityZapEvent(this, lightning, entitywitch).isCancelled()) {
                    return;
                }
                if (SpigotConfig.logVillagerDeaths) {
                    bZ.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
                }
                entitywitch.b(this.dr(), this.dt(), this.dx(), this.dC(), this.dE());
                entitywitch.a(world, world.d_(entitywitch.dm()), EnumMobSpawn.i, (GroupDataEntity)null, null);
                entitywitch.t(this.fU());
                if (this.ae()) {
                    entitywitch.b(this.af());
                    entitywitch.n(this.cB());
                }
                entitywitch.fJ();
                if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, entitywitch, EntityTransformEvent.TransformReason.LIGHTNING).isCancelled()) {
                    return;
                }
                world.addFreshEntityWithPassengers(entitywitch, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                this.gH();
                this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            } else {
                super.a(world, lightning);
            }
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    protected void b(EntityItem item) {
        InventoryCarrier.a(this, this, item);
    }

    @Override
    public boolean k(ItemStack stack) {
        Item item = stack.d();
        return (cc.contains(item) || this.gp().b().d().contains((Object)item)) && this.A().b(stack);
    }

    public boolean gw() {
        return this.gM() >= 24;
    }

    public boolean gx() {
        return this.gM() < 12;
    }

    private int gM() {
        InventorySubcontainer inventorysubcontainer = this.A();
        return bW.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gy() {
        return this.A().a_((ItemStack itemstack) -> itemstack.a(TagsItem.aU));
    }

    @Override
    protected void gl() {
        this.updateTrades(2);
    }

    public boolean updateTrades(int amount) {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap1;
        VillagerData villagerdata = this.gp();
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap = this.dM().I().b(FeatureFlags.d) ? ((int2objectmap1 = VillagerTrades.c.get(villagerdata.b())) != null ? int2objectmap1 : VillagerTrades.a.get(villagerdata.b())) : VillagerTrades.a.get(villagerdata.b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.gg();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, amount);
            return true;
        }
        return false;
    }

    public void a(WorldServer world, EntityVillager villager, long time) {
        if (!(time >= this.cq && time < this.cq + 1200L || time >= villager.cq && time < villager.cq + 1200L)) {
            this.cp.a(villager.cp, this.ag, 10);
            this.cq = time;
            villager.cq = time;
            this.a(world, time, 5);
        }
    }

    private void gN() {
        long i2 = this.dM().X();
        if (this.cr == 0L) {
            this.cr = i2;
        } else if (i2 >= this.cr + 24000L) {
            this.cp.b();
            this.cr = i2;
        }
    }

    public void a(WorldServer world, long time, int requiredCount) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List list1;
        if (this.a(time) && (list1 = (list = world.a(EntityVillager.class, axisalignedbb = this.cH().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(time)).limit(5L).collect(Collectors.toList())).size() >= requiredCount && SpawnUtil.trySpawnMob(EntityTypes.ad, EnumMobSpawn.f, world, this.dm(), 10, 8, 6, SpawnUtil.a.a, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE, () -> SensorGolemLastSeen.b(this)).isPresent()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long time) {
        return !this.b(this.dM().X()) ? false : !this.bz.a(MemoryModuleType.F);
    }

    @Override
    public void a(ReputationEvent interaction, Entity entity) {
        if (interaction == ReputationEvent.a) {
            this.cp.a(entity.cw(), ReputationType.d, 20);
            this.cp.a(entity.cw(), ReputationType.c, 25);
        } else if (interaction == ReputationEvent.e) {
            this.cp.a(entity.cw(), ReputationType.e, 2);
        } else if (interaction == ReputationEvent.c) {
            this.cp.a(entity.cw(), ReputationType.b, 25);
        } else if (interaction == ReputationEvent.d) {
            this.cp.a(entity.cw(), ReputationType.a, 25);
        }
    }

    @Override
    public int w() {
        return this.cs;
    }

    public void u(int experience) {
        this.cs = experience;
    }

    private void gO() {
        this.gF();
        this.cu = 0;
    }

    public Reputation gz() {
        return this.cp;
    }

    @Override
    public void a(NBTBase nbt) {
        this.cp.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt));
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition pos) {
        super.b(pos);
        this.bz.a(MemoryModuleType.G, Long.valueOf(this.dM().X()));
        this.bz.b(MemoryModuleType.m);
        this.bz.b(MemoryModuleType.E);
    }

    @Override
    public void fE() {
        super.fE();
        this.bz.a(MemoryModuleType.H, Long.valueOf(this.dM().X()));
    }

    private boolean b(long worldTime) {
        Optional<Long> optional = this.bz.c(MemoryModuleType.G);
        return optional.isPresent() ? worldTime - optional.get() < 24000L : false;
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        if (LeavesConfig.villagersDontReleaseMemoryFix) {
            this.gH();
            this.dO().b(MemoryModuleType.b);
            this.dO().b(MemoryModuleType.c);
            this.dO().b(MemoryModuleType.d);
            this.dO().b(MemoryModuleType.e);
            this.c(destination);
        }
        return super.b(destination);
    }
}

